package org.seasar.framework.sel.util;

import java.lang.reflect.Array;
import java.util.Map;

import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.sel.Expression;
import org.seasar.framework.sel.SelContext;
import org.seasar.framework.sel.TargetOfPropertyNotFoundRuntimeException;

public final class SelContextUtil {

	private SelContextUtil() {
	}

	public static Object[] evaluateValues(
		SelContext context,
		Expression[] exps) {

		Object[] args = new Object[exps.length];
		for (int i = 0; i < args.length; ++i) {
			args[i] = exps[i].evaluateValue(context);
		}
		return args;
	}
	
	public static Object getProperty(Object variable, String propertyName) {
		if (variable == null) {
			throw new TargetOfPropertyNotFoundRuntimeException(propertyName);
		}
		if (variable instanceof Map) {
			return ((Map) variable).get(propertyName);
		} else if (
			variable.getClass().isArray() && "length".equals(propertyName)) {
			return new Integer(Array.getLength(variable));
		} else {
			BeanDesc beanDesc = BeanDescFactory.getBeanDesc(variable.getClass());
			PropertyDesc propertyDesc = beanDesc.getPropertyDesc(propertyName); 
			return propertyDesc.getValue(variable);
		}
	}
}
