/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.groovy;

import groovy.lang.Closure;
import groovy.util.BuilderSupport;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.aop.AroundAdvice;
import org.seasar.framework.aop.Pointcut;
import org.seasar.framework.aop.impl.PointcutImpl;
import org.seasar.framework.container.ArgDef;
import org.seasar.framework.container.AspectDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.DestroyMethodDef;
import org.seasar.framework.container.InitMethodDef;
import org.seasar.framework.container.MethodDef;
import org.seasar.framework.container.PropertyDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.impl.ArgDefImpl;
import org.seasar.framework.container.impl.AspectDefImpl;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.DestroyMethodDefImpl;
import org.seasar.framework.container.impl.InitMethodDefImpl;
import org.seasar.framework.container.impl.PropertyDefImpl;
import org.seasar.framework.container.impl.S2ContainerImpl;
import org.seasar.framework.container.impl.SimpleComponentDef;
import org.seasar.framework.util.StringUtil;
import org.seasar.groovy.ClosureAroundAdvice;
import org.seasar.groovy.SeasarBuilderException;

public class SeasarBuilder
extends BuilderSupport {
    protected static final Log logger = LogFactory.getLog((Class)(class$org$seasar$groovy$SeasarBuilder == null ? (class$org$seasar$groovy$SeasarBuilder = SeasarBuilder.class$("org.seasar.groovy.SeasarBuilder")) : class$org$seasar$groovy$SeasarBuilder));
    static /* synthetic */ Class class$org$seasar$groovy$SeasarBuilder;

    protected Object createNode(Object name) {
        if (name.equals("container")) {
            logger.debug((Object)"Create S2Container.");
            return new S2ContainerImpl();
        }
        if (name.equals("arg")) {
            logger.debug((Object)"Create ArgDef.");
            return new ArgDefImpl();
        }
        throw new RuntimeException("Unknown markup; " + name);
    }

    protected Object createNode(Object name, Map attributes) {
        if (name.equals("component")) {
            logger.debug((Object)("Create ComponentDef with attributes; " + attributes));
            return this.setupComponentDef(attributes);
        }
        if (name.equals("prop")) {
            logger.debug((Object)("Create PropertyDef with attributes; " + attributes));
            return this.setupPropertyDef(attributes);
        }
        if (name.equals("arg")) {
            logger.debug((Object)("Create ArgDef with attributes; " + attributes));
            return this.setupArgDef(attributes);
        }
        if (name.equals("aspect")) {
            logger.debug((Object)("Create AspectDef with attributes; " + attributes));
            return this.setupAspectDef(attributes);
        }
        throw new SeasarBuilderException("Unknown markup; " + name + " with attributes; " + attributes);
    }

    protected Object createNode(Object name, Object value) {
        if (name.equals("container")) {
            logger.debug((Object)("Create S2Container with namespace `" + value + "'."));
            S2ContainerImpl s2 = new S2ContainerImpl();
            s2.setNamespace((String)value);
            return s2;
        }
        if (name.equals("component")) {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            if (value instanceof Class) {
                attributes.put("class", value);
            } else {
                attributes.put("obj", value);
            }
            return this.createNode(name, attributes);
        }
        if (name.equals("arg")) {
            logger.debug((Object)("Create ArgDef with value; " + value));
            return new ArgDefImpl(value);
        }
        if (name.equals("init")) {
            logger.debug((Object)("Create InitMethodDef with value; " + value));
            return new InitMethodDefImpl((String)value);
        }
        if (name.equals("destroy")) {
            logger.debug((Object)("Create DestroyDef with value; " + value));
            return new DestroyMethodDefImpl((String)value);
        }
        throw new SeasarBuilderException("Unknown markup; " + name + " with value; " + value);
    }

    protected void nodeCompleted(Object parent, Object node) {
        if (parent == null) {
            return;
        }
        if (parent instanceof S2Container && node instanceof ComponentDef) {
            logger.debug((Object)("Registering " + node + " as ComponentDef to " + parent));
            ((S2Container)parent).register((ComponentDef)node);
            return;
        }
        if (parent instanceof ComponentDef) {
            this.setChildToComponent((ComponentDef)parent, node);
            return;
        }
        if (parent instanceof ArgDef) {
            this.setChildToArg((ArgDef)parent, node);
            return;
        }
        if (parent instanceof MethodDef) {
            this.setChildToMethod((MethodDef)parent, node);
            return;
        }
        throw new SeasarBuilderException(parent + " can't be parent of " + node);
    }

    private void setChildToArg(ArgDef def, Object child) {
        if (!(child instanceof ComponentDef)) {
            throw new SeasarBuilderException("ArgDef can't be parent of " + child);
        }
        logger.debug((Object)("Setting " + child + " as child component for " + def));
        def.setChildComponentDef((ComponentDef)child);
    }

    private void setChildToComponent(ComponentDef def, Object child) {
        if (child instanceof PropertyDef) {
            logger.debug((Object)("Adding " + child + " as PropertyDef to " + def));
            def.addPropertyDef((PropertyDef)child);
        } else if (child instanceof AspectDef) {
            logger.debug((Object)("Adding " + child + " as AspectDef to " + def));
            def.addAspectDef((AspectDef)child);
        } else if (child instanceof ArgDef) {
            logger.debug((Object)("Adding " + child + " as ArgDef to " + def));
            def.addArgDef((ArgDef)child);
        } else if (child instanceof InitMethodDef) {
            logger.debug((Object)("Adding " + child + " as InitMethodDef to " + def));
            def.addInitMethodDef((InitMethodDef)child);
        } else if (child instanceof DestroyMethodDef) {
            logger.debug((Object)("Adding " + child + " as DestroyMethod to " + def));
            def.addDestroyMethodDef((DestroyMethodDef)child);
        } else {
            throw new SeasarBuilderException("ComponentDef can't be parent of " + child);
        }
    }

    private void setChildToMethod(MethodDef def, Object child) {
        if (!(child instanceof ArgDef)) {
            throw new SeasarBuilderException("MethodDef can't be parent of " + child);
        }
        logger.debug((Object)("Adding " + child + " as ArgDef to " + def));
        def.addArgDef((ArgDef)child);
    }

    protected void setParent(Object parent, Object child) {
    }

    private ArgDef setupArgDef(Map attributes) {
        String referenceExpression = (String)attributes.get("ref");
        ArgDefImpl def = new ArgDefImpl();
        def.setExpression(referenceExpression);
        return def;
    }

    private AspectDef setupAspectDef(Map attributes) {
        AspectDefImpl def = null;
        String method = (String)attributes.get("pointcut");
        if (attributes.get("advice") instanceof String) {
            if (method != null) {
                PointcutImpl pointcut = new PointcutImpl(StringUtil.split((String)method, (String)","));
                def = new AspectDefImpl((Pointcut)pointcut);
            } else {
                def = new AspectDefImpl();
            }
            def.setExpression((String)attributes.get("advice"));
        } else if (attributes.get("advice") instanceof Closure) {
            ClosureAroundAdvice advice = new ClosureAroundAdvice((Closure)attributes.get("advice"));
            if (method != null) {
                PointcutImpl pointcut = new PointcutImpl(StringUtil.split((String)method, (String)","));
                def = new AspectDefImpl((AroundAdvice)advice, (Pointcut)pointcut);
            } else {
                def = new AspectDefImpl((AroundAdvice)advice);
            }
        } else {
            throw new SeasarBuilderException("'advice' must be an expression string or a closure.");
        }
        return def;
    }

    private ComponentDef setupComponentDef(Map attributes) {
        Object def = null;
        Class cls = (Class)attributes.get("class");
        Object obj = attributes.get("obj");
        String name = (String)attributes.get("name");
        String destroy = (String)attributes.get("destroy");
        String instance = (String)attributes.get("instance");
        String binding = (String)attributes.get("binding");
        if (cls == null && obj == null) {
            throw new SeasarBuilderException("Neither class nor object is pass, or null?");
        }
        def = name != null ? (cls != null ? new ComponentDefImpl(cls, name) : new SimpleComponentDef(obj, name)) : (cls != null ? new ComponentDefImpl(cls) : new SimpleComponentDef(obj));
        if (instance != null) {
            def.setInstanceMode(instance);
        }
        if (binding != null) {
            def.setAutoBindingMode(binding);
        }
        return def;
    }

    private PropertyDef setupPropertyDef(Map attributes) {
        boolean refIsNotNull;
        String propertyName = (String)attributes.get("name");
        Object propertyValue = attributes.get("value");
        String referenceExpression = (String)attributes.get("ref");
        boolean valIsNotNull = propertyValue != null;
        boolean bl = refIsNotNull = referenceExpression != null;
        if (valIsNotNull && refIsNotNull) {
            throw new SeasarBuilderException("'value' and 'ref' on 'prop' is mutually exclusive parameter.");
        }
        if (valIsNotNull) {
            return new PropertyDefImpl(propertyName, propertyValue);
        }
        if (refIsNotNull) {
            PropertyDefImpl def = new PropertyDefImpl(propertyName);
            def.setExpression(referenceExpression);
            return def;
        }
        throw new SeasarBuilderException("'value' or 'ref' must be set.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

