/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.groovy;

import groovy.lang.GroovyShell;
import java.io.IOException;
import java.io.InputStream;
import org.codehaus.groovy.control.CompilationFailedException;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.groovy.SeasarBuilderException;

public class S2ContainerGroovyFactory {
    public static S2Container create(String path) throws SeasarBuilderException {
        S2Container container = null;
        try {
            InputStream stream = ResourceUtil.getResourceAsStream((String)path);
            GroovyShell shell = new GroovyShell();
            container = (S2Container)shell.evaluate(stream, path);
            if (container == null) {
                throw new SeasarBuilderException("The return value is null or not returning.");
            }
            if (!(container instanceof S2Container)) {
                throw new SeasarBuilderException("The return value is not instance of S2Container");
            }
        }
        catch (IOException e) {
            throw new SeasarBuilderException(e.getMessage(), e);
        }
        catch (CompilationFailedException e) {
            throw new SeasarBuilderException(e.getMessage(), e);
        }
        catch (RuntimeException e) {
            throw new SeasarBuilderException(e.getMessage(), e);
        }
        return container;
    }
}

