<?php
$logid = 'Password';

require_once("../lib/util.php");

if (isset($_SESSION['lang']) && $_SESSION['lang']) {
    $lang = $_SESSION['lang'];
}

$error = 0;
$message = '';
$ssoapp = null;

$conf = parse_ini_file("../conf/config.ini", true);
if (empty($conf)) {
     $log->crit(logformat("Can't read config.ini"));
     exit(1);
}

if (!isset($conf['password'])) {
     $log->crit(logformat("Set password configuration"));
     exit(1);
}

$user = isset($_SERVER['REMOTE_USER']) ? $_SERVER['REMOTE_USER'] : null;
$tenant = '';
if (preg_match('/^[^@]+@(.*)$/', $user, $matches)) {
    $tenant = $matches[1];
    $tenant = preg_replace('/([*()])/', '\\$1', $tenant);
}

$tplfile = getTemplateFile('password', $tenant, $lang);

if (isset($_GET['ssoapp'])) {
    $ssoapp = $_GET['ssoapp'] != 'accessmanager' ? $_GET['ssoapp'] : null;
} else if (isset($_POST['ssoapp'])) {
    $ssoapp = $_POST['ssoapp'] != 'accessmanager' ? $_POST['ssoapp'] : null;
}
$winpasswd = isset($conf['password']['winpasswd']) && $conf['password']['winpasswd'] ? true : false;
$setoldpasswd = isset($conf['password']['setoldpasswd']) && $conf['password']['setoldpasswd'] ? true: false;

$login = new AutoLogin($conf['password']['storage'], $conf['password'], $ssoapp);
$rc = $login->setUser($user, true);
if (PEAR::isError($rc)) {
    $log->crit(logformat("Changing password failed: ". $rc->getMessage()));
    $error = 1;
    $message = USS_ERR_003;
} else if (isset($_POST['password'])) {
    $password = $_POST['password'];
    $oldpasswd = isset($_POST['oldpwd']) ? $_POST['oldpwd'] : (isset($_SESSION['password']) ? $_SESSION['password'] : '');

    if ($setoldpasswd && $login->auth($oldpasswd)) {
        $log->err(logformat("Old password is incorrect"));
        $error = 1;
        $message = USS_ERR_010;
    } else if (isset($_POST['confirmpwd']) && $password == $_POST['confirmpwd']) {
        $rc = $login->changePasswd($password, false, $oldpasswd);
        if (PEAR::isError($rc)) {
            $error = 1;
            switch($rc->getCode()) {
              case AUTO_LOGIN_INVALID_VALUE:
                $log->err(logformat("Password is invalid"));
                $message = USS_ERR_001;
                break;
              case AUTO_LOGIN_MIN_AGE:
                $log->err(logformat("Minimum time doesn't elapse between modification to the password"));
                $message = USS_ERR_005;
                break;
              case AUTO_LOGIN_IN_HISTORY:
                $log->err(logformat("Password is in the history"));
                $message = USS_ERR_006;
                break;
              case AUTO_LOGIN_WEAK_PASSWD:
              case AUTO_LOGIN_WEAK_PASSWD_WARN:
                $errmsg = $rc->getMessage();
                if (preg_match('/too short/', $errmsg)) {
                    $message = USS_ERR_011;
                } else if (preg_match('/DIFFERENT characters/', $errmsg)) {
                    $message = USS_ERR_401;
                } else if (preg_match('/all whitespace/', $errmsg)) {
                    $message = USS_ERR_402;
                } else if (preg_match('/too simplistic\/systematic/', $errmsg)) {
                    $message = USS_ERR_403;
                } else if (preg_match('/National Insurance number/', $errmsg)) {
                    $message = USS_ERR_403;
                } else if (preg_match('/dictionary word/', $errmsg)) {
                    $message = USS_ERR_404;
                }
                if ($rc->getCode() == AUTO_LOGIN_WEAK_PASSWD) {
                    $log->err(logformat("Password is weark: $errmsg"));
                } else {
                    $log->err(logformat("Changing password succeeded but password is weak: $errmsg"));
                    $message = USS_NML_001."<br>($message)";
                }
                break;
              case AUTO_LOGIN_MIN_PASSWD:
                $log->err(logformat("Password length is too short"));
                $message = USS_ERR_011;
                break;
              case AUTO_LOGIN_MAX_PASSWD:
                $log->err(logformat("Password length is too long"));
                $message = USS_ERR_012;
                break;
              default:
                $log->crit(logformat("Changing password failed: ". $rc->getMessage()));
                $message = USS_ERR_002;
            }
        } else if ($rc) {
            $log->notice(logformat("Changing password succeeded".($ssoapp ? "($ssoapp)" : "")));
            $message = USS_NML_001;
            if (isset($_COOKIE['auth_tkt'])) {
                $r = sam_auth('/api/auth.cgi', $user, $password);
                if (!PEAR::isError($r) && $r[2]) {
                    setrawcookie('auth_tkt', $r[2], 0, '/', isset($conf['password']['domain']) ? $conf['password']['domain'] : null);
                }
            } else {
                $_SESSION['password'] = $password;
            }
        }
    } else {
        $error = 1;
        $message = USS_ERR_004;
    }
} else {
    if (isset($_GET['msg'])) {
        $message = constant($_GET['msg']);
    }
}

$smarty = new Smarty();
$smarty->template_dir = 'templates';
$smarty->compile_dir = 'templates_c';

$smarty->assign('username', $user);
$smarty->assign('error', $error);
$smarty->assign('message', $message);
$smarty->assign('winpasswd', $winpasswd);
$smarty->assign('setoldpasswd', $setoldpasswd);
$smarty->assign('uri', $_SERVER['SCRIPT_NAME'].'?app=password');
if (isset($_GET['back'])) {
    $smarty->assign('back', urldecode($_GET['back']));
}
if (file_exists('../lib/menu.php') && isset($conf['autologin'])) {
    $smarty->assign('use_menu', 1);
}

if (isset($conf['apps']) && $conf['apps']) {
    if (!isset($conf['apps']['accessmanager'])) {
        $ssoapps = array('accessmanager' => 'Secioss Access Manager');
    } else {
        $ssoapps = array();
    }
    $ssoapps = array_merge($ssoapps, $conf['apps']);
    $smarty->assign('ssoapps', $ssoapps);
    if ($ssoapp) {
        $smarty->assign('ssoapp', $ssoapp);
    }
}

$smarty->display($tplfile);
?>
