<?php
$logid = 'Discovery';

require_once("../lib/util.php");

define('LOGINURL', '/pub/login.cgi');
define('COOKIENAME', 'secioss_tenant');

$conf = parse_ini_file("../conf/config.ini", true);
if (empty($conf)) {
     $log->err(logformat("Can't read config.ini"));
     exit(1);
}

$tenant = '';
if (isset($_COOKIE[COOKIENAME])) {
    $tenant = $_COOKIE[COOKIENAME];
} else if (isset($_POST['tenant'])) {
    $tenant = $_POST['tenant'];
    if (isset($conf['discovery']) && isset($conf['discovery']['timeout'])) {
        $timeout = $conf['discovery']['timeout'];
    } else {
        $timeout = 2592000;
    }
    setcookie(COOKIENAME, $tenant, time() + $timeout);
}

$back = isset($_GET['back']) ? $_GET['back'] : '';
if ($tenant) {
    $back .= (preg_match('/\?[^\/]+$/', $back) ? '&' : '?')."tenant=$tenant";
    header('Location: '.LOGINURL.'?back='.urlencode($back));
    exit(0);
}

$login = new AutoLogin($conf['autologin']['storage'], $conf['autologin']);
$tenants = $login->getTenants();

$smarty = new Smarty();
$smarty->template_dir = 'templates';
$smarty->compile_dir = 'templates_c';

$smarty->assign('tenants', $tenants);
$smarty->assign('back', $back);

$smarty->display('discovery.tpl');
?>
