#!/usr/bin/perl
#
# $Id: migrate_slapd_conf.pl,v 1.5 2003/04/15 03:09:34 lukeh Exp $
#
# Copyright (c) 2001-2003 Luke Howard.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. All advertising materials mentioning features or use of this software
#    must display the following acknowledgement:
#        This product includes software developed by Luke Howard.
# 4. The name of the other may not be used to endorse or promote products
#    derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE LUKE HOWARD ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL LUKE HOWARD BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
#
# LDIF entries for base DN
#
#

require '/opt/secioss/share/openldap/migration/migrate_common.ph';

$PROGRAM = "migrate_slapd_conf.pl";

push (@SCHEMAS, "core.schema");
push (@SCHEMAS, "cosine.schema");
push (@SCHEMAS, "nis.schema");
push (@SCHEMAS, "autofs.schema");
push (@SCHEMAS, "rfc822MailMember.schema");
push (@SCHEMAS, "DUAConfigProfile.schema");

sub gen_slapd_conf
{
	print "# @(#)slapd.conf generated by migrate_slapd_conf.pl\n";
	$creationTime = localtime;
	print "# Creation date: ", $creationTime, "\n";
	print "#\n";
	print "# See slapd.conf(5) for details on configuration options.\n";
	print "# This file should NOT be world readable.\n";
	print "#\n";

	foreach $schema (@SCHEMAS) {
		print "include\t$ROOTDIR/etc/openldap/schema/$schema\n";
	}

	print "\n";

	print <<EOL
# Define global ACLs to disable default read access.
schemacheck     off

# Do not enable referrals until AFTER you have a working directory
# service AND an understanding of referrals.
#referral       ldap://root.openldap.org

EOL
;

	print "pidfile\t$ROOTDIR/var/slapd.pid\n";
	print "argsfile\t$ROOTDIR/var/slapd.args\n";
	print "\n";
	print "database\tldbm\n";
	print "suffix\t\"$DEFAULT_BASE\"\n";
	print "rootdn\tcn=manager\n";
	print "directory\t$ROOTDIR/var/openldap-ldbm\n";
	print "index\tobjectClass\t\tpres,eq\n";
	print "index\tcn,sn,uid\t\teq\n";
	print "index\tuidNumber,gidNumber,memberUid\teq\n";
	print "index\toncRpcNumber,ipServicePort\teq\n";
	print "index\tipNetworkNumber,ipHostNumber\teq\n";

	print "\n";
}

sub main
{
	if ($ARGV[0] ne "") {
		$ROOTDIR = $ARGV[0];
	}
	else {
		$ROOTDIR = "/usr/local";
	}

	if ($ROOTDIR eq "/") {
		$ROOTDIR = "";
	}

	&gen_slapd_conf();
}

&main;

