<?php
$logid = 'UserLogin';
session_start();

require_once("../lib/util.php");

if (strtoupper(substr(PHP_OS, 0, 3)) !== 'WIN') {
    $log = &Log::singleton('syslog', LOG_LOCAL5, $logid);
} else {
    $opts = array('locking' => true, 'timeFormat' => '%Y/%m/%d %H:%M:%S');
    $log = &Log::singleton('file', '/secioss/var/log/auth.log', $logid, $opts);
}

$mobile = false;
if (preg_match('/DoCoMo|UP\.Browser\/|J-PHONE|Vodafone|Softbank/', $_SERVER['HTTP_USER_AGENT'])) {
    ini_set('session.use_trans_sid', 1);
    $mobile = true;
}

$tenant = isset($_GET['tenant']) ? $_GET['tenant'] : '';
$message = '';
$tplfile = getTemplateFile('login', $tenant, $lang);

$conf = parse_ini_file("../conf/config.ini", true);
if (empty($conf)) {
    $log->crit(logformat("Can't read config.ini"));
    exit(1);
}

if (!isset($conf['password'])) {
    $log->crit(logformat("Set password configuration"));
    exit(1);
}

if (isset($_SERVER['REMOTE_USER'])) {
    $_SESSION['username'] = $_SERVER['REMOTE_USER'];
    $_SESSION['tokens'] = $_SERVER['REMOTE_USER_TOKENS'];
} else if (isset($_POST['op']) && $_POST['op'] == 'login' &&
    isset($_POST['username']) && $_POST['username']) {
    $username = $_POST['username'];
    $_SERVER['REMOTE_USER'] = $username;

    $password = isset($_POST['loginpass']) ? $_POST['loginpass'] : '';
    if (isset($conf['password']['authtype']) && $conf['password']['authtype'] == 'sam') {
        $r = sam_auth('/api/auth.cgi', $username, $password);
        if (PEAR::isError($r)) {
            $rc = $r;
        } else {
            $rc = $r[0];
            $_SESSION['tokens'] = $r[1];
        }
    } else {
        $login = new AutoLogin($conf['password']['storage'], $conf['password']);
        $rc = $login->setUser($username, true);
        if (PEAR::isError($rc)) {
            if ($rc->getCode() == -2) {
                $rc = 1;
            }
        } else {
            $rc = $login->auth($password);
        }
    }

    if (PEAR::isError($rc)) {
        $log->crit(logformat("Login failed: ".$rc->getMessage()));
        $message = USS_ERR_003;
    } else if ($rc == 1) {
        $log->err(logformat("User or password is invalid"));
        $message = USS_ERR_007;
    } else if ($rc == 2) {
        $log->err(logformat("User status is inactive"));
        $message = USS_ERR_013;
    } else if ($rc == 3) {
        $log->err(logformat("User account is locked out"));
        $message = USS_ERR_014;
    } else if ($rc == 6) {
        $log->err(logformat("User account is now locked out"));
        $message = USS_ERR_014;
    } else if ($rc == 0) {
        $log->info(logformat("Login succeeded"));
        $_SESSION['username'] = $username;
        $_SESSION['password'] = $password;
        $_SESSION['lang'] = $login->storage->get('preferredlanguage');
    } else {
        $log->crit(logformat("Login failed: unknown error"));
        $message = USS_ERR_014;
    }
}

$use_menu = false;
if (isset($_SESSION['username']) && $_SESSION['username']) {
    $_SERVER['REMOTE_USER'] = $_SESSION['username'];
    if ($mobile) {
        $default_app = 'mobileid';
    } else if (!isset($conf['autologin']) && !file_exists('../lib/secret.php')) {
        $default_app = 'password';
    } else if (file_exists('../lib/menu.php')) {
        $default_app = 'menu';
        $use_menu = true;
    } else if (file_exists('../lib/password.php')) {
        $default_app = 'password';
    } else if (file_exists('../lib/secret.php')) {
        $default_app = 'secret';
    }


    $back = isset($_GET['back']) ? $_GET['back'] : '';
    $app = isset($_GET['app']) ? $_GET['app'] : $default_app;
    if (!preg_match('/\/index.php$/', $_SERVER['PHP_SELF'])) {
        $app = preg_replace('/^.*\/([^\/]+)\.php$/', '$1', $_SERVER['PHP_SELF']);
    }
    if ($back) {
        header("Location: $back");
    } else if ($app == 'secret') {
        require_once('secret.php');
    } else if ($app == 'certificate') {
        require_once('certificate.php');
    } else if ($app == 'mobileid') {
        require_once('mobileid.php');
    } else if ($app) {
        require_once("$app.php");
    } else {
        require_once('password.php');
    }
} else {
    $smarty = new Smarty();
    $smarty->template_dir = 'templates';
    $smarty->compile_dir = 'templates_c';

    $smarty->assign('message', $message);
    $smarty->assign('uri', $_SERVER['SCRIPT_NAME'] . isset($_SERVER['QUERY_STRING']) ? '?'.$_SERVER['QUERY_STRING'] : '');
    if ($mobile) {
        $smarty->assign('mobile', true);
    }
    $smarty->display($tplfile);
}
?>
