#!/bin/sh

PRODUCT="Secioss Identity Suite Cloud Edition SP"
PREFIX="/opt/secioss"
CONF="$PREFIX/etc/openldap/slapd.conf"
LOG="/tmp/install.log"

function install() {
    error=
    rpm -q libtool-ltdl > $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "libtool-ltdlをインストールしてください。"
        error=1
    fi

    rpm -q perl-LDAP >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "perl-LDAPをインストールしてください。"
        error=1
    fi

    rpm -q perl-DBI >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "perl-DBIをインストールしてください。"
        error=1
    fi

    rpm -q perl-DBD-Pg >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "perl-DBD-Pgをインストールしてください。"
        error=1
    fi

    rpm -q perl-Digest-SHA1 >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "perl-Digest-SHA1をインストールしてください。"
        error=1
    fi

    rpm -q perl-XML-LibXML >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "perl-XML-LibXMLをインストールしてください。"
        error=1
    fi

    rpm -q perl-XML-Simple >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "perl-XML-Simpleをインストールしてください。"
        error=1
    fi

    rpm -q perl-TimeDate >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "perl-TimeDateをインストールしてください。"
        error=1
    fi

    rpm -q php-pear >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "php-pearをインストールしてください。"
        error=1
    fi

    rpm -q php-xml >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "php-xmlをインストールしてください。"
        error=1
    fi

    rpm -q php-soap >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "php-soapをインストールしてください。"
        error=1
    fi

    rpm -q php-pdo >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "php-pdoをインストールしてください。"
        error=1
    fi

    if [ -n "$error" ]; then
        exit 1;
    fi

    rpm -Uvh ./third_party/perl-version-* >> $LOG 2>&1
    rpm -Uvh ./third_party/perl-MailTools-* >> $LOG 2>&1
    rpm -Uvh ./third_party/perl-FreezeThaw-* >> $LOG 2>&1
    rpm -Uvh ./third_party/php-pear-Net-Socket-* >> $LOG 2>&1
    rpm -Uvh ./third_party/php-pear-Net-URL-* >> $LOG 2>&1
    rpm -Uvh ./third_party/php-pear-MDB2-* >> $LOG 2>&1
    for f in `ls ./third_party`; do
        rpm -q `echo $f | sed s/-[0-9].*//` > /dev/null
        if [ $? -ne 0 ]; then
            rpm -Uvh ./third_party/$f >> $LOG 2>&1
        fi
    done
    echo "$PRODUCTに必要なパッケージをインストールしました。"

    rpm -Uvh ./software/perl-Net-LDAP-Server-*-[0-9]*.secioss.noarch.rpm >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "perl-Net-LDAP-Serverのインストールに失敗しました。"
        return 1
    fi
    echo "perl-Net-LDAP-Serverをインストールしました。"

    rpm -Uvh ./software/openldap23-2.3.[0-9]*-[0-9]*.secioss.*.rpm \
             ./software/openldap23-servers-2.3.[0-9]*-[0-9]*.secioss.*.rpm >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "openldapのインストールに失敗しました。"
        rpm -e perl-Net-LDAP-Server
        return 1
    fi
    echo "openldapをインストールしました。"

    rpm -Uvh ./software/perl-LISM-[0-9]*.[0-9]*.[0-9]*-[0-9]*.secioss.noarch.rpm >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "LISMのインストールに失敗しました。"
        rpm -e perl-Net-LDAP-Server openldap23 openldap23-servers
        return 1
    fi
    echo "LISMをインストールしました。"

    rpm -q php-Secioss-AutoLogin >& /dev/null
    if [ $? -ne 0 ]; then
        rpm -Uvh ./software/php-Secioss-AutoLogin-*.secioss.noarch.rpm >> $LOG 2>&1
        if [ $? -ne 0 ]; then
            echo "php-Secioss-AutoLoginのインストールに失敗しました。"
            rpm -e perl-Net-LDAP-Server openldap23 openldap23-servers perl-LISM
            return 1
        fi
        echo "php-Secioss-AutoLoginをインストールしました。"
    fi

    rpm -q access-manager-apps >& /dev/null
    if [ $? -ne 0 ]; then
        rpm -Uvh ./software/access-manager-apps-*.secioss.noarch.rpm >> $LOG 2>&1
        if [ $? -ne 0 ]; then
            echo "access-manager-appsのインストールに失敗しました。"
            rpm -e perl-Net-LDAP-Server openldap23 openldap23-servers perl-LISM php-Secioss-AutoLogin
            return 1
        fi
        echo "access-manager-appsをインストールしました。"
    fi

    rpm -Uvh ./software/simplesamlphp-*.rpm >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "simplesamlphpのインストールに失敗しました。"
        rpm -e perl-Net-LDAP-Server openldap23 openldap23-servers perl-LISM php-Secioss-AutoLogin access-manager-apps
        return 1
    fi
    echo "simplesamlphpをインストールしました。"

    rpm -Uvh ./software/php-pecl-filter-*.rpm >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "php-pecl-filterのインストールに失敗しました。"
        rpm -e perl-Net-LDAP-Server openldap23 openldap23-servers perl-LISM php-Secioss-AutoLogin access-manager-apps simplesamlphp
        return 1
    fi
    echo "php-pecl-filterをインストールしました。"

    mkdir /var/www/cgi-bin/lism
    mkdir /usr/share/oauth
    cp ./src/{SoapLism.pm,lism.cgi,lismapi.conf,lism_rest.cgi,lism_restapi.conf} /var/www/cgi-bin/lism/
    cp ./src/saml_sp.php /var/www/lib/
    cp ./src/oauth2/*.php /usr/share/oauth/
    cp -r ./src/oauth2/{lib,templates,templates_c} /usr/share/oauth/
    chown -R apache.apache /usr/share/oauth
    cp ./src/oauth2/cleanoauth /opt/secioss/sbin/
    cp ./src/idsync /opt/secioss/sbin/
    cp ./conf/config.ini /var/www/conf/
    cp ./conf/config.php /usr/share/simplesamlphp/config/
    cp ./conf/saml20* /usr/share/simplesamlphp/metadata/
    cp ./src/oauth2/oauth.conf /var/www/conf/
    chown ldap.apache /opt/secioss/etc/lism.conf
    cp ./conf/{lism.conf,lism-sp.conf,lism-idp.conf} /opt/secioss/etc/
    chown ldap.apache /opt/secioss/etc/{lism.conf,lism-sp.conf,lism-idp.conf}
    chmod 660 /opt/secioss/etc/lism.conf
    chown apache /opt/secioss/var/lib/ldap
    chmod 770 /opt/secioss/var/lib/ldap
    if [ ! -d /opt/secioss/var/lib/csv ]; then
        mkdir /opt/secioss/var/lib/csv
    fi
    chown apache.ldap /opt/secioss/var/lib/csv
    chmod 770 /opt/secioss/var/lib/csv
    cp ./conf/{autologin,oauth}.conf /etc/httpd/conf.d/
    cp -r ./src/lism /var/www/html/
    chown -R apache.apache /var/www/html/

    echo "$PRODUCTのインストールが完了しました。"
}

function update() {
    rpm -Fvh ./third_party/* > $LOG 2>&1
    echo "$PRODUCTに必要なパッケージをアップデートしました。"

    rpm -Fvh ./software/perl-Net-LDAP-Server-*-[0-9]*.secioss.noarch.rpm >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "perl-Net-LDAP-Serverのアップデートに失敗しました。"
        return 1
    fi
    echo "perl-Net-LDAP-Serverをアップデートしました。"

    rpm -Fvh ./software/openldap23-2.3.[0-9]*-[0-9]*.secioss.*.rpm \
             ./software/openldap23-servers-2.3.[0-9]*-[0-9]*.secioss.*.rpm >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "openldapのアップデートに失敗しました。"
        return 1
    fi
    echo "openldapをアップデートしました。"

    rpm -Fvh ./software/perl-LISM-[0-9]*.[0-9]*.[0-9]*-[0-9]*.secioss.noarch.rpm >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "LISMのアップデートに失敗しました。"
        return 1
    fi
    echo "LISMをアップデートしました。"

    rpm -Fvh ./software/php-Secioss-AutoLogin-*.secioss.noarch.rpm >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "php-Secioss-AutoLoginのアップデートに失敗しました。"
        return 1
    fi
    echo "php-Secioss-AutoLoginをアップデートしました。"

    rpm -Fvh ./software/access-manager-apps-*.secioss.noarch.rpm >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "access-manager-appsのアップデートに失敗しました。"
        return 1
    fi
    echo "access-manager-appsをアップデートしました。"

    rpm -Fvh ./software/simplesamlphp-*.rpm >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "simplesamlphpのアップデートに失敗しました。"
        return 1
    fi
    echo "simplesamlphpをアップデートしました。"

    cp ./src/saml_sp.php /var/www/lib/
    cp ./src/{SoapLism.pm,lism.cgi,lism_rest.cgi}  /var/www/cgi-bin/lism/
    cp ./src/oauth2/*.php /usr/share/oauth/
    cp -r ./src/oauth2/lib /usr/share/oauth/
    cp ./src/oauth2/cleanoauth /opt/secioss/sbin/
    cp ./src/idsync /opt/secioss/sbin/
    cp -r ./src/lism /var/www/html

    echo "$PRODUCTのアップデートが完了しました。"
}

function uninstall() {
    rm /opt/secioss/etc/lism*.conf
    rm -rf /var/www/cgi-bin/lism
    rm /var/www/lib/saml_sp.php
    rm -rf /usr/share/oauth
    rm /opt/secioss/sbin/{idsync,cleanoauth}
    rm -rf /var/www/html/lism

    rpm -e php-pecl-filter >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "php-pecl-filterのアンインストールに失敗しました。"
    else
        echo "php-pecl-filterをアンインストールしました。"
    fi

    rpm -e simplesamlphp >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "simplesamlphpのアンインストールに失敗しました。"
    else
        echo "simplesamlphpをアンインストールしました。"
    fi

    rpm -e access-manager-apps > $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "access-manager-appsのアンインストールに失敗しました。"
    else
        echo "access-manager-appsをアンインストールしました。"
    fi

    rpm -e php-Secioss-AutoLogin >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "php-Secioss-AutoLoginのアンインストールに失敗しました。"
    else
        echo "php-Secioss-AutoLoginをアンインストールしました。"
    fi

    rpm -e perl-LISM >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "LISMのアンインストールに失敗しました。"
    else
        echo "LISMをアンインストールしました。"
    fi

    rpm -e openldap23 openldap23-servers >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "openldapのアンインストールに失敗しました。"
    else
        echo "openldapをアンインストールしました。"
    fi

    rpm -e perl-Net-LDAP-Server >> $LOG 2>&1
    if [ $? -ne 0 ]; then
        echo "perl-Net-LDAP-Serverのアンインストールに失敗しました。"
    else
        echo "perl-Net-LDAP-Serverをアンインストールしました。"
    fi

    rm -f /etc/httpd/conf.d/autologin.conf

    echo "$PRODUCTのアンインストールが完了しました。"
}

case "$1" in
    install)
        install
        ;;
    update)
        update
        ;;
    uninstall)
        uninstall
        ;;
    *)
        echo $"Usage: $0 {install|update|uninstall}"
esac

