<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * autolink class
 *
 * PHP version 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license/3_0.txt.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Services
 * @package    Services_Hatena
 * @author     gooooooogle
 * @copyright  2006 gooooooogle
 * @license    http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version    CVS: $Id$
 */

/**
 * autolink class
 *
 * This is autolink class.
 *
 * @category   Services
 * @package    Services_Hatena
 * @author     gooooooogle
 * @copyright  2006 gooooooogle
 * @license    http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version    CVS: $Id$
 */
class Services_Hatena_autolink extends Services_Hatena_base {
    protected $parameters;

    public function Services_Hatena_autolink()
    {
    }

    public function execute($keyword) {
        mb_internal_encoding('euc');
        require_once "XML/RPC.php";

        $keyword = mb_convert_encoding($keyword,'utf8',mb_internal_encoding());
        $params  = $this->makeParams($keyword);

        $msg      = new XML_RPC_Message("hatena.setKeywordLink", array($params));
        $client   = new XML_RPC_Client("/xmlrpc", "d.hatena.ne.jp", 80);
        $response = $client->send($msg);

        if ( !$response->faultCode() ) {
          $r = $response->value()->scalarval();
          $r = strtr($r, array( '&lt;'=>'<', '&gt;'=>'>', '&quote;'=>'"' ));
          $this->result = mb_convert_encoding($r ,mb_internal_encoding(),'utf-8');
          return $this->getResult();
        }
        else {
          /** i do nothing */
        }
    }

    public function setScore($score) {
        if ( $score < 0 || 50 < $score ) {
           /** i do nothing */
           return;
        }
        $this->parameters["score"] = $score; 
    }

    public function setTarget($target) {
        $this->parameters["a_target"] = $target; 
    }

    public function setClass($class) {
        $this->parameters["a_class"] = $class; 
    }

    public function setCname($cname) {
        if ( !(is_array($cname)) ) {
           $cname = array($cname);
        }
        $this->parameters["cname"] = $cname; 
    }

    private function makeParams($keyword) {
        $score    = isset($this->parameters["score"])    ? $this->parameters["score"]    : 0; 
        $a_target = isset($this->parameters["a_target"]) ? $this->parameters["a_target"] : "_blank"; 
        $a_class  = isset($this->parameters["a_class"])  ? $this->parameters["a_class"]  : "keyword"; 
        $cname    = array();
        if ( isset($this->parameters["cname"]) ) {
            foreach ( $this->parameters["cname"] as $c ) {
                 $xml_rpc_value = new XML_RPC_Value($c,"string");
                 array_push($cname, $xml_rpc_value);
            }
        }

        $params  = new XML_RPC_Value(array(
           "body"     => new XML_RPC_Value($keyword , "string"),
           "score"    => new XML_RPC_Value($score   , "int"),
           "cname"    => new XML_RPC_Value($cname   , "array"),
           "a_target" => new XML_RPC_Value($a_target, "string"),
           "a_class"  => new XML_RPC_Value($a_class , "string")
        ), "struct");

        return $params;
    }
}
