﻿/*************************
  Coppermine Photo Gallery
  ************************
  Copyright (c) 2003-2015 Coppermine Dev Team
  v1.0 originally written by Gregory Demar

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License version 3
  as published by the Free Software Foundation.
  
  ********************************************
  Coppermine version: 1.5.40
  $HeadURL: https://svn.code.sf.net/p/coppermine/code/trunk/cpg1.5.x/docs/se/script.js $
  $Revision: 8830 $
**********************************************/

var linebreak = '\n';

$(function() {
    $("#toc_overall").treeview({
        collapsed: true,
        animated: "medium",
        control:"#sidetreecontrol"
    });
    $(".cpg_zebra tr:even").addClass("tableb");
    $(".cpg_zebra tr:odd").addClass("tableb_alternate");
});

function cpgDocToc() {
  if (getUrlParameters('hide_nav') == 1) {
    $('#toc').replaceWith('');
    return;
  }
var doc_toc = '';
doc_toc += '<div id="toc_collapsed">\n';
doc_toc += '<h6><a href="toc.htm">Innehållsförteckning</a></h6>\n';
doc_toc += 'Flytta musen hit för att utöka';
doc_toc += '<div align="center"><img src="../../images/icons/downdown.png" border="0" width="10" height="10" alt="" /></div>\n';
doc_toc += '</div>\n';
doc_toc += '<div id="toc_expanded" style="display:none;">\n';
doc_toc += '<h6>Table of contents (<a href="../index.htm">Dokumentation Språkval</a>)</h6>\n';
doc_toc += '<ul id="tree">\n';
doc_toc += '  <li><a href="index.htm">Coppermine dokumentation</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="index.htm#about">Om Coppermine</a></li>\n';
doc_toc += '      <li><a href="index.htm#about_documentation">Om dokumentationen</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="index.htm#about_documentation_conventions">Dokumentationskonventioner</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="index.htm?expand_all=1#features">Funktioner</a></li>\n';
doc_toc += '      <li><a href="quickstart.htm#about">Quick-Start guide</a></li>\n';
doc_toc += '      <li><a href="toc.htm">Innehållsförteckning</a></li>\n';
doc_toc += '      <li><a href="requirements.htm">Minimikrav</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="requirements.htm#what_minimum">Server-sidans minimikrav</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="requirements.htm#what_minimum_webserver">Webbserver</a></li>\n';
doc_toc += '              <li><a href="requirements.htm#what_minimum_php">PHP support</a></li>\n';
doc_toc += '              <li><a href="requirements.htm#what_minimum_mysql">mySQL databas</a></li>\n';
doc_toc += '              <li><a href="requirements.htm#what_minimum_image_library">Bildbibliotek</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="requirements.htm#what_minimum_self-hosting">Self-Hosting &amp; Webserver Setup</a></li>\n';
doc_toc += '          <li><a href="requirements.htm#personal">Personliga krav</a></li>\n';
doc_toc += '          <li><a href="requirements.htm#requirements_faq">Krav FAQ</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="testing.htm">Testning / bug rapport</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="testing.htm#testing_support">Ingen support för alpha och beta versioner</a></li>\n';
doc_toc += '          <li><a href="testing.htm#testing_areas">Områden att särskilt uppmärksamma</a></li>\n';
doc_toc += '          <li><a href="testing.htm#testing_feature_list">Funktionslista</a></li>\n';
doc_toc += '          <li><a href="testing.htm#testing_report">Rapportformatet</a></li>\n';
doc_toc += '          <li><a href="testing.htm#testing_availability">Tillgänglighet</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="languages.htm">Språk</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="languages.htm#how">Hur språk fungerar i Coppermine</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="languages.htm#how_remove_language">Bli av med ett visst språk</a></li>\n';
doc_toc += '              <li><a href="languages.htm#how_language_fallback">Språk reservlösning</a></li>\n';
doc_toc += '              <li><a href="languages.htm#how_scope">Omfattning av internationalisering</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="languages.htm#language_manager">Språkhanteraren</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="languages.htm#language_manager_controls">Kontroller</a></li>\n';
doc_toc += '              <li><a href="languages.htm#language_manager_columns">Kolumner</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="languages.htm#language_manager_columns_default">Standard</a></li>\n';
doc_toc += '                  <li><a href="languages.htm#language_manager_columns_name">Språkets namn</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="languages.htm#language_manager_columns_name_english">Engelska</a>\n';
doc_toc += '                      <li><a href="languages.htm#language_manager_columns_name_native">Inhemsk</a>\n';
doc_toc += '                      <li><a href="languages.htm#language_manager_columns_name_custom">Anpassad</a>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="languages.htm#language_manager_columns_flag">Flagga</a></li>\n';
doc_toc += '                  <li><a href="languages.htm#language_manager_columns_file">Språkfil</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="languages.htm#language_manager_columns_file_available">Tillgänglig</a>\n';
doc_toc += '                      <li><a href="languages.htm#language_manager_columns_file_complete">Färdig</a>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="languages.htm#language_manager_columns_file">Aktiverad</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="translation.htm">Översättningsguide</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="translation.htm#translation_translators_wanted">Översättare önskas!</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_why_translate">Varför översätta?</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_which_languages">Vilka språk behöver översättas?</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_who">Vem kan översätta?</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_char_encoding">Teckenkodning</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_editors">Editorer &amp; Verktyg</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_full_translation">Full översättning endast</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_step_by_step">Steg för steg</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_special_issues">Särskilda frågor</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_versions">Språkversioner</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_work_in_progress">Arbete pågår</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_initial_translation">Inledande översättning för utgivning</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_older_language_files">Använda äldre språkfiler</a></li>\n';
doc_toc += '              <li><a href="translation.htm#translation_documentation">Översätta dokumentationen</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="translation.htm#translation_documentation_steps">Steg för att översätta docs till ditt språk</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="translation.htm#translation_documentation_steps_not_exist">Kontrollera att översättning inte redan finns</a></li>\n';
doc_toc += '                      <li><a href="translation.htm#translation_documentation_steps_structure">Skapa strukturen</a></li>\n';
doc_toc += '                      <li><a href="translation.htm#translation_documentation_steps_copy_core">Kopiera kärnspråkfilerna</a></li>\n';
doc_toc += '                      <li><a href="translation.htm#translation_documentation_steps_start_translating">Börja översätta</a></li>\n';
doc_toc += '                      <li><a href="translation.htm#translation_documentation_steps_attention">Områden att uppmärksamma</a></li>\n';
doc_toc += '                      <li><a href="translation.htm#translation_documentation_steps_toc">Ta hand om innehållsförteckningen</a></li>\n';
doc_toc += '                      <li><a href="translation.htm#translation_documentation_steps_zip">Packa (zip) din översättning</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="translation.htm#translation_links">Mer läsning</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="credits.htm">Credits</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="credits.htm#developers">Coppermine team</a></li>\n';
doc_toc += '          <li><a href="credits.htm#contributors">Medverkande</a></li>\n';
doc_toc += '          <li><a href="credits.htm#translators">Översättare</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="credits.htm#translators_language_file">Språkfiler</a></li>\n';
doc_toc += '              <li><a href="credits.htm#translators_documentation">Dokumentation</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="credits.htm#codebase">Använd fri kod</a></li>\n';
doc_toc += '          <li><a href="credits.htm#acknowledgements">Tack</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="credits.htm#acknowledgements_thanks">Många tack</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="copyrights.htm">License &amp; Copyright</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="copyrights.htm#copyright_copyright">Copyright</a></li>\n';
doc_toc += '          <li><a href="copyrights.htm#copyright_license">Licens</a></li>\n';
doc_toc += '          <li><a href="copyrights.htm#copyrights_previous_versions">Föregående versioner</a></li>\n';
doc_toc += '          <li><a href="copyrights.htm#copyright_additional">Ytterligare villkor (licens add-ons)</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="copyrights.htm#copyright_additional_preservation">Bevarande av författarbidrag</a></li>\n';
doc_toc += '              <li><a href="copyrights.htm#copyright_additional_marking">Markering av ändrade versioner</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="copyrights.htm#copyright_freedom">Frihet</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="known_issues.htm">Kända problem</a></li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="install.htm">Installation och setup</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="install.htm#how">Hur man installera programmet</a></li>\n';
doc_toc += '      <li><a href="install.htm#what">Vad installationsprogrammet gör</a></li>\n';
doc_toc += '      <li><a href="install.htm#install_related">Relaterad information</a></li>\n';
doc_toc += '      <li><a href="install.htm#install_server_config">Server konfigurering</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="install.htm#install_server_config_register_globals">register_globals</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="install_permissions.htm">Bevilja behörigheter</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="install_permissions.htm#permissions_webserver">Behörigheter på andra typer av webbservrar</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="install_permissions.htm#chmod">Apache på Unix/Linux (CHMOD)</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="install_permissions.htm#chmod_basics">Basics</a></li>\n';
doc_toc += '                  <li><a href="install_permissions.htm#chmod_groups">Groups i Lunix</a></li>\n';
doc_toc += '                  <li><a href="install_permissions.htm#chmod_daemon">Webserver daemon</a></li>\n';
doc_toc += '                  <li><a href="install_permissions.htm#chmod_binary_arithmetics">Binary arithmetics</a></li>\n';
doc_toc += '                  <li><a href="install_permissions.htm#chmod_benefit">Vad är nyttan med allt det här?</a></li>\n';
doc_toc += '                  <li><a href="install_permissions.htm#chmod_ftp">FTP applikation</a></li>\n';
doc_toc += '                  <li><a href="install_permissions.htm#chmod_website_control_panel">Webbsidans kontrollpanel</a></li>\n';
doc_toc += '                  <li><a href="install_permissions.htm#chmod_shell_access">Shell access</a></li>\n';
doc_toc += '                  <li><a href="install_permissions.htm#chmod_chown">Ägare (CHOWN)</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="install_permissions.htm#apache_windows">Apache på Windows</a></li>\n';
doc_toc += '              <li><a href="install_permissions.htm#iis">IIS på Windows</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="install_permissions.htm#support">Be om support för behörighetsproblem</a></li>\n';
doc_toc += '          <li><a href="install_permissions.htm#permissions_folders">Behörigheter på mappnivå</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="install_screen.htm#install_screen_start">Installationsskärmbilden</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="install_screen.htm#install_screen_classic">Den klassiska installationsskärmbilden</a></li>\n';
doc_toc += '          <li><a href="install_screen.htm#install_screen_wizard">Installationsguiden</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="auto-installers.htm">Auto-Installerare</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="auto-installers.htm#definition">Vad är Auto-installerare?</a></li>\n';
doc_toc += '          <li><a href="auto-installers.htm#sad_story">Den tråkiga historien</a></li>\n';
doc_toc += '          <li><a href="auto-installers.htm#">Varför du inte ska använda auto-installerare</a></li>\n';
doc_toc += '          <li><a href="auto-installers.htm#no_support">Ingen support</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="install_faq.htm">FAQ om installation</a></li>\n';
doc_toc += '      <li><a href="uninstall.htm">Avinstallera</a></li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="upgrading.htm">Uppgradera</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="upgrading.htm#upgrade_why">Varför uppgradera?</a>\n';
doc_toc += '          <ul>\n';
doc_toc += '              <li><a href="upgrading.htm#upgrade_why_reasons">Anledning till paket releaser</a></li>\n';
doc_toc += '              <li><a href="upgrading.htm#upgrade_why_changelog">Ändringslogg</a></li>\n';
doc_toc += '          </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="upgrading.htm#upgrade_any">Steg nödvändiga för att uppgradera Coppermine (från vilken som helst version)</a></li>\n';
doc_toc += '      <li><a href="upgrading.htm#upgrade_particular">Ytterligare åtgärder för uppdatering av vissa versioner</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="upgrading.htm#upgrade_10">Uppgradera från version cpg1.0,1.1,1.2.x eller 1.3.x</a></li>\n';
doc_toc += '          <li><a href="upgrading.htm#upgrade_14">Uppgradera från cpg1.4.x till version cpg1.5.x</a>\n';
doc_toc += '              <ul>\n';
doc_toc += '                  <li><a href="upgrading.htm#upgrade_14_plugins">Insticksmoduler (Plugins)<</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#upgrade_14_custom_theme">Anpassade teman</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#upgrade_14_language_files">Språkfiler</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#upgrade_14_password_encryption">Lösenordskryptering</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#upgrade_14_faq">Visa FAQ</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#upgrade_14_outdated_files">Föråldrade filer</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#upgrade_14_safe_mode">Säkert läge</a></li>\n';
doc_toc += '              </ul>\n';
doc_toc += '          <li><a href="upgrading.htm#upgrade_15">Uppgradera från äldre versioner av cpg1.5.x till den senaste versionen av cpg1.5.x</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="upgrading.htm#updater">Uppdateringsprogrammet</a>\n';
doc_toc += '          <ul>\n';
doc_toc += '              <li><a href="upgrading.htm#updater_what_it_does">Vad det gör</a></li>\n';
doc_toc += '              <li><a href="upgrading.htm#updater_purpose">Syfte</a></li>\n';
doc_toc += '              <li><a href="upgrading.htm#updater_authorization">Behörighetskontroll</a></li>\n';
doc_toc += '              <li><a href="upgrading.htm#updater_when">När måste uppdateringsprogrammet köras?</a></li>\n';
doc_toc += '          </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="upgrading.htm#versioncheck">Versionskontrollverktyget</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="upgrading.htm#versioncheck_description_start">Vad det gör</a></li>\n';
doc_toc += '          <li><a href="upgrading.htm#versioncheck_first_run">Första körningen</a></li>\n';
doc_toc += '          <li><a href="upgrading.htm#versioncheck_options_start">Alternativ</a>\n';
doc_toc += '              <ul>\n';
doc_toc += '                  <li><a href="upgrading.htm#versioncheck_options_display_output">Visa output</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#versioncheck_options_only_show_potential_errors">Visa bara eventuella fel</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#versioncheck_options_hide_images">Dölj bilder</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#versioncheck_options_no_modification_check">Kontrollera inte efter ändrade filer</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#versioncheck_options_no_connect_online_repository">Anslut inte till förvaringsplats online</a></li>\n';
doc_toc += '              </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="upgrading.htm#versioncheck_comparison_start">Jämför versioner</a>\n';
doc_toc += '              <ul>\n';
doc_toc += '                  <li><a href="upgrading.htm#versioncheck_comparison_path">Sökväg</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#versioncheck_comparison_missing">Saknas</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#versioncheck_comparison_permissions">Behörigheter</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#versioncheck_comparison_version">Versioner</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#versioncheck_comparison_revision">Granskad</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#versioncheck_comparison_modified">Ändrad</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#versioncheck_comparison_comment">Kommentar</a></li>\n';
doc_toc += '                  <li><a href="upgrading.htm#versioncheck_comparison_repository_link">Länk till förvaringsplats</a></li>\n';
doc_toc += '              </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="upgrading.htm#versioncheck_problems">Saker som kan bli fel vid användning av versionskontroll</a></li>\n';
doc_toc += '          <li><a href="upgrading.htm#versioncheck_expect">Förväntade fel</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="upgrading.htm#upgrade_faq">FAQ om uppgradering</a></li>\n';
doc_toc += '      <li><a href="upgrading.htm#downgrading">Nedgradera från cpg1.5.x till en äldre version</a></li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="start.htm">Komma igång</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="start.htm#getting_concepts">Grundläggande begrepp</a></li>\n';
doc_toc += '      <li><a href="start.htm#getting_initial_configuration">Grundläggande begrepp</a></li>\n';
doc_toc += '      <li><a href="start.htm#getting_structure">Kategori/album/fil struktur</a></li>\n';
doc_toc += '      <li><a href="start.htm#getting_resizing">Skalade bilder</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="start.htm#getting_resizing_thumbnails">Miniatyrbilder</a></li>\n';
doc_toc += '          <li><a href="start.htm#getting_resizing_intermediate">Medelstora bilder</a></li>\n';
doc_toc += '          <li><a href="start.htm#getting_resizing_original">Original</a></li>\n';
doc_toc += '          <li><a href="start.htm#getting_resizing_recommended">Rekommenderad skalningsinställning</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="start.htm#getting_resizing_recommended_nofullsize">Inga full-storlekts pop-ups</a></li>\n';
doc_toc += '              <li><a href="start.htm#getting_resizing_recommended_nointermediate">Tillåt full-storleks pop-ups med maximalt storleksbesparing</a></li>\n';
doc_toc += '              <li><a href="start.htm#getting_resizing_recommended_regular">&quot;Vanlig&quot; inställning med moderat filutrymmesutnyttjande</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="start.htm#getting_admin_account">Ditt administratörskonto</a></li>\n';
doc_toc += '      <li><a href="start.htm#getting_check_uploads">Kontrollera uppladdningar</a></li>\n';
doc_toc += '      <li><a href="start.htm#getting_consider_bridging">Överväg länkning (bridging)</a></li>\n';
doc_toc += '      <li><a href="start.htm#getting_interaction">Vad har dina besökare tillåtelse att göra?</a></li>\n';
doc_toc += '      <li><a href="start.htm#getting_design">Ändra din coppermine design</a></li>\n';
doc_toc += '      <li><a href="start.htm#getting_typical">Typiska inställningar</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="start.htm#getting_typical_monolithic">Enstaka uppladdning utan användarens medverkan (Monolitiskt galleri)</a></li>\n';
doc_toc += '          <li><a href="start.htm#getting_typical_single_uploader_community">Enstaka uppladdning med användarens medverkan </a></li>\n';
doc_toc += '          <li><a href="start.htm#getting_typical_multiple_uploader_closed">Flera uppladdare utan nyregistreringar (sluten grupp)</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="faq.htm">Vanliga frågor (FAQ) </a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="faq.htm#faq_setup">Setup / Konfiguration</a></li>\n';
doc_toc += '      <li><a href="faq.htm#hacks">Tillägg / Ändringar / Hacks</a></li>\n';
doc_toc += '      <li><a href="faq.htm#support_board">Coppermine Support board</a></li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="theme.htm">Teman</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="theme.htm#theme_builtin">Teman som kommer med Coppermine</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="theme.htm#theme_builtin_curve">Curve</a></li>\n';
doc_toc += '          <li><a href="theme.htm#theme_builtin_eyeball">Eyeball</a></li>\n';
doc_toc += '          <li><a href="theme.htm#theme_builtin_hardwired">Hardwired</a></li>\n';
doc_toc += '          <li><a href="theme.htm#theme_builtin_rainy_day">Rainy Day</a></li>\n';
doc_toc += '          <li><a href="theme.htm#theme_builtin_sample">Sample</a></li>\n';
doc_toc += '          <li><a href="theme.htm#theme_builtin_waterdrop">Waterdrop</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="theme.htm#theme_upgrading">Uppgradera ditt anpassade tema</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="theme_upgrade_14x-15x.htm">Konvertera cpg1.4.x tema till cpg1.5.x</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="theme_upgrade_14x-15x.htm#theme_convert_style">Redigera style.css</a></li>\n';
doc_toc += '              <li><a href="theme_upgrade_14x-15x.htm#theme_convert_template">Redigera template.html</a></li>\n';
doc_toc += '              <li><a href="theme_upgrade_14x-15x.htm#theme_convert_theme">Redigera theme.php</a></li>\n';
doc_toc += '              <li><a href="theme_upgrade_14x-15x.htm#theme_convert_validation">Valideringsmetod</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="theme.htm#theme_files">Tema innehåll</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="theme_template.htm#theme_template_html">Redigera template.html</a>\n';
doc_toc += '              <ul>\n';
doc_toc += '                  <li><a href="theme_template.htm#theme_template_token">Mallsymbolers</a></li>\n';
doc_toc += '                  <li><a href="theme_template.htm#theme_template_important">Vikigt</a></li>\n';
doc_toc += '                  <li><a href="theme_template.htm#theme_template_token_list">Lista på symboler i template.html</a></li>\n';
doc_toc += '              </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="theme_style_css.htm#theme_style_css">Redigera style.css</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="theme_style_css.htm#theme_style_css_tools">Verktyg</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="theme_style_css.htm#theme_style_css_tools_webdev">Web Developer Toolbar användning</a></li>\n';
doc_toc += '                  <li><a href="theme_style_css.htm#theme_style_css_tools_editor">Editor</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="theme_style_css.htm#theme_style_css_list">Lista på classes i style.css</a></li>\n';
doc_toc += '              <li><a href="theme_style_css.htm#theme_style_css_overall">Ytterligare stylesheet</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="theme_theme_php.htm#theme_create_theme_php">Redigera theme.php</a>\n';
doc_toc += '              <ul>\n';
doc_toc += '                  <li><a href="theme_theme_php.htm#theme_php_types">Objekttyper</a></li>\n';
doc_toc += '                  <li><a href="theme_theme_php.htm#theme_sample">Exempeltema - en mall att kopiera ifrån</a></li>\n';
doc_toc += '                  <li><a href="theme_theme_php.htm#theme_php_method">Metod</a></li>\n';
doc_toc += '                  <li><a href="theme_theme_php.htm#theme_php_scope">Omfattning</a></li>\n';
doc_toc += '                  <li><a href="theme_theme_php.htm#theme_php_list">Lista på objekt i theme.php</a></li>\n';
doc_toc += '                  <li><a href="theme_examples.htm#theme_examples">Tema Exempel</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="theme_examples.htm#theme_examples_content">Ytterligare innehåll</a>\n';
doc_toc += '                        <ul>\n';
doc_toc += '                          <li><a href="theme_examples.htm#theme_examples_content_thumbnail">Ytterligare innehåll på sidan för miniatyrbilder</a>\n';
doc_toc += '                            <ul>\n';
doc_toc += '                              <li><a href="theme_examples.htm#theme_examples_content_thumbnail_extra_row">Extra rad mellan miniatyrbildsrader</a></li>\n';
doc_toc += '                              <li><a href="theme_examples.htm#theme_examples_content_thumbnail_cell">Extra tabellcell på varje miniatyrbildssida</a></li>\n';
doc_toc += '                            </ul>\n';
doc_toc += '                          </li>\n';
doc_toc += '                          <li><a href="theme_examples.htm#theme_examples_content_displayimage">Ytterligare innehåll på sidorna för medelstora bilder</a>\n';
doc_toc += '                            <ul>\n';
doc_toc += '                              <li><a href="theme_examples.htm#theme_examples_content_displayimage_image">Direkt bredvid den medelstora bilden</a></li>\n';
doc_toc += '                              <li><a href="theme_examples.htm#theme_examples_content_displayimage_filmstrip">Direkt bredvid filmremsan</a></li>\n';
doc_toc += '                            </ul>\n';
doc_toc += '                          </li>\n';
doc_toc += '                          <li><a href="theme_examples.htm#theme_examples_content_fullsize">Ytterligare innehåll på bilden för fullstora pop-up</a></li>\n';
doc_toc += '                          <li><a href="theme_examples.htm#theme_examples_content_menu">Ytterligare menyobjekt</a>\n';
doc_toc += '                            <ul>\n';
doc_toc += '                              <li><a href="theme_examples.htm#theme_examples_content_menu">Hela menystrukturen definierad i ett block</a></li>\n';
doc_toc += '                            </ul>\n';
doc_toc += '                          </li>\n';
doc_toc += '                        </ul>\n';
doc_toc += '                      </li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="theme_theme_php.htm#theme_php_summary">Sammanfattning</a></li>\n';
doc_toc += '              </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="theme.htm#theme_engine">Hur temamotorn fungerar</a></li>\n';
doc_toc += '      <li><a href="theme_user-contributions.htm#theme_user-contributions">Användarnas egna tema</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="theme_user-contributions.htm#theme_user-contributions_preview">Förhandsvisa användarnas egna tema</a></li>\n';
doc_toc += '          <li><a href="theme_user-contributions.htm#theme_user-contributions_download">Ladda ner användarnas egna tema</a></li>\n';
doc_toc += '          <li><a href="theme_user-contributions.htm#theme_user-contributions_install">Installera användarnas egna tema</a></li>\n';
doc_toc += '          <li><a href="theme_user-contributions.htm#theme_user-contributions_copyrights">Copyrights användarnas egna tema</a></li>\n';
doc_toc += '          <li><a href="theme_user-contributions.htm#theme_user-contributions_support">Be om support för användarnas egna tema</a></li>\n';
doc_toc += '          <li><a href="theme_user-contributions.htm#theme_user-contributions_contributing">Bidra med eget tema</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="theme_create.htm#theme_create">Skapa ditt anpassade tema</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="theme_create.htm#theme_create_rename">Döp om ditt tema först</a></li>\n';
doc_toc += '          <li><a href="theme_create.htm#theme_create_tipps">Tips &amp; tricks</a></li>\n';
doc_toc += '          <li><a href="theme_create.htm#theme_create_wysiwyg">Använda WYSIWYG-editorer</a></li>\n';
doc_toc += '          <li><a href="theme_create.htm#theme_create_colors">Ändra färger</a></li>\n';
doc_toc += '          <li><a href="theme_create_matching_page_tutorial.htm#theme_matching">Skapa ett Coppermine tema som motsvarar din övergripande sidolayout</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="theme_create_matching_page_tutorial.htm#theme_matching_intro">Introduktion</a></li>\n';
doc_toc += '              <li><a href="theme_create_matching_page_tutorial.htm#theme_matching_pre-requisites">Förutsättningar</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="theme_create_matching_page_tutorial.htm#theme_matching_pre-requisites_tools">Verktyg</a></li>\n';
doc_toc += '                  <li><a href="theme_create_matching_page_tutorial.htm#theme_matching_pre-requisites_skills">Färdigheter</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="theme_create_matching_page_tutorial.htm#theme_matching_examples">Exempel</a></li>\n';
doc_toc += '              <li><a href="theme_create_matching_page_tutorial.htm#theme_matching_pick_similar">Välj ett liknande tema först</a></li>\n';
doc_toc += '              <li><a href="theme_create_matching_page_tutorial.htm#theme_matching_start">Börja redigera ditt tema</a></li>\n';
doc_toc += '              <li><a href="theme_create_matching_page_tutorial.htm#theme_matching_placeholder_replace">Ersätt innehåll i exempel med platshållarsymboler</a></li>\n';
doc_toc += '              <li><a href="theme_create_matching_page_tutorial.htm#theme_matching_style">Anpassa utseendet</a></li>\n';
doc_toc += '              <li><a href="theme_create_matching_page_tutorial.htm#theme_matching_test1">Första test</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="theme_template.htm#theme_template_html">Redigera template.html</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="theme_template.htm#theme_template_token">Mallsymboler</a></li>\n';
doc_toc += '              <li><a href="theme_template.htm#theme_template_important">Viktigt</a></li>\n';
doc_toc += '              <li><a href="theme_template.htm#theme_template_token_list">Lista på symboler i template.html</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="theme_theme_php.htm#theme_php">Redigera theme.php</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="theme_theme_php.htm#theme_php_types">Objekttyper</a></li>\n';
doc_toc += '              <li><a href="theme_theme_php.htm#theme_sample">Exempeltema - en mall att kopiera ifrån</a></li>\n';
doc_toc += '              <li><a href="theme_theme_php.htm#theme_php_method">Metod</a></li>\n';
doc_toc += '              <li><a href="theme_theme_php.htm#theme_php_scope">Omfattning</a></li>\n';
doc_toc += '              <li><a href="theme_theme_php.htm#theme_php_list">Lista på objekt i  theme.php</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="theme_style_css.htm#theme_style_css">Redigera style.css</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="theme_style_css.htm#theme_style_css_tools">Verktygs</a></li>\n';
doc_toc += '              <li><a href="theme_style_css.htm#theme_style_css_list">Lista på classes i style.css</a></li>\n';
doc_toc += '              <li><a href="theme_style_css.htm#theme_style_css_overall">Ytterligare stylesheet</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="theme_examples.htm#theme_examples">Tema exempel</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="theme_examples.htm#theme_examples_summary">Sammanfattning</a></li>\n';
doc_toc += '          <li><a href="theme_examples.htm#theme_examples_content">Ytterligare innehåll</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="theme_examples.htm#theme_examples_content_thumbnail">Ytterligare innehåll på sidan för miniatyrbilder</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="theme_examples.htm#theme_examples_content_thumbnail_extra_row">Extra rad mellan miniatyrbildsraderna</a></li>\n';
doc_toc += '                  <li><a href="theme_examples.htm#theme_examples_content_thumbnail_cell">Extra tabellcell på varje miniatyrbildssida</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="theme_examples.htm#theme_examples_content_displayimage">Extra innehåll på sidorna för medelstora bilder (displayimage.php)</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="theme_examples.htm#theme_examples_content_displayimage_image">Direkt bredvid den medelstora bilden</a></li>\n';
doc_toc += '                  <li><a href="theme_examples.htm#theme_examples_content_displayimage_filmstrip">Direkt bredvid den medelstora bilden</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="theme_examples.htm#theme_examples_content_fullsize">Ytterligare innehåll på den fullstora pop-up</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="theme_copyright.htm">Inte ange Copyright i sidfoten</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="theme_copyright.htm#theme_copyright_fair_use">Just användning</a>\n';
doc_toc += '          <li><a href="theme_copyright.htm#theme_copyright_unfair_use">Ojust användning</a>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="php-content.htm">Dynamiskt (PHP-drivet) innehåll</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="php-content.htm#php-content_anycontent">Använda anycontent.php</a></li>\n';
doc_toc += '          <li><a href="php-content.htm#php-content_header_footer">Använda</a></li>\n';
doc_toc += '          <li><a href="php-content.htm#php-content_theme">Tema-baserad dynamiskt innehåll (theme.php)</a></li>\n';
doc_toc += '          <li><a href="php-content.htm#php-content_core">Ändra källfiler</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="theme_graphics.htm">Grafiska resurser i teman</a>\n';
doc_toc += '          <ul>\n';
doc_toc += '              <li><a href="theme_graphics.htm#theme_graphics_menu_icons">Menyikoner</a></li>\n';
doc_toc += '              <li><a href="theme_graphics.htm#theme_graphics_nav_bar">Bildadressrad</a></li>\n';
doc_toc += '              <li><a href="theme_graphics.htm#theme_graphics_rating">Röstningsbilder</a></li>\n';
doc_toc += '              <li><a href="theme_graphics.htm#theme_graphics_film_strip">Grafisk Filmremsa</a></li>\n';
doc_toc += '              <li><a href="theme_graphics.htm#theme_graphics_progress">Framstegsbild (laddare)</a></li>\n';
doc_toc += '          </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="administration.htm">Administration</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="admin_menu.htm">Objekt på administrationsmenyn</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="admin_menu.htm#admin_user_mode">Aktivera / inaktivera admin kontroller</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#upload_approval">Ladda upp godkännande</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#config">Konfigurera</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#categories">Kategorier</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#albums">Album</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#sort_my_pictures">Sortera mina bilder</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#groups">Grupper</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#users">Användare</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#ban">Blockera användare</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#my_profile">Min profil</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#review_comments">Granska kommentarer</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#ecard_log">Visa E-kort</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#batch_add">Batch-uppladda filer</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#admin_tools">Admin Verktyg (Skala bilder)</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#keyword_manager">Hantera nyckelord</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#plugin_manager">Hantera insticksmoduler (Plugin)</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#bridge_manager">Hantera länkning (Bridge)</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#view_log">Visa loggfiler</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#stats">Övergripande statistik</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#versioncheck">Kontrollera versioner</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#update_database">Uppdatera databas</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#export">Export</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#phpinfo">phpinfo</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#show_news">Visa nyheter</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#documentation">Dokumentation</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#admin_mode_regular_users">Admin läge för vanliga användare</a></li>\n';
doc_toc += '          <li><a href="admin_menu.htm#user_menu_items">Admin meny objekt för vanliga användare</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="banning.htm#banning">Blockering</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="banning.htm#banning_whats_new">Vad är nytt?<</a></li>\n';
doc_toc += '          <li><a href="banning.htm#banning_scope">Omfattning</a></li>\n';
doc_toc += '          <li><a href="banning.htm#bannig_how_it_works">Hur blockering fungerar</a></li>\n';
doc_toc += '          <li><a href="banning.htm#banning_by_ip_address_no_good">Varför blockering av en IP adress inte rekommenderas</a></li>\n';
doc_toc += '          <li><a href="banning.htm#banning_page">Sidokontroller</a></li>\n';
doc_toc += '          <li><a href="banning.htm#banning_bridged">Ingen blockering vid länkning</a></li>\n';
doc_toc += '          <li><a href="banning.htm#banning_todo">Att göra</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="configuration.htm">Konfigurering</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="configuration.htm#admin_general">Allmänna inställningar</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_language">Inställningar för språk &amp; teckenuppsättning</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_theme">Inställningar för tema</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_album_list">Album listvy</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_thumbnail_view">Miniatyrbildsvy</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_image_comment">Bildvy</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_comment_start">Inställningar för kommentarer</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_contact_start">Inställningar för kontaktformulär</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_thumb_start">Inställningar för miniatyrbilder</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_picture_thumbnail">Inställningar för filer</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_watermarking">Vattenstämpling av bilder</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_registration">Registrering</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_user">Inställningar för användare</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_custom">Anpassade fält för användarprofil</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_custom_image">Anpassade fält för bildbeskrivningar</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_cookie">Inställningar för cookies</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_email">Inställningar för e-post</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_logging">Loggning &amp; statistik</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_misc">Inställningar för underhåll</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_config_usage">Användning av den här sidan</a></li>\n';
doc_toc += '          <li><a href="configuration.htm#admin_reset_entire_config">Återställ fabriksinställningar</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="groups.htm">Grupper</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="groups.htm#group_cp">Kontrollpanelen för grupper</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_names">Gruppnamn</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_types">Grupptyper</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_quota">Kvot</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_permissions">Gruppbehörigheter (Röster/E-kort/Kommentarer)</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_public">Publika albumuppladdningar</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_personal">Personligt galleri</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_upload_method">Uppladdningsmetod</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_assigned">Tilldelade album</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_create">Skapa anpassade grupper</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_delete">Radera anpassade grupper</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_sync">Trigga synkronisering (länkning endast)</a></li>\n';
doc_toc += '          <li><a href="groups.htm#group_cp_more_than_one_group">Medlemskap i mer än en grupp</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="users.htm">Användare</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="users.htm#user_cp">Kontrollpanelen för användare</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="users.htm#user_cp_page">Sidokontroller</a></li>\n';
doc_toc += '              <li><a href="users.htm#user_cp_search">Sök användare</a></li>\n';
doc_toc += '              <li><a href="users.htm#user_cp_new">Skapa nya användare</a></li>\n';
doc_toc += '              <li><a href="users.htm#user_cp_edit">Redigera användare</a></li>\n';
doc_toc += '              <li><a href="users.htm#user_cp_group">Gruppmedlemskap</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="users.htm#lost_password">Glömt lösenord</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="users.htm#lost_password_cpg_user_account">Lösenord för Coppermine användarkonto</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="users.htm#lost_password_cpg_user_account_standalone">Coppermine i fristående läge</a></li>\n';
doc_toc += '                  <li><a href="users.htm#lost_password_cpg_user_account_bridged">Coppermine länkat (bridged)</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="users.htm#lost_password_cpg_user_account">Lösenord för mySQL konto</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="categories.htm">Kategorier</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="categories.htm#cat_cp">Kontrollpanelen för kategorier</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="categories.htm#cat_cp_page_controls"Sidokontroller</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="categories.htm#cat_cp_page_controls_sort">Ruta överst &quot;Sortera kategorier alfabetiskt&quot;</a></li>\n';
doc_toc += '                  <li><a href="categories.htm#cat_cp_page_controls_categories">Ruta mitten &quot;Hantera kategorier&quot;</a></li>\n';
doc_toc += '                  <li><a href="categories.htm#cat_cp_page_controls_create">Ruta nederst &quot;Uppdatera/Skapa kategori&quot;</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="categories.htm#cat_user_galleries">Special kategori &quot;Användargallerier&quot;</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="albums.htm">Album</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="albums.htm#albmgr">Hantera Album</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="albums.htm#albmgr_create">Skapa album</a></li>\n';
doc_toc += '              <li><a href="albums.htm#albmgr_rename">Döpa om album</a></li>\n';
doc_toc += '              <li><a href="albums.htm#albmgr_order">Ändra ordning på album</a></li>\n';
doc_toc += '              <li><a href="albums.htm#albmgr_delete">Radera album</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="albums.htm#modif_alb_pics">Ändra album/filer</a></li>\n';
doc_toc += '          <li><a href="albums.htm#album_prop">Albumegenskaper</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="albums.htm#album_prop_reset_start">Nollställ albumegenskaper</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="albums.htm#album_admin_user">Admin jmf. användare</a></li>\n';
doc_toc += '          <li><a href="albums.htm#album_faq">FAQ om album</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="files.htm">Filer</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="files.htm#edit_pics">Redigera filer</a></li>\n';
doc_toc += '          <li><a href="files.htm#edit_vids">Redigera video</a></li>\n';
doc_toc += '          <li><a href="files.htm#cust_thmb">Anpassa miniatyrbilder</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="files.htm#cust_thmb_order">Ordning på miniatyrbilder</a></li>\n';
doc_toc += '              <li><a href="files.htm#cust_thmb_types">Miniatyrbildstyper</a></li>\n';
doc_toc += '              <li><a href="files.htm#cust_thmb_upload">Ladda upp anpassade miniatyrbilder</a></li>\n';
doc_toc += '              <li><a href="files.htm#cust_thmb_how">Hur det fungerar</a></li>\n';
doc_toc += '              <li><a href="files.htm#cust_thmb_how_naming">Namnsystem</a></li>\n';
doc_toc += '              <li><a href="files.htm#cust_thmb_why">Varför kan inte coppermine skapa miniatyrbilder för mina videos?</a></li>\n';
doc_toc += '              <li><a href="files.htm#cust_thmb_step">Steg-för-steg instruktioner</a></li>\n';
doc_toc += '              <li><a href="files.htm#cust_thmb_faq">FAQ om anpassade miniatyrbilder</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="keywords.htm">Nyckelord</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="keywords.htm#keywords_assign">Tilldela nyckelord</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="keywords.htm#keywords_assign_separator">Nyckelordseparerare eller nyckelordsavgränsare</a></li>\n';
doc_toc += '              <li><a href="keywords.htm#keywords_assign_edit">Redigera/lägga till nyckelord</a></li>\n';
doc_toc += '              <li><a href="keywords.htm#keywords_manager">Hantera nyckelord</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="keywords.htm#keywords_album">Album nyckelord</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="bbcode.htm">bbCode</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="bbcode.htm#bbcode_purpose">Syfte</a></li>\n';
doc_toc += '          <li><a href="bbcode.htm#bbcode_available">Tillgängliga bbcode taggar</a></li>\n';
doc_toc += '          <li><a href="bbcode.htm#bbcode_dangers">Faror</a></li>\n';
doc_toc += '          <li><a href="bbcode.htm#bbcode_control">Mer kontroll</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="exif.htm">Exif data</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="exif.htm#exif_what">Vad är EXIF</a></li>\n';
doc_toc += '          <li><a href="exif.htm#exif_makers">Olika smaker</a></li>\n';
doc_toc += '          <li><a href="exif.htm#exif_how_it_works">Hur det fungerar</a></li>\n';
doc_toc += '          <li><a href="exif.htm#exif_image_libraries">Ingen exif support på servern</a></li>\n';
doc_toc += '          <li><a href="exif.htm#exif_limitations">Begränsningar</a></li>\n';
doc_toc += '          <li><a href="exif.htm#exif_manager">Hantera EXIF</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="plugins.htm">Insticksmoduler (plugins)</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="plugins.htm#plugin_definition">Vad är en insticksmodul (plugin)?</a></li>\n';
doc_toc += '          <li><a href="plugins.htm#plugin_api">Insticksmodulens API</a></li>\n';
doc_toc += '          <li><a href="plugins.htm#plugin_obtain">Var får man insticksmoduler ifrån?</a></li>\n';
doc_toc += '          <li><a href="plugins.htm#plugin_bundled">Insticksmoduler som kommer med Coppermine</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_bundled_link_target">Mållänk (link_target)</a></li>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_bundled_onlinestats">Vem är online? (onlinestats)</a></li>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_bundled_opensearch">OpenSearch (opensearch)</a></li>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_bundled_sample">Exempel på insticksmodul (sample)</a></li>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_bundled_usergal_alphatabs">Användargalleri alfabetiskt tabbning (usergal_alphatabs)</a></li>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_bundled_visiblehookpoints">Synliga HookPoints (visiblehookpoints)</a></li>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_bundled_sef_url">SEF_URLS plugin</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="plugins.htm#plugin_manager">Hantera insticksmoduler (plugins)</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_manager_upload">Ladda upp en insticksmodul</a></li>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_manager_install">Installera en insticksmodul</a></li>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_manager_configuration">Konfigurera insticksmodul</a></li>\n';
doc_toc += '              <li><a href="plugins.htm#plugin_manager_uninstall">Avinstallera en insticksmodul</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="plugins.htm#plugin_writing">Skriva en insticksmodul</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="performance.htm#perf_tips">Prestanda</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="performance.htm#perf_config">Konfigurationsinställningar</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="performance.htm#perf_config_general">Allmänna</a></li>\n';
doc_toc += '              <li><a href="performance.htm#perf_config_spikes">Spiking</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="performance.htm#perf_server">Server inställningar</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="performance.htm#perf_config_spikes">PHP inställningar</a></li>\n';
doc_toc += '              <li><a href="performance.htm#perf_server_mysql">MySQL inställningar</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="performance.htm#perf_tools">Tredjepartsverktyg</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="performance.htm#perf_yslow">YSlow</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="admin-tools.htm#admin_tools">Administratörsverktyg</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="admin-tools.htm#admin_tools_options">Tillgängliga Verktyg</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_rebuild">Uppdatera miniatyrbilder och/eller skala bilder</a></li>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_filename_filetitle">Filnamn → Filtitel/a></li>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_delete_titles">Radera filtitlar</a></li>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_delete_original">Radera original stora bilder</a></li>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_intermediate">Radera medelstora bilder</a></li>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_delete_older_files">Radera bilder som är äldre än visst antal dagar</a></li>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_delete_comments">Radera kommentarer på saknade filer</a></li>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_delete_original_backup">Radera originalbildsbackuper (vattenstämpelläge)</a></li>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_reload_dimensions">Ladda om fildimensioner och storleksinformation</a></li>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_reset_views">Nollställ visningsräknare</a></li>\n';
doc_toc += '              <li><a href="admin-tools.htm#admin_tools_options_keyword_convert">Byt nyckelordavgränsare</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="admin-tools.htm#admin_tools_usage">Användning</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="errors.htm#errors">Fel</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="errors.htm#errors_types">Feltyper</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="errors.htm#errors_soft">Mjuka fel</a></li>\n';
doc_toc += '              <li><a href="errors.htm#errors_hard">Hårda fel</a></li>\n';
doc_toc += '              <li><a href="errors.htm#errors_unhandled">Ej hanterade fel</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="errors.htm#errors_fatal">Kritiska fel</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="errors.htm#errors_debug_mode_config">Aktivera debug_läge i Konfigurationen</a></li>\n';
doc_toc += '              <li><a href="errors.htm#errors_debug_mode_manual">Aktivera debug_läge manuellt</a></li>\n';
doc_toc += '              <li><a href="errors.htm#errors_debug_mode_off">Stäng av debug_läge</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="errors.htm#errors_messages">Vanliga felmeddelanden</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="errors.htm#errors_messages_database">Databas-relaterade felmeddelanden</a></li>\n';
doc_toc += '              <li><a href="errors.htm#commonPHPerrors">Vanliga PHP fel</a></li>\n';
doc_toc += '              <li><a href="errors.htm#errors_messages_upload">Uppladdningsrelaterade felmeddelanden</a></li>\n';
doc_toc += '              <li><a href="errors.htm#errors_messages_webserver">Webbserver svarskoder</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="export.htm#backup_move">Säkerhetskopiering &amp; Flyttning</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="export.htm#backup">Säkerhetskopiera ditt galleri</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="export.htm#backup_file">Filbackup</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="export.htm#backup_file_complete">Fullständig filbackup</a></li>\n';
doc_toc += '                  <li><a href="export.htm#backup_file_partial">Partiell filbackup</a></li>\n';
doc_toc += '                  <li><a href="export.htm#backup_file_incremental">Inkrementell filbackup</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="export.htm#backup_database">Databasbackup</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="export.htm#backup_database_what">Vad behöver man ta backup på?</a></li>\n';
doc_toc += '                  <li><a href="export.htm#backup_database_tools">Databas Backup Verktyg</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="export.htm#backup_database_tools_phpmyadmin">phpMyAdmin</a></li>\n';
doc_toc += '                      <li><a href="export.htm#backup_database_tools_mysqldumper">mySqlDumper</a></li>\n';
doc_toc += '                      <li><a href="export.htm#backup_database_tools_shell_mysqldump">mysqldump</a></li>\n';
doc_toc += '                      <li><a href="export.htm#backup_database_tools_shell_mysqlhotcopy">mysqlhotcopy</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="export.htm#backup_database_after">Efter databasbackupen</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="export.htm#moving">Flytta ditt galleri</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="export.htm#moving_folder">Flytta på din webbserver</a></li>\n';
doc_toc += '              <li><a href="export.htm#moving_server">Flytta från en webbserver till en annan</a></li>\n';
doc_toc += '              <li><a href="export.htm#moving_disadvantages">Nackdelar med att döpa om</a></li>\n';
doc_toc += '              <li><a href="export.htm#moving_config_url">Ändra Coppermine\'s URL i konfigurationen</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="watermarking.htm#watermark">Vattenstämpling</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="watermarking.htm#watermark_alternatives">Alternativ</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="watermarking.htm#watermark_alternatives_no_right_click">Stänga av innehållsmenyn</a></li>\n';
doc_toc += '              <li><a href="watermarking.htm#watermark_alternatives_registered_only">Bara visa ditt dyrbara innehåll för legitima tittare</a></li>\n';
doc_toc += '              <li><a href="watermarking.htm#watermark_alternatives_overlay">Visa på överlappning</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="watermarking.htm#watermark_client_sided">Klient-sidig vattenstämpling</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="uploading.htm">Uppladdning</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="uploading_batch-add.htm#batch_add_pics">Uppladdning av bilder med FTP / Batch-Uppladdning </a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="uploading_batch-add.htm#batch_add_pics_what">Vad batch-uppladdning gör</a></li>\n';
doc_toc += '          <li><a href="uploading_batch-add.htm#batch_add_pics_how">Hur batch-uppladdning fungerar</a></li>\n';
doc_toc += '          <li><a href="uploading_batch-add.htm#batch_add_common_mistakes">Vanliga misstag</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="uploading_batch-add.htm#batch_add_common_mistakes_doesnt_work">Batch-uppladdning fungerar inte som förväntat</a></li>\n';
doc_toc += '              <li><a href="uploading_batch-add.htm#batch_add_common_mistakes_broken_files">Filen förefaller vara skadad</a></li>\n';
doc_toc += '              <li><a href="uploading_batch-add.htm#batch_add_common_mistakes_rename">Döp inte om</a></li>\n';
doc_toc += '              <li><a href="uploading_batch-add.htm#batch_add_common_mistakes_delete">Radera inte</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="uploading_batch-add.htm#batch_add_sort">Sortera</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="uploading_batch-add.htm#batch_add_sort_capitalization">Frågan om versaler</a></li>\n';
doc_toc += '              <li><a href="uploading_batch-add.htm#batch_add_sort_numbers">Datorer ser nummer annorlunda</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="uploading_http.htm#upload_http">Uppladdning med HTTP</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="uploading_http.htm#upload_http_interface">Uppladdningsgränssnitt</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="uploading_http.htm#upload_http_interface_flash">Gränssnitt för Flash-driven flerfilsuppladdning</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="uploading_http.htm#upload_http_interface_flash_usage">Användning</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="uploading_http.htm#upload_http_interface_html">Gränssnitt för HTML-driven enkelfilsuppladdning</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="uploading_http.htm#upload_http_interface_html_usage">Användning</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="uploading_xp-publisher.htm#xp">Windows XP Web Publicerings Guide</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="uploading_xp-publisher.htm#xp_publish_requirements">Krav</a></li>\n';
doc_toc += '          <li><a href="uploading_xp-publisher.htm#xp_publish_setup">Inställning</a></li>\n';
doc_toc += '          <li><a href="uploading_xp-publisher.htm#xp_publish_upload">Ladda upp bilder</a></li>\n';
doc_toc += '          <li><a href="uploading_xp-publisher.htm#xp_publish_upload">Filstruktur</a></li>\n';
doc_toc += '          <li><a href="uploading_xp-publisher.htm#xp_publish_remove">Radering/Avinstallering</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="upload_troubleshooting.htm#upload_trouble">Felsökning uppladdning</a>\n';
doc_toc += '         <ul>\n';
doc_toc += '           <li><a href="upload_troubleshooting.htm#upload_trouble_permission">Behörigheter</a></li>\n';
doc_toc += '           <li><a href="upload_troubleshooting.htm#upload_trouble_enable_settings">Arkivera felsökningsinställningar</a></li>\n';
doc_toc += '           <li><a href="upload_troubleshooting.htm#upload_support">Sök support om uppladdningsproblem</a>\n';
doc_toc += '             <ul>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_support_step-by-step">Steg-för-steg guide vid supportbehov</a>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_support_example">Exempel på supportförfrågan</a>\n';
doc_toc += '             </ul>\n';
doc_toc += '           </li>\n';
doc_toc += '           <li><a href="upload_troubleshooting.htm#upload_error_messages">Felmeddelanden</a>\n';
doc_toc += '             <ul>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_error_messages_cant_move">Failed to create stream: Operation not permitted</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_error_messages_impossible_to_move">Impossible to move x to y</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_error_messages_failed_to_open_dir">failed to open dir: No such file or directory</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_error_messages_no_album">Sorry there is no album where you are allowed to upload files</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_error_messages_allowed_memory_size">Allowed memory size of X bytes exhausted</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_error_messages_exec_disabled">Exec() has been disabled</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_error_messages_not_gd_extension">Not a GD extension</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_error_messages_imagemagick127">Error executing ImageMagick - Return value 127</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_error_messages_no_gd_support">PHP running on your server does not support the GD image library</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_error_messages_no_file_uploaded">No file was uploaded ! If you have really selected a file to upload, check that the server allows file uploads</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_error_messages_destination_not_writable">Destination directory x is not writable by the script</a></li>\n';
doc_toc += '             </ul>\n';
doc_toc += '           </li>\n';
doc_toc += '           <li><a href="upload_troubleshooting.htm#upload_trouble_server-sided_restrictions">Server-sidobegränsningar</a>\n';
doc_toc += '             <ul>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_trouble_server-sided_restrictions_php_ini">PHP konfigurationsfil php.ini</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_trouble_server-sided_restrictions_check">Saker att kontrollera</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_trouble_methods">Uppladdningsmekanismer/metoder</a></li>\n';
doc_toc += '               <li><a href="upload_troubleshooting.htm#upload_trouble_memory_usage">Minnesanvändning vid skalning</a></li>\n';
doc_toc += '             </ul>\n';
doc_toc += '           </li>\n';
doc_toc += '         </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="comments.htm">Kommentarer</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="comments.htm#comments_allow">Tillåt kommentarer</a></li>\n';
doc_toc += '      <li><a href="comments.htm#comments_options">Kommentarer frivilliga</a></li>\n';
doc_toc += '      <li><a href="comments.htm#comments_options_spam">Spam frågor</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="comments.htm#comments_options_spam_captcha">Captcha</a></li>\n';
doc_toc += '          <li><a href="comments.htm#comments_options_spam_approval">Godkännande</a></li>\n';
doc_toc += '          <li><a href="comments.htm#comments_options_spam_akismet">Akismet</a></li>\n';
doc_toc += '          <li><a href="comments.htm#comments_options_spam_resume">Sammanfattning</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="comments.htm#comments_review">Granska kommentarer</a></li>\n';
doc_toc += '      <li><a href="comments.htm#comments_individual">Individuella kommentarer</a></li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="bridging.htm">Länkning (Bridging)</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_bridge_purpose">Vad länkning gör</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_bridge_start">Tillgängliga länkningsfiler</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_prerequisites_start">Förutsättningar</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_cookie_start">Autentisering med cookie</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_standalone_start">Fristående version först</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_users_start">Coppermine användare, grupper och bilder som laddats av användare förloras vid integrering</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_backup_start">Backup</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_steps_start">Integrationssteg</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="bridging.htm#bridge_manager_start">Använda länkningshanteraren</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#bridge_manager_app_start">Välj applikation att länka Coppermine med</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#bridge_manager_path_start">Sökväg(ar) använda av din länkningsapplikation</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="bridging.htm#bridge_manager_path_full_forum_url">Länkade applikationens URL</a></li>\n';
doc_toc += '              <li><a href="bridging.htm#bridge_manager_path_relative_path_of_forum_from_webroot">Absolut sökväg till den länkade applikationen</a></li>\n';
doc_toc += '              <li><a href="bridging.htm#bridge_manager_path_relative_path_to_config_file">Relativ sökväg till den länkade applikationens konfigurationsfil</a></li>\n';
doc_toc += '              <li><a href="bridging.htm#bridge_manager_path_cookie_prefix">Cookie prefix</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="bridging.htm#bridge_manager_specific_start">Specifika inställningar till den länkade applikationen</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="bridging.htm#bridge_manager_specific_groups">Använd den länkade applikationens anpassade grupper?</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="bridging.htm#bridge_manager_enable_start">Aktivera/inaktivera länkning</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="bridging.htm#bridge_manager_recover_start">Återhämtning efter misslyckad länkning</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_steps_sync_start">Synkronisera den länkade applikationens grupper med Coppermines grupper</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_support_start">Länkningssupport</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_config_options_start">En del konfigurationsalternativ blir inaktiverade</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_files_start">Länkningsfiler</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_bridge_file_creating_start">Skapar en anpassad länkningsfil</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_philosophy_start">Länkningsfilosofi</a></li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_individual_bridge_issues_start">Individuella länkningsfrågor</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_individual_bridge_issues_phpbb3">phpBB3</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_individual_bridge_issues_punbb115">PunBB1.1.5</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_individual_bridge_issues_punbb12">PunBB1.2</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_individual_bridge_issues_xmb">XMB</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="bridging.htm#integrating_subdomain">Subdomän frågor</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_subdomain_file_system">Filsyste</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_subdomain_cookie">Cookies</a></li>\n';
doc_toc += '          <li><a href="bridging.htm#integrating_subdomain_www">www-subdomain</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '  <li><a href="dev.htm">Dokumentation för Utvecklare</a>\n';
doc_toc += '    <ul>\n';
doc_toc += '      <li><a href="dev_files.htm">Adding/renaming/removing files</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_files.htm#dev_files_target_audience">Target audience</a></li>\n';
doc_toc += '          <li><a href="dev_files.htm#dev_files_scope">Scope</a></li>\n';
doc_toc += '          <li><a href="dev_files.htm#dev_files_naming">Naming conventions</a></li>\n';
doc_toc += '          <li><a href="dev_files.htm#dev_files_adding">Adding files</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_files.htm#dev_files_adding_language">Language files</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_files.htm#dev_files_renaming">Renaming files</a></li>\n';
doc_toc += '          <li><a href="dev_files.htm#dev_files_deleting">Deleting files</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_coding.htm">Coding guidelines</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_coding.htm#dev_coding_target_audience">Target audience</a></li>\n';
doc_toc += '          <li><a href="dev_coding.htm#dev_coding_scope">Scope</a></li>\n';
doc_toc += '          <li><a href="dev_coding.htm#dev_coding_indentation">Indentation</a></li>\n';
doc_toc += '          <li><a href="dev_coding_encoding">Encoding</a></li>\n';
doc_toc += '          <li><a href="dev_coding.htm#dev_coding_general">General guidelines</a></li>\n';
doc_toc += '          <li><a href="dev_coding.htm#dev_coding_php">PHP code</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_formatting">Formatting</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_control_structures">Control Structures</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_function_calls">Function Calls</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_function_definitions">Function Definitions</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_php_tags">PHP Code Tags</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_html_nesting">Nesting of HTML in PHP</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_linebreaks">Line breaks</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_naming_conventions">Naming Conventions</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_coding.htm#dev_coding_database">Database queries</a></li>\n';
doc_toc += '          <li><a href="dev_coding.htm#dev_coding_documentation">Documentation</a></li>\n';
doc_toc += '          <li><a href="dev_coding.htm#dev_coding_html_output">HTML output</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_html_output_images">Image-tags in HTML output</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_html_output_dev_coding_html_output_links">Links in HTML output</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_html_output_form">Form elements in HTML output</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_html_output_deprecated">Deprecated tags</a></li>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_html_prefered_tags">Prefered tags</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_coding.htm#dev_coding_credits">Credits for coding guidelines</a></li>\n';
doc_toc += '          <li><a href="dev_coding.htm#dev_coding_usability">Usability</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_coding.htm#dev_coding_usability_forms">Forms</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_config.htm">Config options</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_config.htm#dev_config_add_target_audience">Target audience</a></li>\n';
doc_toc += '          <li><a href="dev_config.htm#dev_config_history">History</a></li>\n';
doc_toc += '          <li><a href="dev_config.htm#dev_config_new_features">New features</a></li>\n';
doc_toc += '          <li><a href="dev_config.htm#dev_config_step_by_step">Step by Step</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_config.htm#dev_config_step_basiq_sql">Basic.sql</a></li>\n';
doc_toc += '              <li><a href="dev_config.htm#dev_config_step_update_sql">Update.sql</a></li>\n';
doc_toc += '              <li><a href="dev_config.htm#dev_config_step_array">Admin.inc.php</a></li>\n';
doc_toc += '              <li><a href="dev_config.htm#dev_config_step_language_file">Language file</a></li>\n';
doc_toc += '              <li><a href="dev_config.htm#dev_config_step_documentation">Documentation</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_config.htm#dev_config_todo">To Do</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_database.htm">Database schema</a>\n';
doc_toc += '          <ul>\n';
doc_toc += '              <li><a href="dev_database.htm#db_config_file">Configuration file</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_reference within_code">Database reference within coppermine code</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_albums">cpg15x_albums</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_banned">cpg15x_banned</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_bridge">cpg15x_bridge</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_categories">cpg15x_categories</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_categorymap">cpg15x_categorymap</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_comments">cpg15x_comments</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_config">cpg15x_config</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_dict">cpg15x_dict</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_ecards">cpg15x_ecards</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_exif">cpg15x_exif</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_favpics">cpg15x_favpics</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_filetypes">cpg15x_filetypes</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_hit_stats">cpg15x_hit_stats</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_languages">cpg15x_languages</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_pictures">cpg15x_pictures</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_plugins">cpg15x_plugins</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_sessions">cpg15x_sessions</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_temp_messages">cpg15x_temp_messages</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_usergroups">cpg15x_usergroups</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_users">cpg15x_users</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_votes">cpg15x_votes</a></li>\n';
doc_toc += '              <li><a href="dev_database.htm#db_vote_stats">cpg15x_vote_stats</a></li>\n';
doc_toc += '          </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_documentation.htm">Editing the documentation</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_target_audience">Target audience</a></li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_edit_existing">Edit existing documents</a></li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_add">Add new documents</a></li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_move">Moving content from one document to the other</a></li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_hidden_feature">Hidden features</a></li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_database_structure">Database structure</a></li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_header_block">Header &amp; footer blocks</a></li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_i18n">Documentation internationalization</a></li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_detail">Expandable/collapsible "detail"-blocks</a></li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_help">Help</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_documentation.htm#dev_documentation_help_start_end">Start and end anchors needed</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_heading_anchors">Adding anchors to headings</a></li>\n';
doc_toc += '          <li><a href="dev_documentation.htm#dev_documentation_code">Code</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_documentation.htm#dev_documentation_code_css_code">CSS class &quot;code&quot;</a></li>\n';
doc_toc += '              <li><a href="dev_documentation.htm#dev_documentation_code_html_pre">HTML-tag &quot;pre&quot;</a></li>\n';
doc_toc += '              <li><a href="dev_documentation.htm#dev_documentation_code_css_cpg_code">CSS class &quot;cpg_code&quot;</a></li>\n';
doc_toc += '              <li><a href="dev_documentation.htm#dev_documentation_code_css_smallcode">CSS class &quot;smallcode&quot;</a></li>\n';
doc_toc += '              <li><a href="dev_documentation.htm#dev_documentation_code_html_textarea">HTML-tag &quot;textarea&quot;</a></li>\n';
doc_toc += '              <li><a href="dev_documentation.htm#dev_documentation_code_combining">Combining HTML tags and CSS classes</a></li>\n';
doc_toc += '              <li><a href="dev_documentation.htm#dev_documentation_code_syntaxhighlighting">No syntax highlighting</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_javascript.htm">Javascript in Coppermine</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_javascript.htm#dev_javascript_target_audience">Target audience</a></li>\n';
doc_toc += '          <li><a href="dev_javascript.htm#dev_javascript_files_location">Javascript files location and organization</a></li>\n';
doc_toc += '          <li><a href="dev_javascript.htm#dev_javascript_files_location_todo">TODO</a></li>\n';
doc_toc += '          <li><a href="dev_javascript.htm#dev_javascript_include_files">How to include javascript files</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_javascript.htm#dev_javascript_include_files_plugin">How to include JavaScript files in plugins</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_javascript.htm#dev_javascript_php_vars">How to pass PHP variables to included javascript</a></li>\n';
doc_toc += '          <li><a href="dev_javascript.htm#dev_javascript_autostart">Autostart JavaScript</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_package.htm#packaging">Packaging a new release</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_package.htm#packaging_target_audience">Target audience</a></li>\n';
doc_toc += '          <li><a href="dev_package.htm#packaging_subversion">Subversion repository</a></li>\n';
doc_toc += '          <li><a href="dev_package.htm#packaging_steps">Steps</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_checkout">Check out</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_loop_through_files"></a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#">Replace version number in all files</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_loop_through_files_linux">Linux</a></li>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_loop_through_files_windows">Windows</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_bom">Remove Byte Order Marks</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#">Prepare an announcement thread</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_write_announcement_thread"></a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_docs_upgrade">Edit the upgrade section of the docs</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_changelog">Edit the changelog</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_version_number">Edit the version number</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_svn_commit">Commit your changes</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_versioncheck">Update the versioncheck data</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_versioncheck_complete">Completeness</a></li>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_versioncheck_update">Update revision numbers and hashes</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_xml_webspace">Update cpg15x.files.xml on the Coppermine home page</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_svn_export">Export from subversion</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_rapidsvn">RapidSVN</a></li>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_tortoisesvn">Tortoise SVN</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_create_tag">Create a tag in subversion</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_create_tag_rapidsvn">RapidSVN</a></li>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_create_tag_tortoisesvn">Tortoise SVN</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_create_zip">Create the archive</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_upload_zip">Upload the archive</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_move_announcement">Publish announcement thread</a></li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_news">Create news items</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_news_sf">News item on sf.net</a></li>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_news_forum">News item on forum</a></li>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_news_homepage">News item on home page</a></li>\n';
doc_toc += '                  <li><a href="dev_package.htm#packaging_steps_news_embedded">News embedded into existing galleries</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="dev_package.htm#packaging_steps_demo">Update the demo</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_plugins.htm">Plugin Writing for Coppermine</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_plugins.htm#plugin_writing">Quick Start Guide</a></li>\n';
doc_toc += '          <li><a href="dev_plugins.htm#plugin_writing_target_audience">Intended Audience</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_target_audience_yes">People who should read this documentation</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_target_audience_no">People who do not need to read this documentation</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_plugins.htm#plugin_writing_why_write">Why write plugins?</a></li>\n';
doc_toc += '          <li><a href="dev_plugins.htm#plugin_writing_preparation">Preparations</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_preparation_name">Choose a name</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_preparation_translation">Consider translations</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_preparation_config">Consider a config screen</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_preparation_db">Database changes</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_preparation_support">Support issues</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_preparation_versions">Plugin versions</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_plugins.htm#plugin_writing_core_files">Core files</a></li>\n';
doc_toc += '          <li><a href="dev_plugins.htm#plugin_writing_naming_conventions">Naming conventions</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_naming_conventions_folders">Folders</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_naming_conventions_files">Files</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_naming_conventions_archives">Archives</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_naming_conventions_coding">Coding</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_plugins.htm#plugin_writing_globals">Use of Superglobals</a></li>\n';
doc_toc += '          <li><a href="dev_plugins.htm#plugin_writing_database">Database access</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_database_direct_queries">Direct queries</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_database_tables_access">Accessing database tables</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_database_tables_create">Creating database tables</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_database_tables_delete">Deleting database tables</a></li>\n';
doc_toc += '              <li><a href="dev_plugins.htm#plugin_writing_database_config">Storing your plugin\'s config values</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_plugins.htm#plugin_writing_types">Plugin Types</a></li>\n';
doc_toc += '          <li><a href="dev_plugins.htm#plugin_writing_includes">Using includes</a></li>\n';
doc_toc += '          <li><a href="dev_plugin_api.htm">Plugin Writing: Tutorial, API</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_plugin_api.htm#plugin_api_overview_who">Intended Audience</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_api.htm#plugin_api_overview_skills">Required Skills &amp; Knowledge</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_api.htm#plugin_api_overview_tools">Recommended Software &amp; Support Forums</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_api.htm#plugin_api_tutorial">"Hello, world" Plugin Tutorial</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="dev_plugin_api.htm#plugin_api_tutorial_first">My First Plugin</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_api.htm#plugin_api_tutorial_installconfig">Installation, Configuration, and Clean-Up</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_api.htm#plugin_api_tutorial_installsimple">Installation with Simple Configuration</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_api.htm#plugin_api_tutorial_install">Installation with Configuration Parameters</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_api.htm#plugin_api_tutorial_config">Adding a config section to your plugin</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_api.htm#plugin_api_tutorial_cleanup">Uninstallation &amp; Clean-Up</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>  \n';
doc_toc += '                  <li><a href="dev_plugin_api.htm#plugin_api_tutorial_linking">Linking to Custom Plugin Scripts</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_api.htm#plugin_api_tutorial_button">Adding a Button to Coppermine</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_api.htm#plugin_api_tutorial_button_admin_menu">Adding a Button to the admin menu</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_api.htm#plugin_api_tutorial_button_overall_menu">Adding a Button to the overall menu</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_api.htm#plugin_api_tutorial_js">Adding JavaScript to plugins</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_api.htm#plugin_api_tutorial_lang">Multi-language Support</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_api.htm#plugin_api_tutorial_distrib">Distributing Your Plugin</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="dev_plugin_api.htm#plugin_api_hooks">Plugin Hooks</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_api.htm#plugin_api_plugin_class">Plugin Class Properties &amp; Methods</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_api.htm#plugin_api_globals">Global Variables &amp; Constants</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_plugin_steps.htm">Creating plugins: step by step</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_plugin_steps.htm#steps_template_plugin">Getting started with the plugin template</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_extract_template">1. Extract the plugin template</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_pick_name">2. Choose a name</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_rename_folder">3. Rename the folder</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_rename_file_content">4. Rename the placeholders inside the files</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_copy_to_target">5. Copy the new plugin folder to the target</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="dev_plugin_steps.htm#steps_config">Creating a config record for your plugin</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_config_option_type">1. Decide for an option type</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_config_name">2. Choose a record name</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_config_install">3. Create the record during plugin install</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_config_uninstall">4. Create the uninstall query</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_config_defaults">5. Specify the scope of your config record</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_config_form_options">6. Populate form options</a></li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_config_rows">7. Output the form elements (rows)</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_steps.htm#steps_config_rows_checkbox">a. Checkbox</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_steps.htm#steps_config_rows_radio">b. Radio button</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_steps.htm#steps_config_rows_dropdown">c. Dropdown (select/option list)</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_steps.htm#steps_config_rows_textinput">d. Text input field (one line), both for numerical input (integers) as well as any other textual input</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_steps.htm#steps_config_rows_textarea">e. Text input field (multiple lines, aka textarea)</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_steps.htm#steps_config_language">8. Create the needed translation strings</a></li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_plugin_hooks.htm">Reference list of plugin hooks</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_plugin_hooks.htm#plugin_hooks_target_audience">Target audience</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_hooks.htm#plugin_hooks_choosing">Choosing Plugin Hooks</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_hooks.htm#plugin_hooks_finding">Finding Plugin Hooks</a></li>\n';
//doc_toc += '              <li><a href="dev_plugin_hooks.htm#plugin_hooks_using">Using Plugin Hooks</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_hooks.htm#plugin_hooks_filename">Plugin Hooks by File Name</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_ind_php">Script: index.php</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_ind_anyc">Filter: \'anycontent\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_ind_ucp">Filter: \'user_caption_params\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_ind_pb">Filter: \'plugin_block\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_di_php">Script: displayimage.php</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_di_fi">Filter: \'file_info\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_di_pbc">Filter: \'post_breadcrumb\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_thumb_php">Script: thumbnails.php</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_thumb_pbc">Filter: \'post_breadcrumb\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_func_php">Script: functions.inc.php</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_func_ghgf">Filters: \'gallery_header\' and \'gallery_footer\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_func_td">Filter: \'thumb_data\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_func_th">Filter: \'template_html\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_func_pm">Filter: \'page_meta\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_func_tc">Filters: \'thumb_caption\' and all derivatives</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_th_php">Script: themes.inc.php</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_th_fd">Filter: \'file_data\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_um_php">Script: usermgr.php</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_um_umh">Filter: \'usermgr_header\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_um_umf">Filter: \'usermgr_footer\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_pm_php">Script: pluginmgr.php</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_pm_pcon">Filter: \'plugin_configure\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_pm_pcl">Filter: \'plugin_cleanup\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_papi_php">Script: plugin_api.inc.php</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_papi_ph">Filter: \'page_html\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_papi_pe">Filter: \'page_end\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_papi_pi">Filter: \'plugin_install\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_papi_pu">Filter: \'plugin_uninstall\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_papi_pw">Filter: \'plugin_wakeup\'</a></li>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_papi_ps">Filter: \'plugin_sleep\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_init_php">Script: init.inc.php</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_init_ps">Filter: \'page_start\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                  <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_picm_php">Script: picmgmt.inc.php</a>\n';
doc_toc += '                    <ul>\n';
doc_toc += '                      <li><a href="dev_plugin_hooks.htm#plugin_api_hooks_picm_afd">Filter: \'add_file_data\'</a></li>\n';
doc_toc += '                    </ul>\n';
doc_toc += '                  </li>\n';
doc_toc += '                </ul>\n';
doc_toc += '              </li>\n';
doc_toc += '              <li><a href="dev_plugin_hooks.htm#plugin_hooks_alphabetically">Plugin Hooks Alphabetically</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_hooks.htm#plugin_hooks_hooktype">Plugin Hooks by Hook Type</a></li>\n';
doc_toc += '              <li><a href="dev_plugin_hooks.htm#plugin_hook_examples">Plugin Hook Examples</a>\n';
doc_toc += '                <ul>\n';
doc_toc += '                    <li><a href="dev_plugin_hooks.htm#plugin_hook_example_upload_method">Adding an upload method</a></li>\n';
doc_toc += '                    <li><a href="dev_plugin_hooks.htm#plugin_hook_example_theme_display_thumbnails">Add tags for thumbnails display</a></li>\n';
doc_toc += '                </ul></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_superglobals.htm">Sanitization of Superglobals using Inspekt</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_superglobals.htm#superglobals_sanitization_target_audience">Target audience</a></li>\n';
doc_toc += '          <li><a href="dev_superglobals.htm#superglobals_sanitization_whats_new">What\'s new?</a></li>\n';
doc_toc += '          <li><a href="dev_superglobals.htm#superglobals_sanitization_reason">Reason</a></li>\n';
doc_toc += '          <li><a href="dev_superglobals.htm#superglobals_sanitization_about_inspekt">What Inspekt does</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_superglobals.htm#superglobals_sanitization_inspekt_accessor_methods">Inspekt accessor methods</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_superglobals.htm#superglobals_sanitization_howto">How to use Inspekt with Coppermine Photo Gallery</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_superglobals.htm#superglobals_sanitization_howto_using">Using Inspekt</a></li>\n';
doc_toc += '              <li><a href="dev_superglobals.htm#superglobals_sanitization_howto_inspekt_in_coppermine">Inspekt in Coppermine</a></li>\n';
doc_toc += '              <li><a href="dev_superglobals.htm#superglobals_sanitization_howto_consider_methods">Consider the methods to use</a></li>\n';
doc_toc += '              <li><a href="dev_superglobals.htm#superglobals_sanitization_howto_examples">Examples</a></li>\n';
doc_toc += '              <li><a href="dev_superglobals.htm#superglobals_sanitization_howto_regex">Regular Expressions</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_superglobals.htm#superglobals_sanitization_links">Links</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_subversion.htm">Subversion</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_target_audience">Target audience</a></li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_caveat">Caveats</a></li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_definition">What is subversion?</a></li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_hosting">Where is the subversion repository hosted?</a></li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_software">Recommended software</a></li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_websvn">Alternative access using Web SVN</a></li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_repository_structure">Repository structure</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_repository_structure_trunk">Coppermine core files</a></li>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_repository_structure_plugins">Plugins</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_checking_out">Checking out</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_checking_out_entire">Checking out the entire repository</a></li>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_checking_out_particular_package">Checking out a particular Package</a></li>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_checking_out_particular_file">Checking out a particular file</a></li>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_checking_out_refering">Refering to files downloaded from the subversion repository</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_download">Is there no single package that I could download instead?</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_download_tarball">Download Tarball archives</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_dev-only">Developers-only</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_checkout_checkin">Check out before checking in</a></li>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_commit">Committing your code</a></li>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_changelog">Changelog</a></li>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_write_access">Obtaining write access</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_step-by-step">Step by step</a>\n';
doc_toc += '            <ul>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_client-download">Download the client application</a></li>\n';
doc_toc += '              <li><a href="dev_subversion.htm#dev_subversion_initial_checkout">Initial checkout</a></li>\n';
doc_toc += '            </ul>\n';
doc_toc += '          </li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_revision">Revisions</a></li>\n';
doc_toc += '          <li><a href="dev_subversion.htm#dev_subversion_fileheaders">Subversion file headers</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_tools.htm">Tools recommended by the devs</a>\n';
doc_toc += '          <ul>\n';
doc_toc += '              <li><a href="dev_tools.htm#dev_tools_database">Database manipulation</a></li>\n';
doc_toc += '              <li><a href="dev_tools.htm#dev_tools_ftp_client">FTP clients</a></li>\n';
doc_toc += '              <li><a href="dev_tools.htm#dev_tools_web_development">Web development</a></li>\n';
doc_toc += '              <li><a href="dev_tools.htm#dev_tools_editor">Text editors</a></li>\n';
doc_toc += '              <li><a href="dev_tools.htm#dev_tools_picture_editors">Picture Editors</a></li>\n';
doc_toc += '          </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_update.htm">Updating</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_update.htm#dev_update_target_audience">Target audience</a></li>\n';
doc_toc += '          <li><a href="dev_update.htm#dev_update_hidden_feature">Hidden feature</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_vars.htm#vars_constants">Variables &amp; Constants</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_vars.htm#vars_constants_system">System Global Variables</a></li>\n';
doc_toc += '          <li><a href="dev_vars.htm#vars_constants_constants">Coppermine Constants</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '      <li><a href="dev_versioncheck.htm">Versioncheck</a>\n';
doc_toc += '        <ul>\n';
doc_toc += '          <li><a href="dev_versioncheck.htm#dev_versioncheck_hidden_features">Hidden features</a></li>\n';
doc_toc += '          <li><a href="dev_versioncheck.htm#dev_versioncheck_xml">XML structure</a></li>\n';
doc_toc += '          <li><a href="dev_versioncheck.htm#dev_versioncheck_todo">To do list</a></li>\n';
doc_toc += '        </ul>\n';
doc_toc += '      </li>\n';
doc_toc += '    </ul>\n';
doc_toc += '  </li>\n';
doc_toc += '</ul>\n';
doc_toc += '</div>\n';
$('#toc').replaceWith('<div id="toc">' + doc_toc + '</div>');
}



function cpgDocHeader() {
    // Only display the header if the docs are not included
    if (getUrlParameters('hide_nav') == 1) {
        return;
    }
    $('#docheader').text('Coppermine Photo Gallery v1.5.40: Dokumentation och Manual');
    $('#docheader').after('<br clear="all" />\n<a name="top"></a>');
    $('#docheader').before('<img src="../images/coppermine-logo.png" alt="Coppermine Photo Gallery - Your Online Photo Gallery" align="left" />\n');
}

function cpgDocSearch() {
    // Only display the header if the docs are not included
    if (getUrlParameters('hide_nav') == 1) {
        return;
    }
    var doc_search = '';
    doc_search += '  <div id="doc_search" style="display:none;">\n';
    doc_search += '    <form action="http://www.google.com/cse" id="cse-search-box">\n';
    doc_search += '      <input type="hidden" name="cx" value="009353514429642786404:grsrdpjjnqm " />\n';
    doc_search += '      <input type="text" name="q" size="25" />\n';
    doc_search += '      <input type="submit" name="sa" value="search docs" style="font-size:9px;" />\n';
    doc_search += '    </form>\n';
    doc_search += '    <script type="text/javascript" src="http://www.google.com/coop/cse/brand?form=cse-search-box&lang=en"></script>\n';
    doc_search += '  </div>\n';
    $('#toc').append(doc_search);
}

function cpgDocFooter() {
  var overall_doc_footer = '';
  overall_doc_footer += '</div>';
  overall_doc_footer += '<div class="backtotop">';
  overall_doc_footer += '<a href="#top">Tillbaka till toppen</a>';
  overall_doc_footer += '</div>';
  $('#doc_footer').append(overall_doc_footer);
}



function dateRevision() {
  // strip the unneeded data from last_changed and revision fields
  var lastChangeDate = $('#doc_last_changed').text();
  var lastChangeDate = lastChangeDate.replace('$', '');
  var lastChangeDate = lastChangeDate.replace('$', '');
  var lastChangeDate = lastChangeDate.replace('LastChangedDate: ', '');
  var lastChangeDate = lastChangeDate.replace(/Date: /g, '');
  $('#doc_last_changed').text('Om detta dokument: ' + 'senast uppdaterat ' + lastChangeDate);

  var revisionNumber = $('#doc_revision').text();
  var revisionNumber = revisionNumber.replace('$', '');
  var revisionNumber = revisionNumber.replace('$', '');
  var revisionNumber = revisionNumber.replace(/Revision: /g, '');
  $('#doc_revision').text(', SVN revision ' + revisionNumber);
}

function getUrlParameters(name)
{
  // Taken from http://www.netlobo.com/url_query_string_javascript.html
  name = name.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");
  var regexS = "[\\?&]"+name+"=([^&#]*)";
  var regex = new RegExp(regexS);
  var results = regex.exec(window.location.href);
  if(results == null) {
    return '';
  } else {
    return results[1];
  }
}

function cpgDocTranslationWarning() {
  $('#doc_en_only').replaceWith('<div class="cpg_message_validation"><h1>Inte översatt ännu yet</h1><p>Denna sida har ännu inte översatts och visas därför på engelska.</p><p>Översättare önskas: titta på den här sidan - ser inte alltför svårt ut, eller hur? Om du tror att du kan översätta den här sidan, vänligen se på den officiella Coppermine siten; vi ser fram emot ditt bidrag.</div>');
  $('#doc_en_partial').replaceWith('<div class="cpg_message_warning"><h1>Delvis översatt</h1><p>Denna sida har ännu inte översatts i sin helhet och visas därför bara delvis på ditt språk och delvis på engelska.</p><p>Translators wanted: take a look at this page - doesn\'t look too complicated, does it? If you\'re convinced that you could translate this page, please check the official Coppermine site; we\'re looking forward to your contribution.</div>');
}

$(document).ready(function()
{
    var $_GET = {};
    document.location.search.replace(/\??(?:([^=]+)=([^&]*)&?)/g, function () {
        function decode(s) {
            return decodeURIComponent(s).replace(/\+/g, " ");
        }
        $_GET[decode(arguments[1])] = decode(arguments[2]);
    });
    //hide all elements with class detail_body
    $(".detail_body").hide();
    if ($_GET["expand_all"] == 1) { // Show all details and get rid of the details toggle if the GET parameter expand_all is set
        $('.detail_body').show();
        //$('.detail_head_collapsed').replaceWith('');
    }
    //toggle the component with class detail_body
    $(".detail_head_collapsed").click(function()
    {
        $(this).toggleClass("detail_head_expanded").next(".detail_body").slideToggle(600);
    });
    $(".detail_expand_all").click(function()
    {
        $(".detail_body").slideDown(1200);
        $(".detail_head_collapsed").toggleClass("detail_head_expanded");
        $(".detail_expand_all").hide();
        $(".detail_collapse_all").show();

    });
    $(".detail_collapse_all").click(function()
    {
        $(".detail_body").slideUp(1200);
        $(".detail_head_collapsed").toggleClass("detail_head_expanded");
        $(".detail_expand_all").show();
        $(".detail_collapse_all").hide();

    });
    $(".detail_toggle_all").click(function()
    {
        $(".detail_body").slideToggle(600);
        $(".detail_head_collapsed").toggleClass("detail_head_expanded");
    });
    cpgDocHeader();
    cpgDocTranslationWarning();
    cpgDocToc();
    $("#tree").treeview({
        collapsed: true,
        unique: true,
        animated: "slow",
        persist: "location"
    });
    cpgDocSearch();
    cpgDocFooter();
    dateRevision();
    $("a.nolink").click(function(){
      return false;
    });
    // Fade the toc in if it is needed
    $("#toc").bind("mouseenter",function(){
        $("#toc_collapsed").hide();
        $("#toc_expanded").fadeIn('slow');
        $("#doc_search").show();
    });
    // Fade the toc out if it isn't used
    $("#toc").bind("mouseleave",function(){
        $("#toc_expanded").fadeOut('slow');
        $("#toc_collapsed").show();
        $("#doc_search").hide();
    });
    
});
