<?php
/*************************
  Coppermine Photo Gallery
  ************************
  Copyright (c) 2003-2006 Coppermine Dev Team
  v1.1 originally written by Gregory DEMAR

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  ********************************************
  Coppermine version: 1.4.4
  $Source$
  $Revision$
  $Author$
  $Date$
**********************************************/

// ------------------------------------------------------------------------- //
// This theme has all CORE items removed                                     //
// ------------------------------------------------------------------------- //
define('THEME_IS_XHTML10_TRANSITIONAL',1);
define('THEME_HAS_RATING_GRAPHICS', 1);
define('THEME_HAS_NO_SYS_MENU_BUTTONS', 1);
define('THEME_HAS_NO_SUB_MENU_BUTTONS', 1);


// HTML template for sys menu
$template_sys_menu = <<<EOT
                        <li class="sidebar_item">
                                <h2 class="sidebar_item">Main Menu</h2>
                                <ul>
<!-- BEGIN home -->
                                            <li class="sidebar_menu"><a href="{HOME_TGT}" title="{HOME_TITLE}" class="navmenu">{HOME_LNK}</a></li>
<!-- END home -->
<!-- BEGIN my_friends -->
                                                <li class="sidebar_menu"><a href="{MY_BUDDY_TGT}" title="{MY_BUDDY_LNK}" class="navmenu">{MY_BUDDY_LNK}</a></li>
<!-- END my_friends -->
<!-- BEGIN my_gallery -->
                                                <li class="sidebar_menu"><a href="{MY_GAL_TGT}" title="{MY_GAL_TITLE}" class="navmenu">{MY_GAL_LNK}</a></li>
<!-- END my_gallery -->
<!-- BEGIN allow_memberlist -->
                                                <li class="sidebar_menu"><a href="{MEMBERLIST_TGT}" title="{MEMBERLIST_TITLE}" class="navmenu">{MEMBERLIST_LNK}</a></li>
<!-- END allow_memberlist -->
<!-- BEGIN my_profile -->
                                                <li class="sidebar_menu"><a href="{MY_PROF_TGT}" title="{MY_PROF_LNK}" class="navmenu">{MY_PROF_LNK}</a></li>
<!-- END my_profile -->
<!-- BEGIN faq -->
                                                <li class="sidebar_menu"><a href="{FAQ_TGT}" title="{FAQ_TITLE}" class="navmenu">{FAQ_LNK}</a></li>
<!-- END faq -->
<!-- BEGIN enter_admin_mode -->
                                                <li class="sidebar_menu"><a href="{ADM_MODE_TGT}" title="{ADM_MODE_TITLE}" class="navmenu">{ADM_MODE_LNK}</a></li>
<!-- END enter_admin_mode -->
<!-- BEGIN leave_admin_mode -->
                                                <li class="sidebar_menu"><a href="{USR_MODE_TGT}" title="{USR_MODE_TITLE}" class="navmenu">{USR_MODE_LNK}</a></li>
<!-- END leave_admin_mode -->
<!-- BEGIN upload_pic -->
                                                <li class="sidebar_menu"><a href="{UPL_PIC_TGT}" title="{UPL_PIC_TITLE}" class="navmenu">{UPL_PIC_LNK}</a></li>
<!-- END upload_pic -->
<!-- BEGIN register -->
                                                <li class="sidebar_menu"><a href="{REGISTER_TGT}" title="{REGISTER_TITLE}" class="navmenu">{REGISTER_LNK}</a></li>
<!-- END register -->
<!-- BEGIN login -->
                                                <li class="sidebar_menu"><a href="{LOGIN_TGT}" title="{LOGIN_LNK}" class="navmenu">{LOGIN_LNK}</a></li>
<!-- END login -->
<!-- BEGIN logout -->
                                                <li class="sidebar_menu"><a href="{LOGOUT_TGT}" title="{LOGOUT_LNK}" class="navmenu">{LOGOUT_LNK}</a></li>
<!-- END logout -->
                        </ul>
                                </li>

EOT;

// HTML template for sub menu
$template_sub_menu = <<<EOT
                        <li class="sidebar_item">
                                <h2 class="sidebar_item">Special Albums</h2>
                                <ul>
<!-- BEGIN custom_link -->
                                            <li class="sidebar_menu"><a href="{CUSTOM_LNK_TGT}" title="{CUSTOM_LNK_TITLE}" class="navmenu">{CUSTOM_LNK_LNK}</a></li>
<!-- END custom_link -->
<!-- BEGIN album_list -->
                                            <li class="sidebar_menu"><a href="{ALB_LIST_TGT}" title="{ALB_LIST_TITLE}" class="navmenu">{ALB_LIST_LNK}</a></li>
<!-- END album_list -->
                                            <li class="sidebar_menu"><a href="{LASTUP_TGT}" title="{LASTUP_LNK}" class="navmenu">{LASTUP_LNK}</a></li>
                                            <li class="sidebar_menu"><a href="{LASTCOM_TGT}" title="{LASTCOM_LNK}" class="navmenu">{LASTCOM_LNK}</a></li>
                                            <li class="sidebar_menu"><a href="{TOPN_TGT}" title="{TOPN_LNK}" class="navmenu">{TOPN_LNK}</a></li>
                                            <li class="sidebar_menu"><a href="{TOPRATED_TGT}" title="{TOPRATED_LNK}" class="navmenu">{TOPRATED_LNK}</a></li>
                                            <li class="sidebar_menu"><a href="{FAV_TGT}" title="{FAV_LNK}" class="navmenu">{FAV_LNK}</a></li>
                                            <li class="sidebar_menu"><a href="{SEARCH_TGT}" title="{SEARCH_LNK}" class="navmenu">{SEARCH_LNK}</a></li>
                                  </ul>
                                </li>

EOT;

// HTML template for gallery admin menu
$template_gallery_admin_menu = <<<EOT

                        <li class="sidebar_item">
                                <h2 class="sidebar_item">Admin</h2>
                                <ul>
<!-- BEGIN admin_approval -->
                            <li id="admin_menu_anim"><a href="editpics.php?mode=upload_approval" title="{UPL_APP_TITLE}" class="navmenu">{UPL_APP_LNK}</a></li>
<!-- END admin_approval -->
                            <li class="sidebar_menu"><a href="admin.php" title="{ADMIN_TITLE}" class="navmenu">{ADMIN_LNK}</a></li>
                            <li class="sidebar_menu"><a href="catmgr.php" title="{CATEGORIES_TITLE}" class="navmenu">{CATEGORIES_LNK}</a></li>
                            <li class="sidebar_menu"><a href="albmgr.php{CATL}" title="{ALBUMS_TITLE}" class="navmenu">{ALBUMS_LNK}</a></li>
                            <li class="sidebar_menu"><a href="groupmgr.php" title="{GROUPS_TITLE}" class="navmenu">{GROUPS_LNK}</a></li>
                            <li class="sidebar_menu"><a href="usermgr.php" title="{USERS_TITLE}" class="navmenu">{USERS_LNK}</a></li>
                            <li class="sidebar_menu"><a href="banning.php" title="{BAN_TITLE}" class="navmenu">{BAN_LNK}</a></li>
                            <li class="sidebar_menu"><a href="reviewcom.php" title="{COMMENTS_TITLE}" class="navmenu">{COMMENTS_LNK}</a></li>
<!-- BEGIN log_ecards -->
                            <li class="sidebar_menu"><a href="db_ecard.php" title="{DB_ECARD_TITLE}" class="navmenu">{DB_ECARD_LNK}</a></li>
<!-- END log_ecards -->
                            <li class="sidebar_menu"><a href="picmgr.php" title="{PICTURES_TITLE}" class="navmenu">{PICTURES_LNK}</a></li>
                            <li class="sidebar_menu"><a href="searchnew.php" title="{SEARCHNEW_TITLE}" class="navmenu">{SEARCHNEW_LNK}</a></li>
                            <li class="sidebar_menu"><a href="util.php" title="{UTIL_TITLE}" class="navmenu">{UTIL_LNK}</a></li>
                            <li class="sidebar_menu"><a href="profile.php?op=edit_profile" title="{MY_PROF_TITLE}" class="navmenu">{MY_PROF_LNK}</a></li>
<!-- BEGIN documentation -->
                            <li class="sidebar_menu"><a href="{DOCUMENTATION_HREF}" title="{DOCUMENTATION_TITLE}" target="cpg_documentation" class="navmenu">{DOCUMENTATION_LNK}</a></li>
<!-- END documentation -->
                                  </ul>
                                </li>

EOT;
// HTML template for user admin menu
$template_user_admin_menu = <<<EOT

                        <li class="sidebar_item">
                                <h2 class="sidebar_item">Admin</h2>
                                <ul>
                                <li class="sidebar_menu"><a href="albmgr.php" title="{ALBMGR_TITLE}" class="navmenu">{ALBMGR_LNK}</a></li>
                                <li class="sidebar_menu"><a href="modifyalb.php" title="{MODIFYALB_TITLE}" class="navmenu">{MODIFYALB_LNK}</a></li>
                                <li class="sidebar_menu"><a href="profile.php?op=edit_profile" title="{MY_PROF_TITLE}" class="navmenu">{MY_PROF_LNK}</a></li>
                                <li class="sidebar_menu"><a href="picmgr.php" title="{PICTURES_TITLE}" class="navmenu">{PICTURES_LNK}</a></li>
                                  </ul>
                                </li>

EOT;



// Added to display flim_strip
function theme_display_film_strip(&$thumb_list, $nbThumb, $album_name, $aid, $cat, $pos, $sort_options, $mode = 'thumb')
{
    global $CONFIG, $THEME_DIR;
    global $template_film_strip, $lang_film_strip;

    static $template = '';
    static $thumb_cell = '';
    static $empty_cell = '';
    static $spacer = '';

    if ((!$template)) {
        $template = $template_film_strip;
        $thumb_cell = template_extract_block($template, 'thumb_cell');
        $empty_cell = template_extract_block($template, 'empty_cell');
    }

    $cat_link = is_numeric($aid) ? '' : '&amp;cat=' . $cat;

    $thumbcols = $CONFIG['thumbcols'];
    $cell_width = ceil(100 / $CONFIG['max_film_strip_items']) . '%';

    $i = 0;
    $thumb_strip = '';
    foreach($thumb_list as $thumb) {
        //modify $new_size for max dimension of thumbnails in filmstrip
        $new_size = 65;
        preg_match('/(?<=width=")[0-9]*/',$thumb['image'],$matches,PREG_OFFSET_CAPTURE);
        $srcWidth=$matches[0][0];
        preg_match('/(?<=height=")[0-9]*/',$thumb['image'],$matches,PREG_OFFSET_CAPTURE);
        $srcHeight=$matches[0][0];
        $ratio = max($srcWidth, $srcHeight) / $new_size;
        $ratio = max($ratio, 1.0);
        $destWidth = (int)($srcWidth / $ratio);
        $destHeight = (int)($srcHeight / $ratio);
        $thumb['image']=preg_replace('/width="[^"]*"/','width="'.$destWidth.'"',$thumb['image']);
        $thumb['image']=preg_replace('/height="[^"]*"/','height="'.$destHeight.'"',$thumb['image']);
        $i++;
        if ($mode == 'thumb') {
            $params = array('{CELL_WIDTH}' => $cell_width,
                '{LINK_TGT}' => "displayimage.php?album=$aid$cat_link&amp;pos={$thumb['pos']}",
                '{THUMB}' => $thumb['image'],
                '{CAPTION}' => $thumb['caption'],
                '{ADMIN_MENU}' => ''
                );
        } else {
            $params = array('{CELL_WIDTH}' => $cell_width,
                '{LINK_TGT}' => "index.php?cat={$thumb['cat']}",
                '{THUMB}' => $thumb['image'],
                '{CAPTION}' => '',
                '{ADMIN_MENU}' => ''
                );
        }
        $thumb_strip .= template_eval($thumb_cell, $params);
    }

    if (defined('THEME_HAS_FILM_STRIP_GRAPHICS')) {
        $tile1 = $THEME_DIR . 'images/tile1.gif';
        $tile2 = $THEME_DIR . 'images/tile2.gif';
    } elseif (defined('THEME_HAS_FILM_STRIP_GRAPHIC')) {
        $tile1=$tile2=$THEME_DIR . 'images/tile.gif';
    } else {
        $tile1=$tile2= 'images/tile.gif';
    }

    $params = array('{THUMB_STRIP}' => $thumb_strip,
        '{COLS}' => $i,
        '{TILE1}' => $tile1,
        '{TILE2}' => $tile2,
        );

    ob_start();
    starttable($CONFIG['picture_table_width']);
    echo template_eval($template, $params);
    endtable();
    $film_strip = ob_get_contents();
    ob_end_clean();

    return $film_strip;
}

function pageheader($section, $meta = '')
{
    global $CONFIG, $THEME_DIR;
    global $template_header, $lang_charset, $lang_text_dir;

    $custom_header = cpg_get_custom_include($CONFIG['custom_header_path']);

    header('P3P: CP="CAO DSP COR CURa ADMa DEVa OUR IND PHY ONL UNI COM NAV INT DEM PRE"');
    user_save_profile();

    $template_vars = array('{LANG_DIR}' => $lang_text_dir,
        '{TITLE}' => $CONFIG['gallery_name'] . ' - ' . strip_tags(bb_decode($section)),
        '{CHARSET}' => $CONFIG['charset'] == 'language file' ? $lang_charset : $CONFIG['charset'],
        '{META}' => $meta,
        '{GAL_NAME}' => $CONFIG['gallery_name'],
        '{GAL_DESCRIPTION}' => $CONFIG['gallery_description'],
        '{CUSTOM_HEADER}' => $custom_header,
        );

    echo template_eval($template_header, $template_vars);
}
// Function for writing a pagefooter
function pagefooter()
{
    //global $HTTP_GET_VARS, $HTTP_POST_VARS, $HTTP_SERVER_VARS;
    global $USER, $USER_DATA, $ALBUM_SET, $CONFIG, $time_start, $query_stats, $queries;;
    global $template_footer;

    $custom_footer = cpg_get_custom_include($CONFIG['custom_footer_path']);

    if ($CONFIG['debug_mode']==1 || ($CONFIG['debug_mode']==2 && GALLERY_ADMIN_MODE)) {
    cpg_debug_output();
    }

    $template_vars = array(
        '{SYS_MENU}' => theme_main_menu('sys_menu'),
        '{SUB_MENU}' => theme_main_menu('sub_menu'),
        '{ADMIN_MENU}' => theme_admin_mode_menu(),
        '{CUSTOM_FOOTER}' => $custom_footer,
        '{VANITY}' => (defined('THEME_IS_XHTML10_TRANSITIONAL') && $CONFIG['vanity_block']) ? theme_vanity() : '',
    );

    echo template_eval($template_footer, $template_vars);
}
?>