<?php
/* 
 *******************************************
 plugin JUpload for Coppermine Photo Gallery
 *******************************************

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 ********************************************
 $Revision: 185 $
 $Author: etienne_sf $
 $Date: 2008-03-12 20:26:16 +0100 (mer., 12 mars 2008) $
 ********************************************
 *
 * Allows easy upload to the gallery, through a java applet. 
 * 
 * Up to date version of this script can be retrieved with the full JUpload package, here:
 * 
 * http://etienne.sf.free.fr/wiki
 * 
 * Directly here:
 * http://forum.coppermine-gallery.net/index.php/board,100.0.html
 * 
 * Support is available on this forum:
 * http://coppermine-gallery.net/forum/index.php?topic=43432
 * 
 * The applet is published on sourceforge:
 * http://jupload.sourceforge.net
 * 
 */

/*
 * This include is meant to use the available add_picture() and resize_image() Coppermine functions.
 * 
 * To do that, the cpg_die must be overriden, so that resul (easier success or error) is sent back to the applet
 * as a simple text result.
 * 
 * See jupload/includes/j_picmgmt.inc.php for all details.  
 */

if (!defined('IN_COPPERMINE')) { die('Not in Coppermine...');}
if (!defined('JUPLOAD_PHP')) { die('Not in Jupload...');}

logDebug("Using available Coppermine add_picture() and resize_image().");

if($CONFIG['read_iptc_data'] ){
        include("include/iptc.inc.php");
}


$cpg_die_code = '
	jupload_cpg_die($msg_code, $msg_text,  $error_file, $error_line, $output_buffer);
';

logDebug('Before redefining cpg_die...');
if (!runkit_function_redefine ('cpg_die', '$msg_code, $msg_text,  $error_file, $error_line, $output_buffer = false', $cpg_die_code)) {
	jupload_cpg_die(ERROR, "Unable to redefine cpg_die. Stopping here!", __FILE__, __LINE__);
}
logDebug('  cpg_die redefined. JUpload will available Coppermine add_picture() and resize_picture() functions');


/**
 * Redirection to current version of the relevant function. 
 */
function jupload_add_picture($aid, $filepath, $filename, $position = 0, $title = '', $caption = '', $keywords = '', $user1 = '', $user2 = '', $user3 = '', $user4 = '', $category = 0, $raw_ip = '', $hdr_ip = '', $iwidth = 0, $iheight = 0) {
	return add_picture($aid, $filepath, $filename, $position, $title, $caption, $keywords, $user1, $user2, $user3, $user4, $category, $raw_ip, $hdr_ip, $iwidth, $iheight);
}
function jupload_resize_image($src_file, $dest_file, $new_size, $method, $thumb_use) {
	return resize_image($src_file, $dest_file, $new_size, $method, $thumb_use);
}
