<?php
/*************************
  Coppermine Photo Gallery
  ************************
  Copyright (c) 2009 Miquel Ruiz
  v0.1 originally written by Miquel Ruiz

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License version 3
  as published by the Free Software Foundation.

**********************************************/

if (!defined('IN_COPPERMINE')) die('Not in Coppermine...');

// Add actions
$thisplugin->add_action('plugin_install','cities_install');
$thisplugin->add_action('plugin_uninstall', 'cities_uninstall');
$thisplugin->add_action('plugin_configure','cities_configure');

$thisplugin->add_filter('anycontent', 'cities_block_mgr');


function cities_uninstall() {
    global $CONFIG;

    cpg_db_query("DROP TABLE IF EXISTS {$CONFIG['TABLE_PREFIX']}plugin_cities;");
    return true;
}


function cities_block_mgr() {
	global $CONFIG;

    $cities = array();
	$result = cpg_db_query("SELECT * FROM {$CONFIG['TABLE_PREFIX']}plugin_cities;");
	while ($row = mysql_fetch_array($result)) {
		$cities[$row['name']] = array($row['latitude'], $row['longitude']);
	}

	require_once('plugins/cities/inc/JSON.php');
	$json = new Services_JSON();
	$cities = $json->encode($cities);

	$ret = <<< EOH
<table align="center" width="100%" cellspacing="1" cellpadding="0" class="maintable">
	<tr>
    	<td class="tableh1" colspan="1">Cities where I have been</td>
    </tr>
    <tr>
        <td class="tableb" height="200" align="center">
			<div id="map_canvas" style="height: 300px;"> Loading... </div>
		</td>
	</tr>
</table>

<script type="text/javascript" src="http://maps.google.com/maps/api/js?sensor=false"></script>
<script type="text/javascript">
  var cities = $cities ;
  
  (function() {
    //alert("loading...");
    var latlng = new google.maps.LatLng(46.466667,9.166667);
    var myOptions = {
      zoom: 4,
      center: latlng,
      disableDefaultUI: true,
      mapTypeId: google.maps.MapTypeId.ROADMAP
    };
    var map = new google.maps.Map(document.getElementById("map_canvas"), myOptions);
    
    for (var city in cities) {
        var latlng = new google.maps.LatLng(cities[city][0], cities[city][1]);
        var marker = new google.maps.Marker({
            position: latlng,
            map: map
        });
    }
  })();

</script>

EOH;

    return $ret;
}


// Install function
function cities_install() {
	global $CONFIG;

    require_once 'include/sql_parse.php';
    // create table
    $db_schema = 'plugins/cities/schema.sql';
    $sql_query = fread(fopen($db_schema, 'r'), filesize($db_schema));
    $sql_query = preg_replace('/CPG_/', $CONFIG['TABLE_PREFIX'], $sql_query);

    $sql_query = remove_remarks($sql_query);
    $sql_query = split_sql_file($sql_query, ';');

    foreach($sql_query as $q) {
        cpg_db_query($q);
    }

    return true;
}

// Configure function
// Displays the form
function cities_configure() {
    echo <<< EOT
	<script language="javascript" type="text/javascript">
	function addRow() {
		var tbl = document.getElementById("cities_table");
		var it  = tbl.rows.length - 1;
		var row = tbl.insertRow(it);

		var elems = new Array('name', 'latitude', 'longitude');
		for (var i = 0; i < elems.length; i++)
			addCells(row, it, elems[i]);
	}
	
	function addCells(tr, it, name) {
		var num  = tr.cells.length;

		var cell = tr.insertCell(num);
		cell.setAttribute('class', 'tableb');
		cell.setAttribute('align', 'right');
		cell.appendChild(document.createTextNode(ucfirst(name) + ':'));

		cell = tr.insertCell(num + 1);
		cell.setAttribute('class', 'tableb');
		var el   = document.createElement('input');
		el.setAttribute('type', 'text');
		el.setAttribute('class', 'textinput');
		el.setAttribute('name', name + it);
		el.setAttribute('id',   name + it);
		el.setAttribute('style','width:100%');
		cell.appendChild(el);
	}

	function ucfirst(str) {
    	var firstLetter = str.substr(0, 1);
    	return firstLetter.toUpperCase() + str.substr(1);
	}
	
	</script>
    <form name="cpgform" id="cpgform" action="{$_SERVER['REQUEST_URI']}" method="post">
            <table id="cities_table" name="cities_table" border="0" cellspacing="0" cellpadding="0" width="100%">
              <tr>
                <td class="tableh2" colspan="3">
                  <h3>Enter the name, latitude and longitude of the cities where you ve been</h3>
                </td>
				<td class="tableh2" colspan="3" align="center">
                  <input type="button" value="More" class="button" onclick="addRow();"/>
				</td>
              </tr>
              <tr>
                <td class="tableb" align="right">
                  Name:
                </td>
                <td class="tableb">
                  <input type="text" name="name1" class="textinput" style="width:100%" />
                </td>
                <td class="tableb" align="right">
                  Latitude:
                </td>
                <td class="tableb">
                  <input type="text" name="lat1"  class="textinput" style="width:100%" />
                </td>
                <td class="tableb" align="right">
                  Longitude:
                </td>
                <td class="tableb">
                  <input type="text" name="long1" class="textinput" style="width:100%" />
                </td>
              </tr>
				<tr>
                <td class="tableh2" colspan="6">
                  <input type="submit" value="Go!" class="button" />
                </td>
              </tr>
            </table>
    </form>
EOT;
}
?>
