<?php

function index($cat_id) {
	global $CONFIG, $USER_DATA;
	global $lang_fr_index;
	global $last_msg_date_fmt;
	global $template_fr_index;                                                       	
	// template
	$template_board_view  			= template_extract_block($template_fr_index, "board_view");
	$template_board_view_no_child  	= template_extract_block($template_fr_index, "board_view_no_child");
	$template_no_board 	  			= template_extract_block($template_fr_index, "no_board");
	$template_board_guide 			= template_extract_block($template_fr_index, "board_guide");
	// get all categories data	
	if ($cat_id == 0) {		
		HTMLelement::nagavitor(0, "index");
		$category_array = cpgdb_fetch_rowset("SELECT * FROM `{$CONFIG['TABLE_FR_CATEGORIES']}` ORDER BY cat_order ASC;");	
	} else {			
		HTMLelement::nagavitor($cat_id, "cat");
		$category_array = cpgdb_fetch_rowset("SELECT * FROM `{$CONFIG['TABLE_FR_CATEGORIES']}` WHERE cat_id='$cat_id' ORDER BY cat_order ASC;");
	}
	foreach ($category_array as $category) {		
		// title
		starttable($CONFIG['picture_table_width'], HTMLelement::apply_bold(HTMLelement::cat_link($category['cat_id'], $category['name'])), 5);
		// get board data
		$board_array = cpgdb_fetch_rowset("SELECT * FROM `{$CONFIG['TABLE_FR_BOARDS']}` WHERE cat_id = '{$category['cat_id']}' AND child_level='1' ORDER BY board_order ASC;");
		// no board in this cat
		if (count($board_array) == 0) {
			$vars = array('{TEXT}'=>$lang_fr_index['no_board']);				
			echo template_eval($template_no_board, $vars);			
		}
		foreach ($board_array as $board) {
			$child_board_lst = HTMLelement::get_child_board($board['board_id'], $board['child_level']); 			
			$vars = array(
				'{ICON}'			=>	HTMLelement::image("adaptor/images/default/icon_board_new.gif"),
			    '{TITLE}'			=>	HTMLelement::board_title($board['board_id'], $board['name']),
			    '{DESCRIPTION}'		=>  $board['description'],
			    '{STATS}'           =>	$board['posts'].$lang_fr_index['posts']."<br />".$board['topics'].$lang_fr_index['topics'],
			    '{LAST_POST}'       =>	HTMLelement::get_last_post_text($board['last_msg_id']),
			    '{CHILD_BOARDS}'    =>	$child_board_lst,				
			);
			if ($child_board_lst == "")
				echo template_eval($template_board_view_no_child, $vars);
			else
				echo template_eval($template_board_view, $vars);
		}   
		// loop & display                                             			
		endtable();
		HTMLelement::spacer();			
	}
	$vars = array(
		'{NEW_IMAGE}' => HTMLelement::image("adaptor/images/default/icon_board_new.gif"), 
		'{NEW}' => $lang_fr_index['new_post'], 
		'{NONE_IMAGE}' => HTMLelement::image("adaptor/images/default/icon_board.gif"), 
		'{NONE}' => $lang_fr_index['no_new_post'],
		'{WIDTH}' => $CONFIG['picture_table_width'],
	);	
	echo template_eval($template_board_guide, $vars);		
	forum_stats();	
} 

function forum_stats() {
	global $CONFIG;
	global $lang_fr_index;
	global $last_msg_date_fmt;
	global $template_fr_stats;
	// template
	$template_recent_post = template_extract_block($template_fr_stats, 'recent_post');
	// stats
	$total_post = cpgdb_fetch_var("SELECT count(*) FROM `{$CONFIG['TABLE_FR_MESSAGES']}`;");
	$total_topic = cpgdb_fetch_var("SELECT count(*) FROM `{$CONFIG['TABLE_FR_TOPICS']}`;"); 	
	$total_member = cpgdb_fetch_var("SELECT count(*) FROM `{$CONFIG['TABLE_USERS']}`;");
	
	$lastest_member_data = cpgdb_fetch_row("SELECT user_id, user_name FROM `{$CONFIG['TABLE_USERS']}` ORDER BY user_id DESC LIMIT 1;");
	$lastest_member_link = HTMLelement::profile_link($lastest_member_data['user_id'], $lastest_member_data['user_name']);
	
	$lastest_post_data = cpgdb_fetch_row("SELECT msg_id, topic_id, subject FROM `{$CONFIG['TABLE_FR_MESSAGES']}` ORDER BY msg_id DESC LIMIT 1;");
	// ???
	$topic_count = cpgdb_fetch_var("SELECT count(*) as count FROM `{$CONFIG['TABLE_FR_MESSAGES']}` WHERE topic_id='{$lastest_post_data['topic_id']}';");			
	$topic_total_page = ceil($topic_count/$CONFIG['fr_msg_per_page']);
	$post_extra = "start=".($topic_total_page-1)*$CONFIG['fr_msg_per_page'];
	$post_extra .= "#".$lastest_post_data['msg_id'];
	// ???
	$lastest_post_link = HTMLelement::topic_link($lastest_post_data['topic_id'], $lastest_post_data['subject'], $post_extra);
	$time = localised_date(time(), $last_msg_date_fmt);		
	$lang_fr_index['stasts'] = sprintf($lang_fr_index['stasts'], $total_post, $total_topic, $total_member, $lastest_member_link, $lastest_post_link, $time);
	// recent post
	$recent_post_html = "";
	$recent_post_array = cpgdb_fetch_rowset("SELECT board_id, topic_id, msg_id, subject, poster_id, poster_name, poster_time FROM `{$CONFIG['TABLE_FR_MESSAGES']}` GROUP BY (topic_id) ORDER BY msg_id DESC LIMIT 5;");
	foreach ($recent_post_array as $recent_post) {
		// ???
		$topic_count = cpgdb_fetch_var("SELECT count(*) as count FROM `{$CONFIG['TABLE_FR_MESSAGES']}` WHERE topic_id='{$recent_post['topic_id']}';");		
		$topic_total_page = ceil($topic_count/$CONFIG['fr_msg_per_page']);
		$post_extra = "start=".($topic_total_page-1)*$CONFIG['fr_msg_per_page'];				
		$post_extra .= "#".$recent_post['msg_id'];		
		// ???
		$post_link   = HTMLelement::topic_link($recent_post['topic_id'], $recent_post['subject'], $post_extra);
		$poster_link = HTMLelement::profile_link($recent_post['poster_id'], $recent_post['poster_name']);		
		$board_id    = cpgdb_fetch_var("SELECT board_id FROM `{$CONFIG['TABLE_FR_TOPICS']}` WHERE topic_id='{$recent_post['topic_id']}';");
		$board_name  = cpgdb_fetch_var("SELECT name FROM `{$CONFIG['TABLE_FR_BOARDS']}` WHERE board_id='$board_id';");		
		$board_link  = HTMLelement::board_link($board_id, $board_name);		
		$vars = array(
			'{TEXT}'	=> sprintf($lang_fr_index['recent_post'], $post_link, $poster_link, $board_link),			
	    	'{TIME}'	=> localised_date($recent_post['poster_time'] ,$last_msg_date_fmt),
		);	
		$recent_post_html .= template_eval($template_recent_post, $vars);	
	}
	// out
	starttable($CONFIG['picture_table_width'], HTMLelement::apply_bold("Coppermine Simple Forum - Info Center"), 2);
	$vars = array(
		'{STATS_TITLE}'			=> $lang_fr_index['stats_title'],
		'{STATS_IMAGE}'			=> HTMLelement::image("adaptor/images/default/info.gif"),
		'{STATS}'				=> $lang_fr_index['stasts'],		
		'{RECENT_POST_TITLE}'	=> $lang_fr_index['recent_post_title'],
		'{RECENT_POST_IMAGE}'	=> HTMLelement::image("adaptor/images/default/info.gif"),
		'{RECENT_POST}'			=> $recent_post_html,
	);
	echo template_eval($template_fr_stats, $vars);
	endtable();
	HTMLelement::spacer();	
}

?>