<?php
/**************************************************
  FSslideS - a fullscreen slideshow plugin for Coppermine using Flash
  *************************************************
  Copyright (c) 2007 Andreas Wehr <mail@makrograf.com>
***************************************************/

if (!defined('IN_COPPERMINE')) die('Not in Coppermine...');


// Modify the intermediate image
$thisplugin->add_filter('file_data','fsslides');
// Modify the template to include swfobject
$thisplugin->add_filter('template_html','add_swfo');

function fsslides($pic_data) 
{   
		global $CONFIG, $CURRENT_PIC_DATA;
 		//compute size of intermediate image
    list($interwidth, $interheight, $intertype, $interattr) = getimagesize($CONFIG['site_url'].get_pic_url($CURRENT_PIC_DATA,'normal'));
    
    //script for swfobject to embed the flash-file if supported by the browser
    //compute all urls of current album
    $url_array=get_urls($CURRENT_PIC_DATA);
    //variables needed:
    $image=$CURRENT_PIC_DATA['header'].$CURRENT_PIC_DATA['html'].$CURRENT_PIC_DATA['footer'];
    $imgurl=$CONFIG['site_url'].get_pic_url($CURRENT_PIC_DATA,'fullsize');
    $interImgUrl=$CONFIG['site_url'].get_pic_url($CURRENT_PIC_DATA,'normal');
    $album_urls=$url_array[0];
    $all_urls=$url_array[1];
    
    $script_html= <<<EOT
    <script  type="text/javascript"  >
 			window.onload = function(){
			addSwfs();
			}
			function addSwfs(){
   var so = new SWFObject("plugins/fsslides/bin/fsdia.swf", "vollbild", "{$interwidth}", "{$interheight}", "9", "#000000");
   so.addParam("allowFullScreen", "true");
   so.addVariable("imgUrl", "{$imgurl}");
   so.addVariable("interImgUrl", "{$interImgUrl}");
   so.addVariable("exifData", "not used");
   so.addVariable("title", "not used");
   so.addVariable("album_urls","{$album_urls}");
   so.addVariable("all_urls",escape("{$all_urls}"));
   so.write("flashcontent");
}  
</script>
EOT;
		$image_html=<<<EOT
		<div id="flashcontent">
		{$image}
<div><a href="http://adobe.com/go/getflashplayer" target="_blank">Der Flash-Player muss installiert sein, um die Vollbild-Ansicht zu nutzen!</a></div>
</div>
EOT;
		
		$pic_data['html'] = $script_html.$image_html;
		//$pic_data['html'] = $script_html.$pic_data['html']."<br />".$interwidth." x ".$interheight."<br />".$url_array[0]; 
		return $pic_data;
}


//get all URLs of the current album
function get_urls($picId) {
	/*
	This function is based on the lightbox_list function I found in the Lightbox-Slideshow hack for Coppermine. 
	Thanks for that!!!
	http://coppermine-gallery.net/forum/index.php?topic=35539.0
	Was modded to return an array of the urls in the current album.
	$url_array[0] contains all fullsize-URLs of the albums PICTURES
	$url_array[1] contains all image-URLs (.../displayimage.php......) of the albums PICTURES
	*/
	//Set max number of images, you can adjust that, if you think loading 1000 thumbnails inside flash is not the best idea ;)
	$max = -1; 			//(-1 for all pics in album)
 
	global $lang_display_image_php, $CONFIG;
	$i = 0;
	$pid = $picId['pid'];
	$aid = empty($_GET['album']) ? $picId['aid'] : $_GET['album'];
	$pic_data = get_pic_data($aid, $pic_count, $album_name, -1, -1, false);
	$imax = 0;			//counter
	$max = $max/2;
	foreach ($pic_data as $picture){
		if ($picture['pid'] == $pid) {
		//the number of the picture in  order
		$picnumber = $imax;
		}
	$imax++;
	}	
	//Check beginning and ending of album
	if(! ($max == ((-1)/2))){
		if ($imax > $max){
			if ($picnumber < $max || $picnumber == 0){
				$down = 0;
				$up = 0 + ($max*2);
			}elseif (($picnumber + $max) > $imax){
				$down = $imax - ($max*2);
				$up = $imax;
			}else{
				$down = $picnumber - $max;
				$up = $picnumber + $max;
			}
		}else{
			$down = 0;
			$up = $imax;
		}
	}else{
			$down = 0;
			$up = $imax;
	}
 
	foreach ($pic_data as $picture) {
		if ($i >= $down && $i <= $up){
 
			$picture_page = "./displayimage.php?album=".$picture['aid']."&pos=-".$picture['pid'];
			if (is_image($picture['filename'])) {
				$picture_url_fullsize.= $CONFIG['site_url'].get_pic_url($picture, 'fullsize').'|';
			}
			$picture_pages .= $CONFIG['site_url']."displayimage.php?album=".$picture['aid']."&pos=-".$picture['pid']."|";
		}
		$i++;
	}
 
	//delete the last | in the url lists
	$url_array[0]=substr($picture_url_fullsize,0,-1);
	$url_array[1]=substr($picture_pages,0,-1);
	return $url_array;
}
	
	
function add_swfo($html) 
{   
 	$script_html = <<<EOT
	<script type="text/javascript" src="plugins/fsslides/bin/swfobject.js"></script>
	{META}
EOT;
  return str_replace('{META}',$script_html,$html);
}

?>