/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.filedata;

import java.awt.Canvas;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.FileImageInputStream;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.exception.JUploadIOException;
import wjhk.jupload2.filedata.DefaultFileData;
import wjhk.jupload2.filedata.helper.ImageHelper;
import wjhk.jupload2.filedata.helper.ImageReaderWriterHelper;
import wjhk.jupload2.policies.PictureUploadPolicy;

public class PictureFileData
extends DefaultFileData {
    private boolean isPicture = false;
    boolean storeBufferedImage = false;
    private Image offscreenImage = null;
    int quarterRotation = 0;
    int originalWidth = -1;
    int originalHeight = -1;
    private File transformedPictureFile = null;
    private long uploadLength = -1L;
    private File workingCopyTempFile = null;

    public PictureFileData(File file, File root, PictureUploadPolicy uploadPolicy) throws JUploadIOException {
        super(file, root, uploadPolicy);
        this.storeBufferedImage = uploadPolicy.hasToStoreBufferedImage();
        String fileExtension = this.getFileExtension();
        this.isPicture = PictureFileData.isFileAPictrue(file);
        uploadPolicy.displayDebug("isPicture=" + this.isPicture + " (" + file.getName() + "), extension=" + fileExtension, 50);
        if (this.isPicture) {
            this.setMimeTypeByExtension(fileExtension);
        }
    }

    public void freeMemory(String caller) {
        Runtime rt = Runtime.getRuntime();
        rt.gc();
        this.uploadPolicy.displayDebug("freeMemory (after " + caller + ") : " + rt.freeMemory(), 50);
    }

    public void beforeUpload() throws JUploadException {
        if (this.uploadLength < 0L) {
            try {
                this.initTransformedPictureFile();
            }
            catch (OutOfMemoryError e) {
                this.deleteTransformedPictureFile();
                this.tooBigPicture();
            }
            this.uploadLength = this.transformedPictureFile != null ? this.transformedPictureFile.length() : this.getFile().length();
        }
        super.beforeUpload();
    }

    public long getUploadLength() throws JUploadException {
        if (this.uploadLength < 0L) {
            this.beforeUpload();
        }
        return this.uploadLength;
    }

    public InputStream getInputStream() throws JUploadException {
        if (this.transformedPictureFile != null) {
            try {
                return new FileInputStream(this.transformedPictureFile);
            }
            catch (FileNotFoundException e) {
                throw new JUploadIOException(e);
            }
        }
        return super.getInputStream();
    }

    public void afterUpload() {
        super.afterUpload();
        if (this.transformedPictureFile != null) {
            if (this.uploadPolicy.getDebugLevel() >= 100) {
                this.uploadPolicy.displayWarn("Temporary file not deleted");
            } else {
                this.deleteTransformedPictureFile();
            }
        }
    }

    public Image getImage(Canvas canvas, boolean shadow) throws JUploadException {
        Image localImage = null;
        if (canvas == null) {
            throw new JUploadException("canvas null in PictureFileData.getImage");
        }
        int canvasWidth = canvas.getWidth();
        int canvasHeight = canvas.getHeight();
        if (canvasWidth <= 0 || canvasHeight <= 0) {
            this.uploadPolicy.displayDebug("canvas width and/or height null in PictureFileData.getImage()", 1);
        } else if (shadow && this.offscreenImage != null) {
            localImage = this.offscreenImage;
        } else if (this.isPicture) {
            try {
                ImageReaderWriterHelper irwh = new ImageReaderWriterHelper((PictureUploadPolicy)this.uploadPolicy, this);
                BufferedImage sourceImage = irwh.readImage(0);
                irwh.dispose();
                irwh = null;
                ImageHelper ih = new ImageHelper((PictureUploadPolicy)this.uploadPolicy, this, canvasWidth, canvasHeight, this.quarterRotation);
                localImage = ih.getBufferedImage(((PictureUploadPolicy)this.uploadPolicy).getHighQualityPreview(), sourceImage);
                sourceImage.flush();
                sourceImage = null;
            }
            catch (OutOfMemoryError e) {
                localImage = null;
                this.tooBigPicture();
            }
        }
        if (shadow) {
            this.offscreenImage = localImage;
        }
        this.freeMemory("end of " + this.getClass().getName() + ".getImage()");
        this.uploadPolicy.getApplet().getUploadPanel().getPreparationProgressBar().setValue(0);
        return localImage;
    }

    public void addRotation(int quarter) {
        this.quarterRotation += quarter;
        this.uploadLength = -1L;
        while (this.quarterRotation < 0) {
            this.quarterRotation += 4;
        }
        while (this.quarterRotation >= 4) {
            this.quarterRotation -= 4;
        }
        if (this.offscreenImage != null) {
            this.offscreenImage.flush();
            this.offscreenImage = null;
        }
    }

    public boolean isPicture() {
        return this.isPicture;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void deleteTransformedPictureFile() {
        if (null != this.transformedPictureFile) {
            this.transformedPictureFile.delete();
            this.transformedPictureFile = null;
            this.uploadLength = -1L;
        }
    }

    private void initTransformedPictureFile() throws JUploadException {
        int targetMaxHeight;
        int targetMaxWidth;
        if (this.quarterRotation == 0) {
            targetMaxWidth = ((PictureUploadPolicy)this.uploadPolicy).getMaxWidth();
            targetMaxHeight = ((PictureUploadPolicy)this.uploadPolicy).getMaxHeight();
        } else {
            targetMaxWidth = ((PictureUploadPolicy)this.uploadPolicy).getRealMaxWidth();
            targetMaxHeight = ((PictureUploadPolicy)this.uploadPolicy).getRealMaxHeight();
        }
        ImageHelper imageHelper = new ImageHelper((PictureUploadPolicy)this.uploadPolicy, this, targetMaxWidth, targetMaxHeight, this.quarterRotation);
        if (imageHelper.hasToTransformPicture() && this.transformedPictureFile == null) {
            try {
                this.createTranformedPictureFile(imageHelper);
            }
            catch (JUploadException e) {
                if (this.transformedPictureFile != null) {
                    this.transformedPictureFile.delete();
                    this.transformedPictureFile = null;
                }
                throw e;
            }
        }
    }

    void createTranformedPictureFile(ImageHelper imageHelper) throws JUploadException {
        IIOMetadata metadata = null;
        IIOImage iioImage = null;
        BufferedImage originalImage = null;
        BufferedImage transformedImage = null;
        ImageReaderWriterHelper imageWriterHelper = new ImageReaderWriterHelper((PictureUploadPolicy)this.uploadPolicy, this);
        boolean transmitMetadata = ((PictureUploadPolicy)this.uploadPolicy).getPictureTransmitMetadata();
        this.createTransformedTempFile();
        imageWriterHelper.setOutput(this.transformedPictureFile);
        int nbPictures = 1;
        if (PictureFileData.getExtension(this.getFile()).equalsIgnoreCase("gif")) {
            nbPictures = Integer.MAX_VALUE;
        }
        this.uploadPolicy.displayDebug("Reading image with imageWriterHelper.readImage(i)", 50);
        try {
            for (int i = 0; i < nbPictures; ++i) {
                originalImage = imageWriterHelper.readImage(i);
                transformedImage = imageHelper.getBufferedImage(true, originalImage);
                if (transmitMetadata) {
                    metadata = imageWriterHelper.getImageMetadata(i);
                }
                iioImage = new IIOImage(transformedImage, null, metadata);
                imageWriterHelper.write(iioImage);
                if (originalImage == null) continue;
                originalImage.flush();
                originalImage = null;
            }
        }
        catch (IndexOutOfBoundsException e) {
            this.uploadPolicy.displayDebug("IndexOutOfBoundsException catched: end of reading for file " + this.getFileName(), 10);
        }
        if (originalImage != null) {
            originalImage.flush();
            originalImage = null;
        }
        imageWriterHelper.dispose();
    }

    private void tooBigPicture() {
        String msg = String.format(this.uploadPolicy.getString("tooBigPicture"), this.getFileName());
        JOptionPane.showMessageDialog(null, msg, "Warning", 2);
        this.uploadPolicy.displayWarn(msg);
    }

    private void setMimeTypeByExtension(String fileExtension) {
        String ext = fileExtension.toLowerCase();
        if (ext.equals("jpg")) {
            ext = "jpeg";
        }
        this.mimeType = "image/" + ext;
    }

    private void createTransformedTempFile() throws JUploadIOException {
        if (this.transformedPictureFile == null) {
            try {
                this.transformedPictureFile = File.createTempFile("jupload_", ".tmp");
            }
            catch (IOException e) {
                throw new JUploadIOException("PictureFileData.createTransformedTempFile()", e);
            }
            this.uploadPolicy.getApplet().registerUnload(this, "deleteTransformedPictureFile");
            this.uploadPolicy.displayDebug("Using transformed temp file " + this.transformedPictureFile.getAbsolutePath() + " for " + this.getFileName(), 30);
        }
    }

    private void initWidthAndHeight() throws JUploadIOException {
        Iterator<ImageReader> iter;
        if (this.isPicture && (this.originalHeight < 0 || this.originalWidth < 0) && (iter = ImageIO.getImageReadersByFormatName(this.getFileExtension().toLowerCase())).hasNext()) {
            try {
                FileImageInputStream fiis = new FileImageInputStream(this.getFile());
                ImageReader ir = iter.next();
                ir.setInput(fiis);
                this.originalHeight = ir.getHeight(0);
                this.originalWidth = ir.getWidth(0);
                ir.dispose();
                fiis.close();
            }
            catch (IOException e) {
                throw new JUploadIOException("PictureFileData()", e);
            }
        }
    }

    private void createWorkingCopyTempFile() throws IOException {
        if (this.workingCopyTempFile == null) {
            this.workingCopyTempFile = File.createTempFile("jupload_", ".tmp." + DefaultFileData.getExtension(this.getFile()));
            this.uploadPolicy.getApplet().registerUnload(this, "deleteWorkingCopyPictureFile");
            this.uploadPolicy.displayDebug("Using working copy temp file " + this.workingCopyTempFile.getAbsolutePath() + " for " + this.getFileName(), 30);
        }
    }

    public void deleteWorkingCopyPictureFile() {
        if (null != this.workingCopyTempFile) {
            this.workingCopyTempFile.delete();
            this.workingCopyTempFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public File getWorkingSourceFile() throws JUploadIOException {
        if (this.workingCopyTempFile != null) return this.workingCopyTempFile;
        this.uploadPolicy.displayDebug("[getWorkingSourceFile] Creating a copy of " + this.getFileName() + " as a source working target.", 30);
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            block18: {
                try {
                    int l;
                    this.createWorkingCopyTempFile();
                    is = new FileInputStream(this.getFile());
                    os = new FileOutputStream(this.workingCopyTempFile);
                    byte[] b = new byte[1024];
                    while ((l = is.read(b)) > 0) {
                        os.write(b, 0, l);
                    }
                    Object var6_6 = null;
                    if (is == null) break block18;
                }
                catch (IOException e3) {
                    throw new JUploadIOException("ImageReaderWriterHelper.getWorkingSourceFile()", e3);
                }
                try {
                    try {
                        is.close();
                    }
                    catch (IOException e22) {
                        this.uploadPolicy.displayWarn(e22.getClass().getName() + " while trying to close FileInputStream, in PictureUploadPolicy.copyOriginalToWorkingCopyTempFile.");
                        Object var9_9 = null;
                        is = null;
                        break block18;
                    }
                    Object var9_8 = null;
                    is = null;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    is = null;
                    throw throwable;
                }
            }
            if (os == null) return this.workingCopyTempFile;
            try {
                try {
                    os.close();
                }
                catch (IOException e) {
                    this.uploadPolicy.displayWarn(e.getClass().getName() + " while trying to close FileOutputStream, in PictureUploadPolicy.copyOriginalToWorkingCopyTempFile.");
                    return this.workingCopyTempFile;
                }
                return this.workingCopyTempFile;
            }
            catch (Throwable throwable) {
                Object var11_20 = null;
                os = null;
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            block19: {
                Object var6_7 = null;
                if (is != null) {
                    try {}
                    catch (Throwable throwable2) {
                        Object var9_13 = null;
                        is = null;
                        throw throwable2;
                    }
                    try {}
                    catch (IOException e22) {
                        this.uploadPolicy.displayWarn(e22.getClass().getName() + " while trying to close FileInputStream, in PictureUploadPolicy.copyOriginalToWorkingCopyTempFile.");
                        Object var9_12 = null;
                        is = null;
                        break block19;
                    }
                    is.close();
                    Object var9_11 = null;
                    is = null;
                }
            }
            if (os == null) throw throwable;
            try {}
            catch (Throwable throwable3) {
                Object var11_23 = null;
                os = null;
                throw throwable3;
            }
            try {}
            catch (IOException e) {
                this.uploadPolicy.displayWarn(e.getClass().getName() + " while trying to close FileOutputStream, in PictureUploadPolicy.copyOriginalToWorkingCopyTempFile.");
                Object var11_22 = null;
                os = null;
                throw throwable;
            }
            os.close();
            Object var11_21 = null;
            os = null;
            throw throwable;
        }
    }

    public int getOriginalWidth() throws JUploadIOException {
        this.initWidthAndHeight();
        return this.originalWidth;
    }

    public int getOriginalHeight() throws JUploadIOException {
        this.initWidthAndHeight();
        return this.originalHeight;
    }

    public static ImageIcon getImageIcon(File pictureFile, int maxWidth, int maxHeight) {
        ImageIcon tmpIcon;
        ImageIcon thumbnail = null;
        if (pictureFile != null && (tmpIcon = new ImageIcon(pictureFile.getPath())) != null) {
            double scaleHeight;
            double scaleWidth = (double)maxWidth / (double)tmpIcon.getIconWidth();
            double scale = Math.min(scaleWidth, scaleHeight = (double)maxHeight / (double)tmpIcon.getIconHeight());
            thumbnail = scale < 1.0 ? new ImageIcon(tmpIcon.getImage().getScaledInstance((int)(scale * (double)tmpIcon.getIconWidth()), (int)(scale * (double)tmpIcon.getIconHeight()), 2)) : tmpIcon;
        }
        return thumbnail;
    }

    public static boolean isFileAPictrue(File file) {
        Iterator<ImageReader> iter = ImageIO.getImageReadersByFormatName(DefaultFileData.getExtension(file).toLowerCase());
        return iter.hasNext();
    }
}

