/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.filedata.helper;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.FileImageOutputStream;
import wjhk.jupload2.exception.JUploadIOException;
import wjhk.jupload2.filedata.DefaultFileData;
import wjhk.jupload2.filedata.PictureFileData;
import wjhk.jupload2.policies.PictureUploadPolicy;

public class ImageReaderWriterHelper {
    FileImageInputStream fileImageInputStream = null;
    FileImageOutputStream fileImageOutputStream;
    PictureFileData pictureFileData;
    ImageReader imageReader = null;
    ImageWriter imageWriter = null;
    ImageWriteParam imageWriterParam = null;
    String targetPictureFormat;
    PictureUploadPolicy uploadPolicy;

    public ImageReaderWriterHelper(PictureUploadPolicy uploadPolicy, PictureFileData pictureFileData) {
        this.uploadPolicy = uploadPolicy;
        this.pictureFileData = pictureFileData;
        this.targetPictureFormat = this.uploadPolicy.getTargetPictureFormat() == null ? pictureFileData.getFileExtension() : this.uploadPolicy.getTargetPictureFormat();
    }

    public void setOutput(File file) throws JUploadIOException {
        this.initImageWriter();
        try {
            this.fileImageOutputStream = new FileImageOutputStream(file);
        }
        catch (IOException e) {
            throw new JUploadIOException("ImageReaderWriterHelper.setOutput()", e);
        }
        this.imageWriter.setOutput(this.fileImageOutputStream);
    }

    public void dispose() throws JUploadIOException {
        if (this.imageWriter != null) {
            this.imageWriter.dispose();
            if (this.fileImageOutputStream != null) {
                try {
                    this.fileImageOutputStream.close();
                }
                catch (IOException e) {
                    throw new JUploadIOException("ImageReaderWriterHelper.dispose() [fileImageOutputStream]", e);
                }
            }
            this.imageWriter = null;
            this.fileImageOutputStream = null;
        }
        if (this.imageReader != null) {
            this.imageReader.dispose();
            try {
                this.fileImageInputStream.close();
            }
            catch (IOException e) {
                throw new JUploadIOException("ImageReaderWriterHelper.dispose() [fileImageInputStream]", e);
            }
            this.imageReader = null;
            this.fileImageInputStream = null;
        }
    }

    public int getNumImages(boolean allowSearch) throws JUploadIOException {
        this.initImageReader();
        try {
            return this.imageReader.getNumImages(allowSearch);
        }
        catch (IOException e) {
            throw new JUploadIOException("ImageReaderWriterHelper.getNumImages() [fileImageInputStream]", e);
        }
    }

    public BufferedImage imageIORead() throws JUploadIOException {
        try {
            return ImageIO.read(this.pictureFileData.getWorkingSourceFile());
        }
        catch (IOException e) {
            throw new JUploadIOException("ImageReaderWriterHelper.ImageIORead()", e);
        }
    }

    public BufferedImage readImage(int imageIndex) throws JUploadIOException, IndexOutOfBoundsException {
        this.initImageReader();
        try {
            this.uploadPolicy.displayDebug("ImageReaderWriterHelper: reading picture number " + imageIndex + " of file " + this.pictureFileData.getFileName(), 30);
            return this.imageReader.read(imageIndex);
        }
        catch (IndexOutOfBoundsException e) {
            throw e;
        }
        catch (IOException e) {
            throw new JUploadIOException("ImageReaderWriterHelper.readImage(" + imageIndex + ")", e);
        }
    }

    public IIOImage readAll(int imageIndex) throws JUploadIOException, IndexOutOfBoundsException {
        this.initImageReader();
        try {
            this.uploadPolicy.displayDebug("ImageReaderWriterHelper: reading picture number " + imageIndex + " of file " + this.pictureFileData.getFileName(), 30);
            return this.imageReader.readAll(imageIndex, this.imageReader.getDefaultReadParam());
        }
        catch (IndexOutOfBoundsException e) {
            throw e;
        }
        catch (IOException e) {
            throw new JUploadIOException("ImageReaderWriterHelper.readAll(" + imageIndex + ")", e);
        }
    }

    public IIOMetadata getImageMetadata(int imageIndex) throws JUploadIOException {
        this.initImageReader();
        try {
            this.uploadPolicy.displayDebug("ImageReaderWriterHelper: reading metadata for picture number " + imageIndex + " of file " + this.pictureFileData.getFileName(), 30);
            return this.imageReader.getImageMetadata(imageIndex);
        }
        catch (IOException e) {
            throw new JUploadIOException("ImageReaderWriterHelper.getImageMetadata()", e);
        }
    }

    public void writeInsert(int numIndex, IIOImage iioImage, ImageWriteParam iwp) throws JUploadIOException {
        this.initImageWriter();
        try {
            this.imageWriter.writeInsert(numIndex, iioImage, iwp);
        }
        catch (IOException e) {
            throw new JUploadIOException("ImageReaderWriterHelper.writeInsert()", e);
        }
    }

    public void write(IIOImage iioImage) throws JUploadIOException {
        this.initImageWriter();
        try {
            this.imageWriter.write(null, iioImage, this.imageWriterParam);
        }
        catch (IOException e) {
            throw new JUploadIOException("ImageReaderWriterHelper.write()", e);
        }
    }

    private void initImageWriter() throws JUploadIOException {
        if (this.imageWriter == null) {
            String targetPictureFormatLowerCase = this.targetPictureFormat.toLowerCase();
            Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(targetPictureFormatLowerCase);
            if (!iter.hasNext()) {
                if (targetPictureFormatLowerCase.equals("gif") && System.getProperty("java.version").startsWith("1.5")) {
                    throw new JUploadIOException("gif pictures are not supported in Java 1.5. Please switch to JRE 1.6.");
                }
                throw new JUploadIOException("No writer for the '" + this.targetPictureFormat + "' picture format.");
            }
            this.imageWriter = iter.next();
            this.imageWriterParam = this.imageWriter.getDefaultWriteParam();
            if (this.targetPictureFormat.equalsIgnoreCase("jpg") || this.targetPictureFormat.equalsIgnoreCase("jpeg")) {
                this.imageWriterParam.setCompressionMode(2);
                this.imageWriterParam.setCompressionQuality(this.uploadPolicy.getPictureCompressionQuality());
                ((JPEGImageWriteParam)this.imageWriterParam).setOptimizeHuffmanTables(true);
            }
            try {
                this.uploadPolicy.displayDebug("ImageWriter1 (used), CompressionQuality=" + this.imageWriterParam.getCompressionQuality(), 50);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void initImageReader() throws JUploadIOException {
        try {
            this.fileImageInputStream = new FileImageInputStream(this.pictureFileData.getWorkingSourceFile());
        }
        catch (IOException e) {
            throw new JUploadIOException("ImageReaderWriterHelper.initImageReader()", e);
        }
        if (this.imageReader == null) {
            String ext = DefaultFileData.getExtension(this.pictureFileData.getFile());
            Iterator<ImageReader> iterator = ImageIO.getImageReadersBySuffix(ext);
            if (iterator.hasNext()) {
                this.imageReader = iterator.next();
                this.imageReader.setInput(this.fileImageInputStream);
                this.uploadPolicy.displayDebug("Foud one reader for " + ext + " extension", 50);
            }
            if (this.imageReader == null) {
                this.uploadPolicy.displayErr("Found no reader for " + ext + " extension");
            } else if (this.uploadPolicy.getDebugLevel() >= 50) {
                try {
                    this.uploadPolicy.displayDebug("Nb images in " + this.pictureFileData.getFileName() + ": " + this.imageReader.getNumImages(true), 50);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

