/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.gui;

import java.awt.Color;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class JUploadTextArea
extends JTextArea {
    public static final int MAX_LOG_WINDOW_LENGTH = 100000;
    Queue<String> messages = null;
    private static final long serialVersionUID = -6037767344615468632L;

    public JUploadTextArea(int rows, int columns) {
        super(rows, columns);
        this.setBackground(new Color(255, 255, 203));
        this.setEditable(false);
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.messages = new ConcurrentLinkedQueue<String>();
    }

    public final void displayMsg(String str) {
        this.messages.add(str);
        DisplayOneMessageThread displayOneMessageThread = new DisplayOneMessageThread(this.messages, this);
        SwingUtilities.invokeLater(displayOneMessageThread);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DisplayOneMessageThread
    implements Runnable {
        Queue<String> messages;
        JUploadTextArea textArea;

        DisplayOneMessageThread(Queue<String> messages, JUploadTextArea textArea) {
            this.messages = messages;
            this.textArea = textArea;
        }

        @Override
        public void run() {
            boolean someTextHasBeenAdded = false;
            String nextMessage = null;
            StringBuffer sbLogContent = new StringBuffer(this.textArea.getText());
            String newLogContent = null;
            try {
                while ((nextMessage = this.messages.poll()) != null) {
                    someTextHasBeenAdded = true;
                    sbLogContent.append(nextMessage);
                }
                if (someTextHasBeenAdded) {
                    newLogContent = sbLogContent.toString();
                    int len = newLogContent.length();
                    if (newLogContent.length() > 100000) {
                        newLogContent = newLogContent.substring(len - 100000, len - 1);
                        len = 100000;
                    }
                    this.textArea.setText(newLogContent);
                    if (len > 0) {
                        this.textArea.setCaretPosition(len - 1);
                    }
                    this.textArea.repaint();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

