/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.upload.helper;

import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLSocket;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.policies.UploadPolicy;
import wjhk.jupload2.upload.helper.CookieJar;
import wjhk.jupload2.upload.helper.HTTPConnectionHelper;

public class HTTPInputStreamReader {
    private UploadPolicy uploadPolicy = null;
    private HTTPConnectionHelper httpConnectionHelper = null;
    String responseBody = null;
    String responseHeaders = null;
    String responseMsg = null;
    private CookieJar cookies = null;
    boolean gotClose = false;
    private boolean gotChunked = false;
    private boolean gotContentLength = false;
    private int clen = 0;
    private int httpStatusCode = 0;
    private String line = "";
    private byte[] body = new byte[0];
    private String charset = "ISO-8859-1";
    private static final int CHUNKBUF_SIZE = 4096;
    private final byte[] chunkbuf = new byte[4096];
    private static final Pattern pChunked = Pattern.compile("^Transfer-Encoding:\\s+chunked", 2);
    private static final Pattern pClose = Pattern.compile("^Connection:\\s+close", 2);
    private static final Pattern pProxyClose = Pattern.compile("^Proxy-Connection:\\s+close", 2);
    private static final Pattern pHttpStatus = Pattern.compile("^HTTP/\\d\\.\\d\\s+((\\d+)\\s+.*)$");
    private static final Pattern pContentLen = Pattern.compile("^Content-Length:\\s+(\\d+)$", 2);
    private static final Pattern pContentTypeCs = Pattern.compile("^Content-Type:\\s+.*;\\s*charset=([^;\\s]+).*$", 2);
    private static final Pattern pSetCookie = Pattern.compile("^Set-Cookie:\\s+(.*)$", 2);

    public HTTPInputStreamReader(HTTPConnectionHelper httpConnectionHelper, UploadPolicy uploadPolicy) {
        this.httpConnectionHelper = httpConnectionHelper;
        this.uploadPolicy = uploadPolicy;
        this.cookies = new CookieJar(uploadPolicy);
    }

    public int gethttpStatusCode() {
        return this.httpStatusCode;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public String getResponseHeaders() {
        return this.responseHeaders;
    }

    public String getResponseMsg() {
        return this.responseMsg;
    }

    public int readHttpResponse() throws JUploadException {
        PushbackInputStream httpDataIn = this.httpConnectionHelper.getInputStream();
        try {
            if (!(this.httpConnectionHelper.getSocket() instanceof SSLSocket)) {
                this.httpConnectionHelper.getSocket().shutdownOutput();
            }
            this.readHeaders(httpDataIn);
            if (this.httpConnectionHelper.getMethod().equals("HEAD")) {
                this.uploadPolicy.displayDebug("This is a HEAD request: we don't care about the body", 70);
                this.responseBody = "";
            } else {
                this.readBody(httpDataIn);
            }
        }
        catch (Exception e) {
            throw new JUploadException(e);
        }
        return this.httpStatusCode;
    }

    static byte[] byteAppend(byte[] buf1, byte[] buf2) {
        byte[] ret = new byte[buf1.length + buf2.length];
        System.arraycopy(buf1, 0, ret, 0, buf1.length);
        System.arraycopy(buf2, 0, ret, buf1.length, buf2.length);
        return ret;
    }

    static byte[] byteAppend(byte[] buf1, byte[] buf2, int len) {
        if (len > buf2.length) {
            len = buf2.length;
        }
        byte[] ret = new byte[buf1.length + len];
        System.arraycopy(buf1, 0, ret, 0, buf1.length);
        System.arraycopy(buf2, 0, ret, buf1.length, len);
        return ret;
    }

    public static String readLine(PushbackInputStream inputStream, String charset, boolean includeCR) throws IOException {
        byte[] line = HTTPInputStreamReader.readLine(inputStream, includeCR);
        return null == line ? null : new String(line, charset);
    }

    public static byte[] readLine(PushbackInputStream inputStream, boolean includeCR) throws IOException {
        int EOS = -1;
        int CR = 13;
        int LF = 10;
        int len = 0;
        int buflen = 128;
        byte[] buf = new byte[buflen];
        byte[] ret = null;
        boolean lineRead = false;
        block5: while (!lineRead) {
            int b = inputStream.read();
            switch (b) {
                case -1: {
                    if (len == 0) {
                        return null;
                    }
                    lineRead = true;
                    continue block5;
                }
                case 10: {
                    lineRead = true;
                    continue block5;
                }
                case 13: {
                    b = inputStream.read();
                    if (b != 10) {
                        inputStream.unread(b);
                    }
                    lineRead = true;
                    continue block5;
                }
            }
            buf[len++] = (byte)b;
            if (len + 2 < buflen) continue;
            byte[] tmp = new byte[buflen *= 2];
            System.arraycopy(buf, 0, tmp, 0, len);
            buf = tmp;
        }
        while (len > 0 && (buf[len] == 13 || buf[len] == 10)) {
            --len;
        }
        if (includeCR) {
            buf[len++] = 13;
            buf[len++] = 10;
        }
        if (len > 0) {
            ret = new byte[len];
            if (len > 0) {
                System.arraycopy(buf, 0, ret, 0, len);
            }
        } else {
            ret = new byte[]{};
        }
        return ret;
    }

    private void readHeaders(PushbackInputStream httpDataIn) throws IOException, JUploadException {
        StringBuffer sbHeaders = new StringBuffer();
        while (!Thread.interrupted()) {
            Matcher m;
            String tmp = HTTPInputStreamReader.readLine(httpDataIn, "US-ASCII", false);
            if (null == tmp) {
                throw new JUploadException("unexpected EOF (in header)");
            }
            if (this.httpStatusCode == 0) {
                this.uploadPolicy.displayDebug("-------- Response Headers Start --------", 80);
                m = pHttpStatus.matcher(tmp);
                if (m.matches()) {
                    this.httpStatusCode = Integer.parseInt(m.group(2));
                    this.responseMsg = m.group(1);
                } else {
                    this.uploadPolicy.displayDebug("First line of response: '" + tmp + "'", 80);
                    throw new JUploadException("HTTP response did not begin with status line.");
                }
            }
            this.line = tmp.startsWith(" ") || tmp.startsWith("\t") ? this.line + " " + tmp.trim() : tmp;
            this.uploadPolicy.displayDebug(this.line, 80);
            sbHeaders.append(tmp).append("\n");
            if (pClose.matcher(this.line).matches()) {
                this.gotClose = true;
            }
            if (pProxyClose.matcher(this.line).matches()) {
                this.gotClose = true;
            }
            if (pChunked.matcher(this.line).matches()) {
                this.gotChunked = true;
            }
            if ((m = pContentLen.matcher(this.line)).matches()) {
                this.gotContentLength = true;
                this.clen = Integer.parseInt(m.group(1));
            }
            if ((m = pContentTypeCs.matcher(this.line)).matches()) {
                this.charset = m.group(1);
            }
            if ((m = pSetCookie.matcher(this.line)).matches()) {
                this.uploadPolicy.displayDebug("Calling this.cookies.parseCookieHeader, with parameter: " + m.group(1), 80);
                this.cookies.parseCookieHeader(m.group(1));
                this.uploadPolicy.displayDebug("Cookie header parsed.", 80);
            }
            if (this.line.length() != 0) continue;
            break;
        }
        this.responseHeaders = sbHeaders.toString();
        this.uploadPolicy.displayDebug("--------- Response Headers End ---------", 80);
    }

    private void readBody(PushbackInputStream httpDataIn) throws IOException, JUploadException {
        while (!(Thread.interrupted() || this.gotContentLength && this.clen <= 0)) {
            byte[] lbuf;
            if (this.gotChunked) {
                this.line = HTTPInputStreamReader.readLine(httpDataIn, "US-ASCII", false);
                if (null == this.line) {
                    throw new JUploadException("unexpected EOF (in HTTP Body, chunked mode)");
                }
                int len = Integer.parseInt(this.line.replaceFirst(";.*", "").trim(), 16);
                this.uploadPolicy.displayDebug("Chunk: " + this.line + " dec: " + len, 70);
                if (len == 0) break;
                while (len > 0) {
                    int ofs;
                    int res;
                    int rlen = len > 4096 ? 4096 : len;
                    if (rlen <= 0) continue;
                    for (ofs = 0; ofs < rlen; ofs += res) {
                        res = httpDataIn.read(this.chunkbuf, ofs, rlen - ofs);
                        if (res < 0) {
                            throw new JUploadException("unexpected EOF");
                        }
                        len -= res;
                    }
                    if (ofs < rlen) {
                        throw new JUploadException("short read");
                    }
                    if (rlen < 4096) {
                        this.body = HTTPInputStreamReader.byteAppend(this.body, this.chunkbuf, rlen);
                        continue;
                    }
                    this.body = HTTPInputStreamReader.byteAppend(this.body, this.chunkbuf);
                }
                HTTPInputStreamReader.readLine(httpDataIn, false);
                continue;
            }
            if (this.gotContentLength) {
                while (this.clen > 0) {
                    int ofs;
                    int res;
                    int rlen = this.clen > 4096 ? 4096 : this.clen;
                    if (rlen <= 0) continue;
                    for (ofs = 0; ofs < rlen; ofs += res) {
                        res = httpDataIn.read(this.chunkbuf, ofs, rlen - ofs);
                        if (res < 0) {
                            throw new JUploadException("unexpected EOF (in HTTP body, not chunked mode)");
                        }
                        this.clen -= res;
                    }
                    if (ofs < rlen) {
                        throw new JUploadException("short read");
                    }
                    if (rlen < 4096) {
                        this.body = HTTPInputStreamReader.byteAppend(this.body, this.chunkbuf, rlen);
                        continue;
                    }
                    this.body = HTTPInputStreamReader.byteAppend(this.body, this.chunkbuf);
                }
                continue;
            }
            while (null != (lbuf = HTTPInputStreamReader.readLine(httpDataIn, true))) {
                this.body = HTTPInputStreamReader.byteAppend(this.body, lbuf);
            }
            break;
        }
        this.responseBody = new String(this.body, this.charset);
        this.uploadPolicy.displayDebug("-------- Response Body Start --------", 100);
        this.uploadPolicy.displayDebug(this.responseBody, 100);
        this.uploadPolicy.displayDebug("-------- Response Body End --------", 100);
    }
}

