<?php
/*************************
  Coppermine Photo Gallery
  ************************
  Copyright (c) 2003-2006 Coppermine Dev Team
  v1.1 originally written by Gregory DEMAR

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  ********************************************
  Coppermine version: 1.4.x
  **********************************************
  Plugin "Who is online" aka "onlinestats"
  Plugin version: 1.7
  Correspoding thread: http://coppermine-gallery.net/forum/index.php?topic=26532.0
  **********************************************
  Modified by Frantz to add language files
  **********************************************/
if (!defined('IN_COPPERMINE')) die('Not in Coppermine...');
include ('./plugins/onlinestats/include/init.inc.php');
// Add plugin_install action
$thisplugin->add_action('plugin_install','online_install');

// Add page_start action
$thisplugin->add_action('page_start','online_page_start');

// Add plugin_uninstall action
$thisplugin->add_action('plugin_uninstall','online_uninstall');

// Add plugin_cleanup action
$thisplugin->add_action('plugin_cleanup','online_cleanup');

// Add search display action
$thisplugin->add_filter('plugin_block','online_mainpage');

// Add a configure action
$thisplugin->add_action('plugin_configure','online_configure');


function online_configure()
{

        global $lang_plugin_onlinestats_config,$lang_plugin_onlinestats,$CONFIG;
        require ('./plugins/onlinestats/include/init.inc.php');
?>
    <form action="<?php echo $_SERVER['REQUEST_URI'];?>" method="post">
        <p>
            <?php echo $lang_plugin_onlinestats_config['config_text'];?>
        </p>

        <table border="0" cellspacing="0" cellpadding="0">
            <tr>
                <td><input size="2" type="text" name="duration" value="10" class="textinput" /></td>
                <td><?php echo $lang_plugin_onlinestats_config['minute'];?></td>
            </tr>
        </table>

        <span>
           <input type="submit" name="submit" value="<?php echo $lang_plugin_onlinestats['submit_button'];?>" class="button" /> &nbsp;&nbsp;&nbsp;
            <input type="button" name="cancel" onClick="window.location='pluginmgr.php';" value="<?php echo $lang_plugin_onlinestats['cancel_button'];?>" class="button" />
        </span>
    </form>
<?php
}

function online_page_start()
{
        global $raw_ip, $CONFIG;

        $CONFIG['TABLE_ONLINE'] = $CONFIG['TABLE_PREFIX']."mod_online";

        $user_id = USER_ID;
        $user_name = USER_NAME;

        if (defined('LOGIN_PHP')){
                cpg_db_query("DELETE FROM {$CONFIG['TABLE_ONLINE']} WHERE user_id = 0 AND user_ip = '$raw_ip'");
                return;
        }

        if (defined('LOGOUT_PHP')){
                cpg_db_query("DELETE FROM {$CONFIG['TABLE_ONLINE']} WHERE user_id = $user_id");
                return;
        }

        cpg_db_query("DELETE FROM {$CONFIG['TABLE_ONLINE']} WHERE last_action < NOW() - INTERVAL {$CONFIG['mod_updates_duration']} MINUTE");



        if ($user_id) {
                cpg_db_query("REPLACE INTO {$CONFIG['TABLE_ONLINE']} (user_id, user_name, user_ip, last_action) VALUES ('$user_id', '$user_name', '$raw_ip', NOW())");

        } else{
                $testarray = explode('.',$raw_ip);
                $teststr = $testarray[0] . '.' . $testarray[1];
                $sel = cpg_db_query("SELECT user_ip FROM {$CONFIG['TABLE_ONLINE']} WHERE user_ip LIKE '$teststr%'");
                $res = mysql_fetch_row($sel);
                $result = $res[0];

                if (mysql_num_rows($sel)){
                        cpg_db_query("UPDATE {$CONFIG['TABLE_ONLINE']} SET last_action = NOW() WHERE user_ip = '$result' LIMIT 1");
                } else {
                        cpg_db_query("INSERT INTO {$CONFIG['TABLE_ONLINE']} (user_id, user_name, user_ip, last_action) VALUES ('$user_id', '$user_name', '$raw_ip', NOW())");
                }
        }
}

function online_mainpage()
{
        global $CONFIG, $cpg_udb, $matches, $lang_plugin_onlinestats, $lang_plugin_onlinestats_date_fmt;
	
        if($matches[1] != 'onlinestats') {
          return $matches;
        }
        
        require ('./plugins/onlinestats/include/init.inc.php');

        $num_users = $cpg_udb->get_user_count();

        $result = cpg_db_query("SELECT COUNT(*) FROM {$CONFIG['TABLE_ONLINE']}");
        list($num_online) = mysql_fetch_row($result);

        $result = cpg_db_query("SELECT COUNT(*) FROM {$CONFIG['TABLE_ONLINE']} WHERE user_id <> 0");
        list($num_reg_online) = mysql_fetch_row($result);
        
        $result = cpg_db_query("SELECT {$cpg_udb->field['user_id']} AS user_id, {$cpg_udb->field['username']} AS user_name FROM {$cpg_udb->usertable} ORDER BY user_id DESC LIMIT 1", $cpg_udb->link_id);
        $newest = mysql_fetch_assoc($result);

        $result = cpg_db_query("SELECT user_id, user_name FROM {$CONFIG['TABLE_ONLINE']} WHERE user_id <> 0");

        $logged_in_array = array();

        while ($row = mysql_fetch_row($result)) {
                $logged_in_array[] = vsprintf('<a href="profile.php?uid=%d">%s</a>', $row);
        }

        $logged_in_names = implode(', ', array_unique($logged_in_array));

        $num_guests = $num_online - $num_reg_online;

        // most users online - TND
        if ($num_online > $CONFIG['record_online_users'])
        {
                $CONFIG['record_online_date'] = localised_date(-1, $lang_plugin_onlinestats_date_fmt);
                $CONFIG['record_online_users'] = $num_online;

                $result = cpg_db_query("UPDATE {$CONFIG['TABLE_CONFIG']} SET value = '$num_online' WHERE name = 'record_online_users'");
                $result = cpg_db_query("UPDATE {$CONFIG['TABLE_CONFIG']} SET value = UNIX_TIMESTAMP() WHERE name = 'record_online_date'");
        }

       starttable("100%", $lang_plugin_onlinestats['name']);
        echo '<tr><td class="tableb">';
        echo ($num_users == 1) ? $lang_plugin_onlinestats['have']."<b>1</b>".$lang_plugin_onlinestats['reg_member']."<br />" : $lang_plugin_onlinestats['have']."<b>".$num_users."</b>".$lang_plugin_onlinestats['reg_members']."<br />";
        echo $lang_plugin_onlinestats['most_recent']."<a href=\"profile.php?uid={$newest['user_id']}\">{$newest['user_name']}</a><br />";
        echo ($num_online == 1) ? $lang_plugin_onlinestats['is']."<b>1</b>".$lang_plugin_onlinestats['user'] : $lang_plugin_onlinestats['are']."<b>".$num_online."</b>".$lang_plugin_onlinestats['users'];
        echo ($num_reg_online == 1) ? ": <b>1</b>".$lang_plugin_onlinestats['reg_member'].$lang_plugin_onlinestats['and'] : ": <b>".$num_reg_online."</b>".$lang_plugin_onlinestats['reg_members'].$lang_plugin_onlinestats['and'];
        echo ($num_guests == 1) ? "<b>1</b>".$lang_plugin_onlinestats['guest']."<br />" : "<b>".$num_guests."</b>".$lang_plugin_onlinestats['guests']."<br />";
        echo $lang_plugin_onlinestats['record']."<b>". $CONFIG['record_online_users']."</b>" .$lang_plugin_onlinestats['on']."<b>". localised_date($CONFIG['record_online_date'], $lang_plugin_onlinestats_date_fmt ) ."</b><br />";
        echo $lang_plugin_onlinestats['reg_members'].$lang_plugin_onlinestats['since'].$CONFIG['mod_updates_duration'].$lang_plugin_onlinestats_config['minute'].": ". $logged_in_names."</td></tr>";

        endtable();
}

// Install
function online_install()
{
        global $CONFIG, $thisplugin;

        if (isset($_POST['duration'])) {
                 require 'include/sql_parse.php';

                // create table
                $db_schema = $thisplugin->fullpath . '/schema.sql';
                $sql_query = fread(fopen($db_schema, 'r'), filesize($db_schema));
                $sql_query = preg_replace('/CPG_/', $CONFIG['TABLE_PREFIX'], $sql_query);

                $sql_query = remove_remarks($sql_query);
                $sql_query = split_sql_file($sql_query, ';');
                $sql_query[] = "INSERT IGNORE INTO {$CONFIG['TABLE_CONFIG']} (name, value) VALUES ('mod_updates_duration', '{$_POST['duration']}')";

                foreach($sql_query as $q) cpg_db_query($q);

           return true;
    } else {
        return 1;
    }
}

// Unnstall (drop?)
function online_uninstall()
{
        global $CONFIG;

        if (!isset($_POST['drop'])) return 1;

        if ($_POST['drop']) {

			cpg_db_query("DROP TABLE IF EXISTS {$CONFIG['TABLE_ONLINE']}");
			cpg_db_query("DELETE FROM {$CONFIG['TABLE_CONFIG']} WHERE name = 'mod_updates_duration'");
			cpg_db_query("DELETE FROM {$CONFIG['TABLE_CONFIG']} WHERE name = 'record_online_users'");
			cpg_db_query("DELETE FROM {$CONFIG['TABLE_CONFIG']} WHERE name = 'record_online_date'");
        
           }

        return true;
}

// Ask if we want to drop the table
function online_cleanup($action) {
global $lang_plugin_onlinestats_config,$lang_plugin_onlinestats,$CONFIG;
        require ('./plugins/onlinestats/include/init.inc.php');
    if ($action===1) {
        ?>
    <form action="<?php echo $_SERVER['REQUEST_URI'];?>" method="post">
        <p>
            <?php echo $lang_plugin_onlinestats_config['remove'];?>
        </p>
        <div style="margin:25;">
        <table border="0" cellspacing="0" cellpadding="0">
            <tr>
                <td><input type="radio" name="drop" id="drop_yes" value="1" /></td>
                <td><label for="drop_yes" class="clickable_option"><?php echo $lang_plugin_onlinestats_config['yes'];?></label></td>
            </tr>
            <tr>
                <td><input type="radio" name="drop" id="drop_no" checked="checked" value="0" /></td>
                <td><label for="drop_no" class="clickable_option"><?php echo $lang_plugin_onlinestats_config['no'];?></label></td>
            </tr>
        </table>
        </div>
        <span>
           <input type="submit" name="submit" value="<?php echo $lang_plugin_onlinestats['submit_button'];?>" class="button" /> &nbsp;&nbsp;&nbsp;
            <input type="button" name="cancel" onClick="window.location='pluginmgr.php';" value="<?php echo $lang_plugin_onlinestats['cancel_button'];?>" class="button" />
        </span>
    </form>
<?php
    }
}
?>