<?php
/**************************************************
  Coppermine Plugin - Full-Size Photos Access
  *************************************************
  Copyright (c) 2006 Paul Van Rompay
  *************************************************
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  *************************************************/

if (!defined('IN_COPPERMINE')) die('Not in Coppermine...');

// ------------------------------------------------------------------------------------------------
// Add an install & configure & uninstall actions
// ------------------------------------------------------------------------------------------------
$thisplugin->add_action('plugin_install','controlfullsize_install');
$thisplugin->add_action('plugin_configure','controlfullsize_configure');
$thisplugin->add_action('plugin_uninstall','controlfullsize_uninstall');

// ------------------------------------------------------------------------------------------------
// Add filters
// ------------------------------------------------------------------------------------------------
$thisplugin->add_filter('file_data','controlfullsize_filterfullsize');
$thisplugin->add_filter('page_html','controlfullsize_filterpage');
$thisplugin->add_filter('thumb_data','controlfullsize_getcontent');

// ------------------------------------------------------------------------------------------------
// Add actions
// ------------------------------------------------------------------------------------------------
$thisplugin->add_action('page_start','controlfullsize_page_start');

// ------------------------------------------------------------------------------------------------
// Initialize plugin variable(s)
// ------------------------------------------------------------------------------------------------
$thisplugin->thumbs_ignore = array();
$thisplugin->thumbs = array();

// ------------------------------------------------------------------------------------------------
// Install Plugin
// ------------------------------------------------------------------------------------------------
function controlfullsize_install() {
  global $CONFIG, $lang_plugin_controlfullsize, $lang_plugin_controlfullsize_config;
  require ('plugins/control_fullsize/include/init.inc.php');
  
  if ($_POST['submit']==$lang_plugin_controlfullsize_config['button_done']) {
    return true;
  } else {
    return 1;
  }
}

// ------------------------------------------------------------------------------------------------
// Configure Plugin
// ------------------------------------------------------------------------------------------------
function controlfullsize_configure() {
  global $CONFIG, $lang_plugin_controlfullsize, $lang_plugin_controlfullsize_config;
  require ('plugins/control_fullsize/include/init.inc.php');

  // define('PLUGIN_CONTROLFULLSIZE_CONFIGURE','1');  // not used yet

  // delete previous plugin config options if necessary (just in case)
  cpg_db_query("DELETE FROM {$CONFIG['TABLE_CONFIG']} WHERE name REGEXP '^plugin_controlfullsize_'");

  // insert default parameters into configuration table
  $sql = "INSERT INTO {$CONFIG['TABLE_CONFIG']} (name, value)"
    ." VALUES"
    ." ('plugin_controlfullsize_groups_thumb','')"
    .",('plugin_controlfullsize_groups_inter','')"
    .",('plugin_controlfullsize_groups_full','')"
    .",('plugin_controlfullsize_requsercomment','0')"
    .",('plugin_controlfullsize_conditionoperator','AND')"
    .",('plugin_controlfullsize_displaynotice','0')"
    .",('plugin_controlfullsize_noticemessage','{$lang_plugin_controlfullsize_config['noticemessage_default']}')"
    .",('plugin_controlfullsize_noticemessanon','{$lang_plugin_controlfullsize_config['noticemessage_default_anon']}')"
    .",('plugin_controlfullsize_noticetooltip','1')"
    .",('plugin_controlfullsize_noticepopup','0')"
    .",('plugin_controlfullsize_displaynotice_th','0')"
    .",('plugin_controlfullsize_noticemessage_th','{$lang_plugin_controlfullsize_config['noticemessage_default_th']}')"
    .",('plugin_controlfullsize_noticemessanon_th','{$lang_plugin_controlfullsize_config['noticemessage_default_anon_th']}')"
    .",('plugin_controlfullsize_noticetooltip_th','1')"
    .",('plugin_controlfullsize_noticepopup_th','0')"
    .",('plugin_controlfullsize_controleverything','1')";
  cpg_db_query($sql);

  echo <<< EOT
    <h2>{$lang_plugin_controlfullsize['install_done']}</h2>
    {$lang_plugin_controlfullsize['install_note']}<br />
    <br />
    <form action="{$_SERVER['REQUEST_URI']}" method="post">
    <input type="submit" value="{$lang_plugin_controlfullsize_config['button_done']}" name="submit"/>
    </form>
EOT;
}

// ------------------------------------------------------------------------------------------------
// Uninstall plugin
// ------------------------------------------------------------------------------------------------
function controlfullsize_uninstall() {
  global $CONFIG;
  cpg_db_query("DELETE FROM {$CONFIG['TABLE_CONFIG']} WHERE name REGEXP '^plugin_controlfullsize_'");
  return true;
}

// ------------------------------------------------------------------------------------------------
// Add config button
// ------------------------------------------------------------------------------------------------
function controlfullsize_add_config_button($href,$title,$target,$link)
{
  global $template_gallery_admin_menu;

  $new_template = $template_gallery_admin_menu;
  $button = template_extract_block($new_template,'documentation');
  $params = array(
      '{DOCUMENTATION_HREF}' => $href,
      '{DOCUMENTATION_TITLE}' => $title,
      'target="cpg_documentation"' => $target,
      '{DOCUMENTATION_LNK}' => $link,
   );
   $new_button="<!-- BEGIN $link -->".template_eval($button,$params)."<!-- END $link -->\n";
   template_extract_block($template_gallery_admin_menu,'documentation',"<!-- BEGIN documentation -->" . $button . "<!-- END documentation -->\n" . $new_button);
}

// ------------------------------------------------------------------------------------------------
// Add admin button to start of each page & restrict access if displayimage.php
// ------------------------------------------------------------------------------------------------
function controlfullsize_page_start()
{
  global $CONFIG, $lang_plugin_controlfullsize, $lang_plugin_controlfullsize_config;
  global $lang_errors, $lang_error;
  require ('plugins/control_fullsize/include/init.inc.php');

  if (GALLERY_ADMIN_MODE) {
    controlfullsize_add_config_button('index.php?file=control_fullsize/plugin_config',$lang_plugin_controlfullsize['config_title'],'',$lang_plugin_controlfullsize['config_button']);
  }

  // Restrict access to DisplayImage.php if not allowed to view intermediate images
  if ($CONFIG['plugin_controlfullsize_controleverything'] && defined('DISPLAYIMAGE_PHP') && !GALLERY_ADMIN_MODE) {
    $validuser = controlfullsize_validate('intermediate');
    if (!$validuser) {
      load_template();
      pageheader($lang_error);
      cpg_die(ERROR, $lang_errors['access_denied'], __FILE__, __LINE__);
    }
  }
}

// ------------------------------------------------------------------------------------------------
// Validate access to full-size & intermediate photos
// ------------------------------------------------------------------------------------------------
function controlfullsize_validate($which = 'fullsize') {
  global $CONFIG;
  $usergroups = explode(',',substr(USER_GROUP_SET,1,-1));
  $groups_thumbnail = explode(',',$CONFIG['plugin_controlfullsize_groups_thumb']);
  $groups_intermediate = explode(',',$CONFIG['plugin_controlfullsize_groups_inter']);
  $groups_fullsize = explode(',',$CONFIG['plugin_controlfullsize_groups_full']);

  $validuser = false;
  $validuser_thumbnail = array_intersect($groups_thumbnail,$usergroups);
  $validuser_intermediate = array_intersect($groups_intermediate,$usergroups);
  $validuser_fullsize = array_intersect($groups_fullsize,$usergroups);
  switch ($which) {
    case 'thumbnail' :
      $validuser = $validuser_thumbnail || $validuser_intermediate || $validuser_fullsize;
      break;
    case 'intermediate' :
      $validuser = $validuser_intermediate || $validuser_fullsize;
      break;
    case 'fullsize' :
      $validuser = $validuser_fullsize;
      break;
  }
  $usercomment = false;
  if ($CONFIG['plugin_controlfullsize_requsercomment']) {
    $result = cpg_db_query("SELECT msg_id FROM {$CONFIG['TABLE_COMMENTS']} where (pid='{$cpicdata['pid']}' && author_id='".USER_ID."')");
    if (mysql_num_rows($result) > 0) { 
      $usercomment = true;
    }
    if ($CONFIG['plugin_controlfullsize_conditionoperator'] == 'OR') {
      $validuser = $validuser || $usercomment;
    } else {
      $validuser = $validuser && $usercomment;
    }
  }
  return $validuser;
}

// ------------------------------------------------------------------------------------------------
// Remove link to full-size photo if not permitted
// ------------------------------------------------------------------------------------------------
function controlfullsize_filterfullsize($cpicdata) 
{
  global $CONFIG, $lang_errors, $lang_error;

  $validuser = controlfullsize_validate('fullsize'); 
  $validuser_intermediate = controlfullsize_validate('intermediate'); 
  if (!$validuser && !GALLERY_ADMIN_MODE) {

    // Restrict access to DisplayImage.php if not allowed to view intermediate images
    if (defined('DISPLAYIMAGE_PHP') && !$validuser_intermediate 
        && ($cpicdata['content'] == 'image') && ($cpicdata['mode'] != 'thumb')) {
      load_template();
      pageheader($lang_error);
      cpg_die(ERROR, $lang_errors['access_denied'], __FILE__, __LINE__);
    }

    // Restrict access to full-size image if not allowed to view full-size images
    if(strpos($cpicdata['html'],'fullsize=1') !== false) {
      $cpicdata['html'] = strip_tags($cpicdata['html'],'<img>');
      if ($CONFIG['plugin_controlfullsize_displaynotice']) { 
        if (USER_ID) {
          $alt_text = $CONFIG['plugin_controlfullsize_noticemessage']; 
        } else {
          $alt_text = $CONFIG['plugin_controlfullsize_noticemessanon'];
        }
      } else { 
        $alt_text = ''; 
      }

      $alt_replace = ($CONFIG['plugin_controlfullsize_noticetooltip'] ? 'alt="'.$alt_text.'" title="'.$alt_text.'"' : '')
                    .(($CONFIG['plugin_controlfullsize_noticepopup'] && $alt_text) ? 'onClick="alert(\''.$alt_text.'\')"' : '');
      $cpicdata['html'] = preg_replace('/alt=\"(.*?)\"/si', $alt_replace, $cpicdata['html']);
    }
  }
  return $cpicdata;
}

// ------------------------------------------------------------------------------------------------
// Remove links to displayimage.php on every page (if not allowed to view intermediate image)
// ------------------------------------------------------------------------------------------------
function controlfullsize_filterpage($html) 
{
  global $CONFIG, $thisplugin;

  $validuser = controlfullsize_validate('intermediate');
  if (!GALLERY_ADMIN_MODE && !$validuser) {
    $pattern = "/<a href=\"displayimage\.php.*?>(<img src=\")(.*?)(\".*?)<\/a>/si";
    if (preg_match_all($pattern, $html, $matches, PREG_SET_ORDER)) {
      foreach ($matches as $match) {
        $pic_url = $match[2];
        if ($CONFIG['plugin_controlfullsize_controleverything'] || !in_array($pic_url,$thisplugin->thumbs_ignore)) {
          if ($CONFIG['plugin_controlfullsize_displaynotice_th']) { 
            if (USER_ID) {
              $alt_text = $CONFIG['plugin_controlfullsize_noticemessage_th']; 
            } else {
              $alt_text = $CONFIG['plugin_controlfullsize_noticemessanon_th'];
            }
          } else { 
            $alt_text = ''; 
          }
          $alt_text = str_replace('{TYPE}', $thisplugin->thumbs[$pic_url], $alt_text); 
          $alt_replace = ($CONFIG['plugin_controlfullsize_noticetooltip_th'] ? 'alt="'.$alt_text.'" title="'.$alt_text.'"' : '')
                        .(($CONFIG['plugin_controlfullsize_noticepopup_th'] && $alt_text) ? 'onClick="alert(\''.$alt_text.'\')"' : '');
          $match[3] = preg_replace('/alt=\"(.*?)\"/si', $alt_replace, $match[3]);
          $subst = $match[1].$match[2].$match[3];
          $to_replace = $match[0];
          $html = str_replace($to_replace, $subst, $html);
        }
      } 
    }
  }
  return $html;
}

function controlfullsize_getcontent($pic_row) 
{
  global $CONFIG, $thisplugin;

  if ($CONFIG['plugin_controlfullsize_groups_thumb']) {
    if (!$CONFIG['plugin_controlfullsize_controleverything']) {
      if (($pic_row['content'] != 'image') && ($pic_row['mode'] == 'thumb')) {
        $thisplugin->thumbs_ignore[] = $pic_row['url'];
      }
    }
    $thisplugin->thumbs[$pic_row['url']] = $pic_row['content'];
  }
  return $pic_row;
}

// ------------------------------------------------------------------------------------------------
// End of plugin code
// ------------------------------------------------------------------------------------------------

?>
