<?php

// all page come from here

class cpgHTML {
// -----------------------------------------------------------------------------------------
// VIEW CART
// ----------------------------------------------------------------------------------------- 
	function view_cart() {
		global $CONFIG;
		global $currency_symbol;		
		global $lang_cm_cart, $lang_cm_error;
		global $cpgmart;        
		if (!is_object($cpgmart)) $cpgmart = new cpgMart();			
		if (count($cpgmart->cart == 0)) {
			cpg_die(ERROR, $lang_cm_error['no_item'], __FILE__, __LINE__);
		}				
	    $task = cpgTool::request_var('task');
	    $tpl_view_cart 	= cpgTemplate::get('blog_view_cart');
	    $cart_header  	= cpgTemplate::extract($tpl_view_cart, 'cart_header');
	    $cart_element  	= cpgTemplate::extract($tpl_view_cart, 'cart_element');
	    $cart_footer   	= cpgTemplate::extract($tpl_view_cart, 'cart_footer');	    
	    $no_item   		= cpgTemplate::extract($tpl_view_cart, 'no_item');	    
	    switch ($task) { 
	    	// update cart
	    	case "add_item":
	    		// pid
	    		$pid = (int)cpgTool::post_var("id");    		
	    		// get cart option == little tricky	    		
	    	    $option_array = cpgTool::get_option_array_from_pid($pid);
	    	    $option = array();
	    	    foreach ($option_array as $option_id) {
	    	    	$option[$option_id] = cpgTool::post_var("option_".$option_id);	
				}                                                   				
	    		// vars    	    	
	    		$cpgmart->add_item(array(
	    			'pid'	 =>	$pid,	
	    		    'price'	 =>	cpgTool::post_var("price"),
	    		    'option' =>	$option,
	    		    'qty' 	 =>	1,
	    		));
	    		$cpgmart->save();	    		
	    		break;
			case "edit":										
			    // update cart 			    
			    foreach ($_POST as $name => $value) {
					if (cpgTool::in_string($name, "price_")) {							
						$item_pos = (int)str_replace("price_", "", $name);
						if (cpgTool::post_var("item_".$item_pos) == 'on') {
							// remove	
							$cpgmart->remove_item($item_pos);							
						} else {
							// update
							$current_item_data['pid'] = (int)cpgTool::post_var("pid_".$item_pos);
							$current_item_data['price'] = cpgTool::post_var("price_".$item_pos);
							$current_item_data['qty'] = cpgTool::post_var("qty_".$item_pos);
							$option_array = cpgTool::get_option_array_from_pid((int)cpgTool::post_var("pid_".$item_pos));
	    	    			$current_item_data['option'] = array();
	    	    			foreach ($option_array as $option_id) {
	    	    				$current_item_data['option'][$option_id] = cpgTool::post_var("option_".$option_id."_".$item_pos);	
							}       
							$cpgmart->edit_item($item_pos, $current_item_data);							
						}
					} 
				}				
				// save ^^ 				
			    $cpgmart->save();
				break;			
		}
		// view cart
		starttable($CONFIG['picture_table_width'], $lang_cm_cart['view_cart_title'], 7);
		// cart header
		echo cpgTemplate::set($cart_header, array( 			
			'{LANG_DEL}'          => $lang_cm_cart['delete'],	
			'{LANG_THUMB}'        => $lang_cm_cart['thumb'],	
			'{LANG_NAME}'         => $lang_cm_cart['item_name'],
			'{LANG_PRICE_OPTION}' => $lang_cm_cart['price_n_option'],  
			'{LANG_PRICE_EACH}'   => $lang_cm_cart['price_each'], 
			'{LANG_QTY}'          => $lang_cm_cart['qty'],
			'{LANG_PRICE_ALL}'    => $lang_cm_cart['price_all'],
		));     		
		// cart body
		$total = 0;				
		foreach ($cpgmart->cart as $item_pos => $item_data) {
			$CURRENT_PIC_DATA = cpgTool::get_pic_data($item_data['pid']);			
			$price_each = cpgTool::price_each($item_data);  			
			$total += $price_each * $item_data['qty'];
			$vars = array(
				'{PID}'			=> HTMLelement::hidden("pid_".$item_pos, $item_data['pid']),
				'{CHECK_BOX}'	=> HTMLelement::check_box("item_".$item_pos),
				'{THUMB}'		=> HTMLelement::image(get_pic_url($CURRENT_PIC_DATA, "thumb")),
				'{NAME}'		=> HTMLelement::item_name($CURRENT_PIC_DATA),
				'{PRICE}'		=> HTMLelement::price_list($CURRENT_PIC_DATA['price'], $item_data['price'], "_".$item_pos),
				'{OPTION}'		=> HTMLelement::option_list($CURRENT_PIC_DATA['option'], $item_data['option'], "_".$item_pos),
				'{PRICE_EACH}'	=> $currency_symbol[$CONFIG['cpgmart_currency']] ." ".cpgTool::price_format($price_each),
				'{QTY}'			=> HTMLelement::qty_input("qty_".$item_pos, $item_data['qty']),
				'{PRICE_ALL}'	=> $currency_symbol[$CONFIG['cpgmart_currency']] ." ".cpgTool::price_format($item_data['qty'] * $price_each),
			);
		    echo cpgTemplate::set($cart_element, $vars);		
		}
		// shipping fee + tax fee + ..		
		// cart_footer
		if (count($cpgmart->cart) != 0)
		echo cpgTemplate::set($cart_footer, array(
			'{LANG_PRICE_TOTAL}'	=>	$lang_cm_cart['price_total'],
			'{PRICE_TOTAL}'         =>	$currency_symbol[$CONFIG['cpgmart_currency']] ." ". cpgTool::price_format($total),
			'{LANG_SUBMIT}'         =>	$lang_cm_cart['edit_cart'],
			'{LANG_CHECK_OUT}'		=>	$lang_cm_cart['check_out'],
			'{LANG_HOME_PAGE}'	    =>  $lang_cm_cart['home_page'],   
		));		
		endtable();		
	}
// -----------------------------------------------------------------------------------------
// PREVIEW CART + PAYMENT CHOOSE
// ----------------------------------------------------------------------------------------- 
	function preview_cart() {
		global $CONFIG;
		global $currency_symbol;		
		global $lang_cm_cart, $lang_cm_error;
		global $cpgmart;
		if (!is_object($cpgmart)) $cpgmart = new cpgMart();	
		// no item ???
		if (count($cpgmart->cart == 0)) {
			cpg_die(ERROR, $lang_cm_error['no_item'], __FILE__, __LINE__);
		}						
		$tpl_preview_cart = cpgTemplate::get('blog_preview_cart');	   
	    $payment_gateway  = cpgTemplate::extract($tpl_preview_cart, 'payment_gateway');
		// view cart in plain format
		starttable($CONFIG['picture_table_width'], $lang_cm_cart['preview_cart_title'], 6);		
		HTMLelement::preview_cart($cpgmart->cart);		
		endtable();
		HTMLelement::spacer();
		starttable($CONFIG['picture_table_width'], $lang_cm_cart['payment_title'], 2);
		echo cpgTemplate::set($payment_gateway, array(
			'{LANG_PAYMENT_GATEWAY}' => $lang_cm_cart['type_of_payment'],	
			'{PAYMENT_GATEWAY}'		 =>	HTMLelement::simple_select('payment_gateway', array('paypal'=>'PayPal'),'paypal'),
			'{LANG_SUBMIT}'          =>	$lang_cm_cart['check_out'],  
			'{LANG_GO_BACK}'         =>	$lang_cm_cart['go_back'],  
		));
		endtable();		
	}
// -----------------------------------------------------------------------------------------
// CHECK OUT
// ----------------------------------------------------------------------------------------- 
	function check_out() {
		global $CONFIG;
		global $currency_symbol;
		global $lang_cm_cart, $lang_cm_error;		
		global $cpgmart;		
		if (!is_object($cpgmart)) $cpgmart = new cpgMart();
		if (count($cpgmart->cart == 0)) {
			cpg_die(ERROR, $lang_cm_error['no_item'], __FILE__, __LINE__);
		}						
	    $tpl_check_out = cpgTemplate::get('blog_check_out');
	    $form_header   = cpgTemplate::extract($tpl_check_out, 'form_header'); 	    
	    $form_footer   = cpgTemplate::extract($tpl_check_out, 'form_footer'); 
		// view cart in plain format 
		starttable($CONFIG['picture_table_width'], $lang_cm_cart['check_out_title'], 6);		
		HTMLelement::preview_cart($cpgmart->cart);
		endtable();
		HTMLelement::spacer();		
		// real || sand box
		if ($CONFIG['cpgmart_test_mode'])
			$paypal_address = "https://www.sandbox.paypal.com/cgi-bin/webscr";
		else
			$paypal_address = "https://www.paypal.com/cgi-bin/webscr";
		// checkout button or smt
		starttable($CONFIG['picture_table_width']);
		echo cpgTemplate::set($form_header, array(
			'{SITE_URL}'		=>	$CONFIG['ecards_more_pic_target'],
			'{PAYPAL_ADDRESS}'	=>	$paypal_address,
			'{ACCOUNT}'			=>	$CONFIG['cpgmart_pp_account'],
		    '{CURRENCY}'    	=>  $CONFIG['cpgmart_currency'],
		));		
		$item_pos = 0;
		foreach ($cpgmart->cart as $item_data) {				
			$CURRENT_PIC_DATA = cpgTool::get_pic_data($item_data['pid']);
			$item_pos++;
			// main
			echo HTMLelement::hidden("item_name_".$item_pos, HTMLelement::item_name($CURRENT_PIC_DATA));
			echo HTMLelement::hidden("amount_".$item_pos, cpgTool::price_format(cpgTool::price_each($item_data)));
			echo HTMLelement::hidden("quantity_".$item_pos, $item_data['qty']);
			echo HTMLelement::hidden("item_number_".$item_pos, $item_pos);
			// show option			
			$option_pos = 0;
			foreach ($item_data['option'] as $option_id => $option_value) {				
				$option_data = cpgDB::fetchRow("SELECT title, title_array, value_array, currency FROM `{$CONFIG['TABLE_CM_OPTION']}` WHERE oid = '$option_id' LIMIT 1;");
				$option_data['title_array'] = cpgTool::decode_data($option_data['title_array']);
				$option_data['value_array'] = cpgTool::decode_data($option_data['value_array']);
				foreach ($option_data['title_array'] as $title_key => $title_value) {
					$option_combine[] = array($option_data['value_array'][$title_key], $option_data['title_array'][$title_key]);
					$option_combine[$option_value][0] = cpgTool::price_format(cpgTool::to_config_currency($option_combine[$option_value][0], $option_data['currency']));
				}			
				//$html .= "<tr>\n<td class=\"tableh1\" width=\"30%\">{$option_data['title']}</td>\n<td class=\"tableb\" width=\"40%\">{$option_combine[$option_value][1]}</td>\n<td class=\"tableb\" width=\"30%\">{$currency_symbol[$CONFIG['cpgmart_currency']]} {$option_combine[$option_value][0]}</td>\n</tr>\n";						
				echo HTMLelement::hidden("on".$option_pos."_".$item_pos, $option_data['title']); 	
				echo HTMLelement::hidden("os".$option_pos."_".$item_pos, $option_combine[$option_value][1]);
				$option_pos++;
			}			
		}
		echo cpgTemplate::set($form_footer, array(
			'{SITE_URL}'		=>	$CONFIG['ecards_more_pic_target'],						
		    '{LANG_SUBMIT}' 	=>	$lang_cm_cart['click_to_pay'],
		    '{LANG_GO_BACK}'	=>	$lang_cm_cart['go_back'],
		));
		endtable();		
	}
// -----------------------------------------------------------------------------------------
// PROCESS
// -----------------------------------------------------------------------------------------		
	function proccess() {
		global $CONFIG;		 
		global $cpgmart;
		if (!is_object($cpgmart)) $cpgmart = new cpgMart();
		// read the post from PayPal system and add 'cmd'
		$req = 'cmd=_notify-validate';
		foreach ($_POST as $key => $value) {
			$value = urlencode(stripslashes($value));
			$req .= "&$key=$value";			
		}
		// post back to PayPal system to validate
		$header = "POST /cgi-bin/webscr HTTP/1.0\r\n";
		$header .= "Content-Type: application/x-www-form-urlencoded\r\n";
		$header .= "Content-Length: " . strlen($req) . "\r\n\r\n";
		
		if ($CONFIG['cpgmart_test_mode'])
			$paypal_address = "www.sandbox.paypal.com";
		else
			$paypal_address = "www.paypal.com";
					
		$fp = fsockopen ($paypal_address, 80, $errno, $errstr, 30);
		if (!$fp) {
			self::process_html_error();
			// HTTP ERROR
		} else {
			fputs($fp, $header . $req);
			$content = "";
		    while (!feof($fp)) $content .= fgets ($fp, 1024);
		    // CART STATUS
			if     (strpos($content, "VERIFIED") !== false) $status = "VERIFIED";
			elseif (strpos($content, "INVALID")  !== false) $status = "INVALID";
			else   $status = "UNKNOW";		
			if ($status != "UNKNOW") {
				// txn ID
				$txn_id = $_POST['txn_id'];
				if ($txn_id != "") {
					// check if already exists
					$exists = cpgDB::fetchVar("SELECT count(oid) FROM `{$CONFIG['TABLE_CM_ORDER']}` WHERE txnid='$txn_id';");
					if ($exists == 0) {
						// add to DB	    	
		    			cpgDB::runQuery("INSERT INTO `{$CONFIG['TABLE_CM_ORDER']}` 
		    			(oid, txnid, user_id, user_name, cart, profile, time, status, method, log, note)
		    			VALUES
		    			('','$txn_id','".USER_ID."', '".USER_NAME."', '".cpgTool::encode_data($cpgmart->cart)."','','".time()."', '$status', 'PAYPAL', '".cpgTool::encode_data($_POST)."', '');");    			    		
		    			// flush cart
		    			$cpgmart->flush();		    		
		    		}
				}                                       
			}
		}
	}

	function process_html_error() {
		global $CONFIG;
		// do smt ???		
	}	
// -----------------------------------------------------------------------------------------
// THANK YOU
// -----------------------------------------------------------------------------------------		
	function thank_you() {
		global $CONFIG;
		global $lang_cm_cart; 		
		HTMLelement::message($lang_cm_cart['thank_you_title'], $lang_cm_cart['thank_you']);
	}	
// -----------------------------------------------------------------------------------------
// CONFIG
// ----------------------------------------------------------------------------------------- 
	function config() {
		global $CONFIG;
		global $currency_symbol;
		global $lang_cm_common, $lang_cm_config;
		$task = cpgTool::request_var('task');
		$tpl_config = cpgTemplate::get('blog_config');
		$config_header  = cpgTemplate::extract($tpl_config, "config_header");
		$config_footer  = cpgTemplate::extract($tpl_config, "config_footer");
		$config_element = cpgTemplate::extract($tpl_config, "config_element");		
		if ($task == 'edit') {			
			$cpgmart_enable = (int)cpgTool::post_var('cpgmart_enable');
			cpgDB::runQuery("UPDATE `{$CONFIG['TABLE_CONFIG']}` SET value='$cpgmart_enable' WHERE name='cpgmart_enable' LIMIT 1;");
			$cpgmart_currency = cpgTool::post_var('cpgmart_currency');
			cpgDB::runQuery("UPDATE `{$CONFIG['TABLE_CONFIG']}` SET value='$cpgmart_currency' WHERE name='cpgmart_currency' LIMIT 1;");
			$cpgmart_pp_account = cpgTool::post_var('cpgmart_pp_account');
			cpgDB::runQuery("UPDATE `{$CONFIG['TABLE_CONFIG']}` SET value='$cpgmart_pp_account' WHERE name='cpgmart_pp_account' LIMIT 1;");
			$cpgmart_test_mode = (int)cpgTool::post_var('cpgmart_test_mode');
			cpgDB::runQuery("UPDATE `{$CONFIG['TABLE_CONFIG']}` SET value='$cpgmart_test_mode' WHERE name='cpgmart_test_mode' LIMIT 1;");
			HTMLelement::message($lang_cm_common['message'], $lang_cm_config['edit_config_success']);
			HTMLelement::spacer();
			// update for display
			$CONFIG['cpgmart_enable']	  = $cpgmart_enable;
			$CONFIG['cpgmart_currency']   = $cpgmart_currency;
			$CONFIG['cpgmart_pp_account'] = $cpgmart_pp_account;
			$CONFIG['cpgmart_test_mode']  = $cpgmart_test_mode;
		}                         		
		starttable($CONFIG['picture_table_width'], $lang_cm_config['config_title'], 2);
		echo $config_header;
		echo cpgTemplate::set($config_element, array('{TITLE}'=>$lang_cm_config['enable_plugin'],'{VALUE}'=>HTMLelement::radio('cpgmart_enable', $CONFIG['cpgmart_enable'])));
		echo cpgTemplate::set($config_element, array('{TITLE}'=>$lang_cm_config['plugin_currency'],'{VALUE}'=>HTMLelement::simple_select("cpgmart_currency", $currency_symbol, $CONFIG['cpgmart_currency'])));		
		echo cpgTemplate::set($config_element, array('{TITLE}'=>$lang_cm_config['pp_acount'],'{VALUE}'=>HTMLelement::text_input('cpgmart_pp_account', $CONFIG['cpgmart_pp_account'])));		
		echo cpgTemplate::set($config_element, array('{TITLE}'=>$lang_cm_config['test_mode'],'{VALUE}'=>HTMLelement::radio('cpgmart_test_mode', $CONFIG['cpgmart_test_mode'])));
		echo cpgTemplate::set($tpl_config, $vars);
		echo cpgTemplate::set($config_footer, array(
			'{LANG_SUMBIT}'		=>	$lang_cm_common['edit'],
		    '{LANG_RESET}'		=>	$lang_cm_common['reset'],				
		));	
		endtable();
	}
// -----------------------------------------------------------------------------------------
// MAIN PAGE
// -----------------------------------------------------------------------------------------		
	function mainpage() {
		global $CONFIG;
		global $lang_cm_mainpage;
		$tpl_mainpage = cpgTemplate::get('blog_mainpage');				
		$title 	 = cpgTemplate::extract($tpl_mainpage, "title");
		$element = cpgTemplate::extract($tpl_mainpage, "element");
		$number_of_price     = cpgDB::fetchVar("SELECT count(*) FROM `{$CONFIG['TABLE_CM_PRICE']}`;");
		$number_of_priceset  = cpgDB::fetchVar("SELECT count(*) FROM `{$CONFIG['TABLE_CM_PRICESET']}`;");
		$number_of_option    = cpgDB::fetchVar("SELECT count(*) FROM `{$CONFIG['TABLE_CM_OPTION']}`;");
		$number_of_optionset = cpgDB::fetchVar("SELECT count(*) FROM `{$CONFIG['TABLE_CM_OPTIONSET']}`;");
		$number_of_order     = cpgDB::fetchVar("SELECT count(*) FROM `{$CONFIG['TABLE_CM_ORDER']}`;");
		starttable($CONFIG['picture_table_width'], $lang_cm_mainpage['main_page_title'], 2);
		echo cpgTemplate::set($title, array('{TITLE}' => $lang_cm_mainpage['stastics']));
		echo cpgTemplate::set($element, array('{TITLE}' =>$lang_cm_mainpage['num_of_price'],'{VALUE}' =>$number_of_price));
		echo cpgTemplate::set($element, array('{TITLE}' =>$lang_cm_mainpage['num_of_priceset'],'{VALUE}' =>$number_of_priceset));
		echo cpgTemplate::set($element, array('{TITLE}' =>$lang_cm_mainpage['num_of_option'],'{VALUE}' =>$number_of_option));
		echo cpgTemplate::set($element, array('{TITLE}' =>$lang_cm_mainpage['num_of_optionset'],'{VALUE}' =>$number_of_optionset));
		echo cpgTemplate::set($element, array('{TITLE}' =>$lang_cm_mainpage['num_of_order'],'{VALUE}' =>$number_of_order));
		endtable();
	}
// -----------------------------------------------------------------------------------------
// DOCUMENTS
// -----------------------------------------------------------------------------------------	
	function documents() {
		global $CONFIG;
		global $lang_cm_documents;
		starttable($CONFIG['picture_table_width'],'Documments');
		$tpl_documents = cpgTemplate::get('blog_simple_data');
		$vars = array(
			'{TEXT}'=>'Hello World - Documments ^^ !',
		);		
		echo cpgTemplate::set($tpl_documents, $vars);
		endtable();	
	}
// -----------------------------------------------------------------------------------------
// ABOUTS
// -----------------------------------------------------------------------------------------	
	function abouts() {
		global $CONFIG;
		global $lang_cm_abouts;	
		starttable($CONFIG['picture_table_width'],'Abouts');
		$tpl_about = cpgTemplate::get('blog_simple_data');
		$vars = array(
			'{TEXT}'=>'Hello World - Abouts ^^ !',
		);		
		echo cpgTemplate::set($tpl_about, $vars);
		endtable();
	}
// -----------------------------------------------------------------------------------------
// ADD TO CART BUTTON
// -----------------------------------------------------------------------------------------	
	function add_to_cart($CURRENT_PIC_DATA) {
		global $currency_symbol;
		global $lang_cm_codebase;
		if ((int)$CURRENT_PIC_DATA['price'] == 0) return "";
		$tpl_atc = cpgTemplate::get('blog_add_to_cart');
		if ((int)$CURRENT_PIC_DATA['option'] == 0) 
			cpgTemplate::extract($tpl_atc, 'option');		
		$vars = array(
			'{ID}'			 =>	$CURRENT_PIC_DATA['pid'],
			'{PRICE_TITLE}'	 =>	HTMLelement::price_list_title($CURRENT_PIC_DATA['price']),
			'{PRICE}'		 =>	HTMLelement::price_list($CURRENT_PIC_DATA['price']),
			'{OPTION_TITLE}' =>	HTMLelement::option_list_title($CURRENT_PIC_DATA['option']),
		    '{OPTION}'		 =>	HTMLelement::option_list($CURRENT_PIC_DATA['option']),  
		    '{LANG_TITLE}'	 =>	$lang_cm_codebase['cpgmart_title'],
		    '{LANG_SUBMIT}'	 =>	$lang_cm_codebase['add_to_cart'],
		);
		return cpgTemplate::set($tpl_atc, $vars);
	}

// -----------------------------------------------------------------------------------------
// ORDER MANAGER
// ----------------------------------------------------------------------------------------- 
	function order() {
		global $CONFIG;
		global $currency_symbol;
		global $lang_cm_order;
		global $log_date_fmt;	
		// get ACTION		
		$task = cpgTool::request_var('task');		
		// TEMPLATE  
		$tpl_order      = cpgTemplate::get('blog_order');		
		$order_title    = cpgTemplate::extract($tpl_order, 'order_title');
		$order_element  = cpgTemplate::extract($tpl_order, 'order_element');
	    // task -> action
		switch ($task) {
			case 'view_act':				
				$oid = (int)cpgTool::get_var('oid');				
				$cart_data = cpgDB::fetchVar("SELECT cart FROM `{$CONFIG['TABLE_CM_ORDER']}` WHERE oid = '$oid';"); 
				if ($cart_data) {
					$cart_data = cpgTool::decode_data($cart_data);					
					starttable($CONFIG['picture_table_width'], $lang_cm_order['order_detail_title'], 6);
			    	HTMLelement::preview_cart($cart_data);     			
					endtable();							
					HTMLelement::spacer();
				}
				break;     
		}
		// main
		starttable($CONFIG['picture_table_width'], $lang_cm_order['order_title'], 7);
		echo cpgTemplate::set($order_title, array(
			'{LANG_NUMBER}' => $lang_cm_order['order_number'],  	
			'{LANG_TXN_ID}' => $lang_cm_order['txn_id'],
			'{LANG_USER}'	=> $lang_cm_order['username'],
			'{LANG_TIME}'   => $lang_cm_order['time'],  	  	
			'{LANG_METHOD}' => $lang_cm_order['method'],  	
			'{LANG_AMOUNT}' => $lang_cm_order['amount'],  	
			'{LANG_STATUS}' => $lang_cm_order['status'],				
		));
		$order_array = cpgDB::fetchRowset("SELECT * FROM `{$CONFIG['TABLE_CM_ORDER']}`;");
		foreach ($order_array as $order) {	
			$log_data = cpgTool::decode_data($order['log']);
			echo cpgTemplate::set($order_element, array(
				'{NUMBER}' => HTMLelement::link("index.php?file=cpgmart/cpgmart_config&page=order&task=view_act&oid=".$order['oid'],"#".$order['oid']),
				'{TXN_ID}' => $order['txnid'],
				'{USER}'   => "<a href=\"profile.php?uid={$order['user_id']}\">{$order['user_name']}</a>",
				'{TIME}'   => localised_date($order['time'], $log_date_fmt),  	  	
				'{METHOD}' => $order['method'],  					
				'{AMOUNT}' => $currency_symbol[$log_data['mc_currency']]." ".$log_data['payment_gross'],
				'{STATUS}' => $order['status'],		
			));		
		}
		endtable();				
	}	
// -----------------------------------------------------------------------------------------
// OPTION SET MANAGER
// ----------------------------------------------------------------------------------------- 
	function option_set() {
		global $CONFIG;
		global $currency_symbol;
		global $lang_cm_common, $lang_cm_optionset;
	    // get ACTION		
		$task = cpgTool::request_var('task');		
		// TEMPLATE  
		$tpl_option_set = cpgTemplate::get('blog_option_set');
		$this_title     = cpgTemplate::extract($tpl_option_set, 'title');
		$element   = cpgTemplate::extract($tpl_option_set, 'element');
		$element_m = str_replace('tableb', 'tableh2', $element);
		$page_nav  = cpgTemplate::extract($tpl_option_set, 'page_nav');
		$control   = cpgTemplate::extract($tpl_option_set, 'control');
		$aoe 	   = cpgTemplate::extract($tpl_option_set, 'aoe');
	    // task -> action
		switch ($task) {
	    	case 'new':
	    		// get a price list
	    		$rowset = cpgDB::fetchRowset("SELECT oid, title FROM `{$CONFIG['TABLE_CM_OPTION']}` ORDER BY title ASC;");
	    		$option_array = array();
	    		foreach ($rowset as $row) {
	    			$option_array[$row['oid']]	= $row['title'];	    			
				}	    	
	    		// vars
	    		$vars = array(
	    			'{GB_TITLE}'		=>	$lang_cm_optionset['new_optionset_title'],
					'{ID}'				=>	"",
					'{TASK}'			=>	"new_act",
					'{LANG_TITLE}'		=>	$lang_cm_common['title'],
					'{TITLE}'			=>	HTMLelement::text_input("title",""),
					'{LANG_OPTION_SET}'	=>	$lang_cm_common['optionset'],
					'{OPTION_SET}'		=>	HTMLelement::multiple_select('option_set', $option_array),
					'{LANG_SUBMIT}'		=>	$lang_cm_common['add'],
					'{LANG_RESET}'		=>	$lang_cm_common['reset'],
	    		);
	    		echo cpgTemplate::set($aoe, $vars);
	    		HTMLelement::spacer();		    	
	    		break;
	    	case 'new_act':
	    	    $title = addslashes(cpgTool::post_var('title'));
	    	    $option_set = cpgTool::encode_data(cpgTool::post_var('option_set'));
	    	    $result = cpgDB::runQuery("INSERT INTO `{$CONFIG['TABLE_CM_OPTIONSET']}` (oid, title, option_array) VALUES ('', '$title', '$option_set');");
				$markup_element_id = cpgDB::insertID();
				// success message
				HTMLelement::message($lang_cm_common['message'], sprintf($lang_cm_optionset['add_optionset_success'], $title));				
				HTMLelement::spacer();     
	    		break;	
	    	case 'edit':
	    		$id = (int)cpgTool::get_var('id');
	    		$current_option_set_data = cpgDB::fetchRow("SELECT * FROM `{$CONFIG['TABLE_CM_OPTIONSET']}` WHERE oid='$id';");	    		
	    		$current_option_array = cpgTool::decode_data($current_option_set_data['option_array']);	    		
	    		// get a price list
	    		$rowset = cpgDB::fetchRowset("SELECT oid, title FROM `{$CONFIG['TABLE_CM_OPTION']}` ORDER BY title ASC;");
	    		$option_array = array();
	    		$default_array = array();
	    		foreach ($rowset as $row) {
	    			$option_array[$row['oid']]	= $row['title'];
	    			if (in_array($row['oid'], $current_option_array)) $default_array[] = $row['oid'];	    			
				}	    	
	    		// vars
	    		$vars = array(
	    			'{GB_TITLE}'		=>	$lang_cm_optionset['edit_optionset_title'],
					'{ID}'				=>	$id,
					'{TASK}'			=>	"edit_act",
					'{LANG_TITLE}'		=>	$lang_cm_common['title'],
					'{TITLE}'			=>	HTMLelement::text_input("title", $current_option_set_data['title']),
					'{LANG_OPTION_SET}'	=>	$lang_cm_common['optionset'],
					'{OPTION_SET}'		=>	HTMLelement::multiple_select('option_set', $option_array, $default_array),
					'{LANG_SUBMIT}'		=>	$lang_cm_common['edit'],
					'{LANG_RESET}'		=>	$lang_cm_common['reset'],
	    		);
	    	    echo cpgTemplate::set($aoe, $vars);
	    		HTMLelement::spacer();	
	    		break;
	    	case 'edit_act':
	    		$id = (int)cpgTool::post_var('id');
	    		$title = addslashes(cpgTool::post_var('title'));
	    	    $option_set = cpgTool::encode_data(cpgTool::post_var('option_set'));
	    	    $result = cpgDB::runQuery("UPDATE `{$CONFIG['TABLE_CM_OPTIONSET']}` SET title='$title', option_array='$option_set' WHERE oid = '$id';");
				$markup_element_id = $id;
				// success message
				HTMLelement::message($lang_cm_common['message'], sprintf($lang_cm_optionset['edit_optionset_success'], $title)); 
				HTMLelement::spacer();     
	    		break;	
	    		break;	
	    	case 'del_act':
	    		// which one will be delete
				foreach ($_POST as $name => $value) {
					if (cpgTool::in_string($name, "item_")) {
						$delete_id = (int)str_replace("item_", "", $name);
						if ($delete_id != 0 && $value == 'on') 
							$delete_list[] = $delete_id;
					}			
				}				
				// delete
				// success message
				$msg = array();
				foreach ($delete_list as $delete_id) {
					cpgDB::runQuery("DELETE FROM `{$CONFIG['TABLE_CM_OPTIONSET']}` WHERE oid = '$delete_id' LIMIT 1;");
					$msg[] = sprintf($lang_cm_optionset['del_optionset_success'], $delete_id);				
				}				
				HTMLelement::message($lang_cm_common['message'], $msg);
				HTMLelement::spacer();	
				break;	
		}
		// main page
		starttable($CONFIG['picture_table_width'], $lang_cm_optionset['option_set_list_title'], 3);
		// control box
		echo cpgTemplate::set($control, array(
			'{LANG_NEW}'	=>	$lang_cm_optionset['new_optionset'],
			'{LANG_DEL}'	=>	$lang_cm_optionset['del_optionset'],
		));		
		// title
		echo cpgTemplate::set($this_title, array(
			'{LANG_TITLE}'		=>	$lang_cm_optionset['optionset_name'],
			'{LANG_OPTION_SET}' =>	$lang_cm_optionset['optionset_data'],		
		));	
		$option_set_array = cpgDB::fetchRowset("SELECT * FROM `{$CONFIG['TABLE_CM_OPTIONSET']}` ORDER BY oid DESC;");
		if (count($option_set_array) == 0) echo HTMLelement::apply_simple_text(HTMLelement::simple_text(3), $lang_cm_optionset['no_optionset']);
		foreach ($option_set_array as $key => $option_set) {			
			$option_set['title'] = "<a href=\"index.php?file=cpgmart/cpgmart_config&page=option_set&task=edit&id={$option_set['oid']}\">{$option_set['title']}</a>";
			$vars = array(
				'{CHECK_BOX}'	=>	HTMLelement::check_box("item_". $option_set['oid']),
				'{TITLE}'		=>	$option_set['title'],
				'{OPTION_SET}'	=>	HTMLelement::plain_option_list($option_set['option_array']),
			);
			if ($option_set['oid'] == $markup_element_id)
				echo cpgTemplate::set($element_m, $vars);
			else
				echo cpgTemplate::set($element, $vars);
		}
		// page nav
		echo cpgTemplate::set($page_nav, array(
			'{LANG_CHECK_ALL}'		=>	$lang_cm_common['check_all'],	
			'{LANG_UNCHECK_ALL}'    =>  $lang_cm_common['un_check_all'],
			'{PAGE_NAV}'    		=>  "", 
		));				
		endtable();		
	}	
// -----------------------------------------------------------------------------------------
// OPTION MANAGER
// ----------------------------------------------------------------------------------------- 	
	function option() {
		global $CONFIG;
		global $currency_symbol;
		global $lang_cm_common, $lang_cm_option;	
		// get ACTION		
		$task = cpgTool::request_var('task');		
		// TEMPLATE  
		$tpl_option = cpgTemplate::get('blog_option');
		$this_title = cpgTemplate::extract($tpl_option, 'title');
		$element   = cpgTemplate::extract($tpl_option, 'element');
		$element_m = str_replace('tableb', 'tableh2', $element);
		$page_nav  = cpgTemplate::extract($tpl_option, 'page_nav');
		$control   = cpgTemplate::extract($tpl_option, 'control');
		$aoe 	   = cpgTemplate::extract($tpl_option, 'aoe');		
	    // task -> action
		switch ($task) {
			case 'new':
				$vars = array(
					'{GB_TITLE}'		=>	$lang_cm_option['new_option_title'],
					'{ID}'				=>	"",
					'{TASK}'			=>	"new_act",
					'{LANG_TITLE}' 		 =>	$lang_cm_common['title'],
					'{TITLE}'		 	 =>	HTMLelement::text_input("title", ""),
					'{LANG_TITLE_ARRAY}' =>	$lang_cm_option['option_arr_title'],					
					'{TITLE_ARRAY}'		 =>	HTMLelement::text_input("title_array", ""),
					'{LANG_VALUE_ARRAY}' =>	$lang_cm_option['option_arr_value'],					
					'{VALUE_ARRAY}'		 =>	HTMLelement::text_input("value_array", ""),
					'{LANG_CURRENCY}'	 =>	$lang_cm_common['currrency'],
					'{CURRENCY}'		 =>	HTMLelement::simple_select("currency", $currency_symbol, $CONFIG['cpgmart_currency']),
					'{LANG_SUBMIT}'		=>	$lang_cm_common['add'],
					'{LANG_RESET}'		=>	$lang_cm_common['reset'],
				);
				echo cpgTemplate::set($aoe, $vars);
				HTMLelement::spacer();	
				break;
			case 'new_act':
				$title 		 = addslashes(cpgTool::post_var('title'));
				$title_array = cpgTool::encode_data(explode('||', cpgTool::post_var('title_array')));
				$value_array = explode('||', cpgTool::post_var('value_array'));
				$currency    = cpgTool::post_var('currency');
				foreach ($value_array as $key => $value) {
					$value_array[$key] = (float)$value;
				}
				$value_array = cpgTool::encode_data($value_array);
				cpgDB::runQuery("INSERT INTO `{$CONFIG['TABLE_CM_OPTION']}` (oid, title, title_array, value_array, currency) VALUES ('', '$title', '$title_array', '$value_array', '$currency');");				
				$markup_element_id = cpgDB::insertID();
				HTMLelement::message($lang_cm_common['message'], sprintf($lang_cm_option['add_option_success'], $title));  
				HTMLelement::spacer();
				break;
		    case 'edit':
		    	$id = (int)cpgTool::get_var('id');
				$current_option_data = cpgDB::fetchRow("SELECT * FROM `{$CONFIG['TABLE_CM_OPTION']}` WHERE oid = '$id' LIMIT 1;");				
				// little convert
				$current_option_data['title_array'] = implode("||", cpgTool::decode_data($current_option_data['title_array']));
				$current_option_data['value_array'] = implode("||", cpgTool::decode_data($current_option_data['value_array']));
				// vars
				$vars = array(
					'{GB_TITLE}'		 =>	$lang_cm_option['edit_option'],
					'{ID}'				 =>	$id,
					'{TASK}'			 =>	"edit_act",
					'{LANG_TITLE}' 		 =>	$lang_cm_common['title'],
					'{TITLE}'		 	 =>	HTMLelement::text_input("title", $current_option_data['title']),
					'{LANG_TITLE_ARRAY}' =>	$lang_cm_option['option_arr_title'],
					'{TITLE_ARRAY}'		 =>	HTMLelement::text_input("title_array", $current_option_data['title_array']),
					'{LANG_VALUE_ARRAY}' =>	$lang_cm_option['option_arr_value'],
					'{VALUE_ARRAY}'		 =>	HTMLelement::text_input("value_array", $current_option_data['value_array']),
					'{LANG_CURRENCY}'	 =>	$lang_cm_common['currency'],
					'{CURRENCY}'		 =>	HTMLelement::simple_select("currency", $currency_symbol, $current_option_data['currency']),
					'{LANG_SUBMIT}'		 =>	$lang_cm_common['edit'],
					'{LANG_RESET}'		 =>	$lang_cm_common['reset'],
				);
				echo cpgTemplate::set($aoe, $vars);
				HTMLelement::spacer();	
		    	break;
			case 'edit_act':
				$id 		 = (int)cpgTool::post_var('id');
				$title 		 = addslashes(cpgTool::post_var('title'));
				$title_array = cpgTool::encode_data(explode('||', cpgTool::post_var('title_array')));
				$value_array = explode('||', cpgTool::post_var('value_array'));
				$currency    = cpgTool::post_var('currency');
				foreach ($value_array as $key => $value) {
					$value_array[$key] = (float)$value;
				}
				$value_array = cpgTool::encode_data($value_array);
				cpgDB::runQuery("UPDATE `{$CONFIG['TABLE_CM_OPTION']}` SET title ='$title', title_array='$title_array', value_array='$value_array', currency='$currency' WHERE oid = '$id' LIMIT 1;");				
				$markup_element_id = $id;
				starttable($CONFIG['picture_table_width'], $lang_cm_common['message']);
				HTMLelement::message($lang_cm_common['message'], sprintf($lang_cm_option['edit_option_success'], $title));  
				HTMLelement::spacer();
				break;
			case 'del_act':
				// which one will be delete
				foreach ($_POST as $name => $value) {
					if (cpgTool::in_string($name, "item_")) {
						$delete_id = (int)str_replace("item_", "", $name);
						if ($delete_id != 0 && $value == 'on') 
							$delete_list[] = $delete_id;
					}			
				}				
				$msg = array();
				foreach ($delete_list as $delete_id) {
					cpgDB::runQuery("DELETE FROM `{$CONFIG['TABLE_CM_OPTION']}` WHERE oid = '$delete_id' LIMIT 1;");
					$msg[] = sprintf($lang_cm_option['del_option_success'], $delete_id);				
				}				
				HTMLelement::message($lang_cm_common['message'], $msg);				
				HTMLelement::spacer();	
				break;	
				break;
		}
		// main page
		starttable($CONFIG['picture_table_width'], $lang_cm_option['option_list_title'], 4);
		// control box
		echo cpgTemplate::set($control, array(
			'{LANG_NEW}'	=>	$lang_cm_option['new_option'],
			'{LANG_DEL}'	=>	$lang_cm_option['del_option'],
		));		
		// title
		echo cpgTemplate::set($this_title, array(
			'{LANG_TITLE}'		=>	$lang_cm_common['title'],
			'{LANG_DATA}'		=>	$lang_cm_common['data'],		
			'{LANG_CURRENCY}'	=>	$lang_cm_common['currency'],		
		));		
		$option_array = cpgDB::fetchRowset("SELECT * FROM `{$CONFIG['TABLE_CM_OPTION']}` ORDER BY oid DESC;");
		if (count($option_array) == 0) echo HTMLelement::apply_simple_text(HTMLelement::simple_text(4), $lang_cm_option['no_option']);
		foreach ($option_array as $key => $option) {			
			$option['title'] = "<a href=\"index.php?file=cpgmart/cpgmart_config&page=option&task=edit&id={$option['oid']}\">{$option['title']}</a>";			
			$option['title_array'] = cpgTool::decode_data($option['title_array']);
			$option['value_array'] = cpgTool::decode_data($option['value_array']);
			$combine_array = array_combine($option['title_array'], $option['value_array']);			
			$vars = array(
				'{CHECK_BOX}'	=>	HTMLelement::check_box("item_". $option['oid']),
				'{TITLE}'		=>	$option['title'],
				'{DATA}'		=>	HTMLelement::plain_option($combine_array),
				'{CURRENCY}'	=>	$currency_symbol[$option['currency']],	
			);
			if ($option['oid'] == $markup_element_id)
				echo cpgTemplate::set($element_m, $vars);
			else
				echo cpgTemplate::set($element, $vars);
		}
		// page nav
		echo cpgTemplate::set($page_nav, array(
			'{LANG_CHECK_ALL}'		=>	$lang_cm_common['check_all'],	
			'{LANG_UNCHECK_ALL}'    =>  $lang_cm_common['un_check_all'],
			'{PAGE_NAV}'    		=>  "", 
		));				
		endtable();		
	}
// -----------------------------------------------------------------------------------------
// PRICE SET MANAGER
// ----------------------------------------------------------------------------------------- 	
	function price_set() {
		global $CONFIG;
		global $currency_symbol;
		global $lang_cm_common, $lang_cm_priceset;
	    // get ACTION		
		$task = cpgTool::request_var('task');		
		// TEMPLATE  
		$tpl_price_set = cpgTemplate::get('blog_price_set');
		$this_title    = cpgTemplate::extract($tpl_price_set, 'title');
		$element   = cpgTemplate::extract($tpl_price_set, 'element');
		$element_m = str_replace('tableb', 'tableh2', $element);
		$page_nav  = cpgTemplate::extract($tpl_price_set, 'page_nav');
		$control   = cpgTemplate::extract($tpl_price_set, 'control');
		$aoe 	   = cpgTemplate::extract($tpl_price_set, 'aoe');
		$message   = cpgTemplate::get('element_message');  		 
	    // task -> action
		switch ($task) {
	    	case 'new':
	    		// get a price list
	    		$rowset = cpgDB::fetchRowset("SELECT pid, title, value, currency FROM `{$CONFIG['TABLE_CM_PRICE']}` ORDER BY title ASC;");
	    		$price_array = array();
	    		foreach ($rowset as $row) {
	    			$price_array[$row['pid']]	= "{$row['title']} {$currency_symbol[$row['currency']]} ({$row['title']})";
				}	    	
	    		// vars
	    		$vars = array(
	    			'{GB_TITLE}'		=>	$lang_cm_priceset['new_priceset_title'],
					'{ID}'				=>	"",
					'{TASK}'			=>	"new_act",
					'{LANG_TITLE}'		=>	$lang_cm_common['title'],
					'{TITLE}'			=>	HTMLelement::text_input("title",""),
					'{LANG_PRICE_SET}'	=>	$lang_cm_common['priceset'],
					'{PRICE_SET}'		=>	HTMLelement::multiple_select('price_set', $price_array),
					'{LANG_SUBMIT}'		=>	$lang_cm_common['add'],
					'{LANG_RESET}'		=>	$lang_cm_common['reset'],
	    		);
	    		echo cpgTemplate::set($aoe, $vars);
	    		HTMLelement::spacer();		    	
	    		break;
	    	case 'new_act':
	    	    $title = addslashes(cpgTool::post_var('title'));
	    	    $price_set = cpgTool::encode_data(cpgTool::post_var('price_set'));
	    	    $result = cpgDB::runQuery("INSERT INTO `{$CONFIG['TABLE_CM_PRICESET']}` (pid, title, price_array) VALUES ('', '$title', '$price_set');");
				$markup_element_id = $pid;
				// success message
				HTMLelement::message($lang_cm_common['message'], sprintf($lang_cm_priceset['add_priceset_success'], $title));
				HTMLelement::spacer();     
	    		break;	
	    	case 'edit':
	    		$id = (int)cpgTool::get_var('id');
	    		$current_price_set_data = cpgDB::fetchRow("SELECT * FROM `{$CONFIG['TABLE_CM_PRICESET']}` WHERE pid='$id';");
	    		$current_price_array = cpgTool::decode_data($current_price_set_data['price_array']);	    		
	    		// get a price list
	    		$rowset = cpgDB::fetchRowset("SELECT pid, title, value, currency FROM `{$CONFIG['TABLE_CM_PRICE']}` ORDER BY title ASC;");
	    		$price_array = array();
	    		$default_array = array();
	    		foreach ($rowset as $row) {
	    			$price_array[$row['pid']]	= "{$row['title']} {$currency_symbol[$row['currency']]} ({$row['title']})";
	    			if (in_array($row['pid'], $current_price_array)) $default_array[] = $row['pid'];	    			
				}	    	
	    		// vars
	    		$vars = array(
	    			'{GB_TITLE}'		=>	$lang_cm_priceset['edit_priceset_title'],
					'{ID}'				=>	$id,
					'{TASK}'			=>	"edit_act",
					'{LANG_TITLE}'		=>	$lang_cm_common['title'],
					'{TITLE}'			=>	HTMLelement::text_input("title", $current_price_set_data['title']),
					'{LANG_PRICE_SET}'	=>	$lang_cm_common['priceset'],
					'{PRICE_SET}'		=>	HTMLelement::multiple_select('price_set', $price_array, $default_array),
					'{LANG_SUBMIT}'		=>	$lang_cm_common['edit'],
					'{LANG_RESET}'		=>	$lang_cm_common['reset'],
	    		);
	    	    echo cpgTemplate::set($aoe, $vars);
	    		HTMLelement::spacer();	
	    		break;
	    	case 'edit_act':
	    		$id = (int)cpgTool::post_var('id');
	    		$title = addslashes(cpgTool::post_var('title'));
	    	    $price_set = cpgTool::encode_data(cpgTool::post_var('price_set'));
	    	    $result = cpgDB::runQuery("UPDATE `{$CONFIG['TABLE_CM_PRICESET']}` SET title='$title', price_array='$price_set' WHERE pid = '$id';");
				$markup_element_id = $id;
				// success message
				HTMLelement::message($lang_cm_common['message'], sprintf($lang_cm_priceset['edit_priceset_success'], $title));
				HTMLelement::spacer();     
	    		break;	
	    		break;	
	    	case 'del_act':
	    		// which one will be delete
				foreach ($_POST as $name => $value) {
					if (cpgTool::in_string($name, "item_")) {
						$delete_id = (int)str_replace("item_", "", $name);
						if ($delete_id != 0 && $value == 'on') 
							$delete_list[] = $delete_id;
					}			
				}				
				// delete
				// success message  									
				$msg = array();
				foreach ($delete_list as $delete_id) {
					cpgDB::runQuery("DELETE FROM `{$CONFIG['TABLE_CM_PRICESET']}` WHERE pid = '$delete_id' LIMIT 1;");
					$msg[] = sprintf($lang_cm_priceset['del_priceset_success'], $delete_id);				
				}				
				HTMLelement::message($lang_cm_common['message'], $msg);		
				HTMLelement::spacer();	
				break;	
		}
		// main page
		starttable($CONFIG['picture_table_width'], $lang_cm_priceset['price_set_list_title'], 3);
		// control box
		echo cpgTemplate::set($control, array(
			'{LANG_NEW}'	=>	$lang_cm_priceset['new_priceset'],
			'{LANG_DEL}'	=>	$lang_cm_priceset['del_priceset'],
		));		
		// title
		echo cpgTemplate::set($this_title, array(
			'{LANG_TITLE}'		=>	$lang_cm_priceset['priceset_name'],
			'{LANG_PRICE_SET}'	=>	$lang_cm_priceset['priceset_data'],		
		));		
		$price_set_array = cpgDB::fetchRowset("SELECT * FROM `{$CONFIG['TABLE_CM_PRICESET']}` ORDER BY pid DESC;");
		if (count($price_set_array) == 0) echo HTMLelement::apply_simple_text(HTMLelement::simple_text(4), $lang_cm_priceset['no_priceset']);	
		foreach ($price_set_array as $key => $price_set) {			
			$price_set['title'] = "<a href=\"index.php?file=cpgmart/cpgmart_config&page=price_set&task=edit&id={$price_set['pid']}\">{$price_set['title']}</a>";
			$vars = array(
				'{CHECK_BOX}'	=>	HTMLelement::check_box("item_".$price_set['pid']),
				'{TITLE}'		=>	$price_set['title'],
				'{PRICE_SET}'	=>	HTMLelement::plain_price_list($price_set['price_array']),
			);
			if ($price_set['pid'] == $markup_element_id)
				echo cpgTemplate::set($element, $vars);
			else
				echo cpgTemplate::set($element, $vars);
		}
		// page nav
		echo cpgTemplate::set($page_nav, array(
			'{LANG_CHECK_ALL}'		=>	$lang_cm_common['check_all'],	
			'{LANG_UNCHECK_ALL}'    =>  $lang_cm_common['un_check_all'],
			'{PAGE_NAV}'    		=>  "", 
		));			
		endtable();		
	}	
// -----------------------------------------------------------------------------------------
// PRICE MANAGER
// ----------------------------------------------------------------------------------------- 	
	function price() {
		global $CONFIG;
		global $currency_symbol;
		global $lang_cm_common, $lang_cm_price;
		// get ACTION		
		$task = cpgTool::request_var('task');                      				
		// TEMPLATE
		$tpl_price  = cpgTemplate::get('blog_price');
		$this_title = cpgTemplate::extract($tpl_price, 'title');
		$element   = cpgTemplate::extract($tpl_price, 'element');
		$element_m = str_replace('tableb', 'tableh2', $element);
		$page_nav  = cpgTemplate::extract($tpl_price, 'page_nav');
		$control   = cpgTemplate::extract($tpl_price, 'control');
		$aoe 	   = cpgTemplate::extract($tpl_price, 'aoe');
		$message   = cpgTemplate::get('element_message');  		
		// task -> action
		switch ($task) {
			// add new price
			case 'new':
				$vars = array(
					'{GB_TITLE}'		=>	$lang_cm_price['new_price_title'],
					'{ID}'				=>	"",
					'{TASK}'			=>	"new_act",
					'{LANG_TITLE}'		=>	$lang_cm_common['title'],
					'{TITLE}'			=>	HTMLelement::text_input("title",""),
					'{LANG_VALUE}'		=>	$lang_cm_common['price'],
					'{VALUE}'			=>	HTMLelement::text_input("value",""),
					'{LANG_CURRENCY}'	=>	$lang_cm_common['currency'],
					'{CURRENCY}'		=>	HTMLelement::simple_select("currency", $currency_symbol, $CONFIG['cpgmart_currency']),			    		    		
					'{LANG_SUBMIT}'		=>	$lang_cm_common['add'],
					'{LANG_RESET}'		=>	$lang_cm_common['reset'],
				);
				echo cpgTemplate::set($aoe, $vars);
				HTMLelement::spacer();					
				break;
			// add a new price
			case 'new_act':
            	$title = addslashes(cpgTool::post_var('title'));
			    $value = cpgTool::price_format(cpgTool::post_var('value'));
			    $currency = addslashes(cpgTool::post_var('currency'));
			    $result = cpgDB::runQuery("INSERT INTO `{$CONFIG['TABLE_CM_PRICE']}` (pid, title, value, currency) VALUES ('', '$title', '$value', '$currency');");					
			    $markup_element_id = cpgDB::insertID();
				// success message
				HTMLelement::message($lang_cm_common['message'], sprintf($lang_cm_price['add_price_success'], $title));
				HTMLelement::spacer();
				break;			    
			case 'edit':
				// id = ?
				$id = (int)cpgTool::get_var('id'); 
			    $current_price_data = cpgDB::fetchRow("SELECT pid, title, value, currency FROM `{$CONFIG['TABLE_CM_PRICE']}` WHERE pid = '$id' LIMIT 1;");
			    // no data
			    if (!is_array($current_price_data)) cpgTool::error($lang_cm_common['invaild_id']);			    
				// get current data			
				$vars = array(
					'{GB_TITLE}'		=>	$lang_cm_price['edit_price_title'],
					'{ID}'				=>	$id,
					'{TASK}'			=>	"edit_act",    
					'{LANG_TITLE}'		=>	$lang_cm_common['title'],
					'{TITLE}'			=>	HTMLelement::text_input("title", $current_price_data['title']),
					'{LANG_VALUE}'		=>	$lang_cm_common['price'],
					'{VALUE}'			=>	HTMLelement::text_input("value", $current_price_data['value']),
					'{LANG_CURRENCY}'	=>	$lang_cm_common['currency'],
					'{CURRENCY}'		=>	HTMLelement::simple_select("currency", $currency_symbol, $current_price_data['currency']),			
					'{LANG_SUBMIT}'		=>	$lang_cm_common['modify'],
					'{LANG_RESET}'		=>	$lang_cm_common['reset'],
				);
				echo cpgTemplate::set($aoe, $vars);
				HTMLelement::spacer();
				break;
			case 'edit_act':				
				$id 	  = (int)cpgTool::post_var('id');
			    $title 	  = addslashes(cpgTool::post_var('title'));
			    $value    = cpgTool::price_format(cpgTool::post_var('value'));
			    $currency = addslashes(cpgTool::post_var('currency'));
			    $result = cpgDB::runQuery("UPDATE `{$CONFIG['TABLE_CM_PRICE']}` SET title='$title', value='$value', currency='$currency' WHERE pid = '$id';");
				$markup_element_id = $id;
				// success message 			
				HTMLelement::message($lang_cm_common['message'], sprintf($lang_cm_price['edit_price_success'], $title));
				HTMLelement::spacer();
				break;
			case 'del_act':
				// which one will be delete
				foreach ($_POST as $name => $value) {
					if (cpgTool::in_string($name, "item_")) {
						$delete_id = (int)str_replace("item_", "", $name);
						if ($delete_id != 0 && $value == 'on') 
							$delete_list[] = $delete_id;
					}			
				}				
				// delete
				// success message
				$msg = array();
				foreach ($delete_list as $delete_id) {
					cpgDB::runQuery("DELETE FROM `{$CONFIG['TABLE_CM_PRICE']}` WHERE pid = '$delete_id' LIMIT 1;");	
					$msg[] = sprintf($lang_cm_price['del_price_success'], $delete_id);				
				}				
				HTMLelement::message($lang_cm_common['message'], $msg);
				HTMLelement::spacer();	
				break;	
		}		
		// starttable
		starttable($CONFIG['picture_table_width'], $lang_cm_price['price_list_title'], 4);
		// control box
		echo cpgTemplate::set($control, array(
			'{LANG_NEW}'	=>	$lang_cm_price['new_price'],
			'{LANG_DEL}'	=>	$lang_cm_price['del_price'],
		));		
		// title
		echo cpgTemplate::set($this_title, array(
			'{LANG_TITLE}'		=>	$lang_cm_common['name'],
			'{LANG_VALUE}'		=>	$lang_cm_common['value'],		
			'{LANG_CURRENCY}'	=>	$lang_cm_common['currency'],		
		));			
		// price list		
		$price_array = cpgDB::fetchRowset("SELECT * FROM `{$CONFIG['TABLE_CM_PRICE']}` ORDER BY pid DESC;");
		if (count($price_array) == 0) echo HTMLelement::apply_simple_text(HTMLelement::simple_text(4), $lang_cm_price['no_price']);
		foreach ($price_array as $price) {
			$price['title'] = "<a href=\"index.php?file=cpgmart/cpgmart_config&page=price&task=edit&id={$price['pid']}\">{$price['title']}</a>";
			$vars = array(
				'{CHECK_BOX}'	=>	HTMLelement::check_box("item_".$price['pid']),
				'{TITLE}'		=>	$price['title'],
				'{VALUE}'		=>	cpgTool::price_format($price['value']),
				'{CURRENCY}'	=>	$currency_symbol[$price['currency']],			
			);
			if ($price['pid'] == $markup_element_id)
				echo cpgTemplate::set($element_m, $vars);
			else
				echo cpgTemplate::set($element, $vars);
		}
		// page nav
		echo cpgTemplate::set($page_nav, array(
			'{LANG_CHECK_ALL}'		=>	$lang_cm_common['check_all'],	
			'{LANG_UNCHECK_ALL}'    =>  $lang_cm_common['un_check_all'],
			'{PAGE_NAV}'    		=>  "",
		));		                           
		endtable();
	}
// -----------------------------------------------------------------------------------------
// EDIT ONE PIC || OR PICS IN ALBUM
// -----------------------------------------------------------------------------------------			
	function edit_pic() {
		global $CONFIG;
		global $lang_cm_edit_pic;		
		$current_pic_data = cpgTool::get_pic_data($pid);
	    $tpl_edit_one_pic = cpgTemplate::get("blog_edit_pic");
	    $begin_form = cpgTemplate::extract($tpl_edit_one_pic, "begin_form");
	    $paoa 		= cpgTemplate::extract($tpl_edit_one_pic, "paoa");	    
	    $end_form 	= cpgTemplate::extract($tpl_edit_one_pic, "end_form");			
		$task = cpgTool::request_var('task');
		$pid  = (int)cpgTool::get_var('pid');
		$aid  = (int)cpgTool::get_var('aid');
		// error if aid & pid = 0
		if ($aid == 0 && $pid == 0) {
			cpg_error(ERROR, $lang_cm_edit_pic['err_no_param']);	
		}		
		if ($task == "edit_act") {
	    	$pid_array = cpgTool::post_var('pid_array');
	    	foreach ($pid_array as $pid) {
	    		if (cpgTool::post_var('pic_'.$pid) == "on") {
	    	    	$price  = cpgTool::post_var("price_".$pid);
	    		    $option = cpgTool::post_var("option_".$pid);
	    		    cpgDB::runQuery("UPDATE `{$CONFIG['TABLE_PICTURES']}` SET price='$price', `option`='$option' WHERE pid='$pid';");	    	
				} else {					
					cpgDB::runQuery("UPDATE `{$CONFIG['TABLE_PICTURES']}` SET price='0', `option`='0' WHERE pid='$pid';");
				}
			}
			HTMLelement::message($lang_cm_edit_pic['message'], $lang_cm_edit_pic['edit_success']);
			HTMLelement::spacer();
		}		
		// get the pic data
		if ($aid != 0) {
			$pic_data_array = cpgDB::fetchRowset("SELECT pid, url_prefix, filename, filepath, price, `option`, pwidth, pheight, filesize, hits, votes FROM `{$CONFIG['TABLE_PICTURES']}` WHERE aid = '$aid';");		
			$action = "index.php?file=cpgmart/cpgmart_edit_pic&aid=".$aid;
		} elseif ($pid != 0) {
			$pic_data_array = cpgDB::fetchRowset("SELECT pid, url_prefix, filename, filepath, price, `option`, pwidth, pheight, filesize, hits, votes FROM `{$CONFIG['TABLE_PICTURES']}` WHERE pid = '$pid';");  	
			$action = "index.php?file=cpgmart/cpgmart_edit_pic&pid=".$pid;
		}	    
		
		starttable($CONFIG['picture_table_width'], $lang_cm_edit_pic['pic_price_option'], 3);
		// begin form
	    echo cpgTemplate::set($begin_form, array(   
	    	'{ACTION}'	=>	$action,	    	
	    ));
	    // body
	    foreach ($pic_data_array as $pic_data) {
	    	$pic_data['filesize'] = ceil($pic_data['filesize'] / 1024 );
	    	if ((int)$pic_data['price'] != 0) $checked = " checked=\"checked\""; else $checked = "";
	    	echo cpgTemplate::set($paoa, array(
	    		'{CHECKED}'		   => $checked,
	    	    '{PID}'	    	   => $pic_data['pid'],	    		 	    
	    		'{FILENAME}'	   => $pic_data['filename'],
	    		'{THUMB}'		   => HTMLelement::image(get_pic_url($pic_data, "thumb")),
	    		'{LANG_FILE_INFO}' => $lang_cm_edit_pic['file_info'],
	    		'{FILE_INFO}'	   => "{$pic_data['pwidth']} × {$pic_data['pheight']} - {$pic_data['filesize']} votes - {$pic_data['KB']} {$lang_cm_edit_pic['views']} - {$pic_data['votes']} {$lang_cm_edit_pic['votes']}",
	    		'{LANG_PRICE}' 	   => $lang_cm_edit_pic['price'],
	    		'{PRICE}'		   => HTMLelement::price_set_list ('price_' .$pic_data['pid'], $pic_data['price']),
	    		'{LANG_OPTION}'    => $lang_cm_edit_pic['option'],
	    		'{OPTION}'		   => HTMLelement::option_set_list('option_'.$pic_data['pid'], $pic_data['option']),
	    	));
		}
	    // end form
	    echo cpgTemplate::set($end_form, array(   
	    	'{LANG_SUBMIT}'	=>	$lang_cm_edit_pic['edit'],
	    ));
	    endtable();
	}
// -----------------------------------------------------------------------------------------
// MISC FUNCTION OR FUNCTION IN THE FUTURE
// -----------------------------------------------------------------------------------------				
	// 1. make a panel
	function a_panel() { }	 
	// 2. make a proccess table
	function a_P_table() { }
	// 3. make a button table
	function a_B_table() { }
}
?>