<?php
 /*************************************************************
 * Shopping Cart Modules For Coppermine Photo Gallery v 1.4.x *
 **************************************************************
 * Mod Version: 1.0.0                                         *
 * $Source: /cpgmart/cpgmart.class.php                        *
 * $Revision: 1.0                                             *
 * $Author: foulu                                             *
 * $Email: kak@amfcvn.net                                     *
 * $Date: 2005/06/24 08:05:20                                 *  
 *************************************************************/
 
 // I think I will use cookie
 
 class cpgMart {
 	/**
 	* @desc load cart data from cookie 
 	*/
 	function cpgMart() {
 		global $CONFIG;
 		if (isset($_COOKIE[$CONFIG['cookie_name'].'_cpgmart'])) { 		
 			$data = cpgTool::decode_data($_COOKIE[$CONFIG['cookie_name'].'_cpgmart']);
 			$this->cart = $data['cart']; 			
 			$this->profile = $data['profile']; 
		} else {
			$this->cart = array();
			$this->profile = array();
		}
	}
	/**
	* @desc add item to cart 
	*/
 	function add_item($item_data) {
 		// check if item ID exists || or not
 		$check = false;
 		foreach ($this->cart as $key => $item) {
 			if ($item['pid'] == $item_data['pid'] && $item['price'] == $item_data['price'] && $item['option'] == $item_data['option']) {
 				$check = true;
 				// update because ...
 				$this->cart[$key]['qty']++;
			}
		}
		// add if false
		if (!$check) $this->cart[] = $item_data;
		$this->double_check();
	}
	/**
	* @desc modify an item
	*/
	function edit_item($item_pos, $item_data) {
		$this->cart[$item_pos] = $item_data;
		$this->double_check();
	}
	/**
	* @desc remove an item 
	*/
	function remove_item($item_pos) {
		unset($this->cart[$item_pos]);
	}
	/**
	* @desc save cart to cookie
	*/
 	function save() {
 		global $CONFIG;
		$data['cart'] = $this->cart;
		$data['profile'] = $this->profile;
		$data = cpgTool::encode_data($data);		
        setcookie($CONFIG['cookie_name'].'_cpgmart', $data, time()+86400*30, $CONFIG['cookie_path']);
	}
	/**
	* @desc flush the data
	*/
	function flush() {
		global $CONFIG;
	    unset($this->cart);
	    unset($this->profile);
	    setcookie($CONFIG['cookie_name'].'_cpgmart', "", time()-3600, $CONFIG['cookie_path']);
	}
	/**
	* @desc check if double
	*/
	function double_check() {
		$item_in_cart = count($this->cart);
		$pos_array = array();
		foreach ($this->cart as $key => $item) {			
			$pos_array[] = $key;
		}		
		for ($i=0;$i<=($item_in_cart-2);$i++) {
			for ($j=$i+1;$j<=($item_in_cart-1);$j++) {
				if ($this->cart[$pos_array[$i]]['pid'] == $this->cart[$pos_array[$j]]['pid'] && $this->cart[$pos_array[$i]]['price'] == $this->cart[$pos_array[$j]]['price'] && $this->cart[$pos_array[$i]]['option'] == $this->cart[$pos_array[$j]]['option']) {							
					$this->cart[$pos_array[$i]]['qty'] += $this->cart[$pos_array[$j]]['qty'];
					$this->cart[$pos_array[$j]]['qty'] = 0;
				}		
			}
		}
		foreach ($this->cart as $key => $item) {			
			if ($item['qty'] == 0) unset($this->cart[$key]);
		}	
	}
}

?>