<?php
class table {
    function open($table = 1) {
    	global $CONFIG;    	
	    // border table
    	switch ($table) {
    		case -1:
    			$table = array();
    			break;
    		case 0:
    			$table = array('width'=>-1,'border'=>0,'cellspacing'=>0,'cellpadding'=>0);
    		    break;
    		case 1:    	
		    	$table = array('width'=>-1,'class'=>'maintable','border'=>0,'cellspacing'=>1,'cellpadding'=>0);
				break;	
		}
		// auto convert -1 to picture_table_width config value in with atribute
		if ($table['width'] == -1) {
			$table['width'] = $CONFIG['picture_table_width'];
		}
	    return table::create_element('table', $table);
	}	
	function close() {
	    return '</table>';
	}
	function td($text, $colspan = 1, $class = 'tableh1') {
		$tds = array(
		 	'class'   => $class,
		 	'colspan' => $colspan,
		 	'text'    => $text,		
		);
	    return table::tds($tds);
	} 	
	function tds($tds = array()) {
		$html = '';
		// normalize the data
		if (!is_array($tds[0])) {
			$tds = array($tds);
		}
		if (count($tds) > 0) {
			$html .= table::create_element('tr');
			foreach ($tds as $td) {
				$html .= table::create_element('td', $td, TRUE);
			}
		    $html .= table::create_element('/tr');
		}
		return $html;
	}
	function create_element($name, $options = array(), $need_close_tag = FALSE) {
		$html = '<'.$name;
		foreach ($options as $key => $value) {
			if ($key != 'text') {
				$html .= " {$key}=\"{$value}\"";
			}
		}
		if ($need_close_tag) {
		 	$html .= '>'.$options['text'].'</'.$name.'>'."\n";
		} else {
		 	$html .= ' />'."\n";
		}
		return $html;
	}
	function error($errors) {
	 	$html = "";
	 	if (!is_array($errors)) $errors = array($errors);
	 	foreach ($errors as $error) {
	 		$html .= "<span style=\"color: red; font-weight: bold;\">$error</span>";	 	
		}	
		return $html;
	}
}