<?php
load_helper(array('html','form','table'));
// start
class Control {

	var $action;
	var $id;
	var $table;
	var $primary_key;
	var $lang;
		
	function Control($table, $edits = array(), $types = array(), $lang = array()) {
	 	$this->db       = Database::getInstance(); // load database
	 	$this->table    = $table; // table
	 	$this->edits    = $edits; // array(type, name, default, values)
	 	$this->types    = $types; // validate -> for display -> for insert
	 	$this->primary_key     = $this->db->primary($this->table); // table main ID
	 	$this->action   = isset($_GET['action']) ? $_GET['action']  : ''; // action
        $this->id       = isset($_GET['id'])     ? (int)$_GET['id'] : ''; // id
        $this->load_lang($lang);
	}
	function load_lang($lang = array()) {	
		$default = array(
            'it_insert' 	    => "New item",
            'it_modify'		    => "Modify item",
            'it_list'		    => "Item list",
            'it_delete_title'   => "Delete",
            'it_modify_title'   => "Modify",
            'it_delete_confirm' => "Are you sure to delete this item? This action can't be undone!",
            'bt_add'		    => "Add",
            'bt_modify'		    => "Modify",
            'bt_reset'		    => "Reset",
        );
        // load default language item
        foreach ($default as $key => $value) {
            $this->lang[$key] = isset($lang[$key]) ? $lang[$key] : $value;
        }
        // load extra language item
        foreach ($lang as $key => $value) {
        	if (empty($this->lang[$key])) {
        		$this->lang[$key] = $value;
			}
		}
	}
    function index() {    	
        // bf
        $bf_actions = array('doinsert','domodify','dodelete');
        if (in_array($this->action, $bf_actions)) {
        	$method = $this->action;
        	$this->$method($this->id);
		} 
        starttable(-1);
        $href = $this->action('insert');
        echo '<tr><td class="tableb">' . html::button($href, $this->lang['it_insert']) . '</td></tr>'.PHP_EOL;
     	endtable();
     	
     	$this->db->orderby($this->primary_key . ' asc');     	
     	$query = $this->db->get($this->table);
     	
        starttable(-1, $this->language['it_list'], count($this->edits)+2);
        echo '<tr>'.PHP_EOL;
        foreach ($this->edits as $key => $value) {
        	$title = $this->lang[$value['1']] ? $this->lang[$value['1']] : $value['1'];        	
        	echo "<td class=\"tableh1\"><b>{$title}</b></td>".PHP_EOL;
		}
		echo "<td class=\"tableh1\" align=\"center\"><b>{$this->lang['it_modify_title']}</b></td>".PHP_EOL;
        echo "<td class=\"tableh1\" align=\"center\"><b>{$this->lang['it_delete_title']}</b></td>".PHP_EOL;
        echo '</tr>'.PHP_EOL;
        
        foreach ($query->result_array() as $row) {        
        	//$this->validate($row, $this->types, 'display');
            $this->validate($row);
        	echo '<tr>'.PHP_EOL;
            foreach ($this->edits as $key => $value) {
            	echo "<td class=\"tableb\">{$row[$value['1']]}</td>".PHP_EOL;
            }
            $modify_link = $this->action('modify', array('id'=>$row[$this->primary_key]));
            $delete_link = $this->action('dodelete', array('id'=>$row[$this->primary_key]));
            echo "<td class=\"tableb\" align=\"center\"><a href=\"{$modify_link}\"><img src=\"images/edit.gif\" border=\"0\"></a></td>";
            echo "<td class=\"tableb\" align=\"center\"><a href=\"{$delete_link}\"><img src=\"images/delete.gif\" border=\"0\"></a></td>";
        	echo '</tr>'.PHP_EOL;
		}
		endtable();
		
        $af_actions = array('insert','modify','delete');
        if (in_array($this->action, $af_actions)) {
        	$method = $this->action;
        	$this->$method($this->id);
		}		
	}
	function insert() {		
		starttable(-1, $this->lang['it_insert'], 2);
		echo form::open($this->action('doinsert'));
		foreach ($this->edits as $key => $value) {
		 	echo '<tr>'.PHP_EOL;
		 	$title = $this->lang[$value['1']] ? $this->lang[$value['1']] : $value['1'];
		    echo '<td class="tableb" width="22%"><b>'.$title.'</b></td>'.PHP_EOL;
		    switch ($value[0]) {
		    	case 'text':
		    		$element = form::text($value[1], $value[2]);
		    		break;
		    	case 'password':
		    	    $element = form::password($value[1], $value[2]);
		    		break;
		    	case 'textarea':		        	
		        	$element = form::textarea($value[1], $value[2]);	
		        	break;
		        case 'select':		
		            $element = form::select($value[1], $value[3], $value[2]);
					break;
		        case 'radio':
		            $element = form::radio($value[1], $value[2]);
		        	break;		        
			}
			echo "<td class=\"tableb\" width=\"78%\">{$element}</td>".PHP_EOL;
			echo '</tr>'.PHP_EOL;
		}		
		echo '<tr><td class="tablef" colspan="2">';
		echo form::submit($this->lang['bt_add'], 'submit');
		echo form::reset($this->lang['bt_reset'], 'reset');
		echo '</td></tr>';		
	    echo form::close();
	    endtable();
	}
	function doinsert() {
		if (count($_POST) == 0) codebase_redirect($this->action());
		$this->validate($_POST, $this->types, 'insert');
		$data = array();
		foreach ($this->edits as $k => $v) {		 	
		 	if ($v[1] != $this->primary_key) {
		    	$data[$v[1]] = $_POST[$v[1]];
			}
		}
		$this->db->insert($this->table, $data);		
	}
	function modify() {
		$this->db->where($this->primary_key, $this->id);
		$query = $this->db->get($this->table);
		$row   = $query->row_array();		
		starttable(-1, $this->lang['it_modify'], 2);
		foreach ($this->edits as $key => $value) {
			echo '<tr>'.PHP_EOL;
			$title = $this->lang[$value['1']] ? $this->lang[$value['1']] : $value['1'];
		    echo "<td class=\"tableb\" width=\"22%\"><b>{$title}</b></td>".PHP_EOL;
		    switch ($value[0]) {
		    	case 'text':
		    	    	$element = form::text($value[1], $row[$value[1]]);
		    		break;
		    	case 'password':
		    	        $element = form::password($value[1], $row[$value[1]]);
		    		break;
		    	case 'textarea':		        	
		        		$element = form::textarea($value[1], $row[$value[1]]);	
		        	break;
		        case 'select':		
		                $element = form::select($value[1], $value[3], $row[$value[1]]);
					break;
		        case 'radio':
		            	$element = form::radio($value[1], $row[$value[1]]);
		        	break;
			}
			echo "<td class=\"tableb\" width=\"78%\">{$element}</td>".PHP_EOL;
			echo '</tr>'.PHP_EOL;
		}
		echo '<tr><td class="tablef" colspan="2">';
		echo form::submit($this->lang['bt_modify'], 'submit');
		echo form::reset($this->lang['bt_reset'], 'reset');
		echo '</td></tr>';
		endtable();
		echo form::endform();
	}
	function domodify() {
		if (count($_POST) == 0) codebase_redirect($this->action());
		$data = array();
		foreach ($this->edits as $k => $v) {
		 	if ($v[1] != $this->primary_key) {
		    	$data[$v[1]] = $_POST[$v[1]];
			}
		}		
		$this->db->where($this->primary_key, $this->id);
		$this->db->update($this->table, $data);
		echo $this->db->last_query();
	}
	function dodelete() { 
		$this->db->where($this->primary_key, $this->id);
	    $this->db->delete($this->table);
	}
	function action($action, $params = array()) {
		$html = 'index.php?file='.trim($_GET['file']);
		if ($action) {
			$html .= '&amp;action='.trim($_GET['action']);
		}
		if (count($params) > 0) {
			$pairs = array();
			foreach ($params as $key => $value) {
				$pairs[] = $key. '=' . $value;
			}
			$html .= '&amp;'.implode('&amp;', $pairs);
		}		
		return $html;
	}
	function validate(&$data, $type = 'insert') {
		foreach ($data as $k => $v) {
	    	$my_validate = $this->types[$k];
	        switch ($my_validate[0]) {
	        	case 'string':
	        	    if (strlen($v) > $my_validate[2]) {
	        	    	$data[$k] = substr($v, 0, $my_validate[1]);
					}	        	
	        		break;
	        	case 'float':
	        	    $data[$k] = round($v, $my_validate[1], $my_validate[2]);
	        		break;
	        	case 'yesno':
	        		if ($type == 'display') {
	        			if (strtolower($v) == 'y' || strtolower($v) == 'yes' || strtolower($v) == 'ok' || strtolower($v) == '1' || $v) {
	        				$data[$k] = 'Yes';
						} else {
					    	$data[$k] = 'No';
						}
					}
	        		break;
	        	case 'int':
	        	    $data[$k] = (int)$v;
	        		break;
	        	case 'datetime':	        	
	        		break;
	        	case 'time':	        	
	        		break;
			}
		}
	}
}

?>