<?php

function load_helper($helper) {
	global $helpers;
	if (!is_array($helper)) {
		$helper = array($helper);
	}	
	foreach ($helper as $babe) {		
		$babe = strtolower($babe);				
		if (!$helpers[$babe]) {
			$helper_file = 'plugins/framework/helpers/'.$babe.'_helper.php';			
			if (file_exists($helper_file)) {
				if (!$helpers[$babe]) {	
					require_once($helper_file);
					$helpers[$babe] = TRUE;					
				}
			} else {
				cpg_die(ERROR, "Missing helper file \"{$helper_file}\" .", __FILE__, __LINE__);
			}		
		} else {
			return TRUE;
		}
	}	
}

function load_library($library) {
	global $libaries;
    if (!is_array($library)) {
        $library = array($library);
    }
    foreach ($library as $babe) {    
        $babe = ucfirst(strtolower($babe));
        $library_file = 'plugins/framework/libraries/'.$babe.'.php';
        if (file_exists($library_file)) {
    	    if (!$libaries[$babe]) { 
    		    require_once($library_file);
    		    $libaries[$babe] = TRUE;
		    }
        } else {
		    cpg_die(ERROR, "Missing library file \"{$library_file}\" .", __FILE__, __LINE__);
	    }
    }
}