<?php
require_once('plugins/framework/initialize.php');
load_helper(array('table','form','html'));
load_library('User');
$user = User::getInstance();
$view = isset($_GET['view']) ? trim($_GET['view']) : '';
$query = "SELECT user_id, user_name, user_point FROM {$CONFIG['TABLE_USERS']} WHERE user_point != 0 ORDER BY user_point DESC ";
if ($view != 'full') {
    $query .= "LIMIT 20;";
}
$result = $user->query($query);
$rowset = cpg_db_fetch_rowset($result);
pageheader($lang_guessgame_php['top20']);
echo table::open();
echo table::tds(array(
    array('class'=>'tableh1', 'colspan'=>3, 'text'=>
        $lang_guessgame_php['leader_board'].
        (($view != 'full') ? 
            '&nbsp;&nbsp;'.html::button('index.php?file=guessgame/leaderboard&view=full', $lang_guessgame_php['view_full']) 
            : 
            '&nbsp;&nbsp;'.html::button('index.php?file=guessgame/leaderboard', $lang_guessgame_php['top20']) 
        )
    ),
));
echo table::tds(array(
    array('class'=>'tableh1', 'width'=>'0%', 'align'=>'center', 'text'=>'&nbsp;'),
    array('class'=>'tableh1', 'width'=>'50%', 'text'=>$lang_guessgame_php['uname']),
    array('class'=>'tableh1', 'width'=>'50%', 'text'=>$lang_guessgame_php['upoint']),
));
foreach ($rowset as $key => $row) {
    echo table::tds(array(
        array('class'=>'tableb', 'align'=>'center', 'text'=>'#'.++$key),
        array('class'=>'tableb', 'text'=>html::anchor('profile.php?uid='.$row['user_id'], $row['user_name'])),
        array('class'=>'tableb', 'text'=>$row['user_point']),
    ));
}
if (count($rowset) == 0) {
    echo table::tds(array(
        array('class'=>'tableb', 'colspan'=>3, 'align'=>'center', 'text'=>$lang_guessgame_php['no_userwp']),
    ));   
}
echo table::close();
pagefooter();