<?php
/**************************************************
  Coppermine Photo Gallery 1.4.1 CuteUpload Plugin
  *************************************************
  CuteUpload 1.5
  Copyright (C) 2002-2006 Eversun Software Corp.
  *************************************************
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  *************************************************
  Coppermine version: 1.4.1
  $Revision: 1.0 $
  $Author: Peter $
  $Date: 2006/11/28 13:17:05 $
***************************************************/

if (!defined('IN_COPPERMINE')) die('Not in Coppermine...');

// Add an install action
$thisplugin->add_action('plugin_install','cuteupload_install');
$thisplugin->add_action('plugin_configure','cuteupload_configure');

// Add a action
$thisplugin->add_action('page_start','cuteupload_page_start');

// Add a filter
//$thisplugin->add_filter('add_file_data','cuteupload_add_file_data');

// Install function
function cuteupload_install() {
	if ($_REQUEST['submit']=='Go!') {
    return true;
  } else {
    return 1;
  }
}

function cuteupload_page_start() {
	if (file_exists("plugins/CuteUpload/lang/{$CONFIG['lang']}.php")) {
  	require "plugins/CuteUpload/lang/{$CONFIG['lang']}.php";
	} else {
		require 'plugins/CuteUpload/lang/english.php';
	}
	
	if (USER_ID) {
		cuteupload_add_admin_button('index.php?file=CuteUpload/cuteupload','CuteUpload','CuteUpload','CuteUpload');
	}
	cuteupload_add_config_button('index.php?file=CuteUpload/cuteupload_config',$lang_cuteupload['config_title'],'',$lang_cuteupload['config_title']);
}

function cuteupload_configure($stop = true) {
  global $errors, $CONFIG;
  
	require ('include/sql_parse.php');
  $db_update = 'plugins/CuteUpload/sql/basic.sql';
  $sql_query = fread(fopen($db_update, 'r'), filesize($db_update));
  // Update table prefix
  $sql_query = preg_replace('/CPG_/', $CONFIG['TABLE_PREFIX'], $sql_query);

  $sql_query = remove_remarks($sql_query);
  $sql_query = split_sql_file($sql_query, ';');
  

  ?>
      <h2>Performing Database Updates<h2>
      <table class="maintable">

  <?php

  foreach($sql_query as $q) {
    echo "<tr><td class='tableb'>$q</td>";
    if (mysql_query($q)) {
        echo "<td class='updatesOK'>OK</td></tr>";
    } else {
        echo "<td class='updatesFail'>Already Done</td></tr>";
    }
  }

  echo "</table>";
  
  if ($stop) {
    echo <<< EOT

    <form action="{$_SERVER['REQUEST_URI']}" method="post">
        <input type="submit" value="Go!" name="submit" />
    </form>
EOT;
  }

}

function cuteupload_add_config_button($href,$title,$target,$link)
{
  global $template_gallery_admin_menu;

  $new_template=$template_gallery_admin_menu;
  $button=template_extract_block($new_template,'documentation');
  $params = array(
      '{DOCUMENTATION_HREF}' => $href,
      '{DOCUMENTATION_TITLE}' => $title,
      'target="cpg_documentation"' => $target,
      '{DOCUMENTATION_LNK}' => $link,
   );
   $new_button="<!-- BEGIN $link -->".template_eval($button,$params)."<!-- END $link -->\n";
   template_extract_block($template_gallery_admin_menu,'documentation',"<!-- BEGIN documentation -->" . $button . "<!-- END documentation -->\n" . $new_button);
}

function cuteupload_add_admin_button($href,$title,$target,$link) {
  global $template_sys_menu, $template_sys_menu_spacer;

  $new_template=$template_sys_menu;
  $button=template_extract_block($new_template,'upload_pic');
  $params = array('{UPL_PIC_LNK}' => $target,
						      '{UPL_PIC_TITLE}' => $title,
						      '{UPL_PIC_TGT}' => $href,
						      'upload_pic' => $link);
  $new_button="<!-- BEGIN $link -->".template_eval($button,$params)."<!-- END $link -->\n";
  template_extract_block($template_sys_menu,'upload_pic',"<!-- BEGIN upload_pic -->" . $button . "<!-- END upload_pic -->\n" .$new_button);
}
?>