<?php
/**************************************************
  Coppermine 1.4 Plugin - Restrict Access
  *************************************************
  Copyright (c) 2006 Paul Van Rompay
  *************************************************
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  *************************************************/

if (!defined('IN_COPPERMINE')) die('Not in Coppermine...');

// Add an install & configure & uninstall actions
$thisplugin->add_action('plugin_install','restrictaccess_install');
$thisplugin->add_action('plugin_configure','restrictaccess_configure');
$thisplugin->add_action('plugin_uninstall','restrictaccess_uninstall');

// Add actions
$thisplugin->add_action('page_start','restrictaccess_page_start');

// Install Plugin
function restrictaccess_install() {
	global $CONFIG, $lang_plugin_restrictaccess, $lang_plugin_restrictaccess_config;
	require ('plugins/restrict_access/include/init.inc.php');
	
	if ($_POST['submit']==$lang_plugin_restrictaccess_config['button_done']) {
		return true;
	} else {
		return 1;
	}
}

// Configure Plugin
function restrictaccess_configure() {
	global $CONFIG, $lang_plugin_restrictaccess, $lang_plugin_restrictaccess_config;
	require ('plugins/restrict_access/include/init.inc.php');

	// delete previous plugin config options if necessary (just in case)
	cpg_db_query("DELETE FROM {$CONFIG['TABLE_CONFIG']} WHERE name REGEXP '^plugin_restrictaccess_'");

	// insert default parameters into configuration table
	$sql = "INSERT INTO {$CONFIG['TABLE_CONFIG']} (name, value)"
		." VALUES"
		." ('plugin_restrictaccess_allowedgroups','')";
	cpg_db_query($sql);

	echo <<< EOT
		<h2>{$lang_plugin_restrictaccess['install_done']}</h2>
		{$lang_plugin_restrictaccess['install_note']}<br />
		<br />
		<form action="{$_SERVER['REQUEST_URI']}" method="post">
		<input type="submit" value="{$lang_plugin_restrictaccess_config['button_done']}" name="submit"/>
		</form>
EOT;
}

// Uninstall Plugin
function restrictaccess_uninstall() {
	global $CONFIG;
	cpg_db_query("DELETE FROM {$CONFIG['TABLE_CONFIG']} WHERE name REGEXP '^plugin_restrictaccess_'");
	return true;
}

// add config button
function restrictaccess_add_config_button($href,$title,$target,$link)
{
  global $template_gallery_admin_menu;

  $new_template = $template_gallery_admin_menu;
  $button = template_extract_block($new_template,'documentation');
  $params = array(
      '{DOCUMENTATION_HREF}' => $href,
      '{DOCUMENTATION_TITLE}' => $title,
      'target="cpg_documentation"' => $target,
      '{DOCUMENTATION_LNK}' => $link,
   );
   $new_button="<!-- BEGIN $link -->".template_eval($button,$params)."<!-- END $link -->\n";
   template_extract_block($template_gallery_admin_menu,'documentation',"<!-- BEGIN documentation -->" . $button . "<!-- END documentation -->\n" . $new_button);
}

// add admin button to start of each page
function restrictaccess_page_start()
{
	global $CONFIG, $lang_errors, $lang_plugin_restrictaccess, $lang_plugin_restrictaccess_config;
	require ('plugins/restrict_access/include/init.inc.php');

	if (GALLERY_ADMIN_MODE) {
		restrictaccess_add_config_button('index.php?file=restrict_access/plugin_config',$lang_plugin_restrictaccess['config_title'],'',$lang_plugin_restrictaccess['config_button']);
	} elseif (USER_ID && !defined('LOGIN_PHP') && !defined('LOGOUT_PHP')) {
		$usergroups = explode(',',substr(USER_GROUP_SET,1,-1));
		$restrictgroups = explode(',',$CONFIG['plugin_restrictaccess_allowedgroups']);
		$restrictuser = array_intersect($restrictgroups,$usergroups);
		if ($restrictuser) {
			die($lang_plugin_restrictaccess['access_denied']);
		}
	}
}

?>
