<?php

define('IN_COPPERMINE', true);
define('IN_FORUM', true);

require_once("include/init.inc.php");
require_once('include/smilies.inc.php');

require_once("adaptor/include/init.inc.php");
require_once("adaptor/include/HTMLelement.class.php");
require_once("adaptor/include/functions.inc.php");

// check if forum installed
$result = cpg_db_query("SELECT value FROM `{$CONFIG['TABLE_CONFIG']}` WHERE name='fr_installed';");
$row = cpg_db_fetch_row($result);
if (!$row['value']) {	
	cpg_die(CRITICAL_ERROR, "Forum wasn't installed! Please go to plugin manager and install it !");
}
// end

// auto update if new version
require_once("plugins/adaptor/version.php");
auto_update_sql();
// end

// keyword ^^
$template_header = str_replace("</head>", "<meta name=\"keywords\" content=\"foulu, cpgforum, Coppermine Simple Forum\">\n</head>", $template_header);

// addon JS
if (file_exists("adaptor/js/scripts.js")) {
	$template_header = str_replace("</head>", "<script type=\"text/javascript\" src=\"adaptor/js/scripts.js\"></script>\n</head>", $template_header);
}

// auto correct CSS		
if (!isset($USER['theme'])) $USER['theme'] = $CONFIG['theme'];
if (file_exists("adaptor/css/style_".$USER['theme'].".css")) {
	$template_header = str_replace("</head>", "<link rel=\"stylesheet\" href=\"adaptor/css/style_{$USER['theme']}.css\" type=\"text/css\" />\n</head>", $template_header);
}

// auto correct theme		
if (!isset($USER['theme'])) $USER['theme'] = $CONFIG['theme'];
if (file_exists("adaptor/theme/theme_".$USER['theme'].".php")) {
	require_once("adaptor/theme/theme_".$USER['theme'].".php");	
}

require_once("adaptor/include/themes.inc.php");

if (!file_exists("adaptor/lang/{$CONFIG['lang']}.php")) $CONFIG['lang'] = 'english';
require_once("adaptor/lang/{$CONFIG['lang']}.php");

$cat    = isset($_GET['cat'])    ? (int)$_GET['cat'] : 0;
$board  = isset($_GET['board'])  ? (int)$_GET['board'] : 0;
$topic  = isset($_GET['topic'])  ? (int)$_GET['topic'] : 0;
$msg    = isset($_GET['msg'])    ? (int)$_GET['msg'] : 0;
$action = isset($_GET['action']) ? $_GET['action'] : "";

if ($board != 0) {   
	$page_type = "board";
	check_board($board);
} elseif ($topic != 0) {
	$page_type = "topic";
	check_topic($topic);
} elseif ($msg != 0) {
	$page_type = "msg";	
	check_msg($msg);
} else {  
	$page_type = "index";
	if ($cat != 0) check_cat($cat);
}

pageheader($lang_fr_index['title']);

switch ($page_type) {
	case "index":
		require_once("adaptor/source/index.view.php");
		index($cat);
		break;
	case "board":
		if ($action == "post") {
			require_once("adaptor/source/topic.post.php");
			new_topic($board);
		} elseif ($action == "post2") {			
			require_once("adaptor/source/topic.post.php");			
			new_topic2();                             		
			cpg_redirect("forum.php?board=".$board);						
		} else {
			require_once("adaptor/source/board.view.php");
			board($board);			
		}
		break;
	case "topic":
		if ($action == "post") {
			require_once("adaptor/source/msg.post.php");
		    new_msg($topic);
		} elseif ($action == "post2") {
			require_once("adaptor/source/msg.post.php");
		    new_msg2();
			cpg_redirect("forum.php?topic=".$topic);
		} elseif ($action == "remove") {
			require_once("adaptor/source/topic.remove.php");
            remove_topic($topic, $board);
            cpg_redirect("forum.php?board=".$board);
		} elseif ($action == "move") {
			require_once("adaptor/source/topic.move.php");
			move_topic($topic);			
		} elseif ($action == "move2") {
			require_once("adaptor/source/topic.move.php");
			move_topic2($topic);			
			cpg_redirect("forum.php?topic=".$topic);
		} elseif ($action == "sticky") {
			require_once("adaptor/source/topic.sticky.php");
		    sticky_topic($topic);
		    cpg_redirect("forum.php?topic=".$topic);
		} elseif ($action == "lock") {
			require_once("adaptor/source/topic.lock.php");
			lock_topic($topic);
			cpg_redirect("forum.php?topic=".$topic);
		} else {
			require_once("adaptor/source/topic.view.php");
			topic($topic);
		}
		break;
	case "msg":
		if ($action == "remove") {
			require_once("adaptor/source/msg.remove.php");
			remove_msg($msg);
		} elseif ($action == "modify") {
			require_once("adaptor/source/msg.modify.php");
			modify_msg($msg);
		} elseif ($action == "modify2") {
			require_once("adaptor/source/msg.modify.php");
			modify_msg2($topic);
			cpg_redirect("forum.php?topic=".$topic);
		}
		break;
	default:
}

// excuse time
if ($CONFIG['fr_display_ctime']) {
	$cpg_time_end = cpgGetMicroTime();
	$running_time = round($cpg_time_end - $cpg_time_start, 3);
	$template_footer = "<div class=\"footer\" style=\"padding-top: 10px;\" align=\"center\">".sprintf($lang_fr_index['ctime'], $running_time)."</div>" . $template_footer;
}

// he he - my copyright
$my_copyright = "<a href=\"http://forum.coppermine-gallery.net/index.php/topic,51535.0.html\">Coppermine Simple Forum ".$CONFIG['fr_version']."</a> &#169; <a href=\"http://forum.coppermine-gallery.net/index.php?action=profile;u=3924\">foulu</a><br />";
$magic_string = "<div class=\"footer\" align=\"center\" style=\"padding-top: 10px;\">";	
$template_footer = str_replace($magic_string, $magic_string . $my_copyright, $template_footer);

pagefooter();

?>