<?php
/**************************************************
  Backup Plugin for Coppermine Photo Gallery
/**********************************************
  based on the XT Dump script with the agreement of the author
  Modified by Frantz for Backup plugin
  2007/01/20
**********************************************/

if (!defined('IN_COPPERMINE')) die('Not in Coppermine...');

$thisplugin->add_action('plugin_install','backup_install');
$thisplugin->add_action('plugin_configure','backup_configure');


$thisplugin->add_action('page_start','backup_page_start');
// Install function
// Checks if uid is 'me' and pwd is 'you'; If so, then install the plugin
function backup_install() {

    // Install
    if ($_POST['submit']==$lang_plugin_backup_config['button_install']) {

        return true;

    // Loop again
    } else {

        return 1;
    }
}

// Configure function
// Displays the form
function backup_configure() {
    global $CONFIG, $lang_plugin_backup, $lang_plugin_backup_config;
    // Include the plugin's language file
    // Submit your lang file for this plugin on the coppermine forums
    // Plugin will try to use the configured language if it is available.
    if (file_exists("./plugins/backup/lang/{$CONFIG['lang']}.php")) {
            require "./plugins/backup/lang/{$CONFIG['lang']}.php";
    }
    else {
            require "./plugins/backup/lang/english.php";
    }

        echo <<< EOT
                <h2>{$lang_plugin_backup['install_click']}</h2>
                {$lang_plugin_backup['install_note']}<br />
                <br />
                <form action="{$_SERVER['REQUEST_URI']}" method="post">
                <input type="submit" value="{$lang_plugin_backup_config['button_install']}" name="submit" />
                </form>
EOT;
}
// add config button
function backup_config_button($href,$title,$target,$link)
{
  global $template_gallery_admin_menu;

  $new_template = $template_gallery_admin_menu;
  $button = template_extract_block($new_template,'documentation');
  $params = array(
      '{DOCUMENTATION_HREF}' => $href,
      '{DOCUMENTATION_TITLE}' => $title,
      'target="cpg_documentation"' => $target,
      '{DOCUMENTATION_LNK}' => $link,
   );
   $new_button="<!-- BEGIN $link -->".template_eval($button,$params)."<!-- END $link -->\n";
   template_extract_block($template_gallery_admin_menu,'documentation',"<!-- BEGIN documentation -->" . $button . "<!-- END documentation -->\n" . $new_button);
}
// add admin button to start of each page
function backup_page_start()
{
        global $CONFIG, $lang_plugin_backup, $lang_plugin_backup_config, $lang_plugin_backup_manage, $FEX,$lang_plugin_backup_delete;
        // Include the plugin's language file
        // Submit your lang file for this plugin on the coppermine forums
        // Plugin will try to use the configured language if it is available.
        if (file_exists("./plugins/backup/lang/{$CONFIG['lang']}.php")) {
                require "./plugins/backup/lang/{$CONFIG['lang']}.php";
        }
        else {
                require "./plugins/backup/lang/english.php";
        }


        if (GALLERY_ADMIN_MODE) {
                backup_config_button('index.php?file=backup/backup#backup',$lang_plugin_backup['backup_title'],'',$lang_plugin_backup['backup_button']);

        }

}
?>