<?php
/*************************
  Coppermine Photo Gallery
  ************************
  Copyright (c) 2003-2005 Coppermine Dev Team
  v1.1 originaly written by Gregory DEMAR

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  ********************************************
  Coppermine version: 1.4.14
  $Revision: 1.0 $
  $Author: SaWey $
  $Date: 2008/01/18 02:33:26 $
**********************************************/



if (!defined('IN_COPPERMINE')) die('Not in Coppermine...');
$thisplugin->add_filter('template_html','modify_tpl');


$seconds_treshold = 10;
$seconds_zone = array();
$mag_seconds = 10;
$minutes_treshold = 5;
$minutes_zone = array();
$mag_minutes = 10;
$hours_treshold = 1;
$hours_zone = array();
$mag_hours = 10;

##########################################
### To add a language, just copy one of
### the arrays below and paste/translate in order.
### Use the right name for your language (auto detected)
##########################################
function lang_timeline($string){
	global $USER;
	$lang_timeline = array(
		'english'	=> array(
			'added' 	=> 'Added picture to',
			'watch' 	=> 'Go to picture',
			'timeline'	=> 'Timeline',
			'home'		=> 'Home',
		),
		'dutch' 	=> array(
			'added' 	=> 'Afbeelding toegevoegd aan',
			'watch' 	=> 'Ga naar afbeelding',
			'timeline'	=> 'Tijdslijn',
			'home'		=> 'Home',
		),
	);
	
	$translated = ($lang_timeline[$USER['lang']][$string] == '') ? $lang_timeline['english'][$string] : $lang_timeline[$USER['lang']][$string];
	return $translated;
}


function modify_tpl($tpl){
	##########################################
	### timeline_link is the template that 
	### will be used to add the link to the 
	### timeline page
	##########################################
	global $template_sub_menu_spacer;
	$timeline_link = $template_sub_menu_spacer.' <a href="index.php?file=timeline/index#timeline">' . lang_timeline('timeline') . '</a>';
	if(defined('TIMELINE')){
		if(strpos($tpl, '{META}') != ''){
			//add scripts regex
			$regex = array(
				'/\{META\}/',
				'/\<body/',
				'/\{SUB_MENU\}/',
			);
			$replace = array(
				'{META}' . get_script(),
				'<body onload="onLoad();" onresize="onResize();"',
				'{SUB_MENU} ' . $timeline_link,
			);
			$tpl = preg_replace($regex, $replace, $tpl);
		}
	}else {
		if(strpos($tpl, '{META}') != ''){
			//add scripts regex
			$regex = array(
				'/\{SUB_MENU\}/',
			);
			$replace = array(
				'{SUB_MENU} ' . $timeline_link,
			);
			$tpl = preg_replace($regex, $replace, $tpl);
		}
	}
	return $tpl;
}


function get_script(){//http://simile.mit.edu/timeline/docs
	global $dates, $seconds_treshold, $seconds_zone, $mag_seconds, $minutes_treshold, $minutes_zone, $mag_minutes ,$hours_treshold, $hours_zone, $mag_hours;
	// create javascript code
	$dates = write_xml();
	sort($dates, SORT_NUMERIC);
	$start_date = $dates;
	$start_date = date('M j Y H:i:s \G\M\T', $start_date[count($start_date) - 1]);
	
	//create zoom levels
	$simile = new Simile($dates);
	$simile->createZones();
	
	
	$script = '
	<script src="http://simile.mit.edu/timeline/api/timeline-api.js" type="text/javascript"></script>
	<script type="text/javascript">
		var tl;
		var eventSource = new Timeline.DefaultEventSource();
		function onLoad() {
		  var bandInfos = [
		    Timeline.createHotZoneBandInfo({
				' . $simile->zones . '
				timeZone:       -5,
				eventSource:    eventSource,
        		date:           "' . $start_date . '",
				width:          "85%", 
				intervalUnit:   Timeline.DateTime.DAY, 
				intervalPixels: 100
			}),
			Timeline.createBandInfo({
				eventSource:    eventSource,
        		date:           "' . $start_date . '",
				showEventText:  false,
				trackHeight:    0.8,
				width:          "10%", 
				intervalUnit:   Timeline.DateTime.MONTH, 
				intervalPixels: 100
			}),
			Timeline.createBandInfo({
				eventSource:    eventSource,
        		date:           "' . $start_date . '",
				showEventText:  false,
				trackHeight:    0.5,
				width:          "5%", 
				intervalUnit:   Timeline.DateTime.YEAR, 
				intervalPixels: 300
			})
		  ];
		  bandInfos[1].syncWith = 0;
		  bandInfos[1].highlight = true;
		  bandInfos[2].syncWith = 1;
		  bandInfos[2].highlight = true;

		  

		  tl = Timeline.create(document.getElementById("cpg-timeline"), bandInfos);
		  Timeline.loadXML("./cpg_simile.xml", function(xml, url) { eventSource.loadXML(xml, url); });
		}
		
		var resizeTimerID = null;
		function onResize() {
			if (resizeTimerID == null) {
				resizeTimerID = window.setTimeout(function() {
					resizeTimerID = null;
					tl.layout();
				}, 500);
			}
		}
		
	</script>';
	return $script;
}

function show(){
	echo '<div id="cpg-timeline" style="font-size: 9px; height: 500px; border: 1px solid #aaa"></div>';
}

function write_xml(){
	global $CONFIG; 
	$q = cpg_db_query("SELECT p.pid, p.filepath AS path, p.filename, p.ctime AS date, p.title, p.caption, a.title AS album FROM {$CONFIG['TABLE_PICTURES']} AS p LEFT JOIN {$CONFIG['TABLE_ALBUMS']} AS a ON p.aid = a.aid WHERE p.approved = 'YES' AND a.visibility='0'");
	
	//start xml
	$xml = '<data>' . "\n";
	$dates = array();
	$added = lang_timeline('added');
	$watch = lang_timeline('watch');
	
	while($pic = mysql_fetch_assoc($q))
	{
		$dates[] = $pic['date'];
		$date = date('M j Y H:i:s \G\M\T', $pic['date']);
		$title = ($pic['title'] == '') ? 'No Title' : $pic['title'];
		$xml .= <<<EOT
		<event start="{$date}" title="{$title}"	image="albums/{$pic['path']}thumb_{$pic['filename']}">
			{$added} {$pic['album']} &lt;br /&gt;&lt;a href="displayimage.php?pos=-{$pic['pid']}"&gt;{$watch}&lt;/a&gt;.
		</event>


EOT;
	}
	$xml .= "\n" .'</data>';
	$myFile = "cpg_timeline.xml";
	$fh = fopen($myFile, 'w') or die("can't write the xml file");
	fwrite($fh, $xml);
	fclose($fh);
	
	return $dates;
}


//Simile class
class Simile{
	var $dates;
	var $seconds_treshold = 10;
	var $seconds_zone = array();
	var $mag_seconds = 10000;
	var $minutes_treshold = 5000;
	var $minutes_zone = array();
	var $mag_minutes = 10;
	var $hours_treshold = 1;
	var $hours_zone = array();
	var $mag_hours = 2000;
	var $zones = '';
	
	function Simile($dates){
		$this->dates = array_unique($dates);
			
		//calculate the zones
		$this->calcSeconds();
		$this->calcMinutes();
		$this->calcHours();
	}
	
	function createZones(){
		//create zones array
		$this->zones = 'zones: [';
		if(count($this->seconds_zone) != 0){
			foreach($this->seconds_zone as $start => $val_arr) {
				$beginning 	= date('M j Y H:i:s \G\M\T', $start);
				$ending 	= date('M j Y H:i:s \G\M\T', max($val_arr));
				$this->zones .= '
					{   start:    "' . $beginning . '",
						end:      "' . $ending . '",
						magnify:  ' . $this->mag_seconds . ',
						multiple: 15,
						unit:     Timeline.DateTime.SECOND
					},';
			}
		}
		
		if(count($this->minutes_zone) != 0){
			foreach($this->minutes_zone as $start => $val_arr) {
				$beginning 	= date('M j Y H:i:s \G\M\T', $start);
				$ending 	= date('M j Y H:i:s \G\M\T', max($val_arr));
				$this->zones .= '
					{   start:    "' . $beginning . '",
						end:      "' . $ending . '",
						magnify:  ' . $this->mag_minutes . ',
						multiple: 15,
						unit:     Timeline.DateTime.MINUTE
					},';
			}
		}
		if(count($this->hours_zone) != 0){
			foreach($this->hours_zone as $start => $val_arr) {
				$beginning 	= date('M j Y H:i:s \G\M\T', $start);
				$ending 	= date('M j Y H:i:s \G\M\T', max($val_arr));
				$this->zones .= '
					{   start:    "' . $beginning . '",
						end:      "' . $ending . '",
						magnify:  ' . $this->mag_hours . ',
						multiple: 2,
						unit:     Timeline.DateTime.HOUR
					},';
			}
		}
		$this->zones .= "\n" . '				],';
	}
	
	####################
	####SECONDS-ZONE####
	####################
	function calcSeconds(){
		
		$i = 1;
		foreach($this->dates as $date){
			$tmp = array_slice($this->dates, $i);
			$tmp['f'] = $date;
			$this->seconds_zone[$date] = $this->filter_seconds($tmp);
			$i++;
		}
		//filter zones
		foreach($this->seconds_zone as $key => $zone){
			if(count($zone) == 0){
				unset($this->seconds_zone[$key]);
			}
			foreach($zone as $date => $zero){
				if(array_key_exists($date, $this->seconds_zone)){
					unset($this->seconds_zone[$date]);
				}
				unset($this->dates[array_search($date, $this->dates)]);
			}
		}
	}
	
	####################
	####MINUTES-ZONE####
	####################
	function calcMinutes(){
		$i = 1;
		foreach($this->dates as $date){
			$tmp = array_slice($this->dates, $i);
			$tmp['f'] = $date;
			$this->minutes_zone[$date] = $this->filter_minutes($tmp);
			$i++;
		}
		//filter zones
		foreach($this->minutes_zone as $key => $zone){
			if(count($zone) == 0){
				unset($this->minutes_zone[$key]);
			}else{
				foreach($zone as $date => $zero){
					if(array_key_exists($date, $this->minutes_zone)){
						unset($this->minutes_zone[$date]);
					}
					unset($this->dates[array_search($date, $this->dates)]);
				}
			}
		}
	}
	
	####################
	######HOUR-ZONE#####
	####################
	function calcHours(){
		$i = 1;
		foreach($this->dates as $date){
			$tmp = array_slice($this->dates, $i);
			$tmp['f'] = $date;
			$this->hours_zone[$date] = $this->filter_hours($tmp);
			$i++;
		}
		//filter zones
		foreach($this->hours_zone as $key => $zone){
			if(count($zone) == 0){
				unset($this->hours_zone[$key]);
			}else{
				foreach($zone as $date => $zero){
					if(array_key_exists($date, $this->hours_zone)){
						unset($this->hours_zone[$date]);
					}
					unset($this->dates[array_search($date, $this->dates)]);
				}
			}
		}
	}
	
	function filter_seconds($tmp){
		$tmp2 = array();
		$date_to_check = $tmp['f'];
		unset($tmp['f']);
		$last_one = null;
		foreach($tmp as $key => $date){
			$comparation = $date - $this->seconds_treshold;
			if($last_one != null){
				$last_one = $tmp[$key -1];

				if($last_one > $comparation){
					$tmp2[$date] = $date;
				}else {
					break;
				}
			}else{
				$last_one = $date;
				if($date_to_check > $comparation){
					$tmp2[$date] = $date;
				}else{
					break;
				}
			}
		}
		return $tmp2;
	}
	
	function filter_minutes($tmp){
		$tmp2 = array();
		$date_to_check = $tmp['f'];
		unset($tmp['f']);
		$last_one = null;
		foreach($tmp as $key => $date){
			$comparation = $date - $this->minutes_treshold;
			if($last_one != null){
				$last_one = $tmp[$key -1];
				if($last_one > $comparation){
					$tmp2[$date] = $date;
				}else {
					break;
				}
			}else{
				$last_one = $date;
				if($date_to_check > $comparation){
					$tmp2[$date] = $date;
				}else{
					break;
				}
			}
		}
		return $tmp2;
	}
	
	function filter_hours($tmp){
		$tmp2 = array();
		$date_to_check = $tmp['f'];
		unset($tmp['f']);
		$last_one = null;
		foreach($tmp as $key => $date){
			$comparation = $date - $this->hours_treshold;
			if($last_one != null){
				$last_one = $tmp[$key -1];
				if($last_one > $comparation){
					$tmp2[$date] = $date;
				}else {
					break;
				}
			}else{
				$last_one = $date;
				if($date_to_check > $comparation){
					$tmp2[$date] = $date;
				}else{
					break;
				}
			}
		}
		return $tmp2;
	}
}
?>