<?php
/*
 * $RCSfile: $
 *
 * SnapGalaxy4CPG - a plugin for Coppermine gallery to create photo prints, and print product gift items
 * Copyright (C) 2007 SnapGalaxy, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street - Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */
/**
 * @version $Revision: $ $Date: $
 * @package SnapGalaxy4CPG
 * @author Bhavin Suthar <service@snapgalaxy.com> for SnapGalaxy, Inc. http://www.snapgalaxy.com/
 */

$snapgalaxyPluginHome = dirname(__FILE__);

@session_start();

require_once($snapgalaxyPluginHome.'/libs/SnapGalaxyAPI.php');

// Check that we are in coppermin and if we aren't then die.
if (!defined('IN_COPPERMINE')) die('Not in Coppermine...');

// Add plugin_install action
 $thisplugin->add_action('plugin_install','snapgalaxyInstall');

// Add plugin_uninstall action
 $thisplugin->add_action('plugin_uninstall','snapgalaxyUninstall');

// Filter to add javascript to the album
$thisplugin->add_filter('page_meta','snapgalaxyControlHeader');

// Filter to add the checkout menu
$thisplugin->add_filter('template_html','snapgalaxyCheckoutMenuAndOnloadInit');


// Filter to add the shopping cart view to all pages.
$thisplugin->add_filter('gallery_header','snapgalaxyAddCartAndView');

// Add plugin_install action
$thisplugin->add_filter('thumb_data','snapgalaxyImageButtons');


/** **********************************************************
 *  Functions that are used by the filters to make site changes.
 *************************************************************/

function snapgalaxyInstall(){
  return true;
}

function snapgalaxyUninstall(){
  return true;
}

function snapgalaxyAddCartAndView(){
  return snapgalaxyCartAndViewDivElements();
} // end: function snapgalaxyAddCartAndView()

function snapgalaxyControlHeader(){
  return snapgalaxyCSSandJavascriptIncludes();
} // end: function snapgalaxyControlHeader()

function snapgalaxyCheckoutMenuAndOnloadInit(&$html){
    global $template_sys_menu_spacer;
    $html = str_replace('{SUB_MENU}','{SUB_MENU} <br /> {CART_MENU}',$html);
    $cart_menu = "<a id=\"snapgalaxy-menu-cart\" class=\"snapgalaxy-sub-menu\" href=\"javascript:snapgalaxyOpenViewCart();\"><span id=\"snapgalaxy-cart-total\">".count($_SESSION['snapgalaxy']['cart'])." images</span> in the cart</a> <span class=\"snapgalaxy-sub-menu-delimit\">".$template_sys_menu_spacer."</span> <a href=\"javascript:snapgalaxyCheckout();\" id=\"snapgalaxy-menu-checkout\" class=\"snapgalaxy-sub-menu\">Checkout</a>";
    $html = str_replace('{CART_MENU}',$cart_menu,$html);

    $initScript = '<script language="javascript"> snapgalaxyInitializeCart(); </script>';

    $html = preg_replace("/\<\/body>/",$initScript.'</body>',$html);



    return $html;
} // end: function snapgalaxyCheckoutMenu()

function snapgalaxyImageButtons(&$imageDataArray){

    global $CONFIG;

    // Assume the image is not in the cart.
    $cartStatus = false;

    // We need to calculate the width and height of the thumbnail
    if($imageDataArray['pwidth'] > $imageDataArray['pheight']){
        $thumbwidth = $CONFIG['thumb_width'];
        $ratio = $imageDataArray['pwidth']/$thumbwidth;
        $thumbheight = ceil($imageDataArray['pheight']/$ratio);
    }else{
        $thumbheight = $CONFIG['thumb_width'];
        $ratio = $imageDataArray['pheight']/$thumbheight;
        $thumbwidth = ceil($imageDataArray['pwidth']/$ratio);
    }

    // Check to see if the image is in the cart if it is then we change the $cartStatus to true
    if($_SESSION['snapgalaxy'] && array_key_exists('cart',$_SESSION['snapgalaxy'])){
      if(array_key_exists('test',$_SESSION['snapgalaxy']['cart'])){
        $cartStatus=true;
      }
    }
    
    $mimetype = cpg_get_type($imageDataArray['filename']);
    if(($mimetype['mime'] == 'image/jpg') || ($mimetype['mime'] == 'image/jpeg')) {
      $raw = $CONFIG['site_url'] . get_pic_url($imageDataArray, 'fullsize'); // use 'thumb' to get url of a thumbnail and 'normal' to get the intermediate pic url
      $imageDataArray['caption_text'].=snapgalaxyViewAddRemoveButtons($CONFIG['site_url'].$imageDataArray['url'],$thumbwidth,$thumbheight,$raw,$imageDataArray['pwidth'],$imageDataArray['pheight'],$cartStatus);
    }      
    
    return $imageDataArray;
}

function snapgalaxyOnloadScript(&$html){
  print 'test';
  $html.="hello world";
  return $html;
}



?>
