<?php
/**************************************************
  Coppermine 1.4.x Plugin - XFeeds $VERSION$=1.3
  *************************************************
  Copyright (c) 2008 lee (www.mininoteuser.com)
  *************************************************
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 3 of the License, or
  (at your option) any later version.
  **************************************************/
  
if (!defined('IN_COPPERMINE')) die('Not in Coppermine...');

// RSS Button
$thisplugin->add_filter('gallery_header','xfd_rss_button');

// Add page start action for admin button.
$thisplugin->add_action('page_start','xfd_page_start');

// Add filter for page head
$thisplugin->add_filter('page_meta','xfd_head');

// Add plugin_install action
$thisplugin->add_action('plugin_install','xfd_install');

// Add plugin_uninstall action
$thisplugin->add_action('plugin_uninstall','xfd_uninstall');

// get settings
global $XFDSET,$lang_xfeeds;
require('./plugins/xfeed/include/load_xfdset.php');


// rss button
function xfd_rss_button()
{
global $XFDSET,$lang_xfeeds,$CONFIG;
require('./plugins/xfeed/include/init.inc.php');

$xfd_feed = "plugins/xfeed/xfeed.php";

if ($XFDSET['xfd_feedroute'] == 1) {
	$xfeed_loc = "feeds.feedburner.com/".$XFDSET['xfd_feedburnuname'];
} else {
	$xfeed_loc = "".str_replace("http://","",$CONFIG[ecards_more_pic_target]).$xfd_feed;
}

//static
$xfeed_title_enc = urlencode($CONFIG['gallery_name']);
$xfeed_author = "Admin"; // maybe get the first username in the future (gallery creator).

$html = "
<!-- BEGIN XFeeds Plugin -->
<span class=\"xfeeds\">
<form>
	<select onchange=\"if (this.selectedIndex > 0) location.href=this[this.selectedIndex].value;\">
	<option selected=\"selected\" value=\"\">".$lang_xfeeds['xfd_fe_opts']."</option>
";

if ($XFDSET['xfd_standard'] == 1) {
	$html .= "	<optgroup label=\"".$lang_xfeeds['xfd_fe_atom']."\">
	<option value=\"".$CONFIG[ecards_more_pic_target].$xfd_feed."?type=atom\">".$lang_xfeeds['xfd_fe_local_atom']."</option>
	</optgroup>
";
}

if ($XFDSET['xfd_standard'] == 1 || $XFDSET['xfd_google'] == 1 ||
$XFDSET['xfd_yahoo'] == 1 || $XFDSET['xfd_msn'] == 1 ||
$XFDSET['xfd_lines'] == 1 || $XFDSET['xfd_aol'] == 1 ||
$XFDSET['xfd_feedburn'] == 1 || $XFDSET['xfd_google'] == 1) {

$html .= "	<optgroup label=\"".$lang_xfeeds['xfd_fe_rss']."\">\n";
		
	if ($XFDSET['xfd_standard'] == 1) {
		$html .= "	<option value=\"".$CONFIG[ecards_more_pic_target].$xfd_feed."\">".$lang_xfeeds['xfd_fe_standard']."</option>\n";
	}
	if ($XFDSET['xfd_google'] == 1) {
		$html .= "	<option value=\"http://fusion.google.com/add?feedurl=http%3A//".$xfeed_loc."\">".$lang_xfeeds['xfd_fe_google']."</option>\n";
	}
	if ($XFDSET['xfd_yahoo'] == 1) {
		$html .= "	<option value=\"http://us.rd.yahoo.com/my/atm/".$xfeed_author."/".$xfeed_title_enc."http%3A//".$xfeed_loc."\">".$lang_xfeeds['xfd_fe_yahoo']."</option>\n";
	}
	if ($XFDSET['xfd_msn'] == 1) {
		$html .= "	<option value=\"http://my.msn.com/addtomymsn.armx?id=rss&amp;ut=http://".$xfeed_loc."\">".$lang_xfeeds['xfd_fe_msn']."</option>\n";
	}
	if ($XFDSET['xfd_lines'] == 1) {
		$html .= "	<option value=\"http://www.bloglines.com/sub/http://".$xfeed_loc."\">".$lang_xfeeds['xfd_fe_lines']."</option>\n";
	}
	if ($XFDSET['xfd_aol'] == 1) {
		$html .= "	<option value=\"http://feeds.my.aol.com/add.jsp?url=http://".$xfeed_loc."\">".$lang_xfeeds['xfd_fe_aol']."</option>\n";
	}
	if ($XFDSET['xfd_feedburn'] == 1) {
		$html .= "	<option value=\"http://feeds.feedburner.com/".$xfeed_loc."\">".$lang_xfeeds['xfd_fe_feedburn']."</option>\n";
	}

$html .= "	</optgroup>\n";
}

if ($XFDSET['xfd_customenable1'] == 1 || $XFDSET['xfd_customenable2'] == 1 || 
$XFDSET['xfd_customenable3'] == 1 || $XFDSET['xfd_customenable4'] == 1 || 
$XFDSET['xfd_customenable5'] == 1) {

$html .= "	<optgroup label=\"".$lang_xfeeds['xfd_fe_links']."\">\n";

	if ($XFDSET['xfd_customenable1'] == 1) {
		$html .= "	<option value=\"".$XFDSET['xfd_customurl1']."\">".$XFDSET['xfd_customtitle1']."</option>\n";
	}
	if ($XFDSET['xfd_customenable2'] == 1) {
		$html .= "	<option value=\"".$XFDSET['xfd_customurl2']."\">".$XFDSET['xfd_customtitle2']."</option>\n";
	}
	if ($XFDSET['xfd_customenable3'] == 1) {
		$html .= "	<option value=\"".$XFDSET['xfd_customurl3']."\">".$XFDSET['xfd_customtitle3']."</option>\n";
	}
	if ($XFDSET['xfd_customenable4'] == 1) {
		$html .= "	<option value=\"".$XFDSET['xfd_customurl4']."\">".$XFDSET['xfd_customtitle4']."</option>\n";
	}
	if ($XFDSET['xfd_customenable5'] == 1) {
		$html .= "	<option value=\"".$XFDSET['xfd_customurl5']."\">".$XFDSET['xfd_customtitle5']."</option>\n";
	}

$html .= "	</optgroup>\n";
}

$html .= "	</select>
	<noscript><input type=\"submit\" value=\"go\"></noscript>
</form>
</span>

<!-- END XFeeds Plugin -->
";

return $html;

}


// include header elements
function xfd_head()
{        

global $CONFIG,$thisplugin, $XFDSET;
$xfd_feed = "plugins/xfeed/xfeed.php";

switch ($XFDSET['xfd_theme']) {
case 0:
    $color = "orange";
    break;
case 1:
    $color = "azure";
    break;
case 2:
    $color = "red";
    break;
case 3:
    $color = "blue";
    break;
case 4:
    $color = "trans_dark";
    break;
case 5:
    $color = "trans_light";
    break;
}

$header = "
	<!-- Begin CPG XFeed Headcode -->
	";

if ($XFDSET['xfd_feedroute'] == 1) {
	$xfeed_loc = "feeds.feedburner.com/".$XFDSET['xfd_feedburnuname'];
	$header .= "<link rel=\"alternate\" type=\"application/rss+xml\" title=\"".$CONFIG['gallery_name']." - Feedburner\" href=\"http://".$xfeed_loc."\" />\n";
}

$header .= "	<link rel=\"alternate\" type=\"application/rss+xml\" title=\"".$CONFIG['gallery_name']." - RSS\" href=\"".$CONFIG[ecards_more_pic_target].$xfd_feed."\" />
	<link rel=\"alternate\" type=\"application/atom+xml\" title=\"".$CONFIG['gallery_name']." - Atom\" href=\"".$CONFIG[ecards_more_pic_target].$xfd_feed."?type=atom\" /> 

	<style>
		.xfeeds{background-image: url(./plugins/xfeed/images/xfeeds_".$color.".png);}
	</style>
	<link rel=\"stylesheet\" href=\"plugins/xfeed/css/xfeeds.css\" type=\"text/css\" />
	<!-- END CPG XFeed Headcode -->
	";

	return $header;

}

// add config button
function xfd_add_config_button($href,$title,$target,$link)
{
  global $template_gallery_admin_menu;
  $new_template = $template_gallery_admin_menu;
  $button = template_extract_block($new_template,'documentation');
  $params = array(
      '{DOCUMENTATION_HREF}' => $href,
      '{DOCUMENTATION_TITLE}' => $title,
      'target="cpg_documentation"' => $target,
      '{DOCUMENTATION_LNK}' => $link,
   );
   $new_button="<!-- BEGIN $link -->".template_eval($button,$params)."<!-- END $link -->\n";
   template_extract_block($template_gallery_admin_menu,'documentation',"<!-- BEGIN documentation -->" . $button . "<!-- END documentation -->\n" . $new_button);
}

function xfd_page_start()
{ 
  if (GALLERY_ADMIN_MODE) {
    xfd_add_config_button('index.php?file=xfeed/plugin_config','','','XFeeds');
  } 
}

// Install
function xfd_install()
{
                global $CONFIG, $thisplugin;
                require 'include/sql_parse.php';

                // create table
                $db_schema = $thisplugin->fullpath . '/schema.sql';
                $sql_query = fread(fopen($db_schema, 'r'), filesize($db_schema));
                $sql_query = preg_replace('/CPG_/', $CONFIG['TABLE_PREFIX'], $sql_query);
                $sql_query = remove_remarks($sql_query);
                $sql_query = split_sql_file($sql_query, ';');
                echo $sqlquery;
                foreach($sql_query as $q) { 
                  cpg_db_query($q);
                }
                
                // insert default values
                $db_schema = $thisplugin->fullpath . '/basic.sql';
                $sql_query = fread(fopen($db_schema, 'r'), filesize($db_schema));
                $sql_query = preg_replace('/CPG_/', $CONFIG['TABLE_PREFIX'], $sql_query);
                $sql_query = remove_remarks($sql_query);
                $sql_query = split_sql_file($sql_query, ';');
              
                foreach($sql_query as $q) { 
                  cpg_db_query($q);
                }

		return true;

}


// Unnstall and drop settings table
function xfd_uninstall()
{
        global $CONFIG;
        cpg_db_query("DROP TABLE IF EXISTS {$CONFIG['TABLE_PREFIX']}plugin_xfeeds");
        return true;
}

?>