<?php
#**************************************************
#  CPG PMS Plugin for Coppermine Photo Gallery
#  *************************************************
#  Copyright (c) 2006 Thomas Lange <stramm@gmx.net>
#  *************************************************
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#  *************************************************
#  Coppermine version: 1.4.13
#  CPG PMS version: 1.1
#  $Revision: 1.0 $
#  $Author: stramm $
#***************************************************


function display_messages_td($day_name,$pms_day_count,$collapse,$checkdategroup)
{
global	$id,$owner,$subject,$sender,$sender_id,$posted,$stat,$showed,$icon_type,$dategroup,$box,$CONFIG;
echo <<<EOT
<tbody id="collapseobj_pmf0_$day_name" style="$collapse">
EOT;
for ($k=0;$k<count($id);$k++)
{
	if($dategroup[$k]==$checkdategroup)
	{
	$pmid =$id[$k];
	$thisdate=date($CONFIG['pms_date_format'], $posted[$k]);
	$thistime=date($CONFIG['pms_time_format'], $posted[$k]);
	$disp_subject=stripslashes($subject[$k]);
echo <<<EOT
	<tr>
	<td class="alt1"><img src="$icon_type[$k]" alt="" border="0" /></td>
	<td class="alt2">&nbsp;&nbsp;&nbsp;</td>
	<td class="alt1Active" id="$pmid" width="100%">

		<div>
			<span style="float:right" class="smallfont">$day_name - $thisdate</span>
			<a href="index.php?file=cpg_pms/pms&id=$pmid&box=$box">$disp_subject</a>
		</div>
		<div class="smallfont">
			<span style="float:right" class="time">$thistime</span>
			<span style="cursor:pointer" onclick="window.location='profile.php?uid=$sender_id[$k]';">$sender[$k]</span>
		</div>

	</td>
	<td class="alt2" align="center" style="padding:0px"><input type="checkbox" name="messages[$pmid]" value="0_$day_name" /></td>
</tr>

EOT;
	}
}
echo <<<EOT
</tbody>
EOT;


return;
}


function format_time($timestamp, $date_only = false)
{
	global $CONFIG, $lang_pms;
	if ($timestamp == '')
		//return $lang_common['Never'];
		return "Never";
	$now = time();

	$date = date($CONFIG['pms_date_format'], $timestamp);
	$today = date($CONFIG['pms_date_format'], $now);
	$yesterday = date($CONFIG['pms_date_format'], $now - 86400);
	if ($date == $today)
		$date = $lang_pms['Today'];
	else if ($date == $yesterday)
		$date = $lang_pms['Yesterday'];

	if (!$date_only)
		return $date.' '.date($CONFIG['pms_time_format'], $timestamp);
	else
		return $date;
}


function check_date($timestamp)
{
	global $CONFIG;
	if ($timestamp == '')
		return "Never";
	$now = time();

	$date = date("Ymd", $timestamp);
	$today = date("Ymd", $now );
	$yesterday = date("Ymd", $now-86400);
	$thisweek = date("Ymd", $now-604800);
	$thismonth = date("Ymd", $now-2592000);
	if ($date == $today)
		return 0;
	else if ($date == $yesterday)
		return 1;
	else if ($date >= $thisweek)
		return 2;
	else if ($date >= $thismonth)
		return 3;

return 4;
}


function copper_htmlspecialchars($str)
{
	//$str = preg_replace('/&(?!#[0-9]+;)/s', '&amp;', $str);
	$str = str_replace(array('<', '>', '"'), array('&lt;', '&gt;', '&quot;'), $str);
	return $str;
}



function copper_trim($str)
{
	global $lang_common;

	if (strpos($lang_common['lang_encoding'], '8859') !== false)
	{
		$fishy_chars = array(chr(0x81), chr(0x8D), chr(0x8F), chr(0x90), chr(0x9D), chr(0xA0));
		return trim(str_replace($fishy_chars, ' ', $str));
	}
	else
		return trim($str);
}

function copper_linebreaks($str)
{
	return str_replace("\r", "\n", str_replace("\r\n", "\n", $str));
}


function copper_strlen($str)
{
	return strlen(preg_replace('/&#([0-9]+);/', '!', $str));
}

function get_remote_address()
{
	$remote_address = $_SERVER['REMOTE_ADDR'];

	if (!empty($_SERVER['HTTP_X_FORWARDED_FOR']))
	{
		if (preg_match_all('/[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}/', $_SERVER['HTTP_X_FORWARDED_FOR'], $address_list))
		{
			$lan_ips = array('/^0\./', '/^127\.0\.0\.1/', '/^192\.168\..*/', '/^172\.((1[6-9])|(2[0-9])|(3[0-1]))\..*/', '/^10\..*/', '/^224\..*/', '/^240\..*/');
			$address_list = preg_replace($lan_ips, null, $address_list[0]);

			while (list(, $cur_address) = each($address_list))
			{
				if ($cur_address)
				{
					$remote_address = $cur_address;
					break;
				}
			}
		}
	}

	return $remote_address;
}


//
// Make sure all BBCodes are lower case and do a little cleanup
//
function preparse_bbcode($text, &$errors, $is_signature = false)
{
	// Change all simple BBCodes to lower case
	$a = array('[B]', '[I]', '[U]', '[/B]', '[/I]', '[/U]');
	$b = array('[b]', '[i]', '[u]', '[/b]', '[/i]', '[/u]');
	$text = str_replace($a, $b, $text);

	// Do the more complex BBCodes (and strip excessive whitespace)
	$a = array( '#\[url=(.*?)\]\s*#i',
				'#\[url\]\s*#i',
				'#\s*\[/url\]#i',
				'#\[email=(.*?)\]\s*#i',
				'#\[email\]\s*#i',
				'#\s*\[/email\]#i',
				'#\[img\]\s*(.*?)\s*\[/img\]#is',
				'#\[colou?r=(.*?)\](.*?)\[/colou?r\]#is');

	$b = array(	'[url=$1]',
				'[url]',
				'[/url]',
				'[email=$1]',
				'[email]',
				'[/email]',
				'[img]$1[/img]',
				'[color=$1]$2[/color]');


	// Run this baby!
	$text = preg_replace($a, $b, $text);

		$overflow = check_tag_order($text, $error);

		if ($error)
			// A BBCode error was spotted in check_tag_order()
			$errors[] = $error;
		else if ($overflow)
			// The quote depth level was too high, so we strip out the inner most quote(s)
			$text = substr($text, 0, $overflow[0]).substr($text, $overflow[1], (strlen($text) - $overflow[0]));

	return trim($text);
}


//
// Parse text and make sure that [code] and [quote] syntax is correct
//
function check_tag_order($text, &$error)
{
	global $lang_common;

	// The maximum allowed quote depth
	$max_depth = 3;

	$cur_index = 0;
	$q_depth = 0;

	while (true)
	{
		// Look for regular code and quote tags
		$c_start = strpos($text, '[code]');
		$c_end = strpos($text, '[/code]');
		$q_start = strpos($text, '[quote]');
		$q_end = strpos($text, '[/quote]');

		// Look for [quote=username] style quote tags
		if (preg_match('#\[quote=(&quot;|"|\'|)(.*)\\1\]#sU', $text, $matches))
			$q2_start = strpos($text, $matches[0]);
		else
			$q2_start = 65536;

		// Deal with strpos() returning false when the string is not found
		// (65536 is one byte longer than the maximum post length)
		if ($c_start === false) $c_start = 65536;
		if ($c_end === false) $c_end = 65536;
		if ($q_start === false) $q_start = 65536;
		if ($q_end === false) $q_end = 65536;

		// If none of the strings were found
		if (min($c_start, $c_end, $q_start, $q_end, $q2_start) == 65536)
			break;

		// We are interested in the first quote (regardless of the type of quote)
		$q3_start = ($q_start < $q2_start) ? $q_start : $q2_start;

		// We found a [quote] or a [quote=username]
		if ($q3_start < min($q_end, $c_start, $c_end))
		{
			$step = ($q_start < $q2_start) ? 7 : strlen($matches[0]);

			$cur_index += $q3_start + $step;

			// Did we reach $max_depth?
			if ($q_depth == $max_depth)
				$overflow_begin = $cur_index - $step;

			++$q_depth;
			$text = substr($text, $q3_start + $step);
		}

		// We found a [/quote]
		else if ($q_end < min($q_start, $c_start, $c_end))
		{
			if ($q_depth == 0)
			{
				$error = $lang_common['BBCode error'].' '.$lang_common['BBCode error 1'];
				return;
			}

			$q_depth--;
			$cur_index += $q_end+8;

			// Did we reach $max_depth?
			if ($q_depth == $max_depth)
				$overflow_end = $cur_index;

			$text = substr($text, $q_end+8);
		}

		// We found a [code]
		else if ($c_start < min($c_end, $q_start, $q_end))
		{
			$tmp = strpos($text, '[/code]');
			if ($tmp === false)
			{
				$error = $lang_common['BBCode error'].' '.$lang_common['BBCode error 2'];
				return;
			}
			else
				$text = substr($text, $tmp+7);

			$cur_index += $tmp+7;
		}

		// We found a [/code] (this shouldn't happen since we handle both start and end tag in the if clause above)
		else if ($c_end < min($c_start, $q_start, $q_end))
		{
			$error = $lang_common['BBCode error'].' '.$lang_common['BBCode error 3'];
			return;
		}
	}

	// If $q_depth <> 0 something is wrong with the quote syntax
	if ($q_depth)
	{
		$error = $lang_common['BBCode error'].' '.$lang_common['BBCode error 4'];
		return;
	}
	else if ($q_depth < 0)
	{
		$error = $lang_common['BBCode error'].' '.$lang_common['BBCode error 5'];
		return;
	}

	// If the quote depth level was higher than $max_depth we return the index for the
	// beginning and end of the part we should strip out
	if (isset($overflow_begin))
		return array($overflow_begin, $overflow_end);
	else
		return null;
}


//
// Split text into chunks ($inside contains all text inside $start and $end, and $outside contains all text outside)
//
function split_text($text, $start, $end)
{
	global $CONFIG;

	$tokens = explode($start, $text);

	$outside[] = $tokens[0];

	$num_tokens = count($tokens);
	for ($i = 1; $i < $num_tokens; ++$i)
	{
		$temp = explode($end, $tokens[$i]);
		$inside[] = $temp[0];
		$outside[] = $temp[1];
	}

	return array($inside, $outside);
}


//
// Truncate URL if longer than 55 characters (add http:// or ftp:// if missing)
//
function handle_url_tag($url, $link = '')
{


	$full_url = str_replace(' ', '%20', $url);
	if (strpos($url, 'www.') === 0)			// If it starts with www, we add http://
		$full_url = 'http://'.$full_url;
	else if (strpos($url, 'ftp.') === 0)	// Else if it starts with ftp, we add ftp://
		$full_url = 'ftp://'.$full_url;
	else if (!preg_match('#^([a-z0-9]{3,6})://#', $url, $bah)) 	// Else if it doesn't start with abcdef://, we add http://
		$full_url = 'http://'.$full_url;

	// Ok, not very pretty :-)
	$link = ($link == '' || $link == $url) ? ((strlen($url) > 55) ? substr($url, 0 , 39).' &hellip; '.substr($url, -10) : $url) : stripslashes($link);

	return '<a href="'.$full_url.'">'.$link.'</a>';
}


//
// Turns an URL from the [img] tag into an <img> tag or a <a href...> tag
//
function handle_img_tag($url, $link = '')
{

global $lang_pms;

if (!$link) $link=$lang_pms['Image link'];

		$img_tag = '<img class="postimg" src="'.$url.'" alt="'.htmlspecialchars($url).'" border=0 />';

return $img_tag;
}


//
// Convert BBCodes to their HTML equivalent
//
function do_bbcode($text)
{
	global $lang_common;

	$pattern = array('#\[b\](.*?)\[/b\]#s',
					 '#\[i\](.*?)\[/i\]#s',
					 '#\[u\](.*?)\[/u\]#s',
					 '#\[url\](.*?)\[/url\]#e',
					 '#\[url=(.*?)\](.*?)\[/url\]#e',
					 '#\[img\](.*?)\[/img\]#e',
					 '#\[img=(.*?)\](.*?)\[/img\]#e',
					 '#\[email\](.*?)\[/email\]#',
					 '#\[email=(.*?)\](.*?)\[/email\]#',
					 '#\[color=([a-zA-Z]*|\#?[0-9a-fA-F]{6})](.*?)\[/color\]#s');

	$replace = array('<strong>$1</strong>',
					 '<em>$1</em>',
					 '<u>$1</u>',
					 'handle_url_tag(\'$1\')',
					 'handle_url_tag(\'$1\', \'$2\')',
					 'handle_img_tag(\'$1\')',
					 'handle_img_tag(\'$1\', \'$2\')',
					 '<a href="mailto:$1">$1</a>',
					 '<a href="mailto:$1">$2</a>',
					 '<span style="color: $1">$2</span>');

	// This thing takes a while! :)
	$text = preg_replace($pattern, $replace, $text);

	if (strpos($text, 'quote') !== false)
	{
		$text = str_replace('[quote]', '<fieldset style=\"background: #f5f5f5; margin: 0px 0px 10px 20px; padding: 5px 0px 5px 5px\"><em>Quote</em>:<br /><br />', stripslashes($text));
		$text = preg_replace('#\[quote=(&quot;|"|\'|)(.*)\\1\]#seU', '"<fieldset style=\"background: #f5f5f5; margin: 0px 0px 10px 20px; padding: 5px 0px 5px 5px\"><em>Quote from <strong>".str_replace(\'[\', \'&#91;\', \'$2\')." :</strong></em><br /><br />"', stripslashes($text));
		$text = preg_replace('#\[\/quote\]\s*#', '</fieldset>', stripslashes($text));

	}

	return $text;
}






//
// Make hyperlinks clickable
//
function do_clickable($text)
{

	$text = ' '.$text;

	$text = preg_replace('#([\s\(\)])(https?|ftp|news){1}://([\w\-]+\.([\w\-]+\.)*[\w]+(:[0-9]+)?(/[^"\s\(\)<\[]*)?)#ie', '\'$1\'.handle_url_tag(\'$2://$3\')', $text);
	$text = preg_replace('#([\s\(\)])(www|ftp)\.(([\w\-]+\.)*[\w]+(:[0-9]+)?(/[^"\s\(\)<\[]*)?)#ie', '\'$1\'.handle_url_tag(\'$2.$3\', \'$2.$3\')', $text);

	return substr($text, 1);
}




//
// Parse message text
//
function parse_message($text, $hide_smilies)
{
	global $CONFIG, $lang_common;


	// Convert applicable characters to HTML entities
	$text = copper_htmlspecialchars($text);

	// If the message contains a code tag we have to split it up (text within [code][/code] shouldn't be touched)
	if (strpos($text, '[code]') !== false && strpos($text, '[/code]') !== false)
	{
		list($inside, $outside) = split_text($text, '[code]', '[/code]');
		$outside = array_map('ltrim', $outside);
		$text = implode('<">', $outside);
	}

	if ($CONFIG['pms_make_links'] == '1')
		$text = do_clickable($text);

	if ($CONFIG['pms_smilies'] == '1' && $hide_smilies == '0')
		//$text = do_smilies($text);

		$text = process_smilies($text);

	if ($CONFIG['pms_message_bbcode'] == '1' && strpos($text, '[') !== false && strpos($text, ']') !== false)
	{
		$text = do_bbcode($text);

		if ($CONFIG['pms_message_img_tag'] == '1')
		{
//			$text = preg_replace('#\[img\]((ht|f)tps?://)([^\s<"]*?)\.(jpg|jpeg|png|gif)\[/img\]#e', 'handle_img_tag(\'$1$3.$4\')', $text);
			$text = preg_replace('#\[img\]((ht|f)tps?://)([^\s<"]*?)\[/img\]#e', 'handle_img_tag(\'$1$3\')', $text);
		}
	}

	// Deal with newlines, tabs and multiple spaces
	$pattern = array("\n", "\t", '  ', '  ');
	$replace = array('<br />', '&nbsp; &nbsp; ', '&nbsp; ', ' &nbsp;');
	$text = str_replace($pattern, $replace, $text);

	// If we split up the message before we have to concatenate it together again (code tags)
	if (isset($inside))
	{
		$outside = explode('<">', $text);
		$text = '';

		$num_tokens = count($outside);

		for ($i = 0; $i < $num_tokens; ++$i)
		{
			$text .= $outside[$i];
			if (isset($inside[$i]))
			{
				$num_lines = ((substr_count($inside[$i], "\n")) + 3) * 1.5;
				$height_str = ($num_lines > 35) ? '35em' : $num_lines.'em';
				$text .= '</p><div class="codebox"><div class="incqbox"><h4>'.$lang_common['Code'].':</h4><div class="scrollbox" style="height: '.$height_str.'"><pre>'.$inside[$i].'</pre></div></div></div><p>';
			}
		}
	}

	// Add paragraph tag around post, but make sure there are no empty paragraphs
	$text = str_replace('<p></p>', '', '<p>'.$text.'</p>');

	return $text;
}



?>