<?php
/**
 * flf zwitscher
 *
 * Plugin Written by Florian Lechner - http://www.lounge-lizard.org
 * 27 February 2010
*/
if (!defined('IN_COPPERMINE')) die('Not in Coppermine...');

global $CONFIG, $lang_plugin_zwitscher;
require_once('plugins/flf_zwitscher/init.inc.php');
$flf_zwitscher_init_array = flf_zwitscher_initialize();
$lang_plugin_zwitscher = $flf_zwitscher_init_array['language']; 

$thisplugin->add_filter('add_file_data_success','flf_zwitscher_update_pic');
$thisplugin->add_action('plugin_install','flf_zwitscher_install');
$thisplugin->add_action('plugin_uninstall','flf_zwitscher_uninstall');


function flf_zwitscher_update_pic($data){
	// Generate a text <New Image uploaded in album 'album'. Visit <make tinyurl>
	
	global $CONFIG, $CURRENT_PIC, $lang_plugin_zwitscher;

	
	$id= $data['pid'];
	$aid= $data['aid'];
	$album=get_album_name($aid);

	if ($CONFIG['plugin_flf_zwitscher_privatealbums']=='0') {
		// Check if Album is protected; if it is: don't send twitter update
		if (album_is_private($aid)==true) {
			// no update!
			echo $lang_plugin_zwitscher['noupdate'];
			return $data;
			
		}
	}
	
	
	$twittertext=$lang_plugin_zwitscher['newimage']. ' '.$album['title'].' ';
	if (strlen($data['title'])>0) {
		$twittertext=$twittertext."('".$data['title']."')";
	}
	$url=$CONFIG['site_url'].'thumbnails.php?album='.$aid;
	
	$tweet=new twitter();
	$tweet->username=$CONFIG['plugin_flf_zwitscher_username'];
	$tweet->password=base64_decode($CONFIG['plugin_flf_zwitscher_password']);
	$tweet->user_agent="Coppermine plugin flf_zwitscher - contact ".$CONFIG['gallery_admin_email'];
	$tinyurl=$tweet->shorturl($url);
	$twittertext=shortentweet($twittertext,$tinyurl);

	$tweet->update($twittertext);
	echo $lang_plugin_zwitscher['update'];
	return $data;
	


	
}
	
	
function flf_zwitscher_install($data){
	
	require_once('plugins/flf_zwitscher/include/zwitscher_install.php');
	$retval=flf_enter_base_config();
	return $retval;

}

function flf_zwitscher_uninstall($data){
		require_once('plugins/flf_zwitscher/include/zwitscher_install.php');
		global $CONFIG, $thisplugin;
		
		$retval=flf_delete_base_config();	
   
	    return $retval;
}







?>