/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.filedata;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.exception.JUploadExceptionTooBigFile;
import wjhk.jupload2.exception.JUploadIOException;
import wjhk.jupload2.filedata.FileData;
import wjhk.jupload2.policies.UploadPolicy;
import wjhk.jupload2.upload.helper.ByteArrayEncoder;

public class DefaultFileData
implements FileData {
    UploadPolicy uploadPolicy;
    boolean preparedForUpload = false;
    protected String mimeType = "application/octet-stream";
    private File file;
    private long fileSize;
    private String fileDir;
    private String fileRoot = "";
    private Date fileModified;
    private Boolean canRead = null;

    public DefaultFileData(File file, File root, UploadPolicy uploadPolicy) {
        this.file = file;
        this.uploadPolicy = uploadPolicy;
        this.fileSize = this.file.length();
        this.fileDir = this.file.getAbsoluteFile().getParent();
        this.fileModified = new Date(this.file.lastModified());
        if (null != root) {
            this.fileRoot = root.getAbsolutePath();
            uploadPolicy.displayDebug("Creation of the DefaultFileData for " + file.getAbsolutePath() + "(root: " + root.getAbsolutePath() + ")", 10);
        } else {
            uploadPolicy.displayDebug("Creation of the DefaultFileData for " + file.getAbsolutePath() + "(root: null)", 10);
        }
        this.mimeType = this.uploadPolicy.getContext().getMimeType(this.getFileExtension());
    }

    public void appendFileProperties(ByteArrayEncoder bae, int index) throws JUploadIOException {
        bae.appendTextProperty("mimetype", this.getMimeType(), index);
        bae.appendTextProperty("pathinfo", this.getDirectory(), index);
        bae.appendTextProperty("relpathinfo", this.getRelativeDir(), index);
        SimpleDateFormat dateformat = new SimpleDateFormat(this.uploadPolicy.getDateFormat());
        String uploadFileModificationDate = dateformat.format(this.getLastModified());
        bae.appendTextProperty("filemodificationdate", uploadFileModificationDate, index);
    }

    public synchronized void beforeUpload() throws JUploadException {
        if (this.preparedForUpload) {
            throw new IllegalStateException("The file " + this.getFileName() + " is already prepared for upload");
        }
        this.preparedForUpload = true;
        if (this.getUploadLength() > this.uploadPolicy.getMaxFileSize()) {
            throw new JUploadExceptionTooBigFile(this.getFileName(), this.getUploadLength(), this.uploadPolicy);
        }
    }

    public long getUploadLength() throws JUploadException {
        if (!this.preparedForUpload) {
            throw new IllegalStateException("The file " + this.getFileName() + " is prepared for upload");
        }
        return this.fileSize;
    }

    public synchronized void afterUpload() {
        if (!this.preparedForUpload) {
            throw new IllegalStateException("The file " + this.getFileName() + " is not prepared for upload");
        }
        this.preparedForUpload = false;
    }

    public synchronized InputStream getInputStream() throws JUploadException {
        if (!this.preparedForUpload) {
            throw new IllegalStateException("The file " + this.getFileName() + " is not prepared for upload");
        }
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new JUploadIOException(e);
        }
    }

    public String getFileName() {
        return this.file.getName();
    }

    public String getFileExtension() {
        return DefaultFileData.getExtension(this.file);
    }

    public long getFileLength() {
        return this.fileSize;
    }

    public Date getLastModified() {
        return this.fileModified;
    }

    public String getDirectory() {
        return this.fileDir;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public boolean canRead() {
        if (this.canRead == null) {
            try {
                FileInputStream is = new FileInputStream(this.file);
                ((InputStream)is).close();
                this.canRead = true;
            }
            catch (IOException e) {
                this.canRead = false;
            }
        }
        return this.canRead;
    }

    public File getFile() {
        return this.file;
    }

    public String getRelativeDir() {
        if (null != this.fileRoot && !this.fileRoot.equals("") && this.fileDir.startsWith(this.fileRoot)) {
            int skip = this.fileRoot.length();
            if (!this.fileRoot.endsWith(File.separator)) {
                ++skip;
            }
            if (skip >= 0 && skip < this.fileDir.length()) {
                return this.fileDir.substring(skip);
            }
        }
        return "";
    }

    public static String getExtension(File file) {
        String name = file.getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public static File getRoot(File[] fileArray) {
        File root;
        for (root = fileArray[0].getParentFile(); root != null && !root.isDirectory(); root = root.getParentFile()) {
        }
        if (root != null) {
            String pathRoot = root.getAbsolutePath();
            for (int i = 1; i < fileArray.length; ++i) {
                String pathCurrentFileParentPath;
                File pathCurrentFileParent;
                for (pathCurrentFileParent = fileArray[i]; pathCurrentFileParent != null && !pathCurrentFileParent.isDirectory(); pathCurrentFileParent = pathCurrentFileParent.getParentFile()) {
                }
                if (pathCurrentFileParent == null || (pathCurrentFileParentPath = pathCurrentFileParent.getAbsolutePath()).startsWith(pathRoot)) continue;
                if (pathRoot.startsWith(pathCurrentFileParentPath)) {
                    pathRoot = pathCurrentFileParentPath;
                    continue;
                }
                char[] rootPathChars = pathRoot.toCharArray();
                char[] currentFileParentPathChars = pathCurrentFileParentPath.toCharArray();
                StringBuffer commonPath = new StringBuffer(Math.max(rootPathChars.length, currentFileParentPathChars.length));
                for (int j = 0; j < pathRoot.length() && j < pathCurrentFileParentPath.length() && rootPathChars[j] == currentFileParentPathChars[j]; ++j) {
                    commonPath.append(rootPathChars[j]);
                }
                root = new File(commonPath.toString());
                break;
            }
            root = new File(pathRoot);
        }
        return root;
    }

    public boolean isPreparedForUpload() {
        return this.preparedForUpload;
    }
}

