<?php
/*
 *******************************************
 plugin JUpload for Coppermine Photo Gallery
 *******************************************

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 ********************************************
 $Revision: 547 $
 $Author: $
 $Date: 2009-10-22 19:10:24 +0200 (jeu., 22 oct. 2009) $
 ********************************************
 *
 * Allows easy upload to the gallery, through a java applet. 
 * 
 * Up to date version of this script can be retrieved with the full JUpload package, here:
 * 
 * http://etienne.sf.free.fr/wiki
 * 
 * Directly here:
 * http://forum.coppermine-gallery.net/index.php/board,100.0.html
 * 
 * Support is available on this forum:
 * http://coppermine-gallery.net/forum/index.php?topic=43432
 * 
 * The applet is published on sourceforge:
 * http://jupload.sourceforge.net
 * 
 */


if (!defined('IN_COPPERMINE')) die('Not in Coppermine...');



////////////////////////////////////////////////////////////////////////////////////////////////// 
///////////////////////////   Creation of the JUpload button ///////////////////////////////////// 
/////////////////////  Largely inspired from the photo_summary plugin //////////////////////////// 
////////////////////////////////////////////////////////////////////////////////////////////////// 

$thisplugin->add_action('plugin_wakeup','jupload_plugin_wakeup'); // ( ...when initialized )
$thisplugin->add_action('page_start','jupload_page_start');
$thisplugin->add_filter('add_file_data','jupload_add_file_data');

/**
 * The wakeup is the good place to include files...
 * 
 * But it doesn't seem to suit our needs, so, in jupload_page_start:
 * - define('JUPLOAD_PHP', true) is done in jupload.php
 * - include of jupload.inc.php is done in jupload_page_start
 */
function jupload_plugin_wakeup() {
/*	if (!defined('JUPLOAD_PHP')) {
		define('JUPLOAD_PHP', true);
		require_once('plugins/jupload/include/jupload.inc.php');
	}	
*/
	return true;
}

//This code comes from a sample, given by Sami to Frantz.
//Thanks to both of you !   ;-)
function jupload_page_start()
{
	global $template_sys_menu, $USER, $lang_jupload_php, $JUPLOAD_CONFIG, $superCage;
	global $album, $category, $jupload_may_see_jupload_link, $jupload_user_may_use_jupload;
	
	if (!defined('JUPLOAD_PHP')) {
		define('JUPLOAD_PHP', true);
		require_once('plugins/jupload/include/jupload.inc.php');
	}	
	
	if ($jupload_may_see_jupload_link) {
		$jupload_section = 'jupload';
		$linkComment = ('' != $JUPLOAD_CONFIG['linkComment']) 
								? $JUPLOAD_CONFIG['linkComment'] 
								: $lang_jupload_php['link_comment'];  
		$linkTitle   = ('' != $JUPLOAD_CONFIG['linkTitle'])   
								? $JUPLOAD_CONFIG['linkTitle']   
								: $lang_jupload_php['link_title'];  
		//For CPG1.5, we need some extra work.
		if (isset($superCage)) {
			$category = getSuperCageInt('category', -1);
			if ($category < 0) {
				$category = getSuperCageInt('cat', -1);				
			} 
			$album = getSuperCageInt('album', -1); 
		} else {
			$category = (isset($_GET['cat'])) 
							? (int)$_GET['cat'] 
							: (
								isset($_GET['category']) 
									? (int)$_GET['category'] 
									: -1
								);
			$album = isset($_GET['album']) ? (int)$_GET['album'] : -1;
		}
		$url = 'index.php?file=jupload/jupload'
			.  ( $category>0 ? "&category=$category" : '')
			.  ( $album>0    ? "&album=$album"       : '')
			;


		//The upload_pic button always exist in $template_sys_menu. The question is just to know if it should
		//be hidden o not ... after the call of this function.
		//We use it as the template for our JUpload button.
		//as template_extract_block changes the given template, we use a opy of the original one 
		$base_template = $template_sys_menu;
		$standard_upload_button = template_extract_block($base_template,'upload_pic');
		//echo("<PRE>$standard_upload_button</PRE><BR>");
		$params = array(
			'{UPL_PIC_LNK}'   => $linkTitle,
			'{UPL_PIC_TITLE}' => $linkComment,
			'{UPL_PIC_TGT}'   => $url,
			'upload_pic'  => $jupload_section,
		);

		//template_eval needs that $params parameters correspond to the given $button.
		$jupload_button = "<!-- BEGIN $jupload_section -->".template_eval($standard_upload_button,$params)."<!-- END $jupload_section -->";
		//echo("<HR><PRE>$jupload_button</PRE><HR><BR>");
		
		//A patch for the 'hardwired' theme, that need the themes/hardwired/images/buttonleftJUpload.gif image
		//This image, of course (hum .. jupload should be everywhere ;-) ), doesn't exist in this theme. So we
		//replace by the faq.gif picture.
		$jupload_button = str_replace('jupload.gif', 'up.gif', $jupload_button);

		//Now: let's build our jupload button.
		//It will contain the standard upload button or not, depending on the answer to these two questions:
		// 1) Should we keep the standard upload button or not ?
		// 2) May the user upload picture? If not, we let Coppermine remove the button.
		if ($JUPLOAD_CONFIG['linkKeepStandardUpload'] || !USER_CAN_UPLOAD_PICTURES) {
			$jupload_button =  "<!-- BEGIN upload_pic -->"
									. $standard_upload_button
									. "<!-- END upload_pic -->\n"
									. $jupload_button;
		}

		//Let's insert the new button in place of the standard upload link. The new button may contain or
		//not the standard upload button, depending on the previous choice.
		template_extract_block($template_sys_menu, 'upload_pic', $jupload_button);
	}
	
	return true;
}


/**
 * Last possible action, just before the insert into the database. If a failure should occur, it's up to this
 * hook to remove picture (or other) files.
 */
function jupload_add_file_data($CURRENT_PIC_DATA) {
	global $JUPLOAD_CONFIG, $jupload_original_file_name;
	
	logDebug("[jupload_add_file_data] Entering function");

	//If the following condition are met, we create a default title:
	//  - We are within JUpload upload (and not only test of: the plugin is installed), as I want no impact
	//   on standard upload.
	//  - The title was not defined, 
	//  - The JUpload config ask for creation of a default title.  	
	if (defined('JUPLOAD_PHP_in_upload_picture')) {
	    // If the title is still empty, a default title is generated.
		if ($CURRENT_PIC_DATA['title'] == '' && $JUPLOAD_CONFIG['generateDefaultPictureTitle']) {
		    // Analyze the file extension using regular expressions.
		    logDebug("[jupload_add_file_data] Reading jupload_original_file_name ($jupload_original_file_name)");
		    if (!preg_match("/(.+)\.(.*?)\Z/", $jupload_original_file_name, $fmatches)) {
		    	//The regular expression is taken from the previously called Coppermine function.
		    	//So, how can it be, that we got here ????????
		    	return jupload_cpg_die(ERROR, "[jupload_add_file_data] Internal error while reading the extension, for file '${CURRENT_PIC_DATA['filename']}'", __FILE__, __LINE__);
		    }
			$CURRENT_PIC_DATA['title'] = addslashes(str_replace("_", " ", rawurldecode($fmatches[1])));
	    }
	}//if (defined('JUPLOAD_PHP_in_upload_picture'))

	logDebug("[jupload_add_file_data] End of function");
	return $CURRENT_PIC_DATA;
}

