<?php
/* 
 *******************************************
 plugin JUpload for Coppermine Photo Gallery
 *******************************************

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 ********************************************
 $Revision: 185 $
 $Author: etienne_sf $
 $Date: 2008-03-12 20:26:16 +0100 (mer., 12 mars 2008) $
 ********************************************
 *
 * Allows easy upload to the gallery, through a java applet. 
 * 
 * Up to date version of this script can be retrieved with the full JUpload package, here:
 * 
 * http://etienne.sf.free.fr/wiki
 * 
 * Directly here:
 * http://forum.coppermine-gallery.net/index.php/board,100.0.html
 * 
 * Support is available on this forum:
 * http://coppermine-gallery.net/forum/index.php?topic=43432
 * 
 * The applet is published on sourceforge:
 * http://jupload.sourceforge.net
 * 
 */

/**
 * This file contains all common functions, used by the graphical user interface (gui) of the jupload.php script.
 * 
 * It could be reused by other scripts: these fuctions are copy/paste from the main scripts (like upload.php)
 * 
 */

if (!defined('IN_COPPERMINE')) { die('Not in Coppermine...');}
if (!defined('JUPLOAD_PHP')) { 
	die('Not in JUpload...<BR><BR><BR>Check that the plugin is actually installed (from the Coppermine Plugin Manager)');
}

/**
 * Contribution coming from AWJunkies. 
 * 
 * This function displays a bar, indicating to the user the part of his quota that 
 * he is using, by a progress-bar.
 * 
 * Opens all data for the users quota
 * 
 * Main changes: 
 * - Must be called within an existing table (no table creation in this function)
 * - Translation added (text are within jupload text array)
 * - Some adjustement (less colors, white background), to be compatible with themes.
 * - Removed the link to the upgrade.php script. 
 */
function jupload_startquotadata(){
	global $CONFIG, $USER_DATA, $lang_jupload_php;
	
	$results = cpg_db_query("SELECT sum(total_filesize) FROM {$CONFIG['TABLE_PICTURES']} WHERE owner_id = " . USER_ID);
	$record = mysql_fetch_array($results);
	        $total_space_used = $record[0];
			$total_space_used = round($total_space_used / 1048576, 2);
			$quota = $USER_DATA['group_quota'];
	$quota = round($quota/1024, 2);
	if ($quota == 0) {
		//User has no quota, so don't display quota message.
	} else {
		$percentage = round(100 * ($total_space_used / $quota), 2);
		if($percentage < 60) {
			$color = '#00A000';
			//$color1 = '#FFFFFF';
			$quota_about_full = '';
		} else if ($percentage < 80) {
			$color = '#FFD300';
			//$color1 = '#FFD300';
			$quota_about_full = '';
		} else {
			$color = '#FF0000';
			//$color1 = '#FF0000';
			$quota_about_full = $lang_jupload_php['quota_about_full'];
		}

		$prog_width = round($percentage, 0);
		if ($prog_width > 100) {
			$prog_width = 100;
		}

		$text = //str_replace(
				//	'$color1', 
				//	$color1, 
					str_replace(
						'$1', 
						$total_space_used, 
						str_replace(
							'$2', 
							$percentage, 
							str_replace('$3', $quota, $lang_jupload_php['quota_used'])))
				//	)
				;
	
		form_statement("$text $quota_about_full");

		echo <<<EOS
	<tr>
		<td class="tableb" colspan=2>
			<div align="left" style="display:block; background-color:#FFFFFF; margin-top:5px; margin-bottom:5px; width:100%; border:1px solid #000000; height:10px;">
				<div align="left" style="display:block; background-color:$color; width:$prog_width%; height:10px; color:#000000;">
				</div>
			</div>
		</td>
	</tr>
	<BR>
EOS
;
	}
}


//This function displays the success message resulting of an action (creation or modification of album for instance)
function jupload_message_success ($action, $album = 0, $category=0) {
	global $lang_jupload_php, $lang_login_php, $lang_continue;
	$url = "index.php?file=jupload/jupload&action=$action" 
		. ( ($album>0) ? "&album=$album" : '')
		. ( ($category>0) ? "&category=$category" : '');
    pageheader($lang_login_php['success'], '<META http-equiv="refresh" content="3;url=' . $url . '">');
    msg_box($lang_jupload_php['success'], $lang_jupload_php['success'], $lang_continue, $url);
    pagefooter();
    exit;
}

function create_form(&$data)
{
        foreach($data as $element){
                if ((is_array($element))) {
                    switch($element[2]){
                            case 0 :
                                    form_input($element[0], $element[1], $element[3]);
                                    break;
                            case 1 :
                                    form_alb_list_box($element[0], $element[1]);
                                    break;
                            case 1.1 : //Specific form_alb_list_box_pic function, from the editpics.php script
                                    form_alb_list_box_pic($element[0], $element[1]);
                                    break;
                            case 2 :
                                    form_textarea($element[0], $element[1], $element[3]);
                                    break;
                            case 3 :
                                    form_pic_info($element[0]);
                                    break;
                            case 4 :
                                    form_options();
                                    break;
                            case 5 :
                                    form_hidden($element[0], $element[1]);
                                    break;
                            case 6: //Specific to JUpload. The content of the cell (td tag) is given
                            		//in the $element[0] parameter.
                            		//The $element[1] is optional. It contains the content of the left column.
                            		form_html($element[0], $element[1]);
                            		break;
                            default:
                                        cpg_die(CRITICAL_ERROR, 'Invalid action for form creation', __FILE__, __LINE__);
                    } // switch
                } else {
                        form_label($element);
                }
        }
}


// The function to create the album list drop down.
//etienne_sf(JUpload) : add of the $jsEvent parameter : it allows the caller to precise a javascript event, 
 //like onChange. 
function form_alb_list_box($text, $name, $jsEvent='') {
// frogfoot re-wrote this function to present the list in categorized, sorted and nicely formatted order

    // Pull the $CONFIG array and the GET array into the function
    global $CONFIG, $lang_upload_php, $lang_jupload_php, $album;

    // Also pull the album lists into the function
    global $user_albums_list, $public_albums_list;

    // Create the opening of the drop down box
    echo <<<EOT
    <tr>
        <td class="tableb">
            $text
        </td>
        <td class="tableb" valign="top">
            <select name="$name" class="listbox" $jsEvent>

EOT;

    // Reset counter
    $list_count = 0;

    // Cycle through the User albums
    foreach($user_albums_list as $a) {

        // Add to multi-dim array for later sorting
        $listArray[$list_count]['cat'] = $lang_upload_php['personal_albums'];
        $listArray[$list_count]['aid'] = $a['aid'];
        $listArray[$list_count]['title'] = $a['title'];
        //EGR : add of the description to this interesting array.
        $listArray[$list_count]['description'] = $a['description'];
        $list_count++;
    }

    // Cycle through the public albums
    foreach($public_albums_list as $a) {

        // Set $a to the real album ID
        $aid = $a['aid'];

        // Get the category name
        $vQuery = "SELECT cat.name "
        		. " FROM " . $CONFIG['TABLE_CATEGORIES'] . " cat, " . $CONFIG['TABLE_ALBUMS'] . " alb " 
        		. " WHERE alb.aid='" . $aid . "' AND cat.cid=alb.category";
        $vRes = cpg_db_query($vQuery);
        $vRes = mysql_fetch_array($vRes);

        // Add to multi-dim array for sorting later
        if ($vRes['name']) {
            $listArray[$list_count]['cat'] = $vRes['name'];
        } else {
            $listArray[$list_count]['cat'] = $lang_upload_php['albums_no_category'];
        }
        $listArray[$list_count]['aid'] = $a['aid'];
        $listArray[$list_count]['title'] = $a['title'];
        $listArray[$list_count]['description'] = $a['description'];
        $list_count++;
    }

    // Sort the pulldown options by category and album name
    $listArray = array_csort($listArray,'cat','title');

    // Finally, print out the nicely sorted and formatted drop down list
    $alb_cat = '';
	echo '                <option value="">' . $lang_upload_php['select_album'] . "</option>\n";
    foreach ($listArray as $val) {
        if ($val['cat'] != $alb_cat) {
			if ($alb_cat) echo "                </optgroup>\n";
            echo '                <optgroup label="' . $val['cat'] . '">' . "\n";
            $alb_cat = $val['cat'];
        }
        echo '                <option value="' . $val['aid'] . '"' . ( ($val['aid'] == $album) ? ' SELECTED' : '') . '>   ' . $val['title'] . "</option>\n";
    }
    if ($alb_cat) echo "                </optgroup>\n";

    // Close the drop down
    echo <<<EOT
            </select>
        </td>
    </tr>

EOT;
}


// The function to create the album list drop down, for one category.
//etienne_sf(JUpload) : add of the $jsEvent parameter : it allows the caller to precise a javascript event, 
 //like onChange. 
function form_cat_alb_list_box($cat, $album, $text, $name, $jsEvent='') {

    // Pull the $CONFIG array and the GET array into the function
    global $CONFIG, $lang_upload_php, $lang_jupload_php, $album;

    // Also pull the album lists into the function
    global $user_albums_list, $public_albums_list;

    // Create the opening of the drop down box
    echo <<<EOT
    <tr>
        <td class="tableb">
            $text
        </td>
        <td class="tableb" valign="top">
            <select name="$name" class="listbox" $jsEvent>
		        <option value="">${lang_upload_php['select_album']}</option>
            </select>
            <img name="album_wait" src="plugins/jupload/resources/ajax-loader.gif" width=0 height=0>
            <script language="javascript">
EOT;
	//I fill the album's list with a javascript code, to use the same code as the AJAX call.
	jsFillAlbumList($cat, $album);
    echo <<<EOT
            </script>
        </td>
    </tr>

EOT;
}


//An evolution of the form_alb_list_box function, adapated for the jupload/edit_uploaded_pic.php script
//It is taken from the editpics.php, and renamed. 
//See the form_alb_list_box function, to know how to call it.  
function form_alb_list_box_pic($text, $name)
{
	global $CURRENT_PIC;
	return form_alb_list_box($text, $name . $CURRENT_PIC['pid']);
/*
        global $CONFIG, $CURRENT_PIC;
        global $user_albums_list, $public_albums_list;

        $sel_album = $CURRENT_PIC['aid'];

        $name .= $CURRENT_PIC['pid'];
        echo <<<EOT
        <tr>
            <td class="tableb" style="white-space: nowrap;">
                        $text
        </td>
        <td class="tableb" valign="top">
                <select name="$name" class="listbox">

EOT;
                foreach($public_albums_list as $album) {
        echo '              <option value="' . $album['aid'] . '"' . ($album['aid'] == $sel_album ? ' selected' : '') . '>' . $album['cat_title'] . "</option>\n";
    }
                foreach($user_albums_list as $album){
                        echo '                        <option value="'.$album['aid'].'"'.($album['aid'] == $sel_album ? ' selected' : '').'>* '.$album['title'] . "</option>\n";
                }
        echo <<<EOT
                        </select>
                </td>
        </tr>

EOT;
*/
}

function form_hidden($name, $value, $text = '')
{
    global $CURRENT_PIC;

    $value = $CURRENT_PIC[$name];
    $name .= $CURRENT_PIC['pid'];
    
	//echo("<input type='hidden' name='$name' value='$value' />");

    echo <<<EOT
        <tr>
            <td class="tableb" style="white-space: nowrap;">
                        $text
        </td>
        <td width="100%" class="tableb" valign="top">
                <input type='hidden' name='$name' value='$value' />
                </td>
        </tr>

EOT;
}

/**
 * This functions is specific to JUpload (but should not be).
 * It creates a new line on the main page table. Its content is the HTML given in parameter.
 */
function form_html ($html, $text='') {
    echo <<<EOT
        <tr>
            <td width="40%" class="tableb" style="white-space: nowrap;">$text</td>
        	<td class="tableb" valign="top">$html</td>
        </tr>
EOT;
}

function form_input($text, $name, $max_length,$field_width=100)
{
    global $CURRENT_PIC;

    $value = $CURRENT_PIC[$name];
    $name .= $CURRENT_PIC['pid'];
    if ($text == '') {
        echo "        <input type=\"hidden\" name=\"$name\" value=\"\" />\n";
        return;
    }

    echo <<<EOT
        <tr>
            <td class="tableb" style="white-space: nowrap;">
                        $text
        </td>
        <td width="100%" class="tableb" valign="top">
                <input type="text" style="width: {$field_width}%" name="$name" maxlength="$max_length" value="$value" class="textinput" />
                </td>
        </tr>

EOT;
}

// The form label creation function. Takes a non-array element form $data as its argument.
//if $replace1 is given, all occurences of $1 is replaced by it (I don't like printf functions) 
function form_label($text, $replace1='') {
	if ($replace1 != '') {
		$t = str_replace('$1', $replace1, $text);
	} else {
		$t = $text;
	}
    echo <<<EOT
        <tr>
                <td class="tableh2" colspan="2">
                        <b>$t</b>
                </td>
        </tr>

EOT;
}

// The form statement creation function. Takes a non-array element form $data as its argument.
function form_statement($text) {
    echo <<<EOT
        <tr>
                <td class="tableb" colspan="2">
                        $text
                </td>
        </tr>

EOT;
}

function form_textarea($text, $name, $max_length)
{
        global $ALBUM_DATA, $CURRENT_PIC;

        $value = $CURRENT_PIC[$name];

        $name .= $CURRENT_PIC['pid'];
        echo <<<EOT
        <tr>
                <td class="tableb" valign="top" style="white-space: nowrap;">
                        $text
                </td>
                <td class="tableb" valign="top">
                        <textarea name="$name" rows="5" cols="40" class="textinput" style="width: 100%;" onkeydown="textCounter(this, $max_length);" onkeyup="textCounter(this, $max_length);">$value</textarea>
                </td>
        </tr>
EOT;
}


// The hidden form input function. Takes the hidden input field name and value.
function hidden_input($name, $value) {
        echo <<<EOT
        <tr>
            <td colspan="2">
                   <input type="hidden" name="$name" value="$value" />
            </td>
        </tr>

EOT;
}

// The text box form input function. Takes the text label for the box, the input name, the maximum length for text boxes,
// and the number of iterations.
function text_box_input($text, $name, $max_length, $iterations, $default='') {

    global $CONFIG;

    $ordinal = '';

    if (($text == '') and ($iterations == '')) {
        echo "        <input type=\"hidden\" name=\"$name\" value=\"$default\" />\n";
        return;
    }

    // Begin loop
    for ($counter=0; $counter<$iterations; $counter++) {

    // Create a numbering system when necessary.
    if ($text == '') {
        $cardinal = $counter + 1;
        $ordinal = "".$cardinal.". ";
    }

    // Create a text box.
    echo <<<EOT
        <tr>
            <td width="40%" class="tableb">
                        $text  $ordinal
        </td>
        <td width="60%" class="tableb" valign="top">
                <input type="text" style="width: 100%" name="$name" maxlength="$max_length" value="$default" class="textinput" />
                </td>
        </tr>

EOT;
    }
}

/**
 * The select form input function. Takes the text label for the box, the input name, the values array and the
 * text array. If the text is not given to the function, the values are displayed to the user.
 * 
 * @param $text The text to display on the HTML page, before the list box
 * @param $name The name of the select input
 * @param $selectedValue The value that is currently selected (not the index)
 * @param @values an array of values, for the list.
 * @param @texts an optional array of text, to be displayed instead of value (if given)
 * @param @jsEvent A javascrip even, to be added to the select tag.
 * 
 */
function select_input($text, $name, $selectedValue, $values, $texts='', $jsEvent='') {
    global $CONFIG;
    
    if (!is_array($values)) {
    	cpg_die('select_input: given $values is not an array !');
    }
    
    if ($texts == '') {
    	$texts = $values;
    }

    // Create a text box.
    echo <<<EOT
        <tr>
            <td width="40%" class="tableb">
                        $text
        </td>
        <td width="60%" class="tableb" valign="top">
                <select name="$name" class="listbox" $jsEvent>

EOT;

    // Begin loop
    for ($counter=0; $counter<count($values); $counter++) {
    	$selected = ($values[$counter] == $selectedValue) ? 'selected' : '';
    	echo("                	<option value='${values[$counter]}' $selected>${texts[$counter]}</option>\n");
    }

    echo <<<EOT
                </select>
                </td>
        </tr>

EOT;
}


// The function for text areas on forms. Takes the label, field name, and maximum length as arguments.
function text_area_input($text, $name, $max_length,$default='') {

    // Create the text area.
    echo <<<EOT
        <tr>
                <td class="tableb" valign="top">
                        $text
                </td>
                <td class="tableb" valign="top">
<f></f>                        <textarea name="$name" rows="5" cols="40" class="textinput" style="width: 100%;" onKeyDown="textCounter(this, $max_length);" onKeyUp="textCounter(this, $max_length);">$default</textarea>
                </td>
        </tr>
EOT;
}



// Creation of one or many submit buttons.
//If one : just give its value.
//If many (or one with js events), give an array of array. The second array should have the following keys :
//   - value   (mandatory) : the value of the button
//   - js      (optional)  : the js event to handle.
function submit_button($buttons) {
  global $lang_upload_php;  
  $buttonsHtml = '';
  
  if (is_array($buttons)) {
    foreach ($buttons as $button) {
      if ($buttonsHtml != '') {
        $buttonsHtml .= '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
      }
      $buttonsHtml .= '<input type="submit" value="' . $button['value'] . '" class="button" ' 
          . ( (isset($button['js'])) ? $button['js'] : '')
          . ' />';
    }//foreach
  } else {
    $buttonsHtml = '<input type="submit" value="' . $buttons . '" class="button" />';
  }
  
  // Create the submit button and close the form.
  echo <<<EOT
        <tr>
                <td colspan="2" align="center" class="tablef">
                        {$buttonsHtml}
                </td>

        </tr>

EOT;
}


