<?php
/*************************
  Coppermine Photo Gallery
  ************************
  Copyright (c) 2003-2006 Coppermine Dev Team
  v1.1 originally written by Gregory DEMAR

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  ********************************************
  Coppermine version: 1.4.5
  $Source: /cvsroot/coppermine/stable/themes/classic/theme.php,v $
  $Revision: 1.16 $
  $Author: gaugau $
  $Date: 2006/03/02 08:25:15 $
**********************************************/

// ------------------------------------------------------------------------- //
// This theme has all CORE items removed                                     //
// ------------------------------------------------------------------------- //
//define('THEME_IS_XHTML10_TRANSITIONAL',1);

// Added to display flim_strip
function theme_display_film_strip(&$thumb_list, $nbThumb, $album_name, $aid, $cat, $pos, $sort_options, $mode = 'thumb')
{
    global $CONFIG, $THEME_DIR;
    global $template_film_strip, $lang_film_strip;

    static $template = '';
    static $thumb_cell = '';
    static $empty_cell = '';
    static $spacer = '';

    if ((!$template)) {
        $template = $template_film_strip;
        $thumb_cell = template_extract_block($template, 'thumb_cell');
        $empty_cell = template_extract_block($template, 'empty_cell');
    }

    $cat_link = is_numeric($aid) ? '' : '&amp;cat=' . $cat;

    $thumbcols = $CONFIG['thumbcols'];
    $cell_width = ceil(100 / $CONFIG['max_film_strip_items']) . '%';

    $i = 0;
    $thumb_strip = '';
    foreach($thumb_list as $thumb) {
        //modify $new_size for max dimension of thumbnails in filmstrip
        $new_size = 65;
        preg_match('/(?<=width=")[0-9]*/',$thumb['image'],$matches,PREG_OFFSET_CAPTURE);
        $srcWidth=$matches[0][0];
        preg_match('/(?<=height=")[0-9]*/',$thumb['image'],$matches,PREG_OFFSET_CAPTURE);
        $srcHeight=$matches[0][0];
        $ratio = max($srcWidth, $srcHeight) / $new_size;
        $ratio = max($ratio, 1.0);
        $destWidth = (int)($srcWidth / $ratio);
        $destHeight = (int)($srcHeight / $ratio);
        $thumb['image']=preg_replace('/width="[^"]*"/','width="'.$destWidth.'"',$thumb['image']);
        $thumb['image']=preg_replace('/height="[^"]*"/','height="'.$destHeight.'"',$thumb['image']);
        $i++;
        if ($mode == 'thumb') {
            $params = array('{CELL_WIDTH}' => $cell_width,
                '{LINK_TGT}' => "displayimage.php?album=$aid$cat_link&amp;pos={$thumb['pos']}",
                '{THUMB}' => $thumb['image'],
                '{CAPTION}' => $thumb['caption'],
                '{ADMIN_MENU}' => ''
                );
        } else {
            $params = array('{CELL_WIDTH}' => $cell_width,
                '{LINK_TGT}' => "index.php?cat={$thumb['cat']}",
                '{THUMB}' => $thumb['image'],
                '{CAPTION}' => '',
                '{ADMIN_MENU}' => ''
                );
        }
        $thumb_strip .= template_eval($thumb_cell, $params);
    }

    if (defined('THEME_HAS_FILM_STRIP_GRAPHICS')) {
        $tile1 = $THEME_DIR . 'images/tile1.gif';
        $tile2 = $THEME_DIR . 'images/tile2.gif';
    } elseif (defined('THEME_HAS_FILM_STRIP_GRAPHIC')) {
        $tile1=$tile2=$THEME_DIR . 'images/tile.gif';
    } else {
        $tile1=$tile2= 'images/tile.gif';
    }

    $params = array('{THUMB_STRIP}' => $thumb_strip,
        '{COLS}' => $i,
        '{TILE1}' => $tile1,
        '{TILE2}' => $tile2,
        );

    ob_start();
    starttable($CONFIG['picture_table_width']);
    echo template_eval($template, $params);
    endtable();
    $film_strip = ob_get_contents();
    ob_end_clean();

    return $film_strip;
}

// HTML template for the category list
if (!isset($template_cat_list))  //{THEMES}
$template_cat_list = <<<EOT
<!-- BEGIN header -->

      <TABLE cellSpacing=0 cellPadding=0 width="100%" border=0>
        <TBODY>
        <TR>
          <TD vAlign=bottom align=right width=50><IMG height=28 alt="" src="themes/helius/images/top_left.gif" width=50 border=0></TD>
          
      <TD vAlign=center align=middle width="100%" background=themes/helius/images/top_center.gif>&nbsp;</TD>
          <TD vAlign=bottom align=left width=50><IMG height=28 alt="" src="themes/helius/images/top_right.gif" width=50 border=0></TD>
		  </TR></TBODY></TABLE>
        
<DIV> 
  <TABLE class=forumline cellSpacing=1 cellPadding=2 width="100%" 
        border=0>
    <TBODY>
      <TR> 
        <TH width="70%" noWrap class=thCornerL><div align="left"><b>{CATEGORY}</b></div></TH>
        <TH width="15%" noWrap class=thCornerL><div align="right"><b>{ALBUMS}</b></div></TH>
        <TH width="15%" height=26 colSpan=2 noWrap class=thCornerL><div align="right"><b>{PICTURES}</b></div></TH>
      </TR>
    </TBODY>
  </TABLE>
</DIV>

<!-- END header -->
<!-- BEGIN catrow_noalb -->
<table width="100%" border="0" cellPadding="2" cellSpacing="1" class="forumline">
  <tbody>
    <tr> 
          <td class="tableh2" colspan="3"><table border=0 ><tr><td>
		  <img title="Category" alt="Category" src="themes/helius/images/folder_big.gif" border="0" />{CAT_THUMB}</td><td><span class="catlink"><b>{CAT_TITLE}</b></span>{CAT_DESC}</td></tr></table></td>

    </tr>
  </tbody>
</table>
<!-- END catrow_noalb -->
<!-- BEGIN catrow -->
<TABLE width="100%" border=0 cellPadding=2 cellSpacing=1 class=forumline>
  <TBODY>
    <TR> 
                <th width="70%" noWrap class="thCornerL" align="left"><table border=0 ><tr><td><img title="Category" alt="Category" src="themes/helius/images/folder_big.gif" border="0" />{CAT_THUMB}</td><td><span class="catlink"><b>{CAT_TITLE}</b></span>{CAT_DESC}</td></tr></table></th>
                <th width="15%" noWrap class="thCornerL" align="right">{ALB_COUNT}</th>
                <th width="15%" noWrap class="thCornerL" align="right">{PIC_COUNT}</th>
    </TR>
  </TBODY>
</TABLE>


  <TABLE class=forumline cellSpacing=1 cellPadding=2 width="100%"border=0>
    <TBODY>
      <TR> 
        <TD class=row1 width="100%">
     <!--if (isset(CAT_ALBUMS)){-->
        {CAT_ALBUMS}
     <!--};-->

</TD>
      </TR>
    </TBODY>
		
<!-- END catrow -->
<!-- BEGIN footer -->
        <tr>
                <td colspan="3" class="tableh1" align="center"><span class="statlink"><b>{STATISTICS}</b></span></td>
        </tr>
		<TABLE cellSpacing=0 cellPadding=0 width="100%" border=0>
  <TBODY>
    <TR> 
      <TD vAlign=top align=right width=40><IMG height=9 alt="" src="themes/helius/images/bottom_left.gif" width=40 border=0 /></TD>
      <TD width="100%" background=themes/helius/images/bottom_center.gif>
	  <IMG height=1 alt="" src="themes/helius/images/spacer.gif" width=1 border=0 /></TD>
      <TD vAlign=top align=left width=40><IMG height=9 alt="" src="themes/helius/images/bottom_right.gif" width=40 border=0 /></TD>
    </TR>
  </TBODY>
<!-- END footer -->
<!-- BEGIN spacer -->
        <img src="images/spacer.gif" width="1" height="17" /><br />
<!-- END spacer -->

EOT;

// HTML template for the breadcrumb
if (!isset($template_breadcrumb))  //{THEMES}
$template_breadcrumb = <<<EOT
<!-- BEGIN breadcrumb -->
<table cellspacing="0" cellpadding="0" width="100%" border="0">
  <tbody>
    <tr> 
      <td valign=bottom align=right width="50"><img height="28" alt="" src="themes/helius/images/top_left.gif" width="50" border="0" /></td>
      <td valign=center align=middle width="100%" background=themes/helius/images/top_center.gif>&nbsp;</td>
      <td valign=bottom align=left width="50"><img height="28" alt="" src="themes/helius/images/top_right.gif" width="50" border="0" /></td>
    </tr>
  </tbody>
</table>
<div> 
  <table class=forumline cellspacing="1" cellpadding="2" width="100%" border="0">
    <tbody>
      <tr> 
        <th width="52%" nowrap class=thcornerl><div align="left"><span class="statlink"><b>{BREADCRUMB}</b></span></div></th>
      </tr>
    </tbody>
  </table>
</div>
<table cellspacing="0" cellpadding="0" width="100%" border="0">
  <tbody>
    <tr> 
      <td valign="top" align="right" width="40"><img height="9" alt="" src="themes/helius/images/bottom_left.gif" width="40" border="0" /></td>
      <td width="100%" background=themes/helius/images/bottom_center.gif>
	  <img height="1" alt="" src="themes/helius/images/spacer.gif" width="1" border="0" /></td>
      <td valign=top align=left width="40"><img height="9" alt="" src="themes/helius/images/bottom_right.gif" width="40" border="0" /></td>
    </tr>
  </tbody>
</table><br />
<!-- END breadcrumb -->
<!-- BEGIN breadcrumb_user_gal -->
        <tr>
                <td colspan="3" class="tableh1">
                <table width="100%" cellpadding="0" cellspacing="0" border="0">
                <tr>
                        <td><span class="statlink"><b>{BREADCRUMB}</b></span></td>
                        <td align="right"><span class="statlink"><b>{STATISTICS}</b></span></td>
                </tr>
                </table>
                </td>
        </tr>
<!-- END breadcrumb_user_gal -->

EOT;

// HTML template for the album list
if (!isset($template_album_list))  //{THEMES}
$template_album_list = <<<EOT

<!-- BEGIN stat_row -->
        <tr>
                <td colspan="{COLUMNS}" class="tableh1" align="center"><span class="statlink"><b>{STATISTICS}</b></span></td>
        </tr>
<!-- END stat_row -->
<!-- BEGIN header -->
        <tr>
<!-- END header -->
<!-- BEGIN album_cell -->
 <td width="{col_width}%" height="100%" valign="top"> <table width="100%" border="0" cellspacing="0" cellpadding="0">
    <tbody>
      <tr> 
        <td valign=bottom align=right width=50><img height=28 alt="" src="themes/helius/images/top_left.gif" width=50 border=0 /></td>
        <td valign=center align=middle width="100%" background=themes/helius/images/top_center.gif>&nbsp;</td>
        <td valign=bottom align=left width=50><img height=28 alt="" src="themes/helius/images/top_right.gif" width=50 border=0 /></td>
      </tr>
    </tbody>
  </table>
  <div> 
    <table class=forumline cellspacing=1 cellpadding=2 width="100%" border=0>
      <td width="{COL_WIDTH}%" height="100%" valign="top"> <table width="100%" height="100%" cellspacing="0" cellpadding="0">
          <tr> 
            <th colspan="3" height="1" valign="top" align="left" class="thCornerL"> 
              <a href="{ALB_LINK_TGT}" class="alblink"><b>{ALBUM_TITLE}</b></a> 
            </th>
          </tr>
          <tr> 
            <td colspan="3"> <img src="images/spacer.gif" width="1" height="1"><br /> 
            </td>
          </tr>
          <tr height="100%"> 
            <td align="center" height="100%" valign="middle" class="thumbnails"> 
              <img src="images/spacer.gif" width="{THUMB_CELL_WIDTH}" height="1" class="image" style="margin-top: 0px;
 margin-bottom: 0px; border: none;" /><br /> <a href="{ALB_LINK_TGT}" class="albums">{ALB_LINK_PIC}<br />
              </a> </td>
            <td height="100%"> <img src="images/spacer.gif" width="1" height="1"> 
            </td>
            <td width="100%" height="100%" valign="top" class="tableb_compact"> 
              {ADMIN_MENU} 
              <p>{ALB_DESC}</p>
              <p class="album_stat">{ALB_INFOS}</p></td>
          </tr>
        </table></td>
    </table>
  </div>
  <table cellspacing=0 cellpadding=0 width="100%" border=0>
    <tbody>
      <tr> 
        <td valign=top align=right width="40"><img height="9" alt="" src="themes/helius/images/bottom_left.gif" width="40" border=0 /></td>
        <td width="100%" background=themes/helius/images/bottom_center.gif> <img height=1 alt="" src="themes/helius/images/spacer.gif" width=1 border=0 /></td>
        <td valign=top align=left width="40"><img height="9" alt="" src="themes/helius/images/bottom_right.gif" width="40" border=0 /></td>
      </tr>
    </tbody>
  </table>
<!-- END album_cell -->
<!-- BEGIN empty_cell -->
        <td width="{COL_WIDTH}%" height="100%" valign="top">
        <table width="100%" height="100%" cellspacing="0" cellpadding="0">
        <tr>
                <td height="1" valign="top" class="tableh2">
                        <b>&nbsp;</b>
                </td>
        </tr>
        <tr>
                <td>
                        <img src="images/spacer.gif" width="1" height="1"><br />
                </td>
        </tr>
        <tr height="100%">
                <td width="100%" height="100%" valign="top" class="tableb_compact">
                        &nbsp;
                </td>
        </tr>
        </table>
        </td>
<!-- END empty_cell -->
<!-- BEGIN row_separator -->
        </tr>
        <tr>
<!-- END row_separator -->
<!-- BEGIN footer -->
        </tr>
<!-- END footer -->
<!-- BEGIN tabs -->
        <tr>
                <td colspan="{COLUMNS}" style="padding: 0px;">
                        <table width="100%" cellspacing="0" cellpadding="0">
                                <tr>
                                        {TABS}
                                </tr>
                        </table>
                </td>
        </tr>
<!-- END tabs -->
<!-- BEGIN spacer -->
        <img src="images/spacer.gif" width="1" height="17" /><br />
<!-- END spacer -->

EOT;

// HTML template for filmstrip display
if (!isset($template_film_strip))  //{THEMES}
$template_film_strip = <<<EOT

        <tr>
         <td valign="top" background='themes/helius/images/tile.gif' align="center" height='30'>&nbsp;</td>
        </tr>
        <tr>
        <td valign="bottom" class="thumbnails" align="center">
          {THUMB_STRIP}
        </td>
        </tr>
        <tr>
         <td valign="top" background='themes/helius/images/tile.gif' align="center" height='30'>&nbsp;</td>
        </tr>
<!-- BEGIN thumb_cell -->
                                        <a href="{LINK_TGT}">{THUMB}</a>&nbsp;
                                        {CAPTION}
                                        {ADMIN_MENU}
<!-- END thumb_cell -->
<!-- BEGIN empty_cell -->
                <td valign="top" align="center" >1&nbsp;</td>
<!-- END empty_cell -->

EOT;

// HTML template for thumbnails display
if (!isset($template_thumbnail_view))  //{THEMES}
$template_thumbnail_view = <<<EOT

<!-- BEGIN header -->
        <tr>
<!-- END header -->
<!-- BEGIN thumb_cell -->
<td valign="top" class="thumbnails" width ="{CELL_WIDTH}" align="center"> <table cellspacing=0 cellpadding=0 width="100%" border=0>
    <tbody>
      <tr> 
        <td valign=bottom align=right width=50><img height=28 alt="" src="themes/helius/images/top_left.gif" width=50 border=0 /></td>
        <td valign=center align=middle width="100%" background=themes/helius/images/top_center.gif>&nbsp;</td>
        <td valign=bottom align=left width=50><img height=28 alt="" src="themes/helius/images/top_right.gif" width=50 border=0 /></td>
      </tr>
    </tbody>
  </table>
  <div> 
    <table class=forumline cellspacing=1 cellpadding=2 width="100%" 
        border=0>
      <tbody>
      <th align="center"> <a href="{LINK_TGT}">{THUMB}<br />
        </a> {CAPTION} {ADMIN_MENU} </th></tbody>
    </table>
  </div>
  <table cellspacing=0 cellpadding=0 width="100%" border=0>
    <tbody>
      <tr> 
        <td valign=top align=right width="40"><img height="9" alt="" src="themes/helius/images/bottom_left.gif" width="40" border=0 /></td>
        <td width="100%" background=themes/helius/images/bottom_center.gif> <img height=1 alt="" src="themes/helius/images/spacer.gif" width=1 border=0 /></td>
        <td valign=top align=left width="40"><img height="9" alt="" src="themes/helius/images/bottom_right.gif" width="40" border=0 /></td>
      </tr>
    </tbody>
  </table></td>
<!-- END thumb_cell -->
<!-- BEGIN empty_cell -->
                <td valign="top" class="thumbnails" align="center">&nbsp;</td>
<!-- END empty_cell -->
<!-- BEGIN row_separator -->
        </tr>
        <tr>
<!-- END row_separator -->
<!-- BEGIN footer -->
        </tr>
<!-- END footer -->
<!-- BEGIN tabs -->
        <tr>
                <td colspan="{THUMB_COLS}" style="padding: 0px;">
                        <table width="100%" cellspacing="0" cellpadding="0">
                                <tr>
                                        {TABS}
                                </tr>
                        </table>
                </td>
        </tr>
<!-- END tabs -->
<!-- BEGIN spacer -->
        <img src="images/spacer.gif" width="1" height="17" /><br />
<!-- END spacer -->

EOT;

?>
