<?php
	// This PHP guestbook script was written by Thomas Hettenhausen in 2003.
	// http://flatphpbook.sourceforge.net
	// http://www.hettenhausen.net
	//
	// This software is free software; you can redistribute it and/or modify
	// it under the terms of the GNU General Public License as published by
	// the Free Software Foundation; either version 2 of the License, or
	// (at your option) any later version.
	// 
	// This program is distributed in the hope that it will be useful,
	// but WITHOUT ANY WARRANTY; without even the implied warranty of
	// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	// GNU General Public License for more details.
	// 
	// You should have received a copy of the GNU General Public License
	// along with this program; if not, write to the Free Software
	// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


	// starting the session for the admin login
	session_start();
	header("Cache-control: private"); // IE 6 Fix, needed for using the "Back" button with sessions and forms

	// global variables, such as filenames and settings
	$version = "0.9.5";
	$gbname = "flatPHPBook"; // the name of the guestbook, this is used in the titles of the various pages - change to your liking
	$guestbookFile = "guestbook.db"; // filename of the guestbook itself (default: guestbook.db)
	$stylesheetFile = "guestbook.css"; // filename of the stylesheet
	$javaScriptFile = "guestbook.js"; // file containing the JavaScript functions
	$emailIcon = "email.png"; // the little image used to represent the email address, change this if you have another one (does not have to be PNG)
	$homepageIcon = "homepage.png"; // dito, for the homepage
	$delimiter = "::"; // the special character used to tokenize the parts of a post in the database file
	$displayNewestFirst = 1; // sorting order for display of entries, 1 for newest first, 0 for oldest first
	$refreshWaitingTime = 5; // time to wait in seconds before a refresh on the Thanks-for-posting page
	$showTotalNumber = 1; // if 1, displays the total number of posts in guestbook above the posts
	$entriesPerPage = 10 ; // set to 0 for all entries on a single page, or else to how many you want on one page
	$separateViewFromSign = 0; // if set to 1 (not 0), the form to sign the guestbook is displayed on another page and not together with the old entries
	$trackUserIP = 1; // set to 0 if you do not want to (or it is illegal in your country) log user IP addresses
	$adminusername = "admin"; // the administrator username who can delete posts - YOU REALLY SHOULD CHANGE THIS
	$adminpassword = "adminpw" ; // the corresponding passwort - YOU REALLY SHOULD CHANGE THIS
	$adminmode = 0; // set adminmode to 0 for security reasons DO NOT CHANGE THIS
	$language = "english.lang"; // sets the language file.
	$timeNotation = "ISO"; // set to american to have the time and date noted as h:mm:ss am/pm and MM-DD-YYYY

	// reading the language-specific content
	$languageStrings = parse_ini_file($language);
	
	///////////////////////////////////////////////////////////////////////////////////////////
	// functions declarations
	//
	
	// removes HTML tags and the delimiters used in the db file from the input
	function safeHTML($input, $delimiter)	{
		$input = strip_tags($input);
		$input = htmlspecialchars(stripslashes($input), ENT_QUOTES);
		$input = preg_replace("/(\015\012)|(\015)|(\012)/", "&nbsp;<br />", $input); // exchanges CR, LF and CRLF with <br />
		$input = ereg_replace($delimiter, "[[delimiter]]", $input);
		return $input;
	}

	// here the BBcode for formatting, links and images is replaced with the real HTML tags
	// together with any incidentally used delimiter in the database file (because a visitor wanted to use it in his text) -
	// they were exchanged by the safeHTML() function and are now reinserted for display
	function recreateUserInput($input, $delimiter)	{
		$input = str_replace("[[delimiter]]", $delimiter, $input);		// put the real delimiter back into the string
		$input = preg_replace('/(\[b\])(.+?)(\[\/b\])/i', '<b>\\2</b>',  $input);
		$input = preg_replace('/(\[i\])(.+?)(\[\/i\])/i', '<i>\\2</i>', $input);
		$input = preg_replace('/(\[u\])(.+?)(\[\/u\])/i', "<u>\\2</u>", $input);
		$input = preg_replace('/(\[pre\])(.+?)(\[\/pre\])/i', "<pre>\\2</pre>", $input);
		$input = preg_replace('/(\[img\])(.+?)(\[\/img\])/i', '<img src="\\2" alt="\\2">', $input);
		$input = preg_replace('/(\[color=(.+?)\])(.+?)(\[\/color\])/i', '<font color=\\2>\\3</font>', $input);
		$input = preg_replace('/(\[email\])(.+?)(\[\/email\])/i', "<a href=\"mailto:\\2\">\\2 </a>", $input);
		$input = preg_replace('/(\[email=(.+?)\])(.+?)(\[\/email\])/i', "<a href=\"mailto:\\2\">\\3</a>", $input);
		$input = preg_replace('/\[url\]http\:\/\//i', '[url]', $input);
		$input = preg_replace('/\[url=http\:\/\//i', '[url=', $input);
		$input = preg_replace('/(\[url\])(.+?)(\[\/url\])/i', "<a href=\"http://\\2\">\\2</a>", $input);
		$input = preg_replace('/(\[url=\])(.+?)(\[\/url\])/i', "<a href=\"http://\\2\">\\2</a>", $input);
		$input = preg_replace('/(\[url=(.+?)\])(.+?)(\[\/url\])/i', "<a href=\"http://\\2\">\\3</a>", $input);
		$input = str_replace('\\&quot;', '&quot;', $input);
		return $input;
	}

	// displays the input fields for a new post: name, email, you name it
	// made into a function because used twice in the script, saves place
	function displayInputForm($Nickname, $Emailaddress, $Homepage) {
		global $languageStrings;
		if (isset($_POST["Message"]))	{
			$messageDisplay = stripslashes($_POST["Message"]);
		}
		else	{
			$messageDisplay = "";
		}
		echo "\n\t\t\t<table>\n\t\t\t\t<tr>\n\t\t\t\t\t<td>\n\t\t\t\t\t\t<form name='inputform' method='post' action='" . $_SERVER['PHP_SELF'] . "'>\n";
		echo "\t\t\t\t\t\t\t<table border='0'>\n\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t<td>".$languageStrings['YourName'].":<br>";
		echo "<input type='text' name='NickName' size='26' value='" . $Nickname . "' /></td>\n";
		echo "\t\t\t\t\t\t\t\t\t<td>".$languageStrings['YourEmail'].":<br>";
		echo "<input type='text' name='EmailAddress' size='36' value='" . $Emailaddress . "' /></td>";
		echo "\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t<td colspan='2'>".$languageStrings['YourHomepage'].":<br>";
		echo "<input type='text' name='Homepage' size='67' value='" . $Homepage . "' /><br>";
		echo "\t\t\t</td></tr><tr><td colspan='2'>".$languageStrings['YourMessage'].":<br>\n";
		echo "\t\t\t\t\t\t\t\t\t\t<textarea rows='5' cols='50' id='messagebox' name='Message'>" . $messageDisplay . "</textarea>\n\t\t\t\t\t\t\t\t\t\t<br>\n";
		echo "\t\t\t\t\t\t\t\t\t\t<input type='button' accesskey='h' value='".$languageStrings['ButtonWWW']."' onClick='addHyperlink(\"".$languageStrings['jsWWWurl']."\", \"".$languageStrings['jsWWWname']."\")' onMouseOver='helpHyperlink(\"".$languageStrings['jsHelpWWW']."\")' onMouseOut='clearHelp()'>\n";
		echo "\t\t\t\t\t\t\t\t\t\t<input type='button' accesskey='e' value='".$languageStrings['ButtonEmail']."' onClick='addEmail(\"".$languageStrings['jsEmailAddress']."\", \"".$languageStrings['jsEmailName']."\")' onMouseOver='helpEmail(\"".$languageStrings['jsHelpEmail']."\")' onMouseOut='clearHelp()'>\n";
		echo "\t\t\t\t\t\t\t\t\t\t<input type='button' accesskey='b' value='".$languageStrings['ButtonBold']."' style='font-weight: bold;' onClick='addBold(\"".$languageStrings['jsBold']."\", \"".$languageStrings['jsYourTextGoesHere']."\")' onMouseOver='helpBold(\"".$languageStrings['jsHelpBold']."\")' onMouseOut='clearHelp()'>\n";
		echo "\t\t\t\t\t\t\t\t\t\t<input type='button' accesskey='i' value='".$languageStrings['ButtonItalic']."' style='font-style: italic;' onClick='addItalics(\"".$languageStrings['jsItalic']."\", \"".$languageStrings['jsYourTextGoesHere']."\")' onMouseOver='helpItalics(\"".$languageStrings['jsHelpItalic']."\")' onMouseOut='clearHelp()'>\n";
		echo "\t\t\t\t\t\t\t\t\t\t<input type='button' accesskey='u' value='".$languageStrings['ButtonUnderline']."' style='text-decoration: underline;' onClick='addUnderline(\"".$languageStrings['jsUnderline']."\", \"".$languageStrings['jsYourTextGoesHere']."\")' onMouseOver='helpUnderline(\"".$languageStrings['jsHelpUnderline']."\")' onMouseOut='clearHelp()'>\n";
		echo "\t\t\t\t\t\t\t\t\t\t<select name='colorselect' size='1' onChange='addColor(\"".$languageStrings['jsColor']."\", \"".$languageStrings['jsYourTextGoesHere']."\")' onMouseOver='helpColor(\"".$languageStrings['jsHelpColor']."\")' onMouseOut='clearHelp()'>\n";
		echo "\t\t\t\t\t\t\t\t\t\t\t<option>".$languageStrings['ButtonColor']."</option><option value='#ff0000'>".$languageStrings['red']."</option><option value='#ff8800'>".$languageStrings['orange']."</option><option value='#ffff00'>".$languageStrings['yellow']."</option>\n";
		echo "\t\t\t\t\t\t\t\t\t\t\t<option value='#884400'>".$languageStrings['brown']."</option><option value='#00ff00'>".$languageStrings['green']."</option><option value='#00ffff'>".$languageStrings['turquoise']."</option><option value='#0000ff'>".$languageStrings['blue']."</option>\n";
		echo "\t\t\t\t\t\t\t\t\t\t\t<option value='#8800ff'>".$languageStrings['violet']."</option><option value='#ff00ff'>".$languageStrings['pink']."</option><option value='#ffffff'>".$languageStrings['white']."</option>\n\t\t\t\t\t\t\t\t\t\t</select>\n";
		echo "\t\t\t\t\t\t\t\t\t\t<input type='button' value='".$languageStrings['ButtonImage']."' onClick='addImage(\"".$languageStrings['jsImage']."\")' onMouseOver='helpImage(\"".$languageStrings['jsHelpImage']."\")' onMouseOut='clearHelp()'>\n";
		echo "\t\t\t\t\t\t\t\t\t\t<input type='button' value='".$languageStrings['ButtonCode']."' style='font-family: monospaced;' onClick='addCode(\"".$languageStrings['jsCode']."\", \"".$languageStrings['jsYourTextGoesHere']."\")' onMouseOver='helpCode(\"".$languageStrings['jsHelpCode']."\")' onMouseOut='clearHelp()'>\n";
		echo "\t\t\t\t\t\t\t\t\t\t<div id='jsHelpLine' class='jsHelpLine'>&nbsp;<br></div>\n";
		echo "\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t<td colspan='2'>\n\t\t\t\t\t\t\t\t\t\t<div align='left'>\n\t\t\t\t\t\t\t\t\t\t\t<input type='submit' name='submit' value='".$languageStrings['SubmitPost']."' />&nbsp;\n";
		echo "\t\t\t\t\t\t\t\t\t\t\t<input type='submit' name='preview' value='".$languageStrings['PreviewPost']."'>\n";
		echo "\t\t\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t</form>\n\t\t\t\t\t</td>\n\t\t\t\t</tr>\n\t\t\t</table>";
	}


	// called when displaying posts on more than one page
	// adds the page navigation that looks like "< [1] 2 3 >"
	function displayPostNavigation($numberofposts, $offset)
	{
		global $entriesPerPage;
		if (($numberofposts > 0) && ($numberofposts > $entriesPerPage))	{
			$numberofpages = ceil($numberofposts / $entriesPerPage); // one post more than entries per page -> new page
			echo "\n\t\t<!-- navigation between the pages -->";
			echo "\n\t\t<div style='text-align: center; width: 100%;'><p style='font-weight: bold;'>";
			echo "\n\t\t\t<a href='" . $_SERVER['PHP_SELF'] . "?offset=" . max(($offset - $entriesPerPage), 0) . "'>&laquo;</a>";
			for ($thispage = 1; $thispage <= $numberofpages; $thispage++)  {
				if (($offset >= ($entriesPerPage * ($thispage - 1))) && ($offset < ($entriesPerPage * $thispage))) {
					echo "&nbsp;[" . $thispage . "]";
				}
				else {
					echo "&nbsp;<a href='" . $_SERVER['PHP_SELF'] . "?offset=" . ($entriesPerPage * ($thispage - 1)) . "'>" . $thispage . "</a>";
				}
			}
			echo "&nbsp;<a href='" . $_SERVER['PHP_SELF'] . "?offset=" . min(($offset + $entriesPerPage), $numberofposts - 1) . "'>&raquo;</a>\n";
			echo "\t\t</p></div>\n\n";
		}
	}
	
	// displays the recurring html header that is the same on every page (page title, style sheet, JavaScript, meta tags...)
	function displayHTMLHeader()	{
		global  $gbname, $stylesheetFile, $javaScriptFile;
		echo "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n\n";
		echo "<html>\n\t<head>\n\t\n\t\t<title>" . $gbname . "</title>\n\t\t<meta name='Author' content='Thomas Hettenhausen'>\n";
		echo "\t\t<meta http-equiv='Content-Type' content='text/html; charset=iso-8859-1'>";
		echo "\t\t<link rel='stylesheet' type='text/css' href='" . $stylesheetFile . "'>\n";
		echo "\t\t<script language='JavaScript' type='text/javascript' src='" . $javaScriptFile . "'></script>\n\t</head>\n\t<body>\n";
	}
	
	function displayHTMLFooter()	{
		echo "\t\t<div style='text-align: center; margin-top: 10px;'><a href='http://flatphpbook.sourceforge.net/' style='font-size: 9px;'>flatPHPbook by Thomas Hettenhausen</a></div>\n";
		echo "\n\t</body>\n</html>";
	}


	///////////////////////////////////////////////////////////////////////////////////////////
	// MAIN body of the script
	//

	// FIRST all the special cases: previewing, submitting, logging in as admin

	// previewing a post
	if (isset($_POST["preview"]))	{
		// same requirements as if just submitting
		if (($_POST["NickName"] != "") && ($_POST["Message"] != ""))	{
			// preparing the data to be written to the guestbook
			if ($timeNotation == "american")	{
				$currentTime = date("g:i:s a");
				$currentDate = date("m-d-Y");
			}
			else	{
				// falling back to ISO norm
				$currentTime = date("H:i:s");
				$currentDate = date("Y-m-d");
			}
			
			if (($_POST["Homepage"] == "http://") || ($_POST["Homepage"]) == "")	{
				$Homepage = "";
			}
			else	{
				$Homepage = safeHTML($_POST["Homepage"], $delimiter);
			}

			$Nickname = safeHTML($_POST["NickName"], $delimiter);
			$Emailaddress = safeHTML($_POST["EmailAddress"], $delimiter);
			$messageString = safeHTML($_POST["Message"], $delimiter);
			
			// beginning to output the HTML page
			displayHTMLHeader();
			// displaying the single entry with the new data
			echo "\t\t<h1>" . $gbname . "</h1>\n\t\t<table class='gbdisplay' cellpadding='0' cellspacing='0'>\n";
			echo "\t\t\t<tr class='layouttr'>\n\t\t\t\t<td class='posttopleft' valign='top'>";
			echo "\n\t\t\t\t\t<span class='emphasis'>0. " . $Nickname . "</span>\n\t\t\t\t</td>\n";
			echo "\t\t\t\t<td class='posttopright'  valign='top'>\n\t\t\t\t\t<span class='emphasis'>" . $currentDate . ", " . $currentTime . "</span>\n\t\t\t\t\t</td>\n\t\t\t\t</tr>\n";
			echo "\t\t\t<tr>\n\t\t\t\t<td class='postbottomleft'  valign='top'>";
			if ($Emailaddress != "")	{
				echo " <a href='mailto:" . $Emailaddress . "'><img src='" . $emailIcon . "' alt='email' border=''></a>&nbsp;";
				if ($Homepage == "")	{
					echo "\n\t\t\t\t<br>";
				}
			}
			if ($Homepage != "")	{
				if (!(preg_match("/^http:\/\//", $Homepage)))
					{$currentHomepage = "http://" . $Homepage;}
					echo "<a href='" . $currentHomepage . "'><img src='" . $homepageIcon . "' alt='homepage' border='0'></a><br>";
			}
			echo "</td>\n\t\t\t\t<td class='postbottomright' valign='top'>";
			echo "\n\t\t\t\t\t" . recreateUserInput($messageString, $delimiter) . "\t\t\t\t</td>\n\t\t\t</tr>\n";
			echo "\t\t</table>\n\t\t<p>&nbsp;</p>\n";
			// displaying the form fields with the data inserted, too
			echo "\t\t<div class='gbinput'>\n\t\t\t";
			displayInputForm($Nickname, $Emailaddress, $Homepage);
			echo "\n\t\t</div>";
			displayHTMLFooter();
			die();
		}
		else	{
			// If no entry was made display an error message and go back to the guestbook
			// double time because user might want to press "Back" to re-submit without filling in everything again
			header( 'refresh: ' . $refreshWaitingTime * 2 . '; url= '. $_SERVER["PHP_SELF"] );
			displayHTMLHeader();
			echo "\t\t<div class='gbheader' align='center'><h1>" . $gbname . "</h1></div>\n";
			echo "\t\t<div class='gbinput'>\n";
			echo "\t\t\t<p>".$languageStrings['IncompletePost']."</p>\n";
			echo "\t\t\t<p>" . $languageStrings['YouWillBeTaken1'] . $refreshWaitingTime * 2 . $languageStrings['YouWillBeTaken2'] . "</p>\n";
			echo "\t\t\t<a href='" . $_SERVER["PHP_SELF"] . "'>" . $languageStrings['ClickInsteadOfWaiting'] . "</a>\n\t\t</div>";
			displayHTMLFooter();
			die();
		}
		die;
	}

	// new post is being submitted
	if (isset($_POST["submit"]))
	{
		// minimum requirements for posting are a name and a message, would not make much sense without these
		// at least I do not want anonymous posts, might change this later for flexibilitys sake
		if (($_POST["NickName"] != "") && ($_POST["Message"] != ""))	{
			// preparing the data to be written to the guestbook
			$currentDate = date("Y-m-d");
			$currentTime = date("H:i:s");

			if (($_POST["Homepage"] == "http://") || ($_POST["Homepage"]) == "")	{
				$Homepage = "";
			}
			else	{
				$Homepage = safeHTML($_POST["Homepage"], $delimiter);
			}

			$Nickname = safeHTML($_POST["NickName"], $delimiter);
			$Emailaddress = safeHTML($_POST["EmailAddress"], $delimiter);
			$messageString = safeHTML($_POST["Message"], $delimiter);
			
			// IP address: real unless trackUserIP is set to 0, then "0.0.0.0"
			if ($trackUserIP == 1)	{
				$userIP = $_SERVER['REMOTE_ADDR'];
			}
			else	{
				$userIP = "0.0.0.0";
			}

			$newguestbookline = $Nickname.$delimiter.$Emailaddress.$delimiter.$Homepage.$delimiter.date("Y-m-d").$delimiter.date("H:i:s").$delimiter.$userIP.$delimiter.$messageString."\n";

			// adding the stuff to the guestbook file (simply adding a new line at the end due to design of the data structure)
			$bookInputStream = fopen($guestbookFile, "a");
			fwrite($bookInputStream, $newguestbookline);
			fclose($bookInputStream);

			// display a "Thank you" page and then go back to the guestbook
			header( 'refresh: ' . $refreshWaitingTime . '; url= '. $_SERVER["PHP_SELF"] );
			displayHTMLHeader();
			echo "\t\t<h1>" . $gbname . "</h1>\n";
			echo "\t\t<div class='gbinput'>\n";
			echo "\t\t\t<p>".$languageStrings['ThanksForPosting']."</p>\n";
			echo "\t\t\t<p>" . $languageStrings['YouWillBeTaken1'] . $refreshWaitingTime . $languageStrings['YouWillBeTaken2'] . "</p>\n";
			echo "\t\t\t<a href='" . $_SERVER["PHP_SELF"] . "'>" . $languageStrings['ClickInsteadOfWaiting'] . "</a>\n\t\t</div>";
			displayHTMLFooter();
			die();
		}
		else	{
			// If no entry was made display an error message and go back to the guestbook
			// double time because user might want to press "Back" to re-submit without filling in everything again
			header( 'refresh: ' . $refreshWaitingTime * 2 . '; url= '. $_SERVER["PHP_SELF"] );
			displayHTMLHeader();
			echo "\t\t<h1>" . $gbname . "</h1>\n";
			echo "\t\t<div class='gbinput'>\n";
			echo "\t\t\t<p>".$languageStrings['IncompletePost']."</p>\n";
			echo "\t\t\t<p>" . $languageStrings['YouWillBeTaken1'] . $refreshWaitingTime * 2 . $languageStrings['YouWillBeTaken2'] . "</p>\n";
			echo "\t\t\t<a href='" . $_SERVER["PHP_SELF"] . "'>" . $languageStrings['ClickInsteadOfWaiting'] . "</a>\n\t\t</div>";
			displayHTMLFooter();
			die();
		}
	}

	// deleting an entry (only allow POST so nobody can fake the action via URLs)
	if (isset($_POST["delete"]))	{
		// obviously, a post is to be deleted

		// need to load the database file, build an array, remove the corresponding field, and write the array back to the database file
		$content = file($guestbookFile);
		$posttobedeleted = count($content) - $_POST["whichpost"] - 1;
		$gbentry = split($delimiter, $content[$posttobedeleted]);	// preparing the double-checking: need to read the posttime filed from the database later on
		
		// double-checking: the post number and time the post was made have to be correct
		// if someone posts between clicking the delete button and the reloading of the page
		// the post numbers are screwed - in that case, nothing will be deleted
		if ($_POST["posttime"] == $gbentry[4])	{
			// now, $content is our array, need to remove the appropriate one
			$index_nb_elements = count($content) - 1;
			switch($posttobedeleted)
			{
				case 0:
					$content = array_slice($content, 1);
					break;
				case $index_nb_elements:
					$content = array_slice($content, 0, -1);
					break;
				default:
					$array_start = array_slice($content, 0, $posttobedeleted);
					$array_end = array_slice($content, $posttobedeleted + 1);
					$content = array_merge ($array_start, $array_end);
					break;
			}

			// writing the new array back
			$bookInputStream = fopen($guestbookFile, "w");
			fseek($bookInputStream, 0);
			// $content = implode("\r\n", $content);
			foreach ($content as $gbline)	{
				fwrite($bookInputStream, trim($gbline) . "\n"); }
			fclose($bookInputStream);
		}
	}
	
	// the admin mode login, displaying a form field for entering username and passwort,
	// then directing the user to the admin mode guestbook
	if (isset($_GET["adminlogin"]))
	{
		displayHTMLHeader();
		echo "\t\t<h1>" . $gbname." ".$languageStrings['AdminTitle']."</h1>\n";
		echo "\t\t<div class='gbinput'>\n";
		echo "\t\t\t<form method='POST' action='" . $_SERVER['PHP_SELF'] . "'>\n";
		echo "\t\t\t\t<table>\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td>".$languageStrings['AdminUserName'].":</td>\n\t\t\t\t\t\t<td><input type='text' name='adminuser'></td>\n\t\t\t\t\t</tr>\n";
		echo "\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td>".$languageStrings['AdminPassword'].":</td>\n\t\t\t\t\t\t<td><input type='password' name='adminpass'></td>\n\t\t\t\t\t</tr>\n";
		echo "\t\t\t\t\t<tr>\n\t\t\t\t\t\t<td>\n\n\t\t\t\t\t\t\t<input type='submit' name='Login' value='".$languageStrings['AdminLogin']."'/>\n\t\t\t\t\t\t</td>\n\t\t\t\t\t</tr>\n\t\t\t\t</table>\n";
		echo "\t\t\t</form>\n\t\t</div>\n";
		displayHTMLFooter();
		die();
	}
	
	// THEN the regular display of the guestbook, even if some special conditions get checked first
	
	// checking if logging into admin mode, setting the appropriate PHP session variables
	if (isset($_POST["Login"]) && ($_POST["adminuser"] == $adminusername) && ($_POST["adminpass"] == $adminpassword))	{
		$adminmode = 1;
		session_register('adminmode');
		$_SESSION['adminmode'] = $adminmode;
	}

	// check if already in admin mode via PHP session
	if ((isset($_SESSION['adminmode'])) && ($_SESSION['adminmode'] == 1))	{
		$adminmode = 1;
	}
	
	// logging out of admin mode and destroying the associated PHP session
	if (isset($_GET["logout"]))	{
		session_unset();
		session_destroy();
		$adminmode = 0;
	}

	// beginning the regular guestbok display
	displayHTMLHeader();
	echo "\t\t<h1>" . $gbname . " ".$languageStrings['MainPage']."</h1>\n\n";
	echo "\t\t<!-- html input form for guestbook -->\n\t\t<div class='gbinput'>";
	
	// this includes (makes it as if it was really in this page) the content of welcomeMessage.html
	// this is useful for having your own welcome message
	// right now it lists the features of the script - just edit the welcomeMessage.html file
	// or change the following line so it points to another file
	include("./welcomeMessage.html");
	
	// all the "if ((separateViewFromSign == 1) ... etc make sure the right parts are displayed according to the mode:
	// either everything on one page, but no links, or either the form fields or the old entries together with navigation links ("Click to view" or "Click to sign").
	
	if (($separateViewFromSign == 1) && !isset($_GET['signgb']))	{
		echo "<p align='center'><a href='" . $_SERVER['PHP_SELF'] . "?signgb=1'>".$languageStrings['ClickHereToSign']."</a></p>";
	}
	else	{
		echo "<hr width='80%'>";
	}
	
	// calling the function which displays the long form with the input text fields and buttons
	// parameters are empty here, they are used for the preview page so that the fields can be filled with already submitted values
	if ((($separateViewFromSign == 1) && isset($_GET['signgb']) && ($_GET['signgb'] == 1)) || ($separateViewFromSign == 0))	{
		displayInputForm("", "", "");
		if (!($separateViewFromSign == 0))	{
			echo "<p align='center'><a href='" . $_SERVER['PHP_SELF'] . "'>".$languageStrings['ClickHereToView']."</a></p>";
		}
	}
	echo "</div>\n\t\t<p>&nbsp;</p>";

	if ((($separateViewFromSign == 1) && !isset($_GET['signgb'])) || ($separateViewFromSign == 0))
	{
		// checking if we are displaying posts starting with the first one or if we start somewhere else when using multiple pages
		if (isset($_GET["offset"]))	{
			$offset = $_GET["offset"];
		}
		else	{
			$offset = 0;
		}

		// reading the content of the guestbook file ($guestbookFile) and creating an array ($content) out of it
		//
		// if the file does not exist, create it for further use
		if (!file_exists($guestbookFile))	{
			touch($guestbookFile);
		}
		$content = file($guestbookFile);
		$numberofposts = count($content);

		// displaying the total number of posts in the guestbook if wanted
		if ($showTotalNumber == 1)	{
			echo "\t\t<!-- displaying the total number of posts in the guestbook -->\n";
			echo "\t\t<div class='gbinput'>\n\t\t\t<p style='font-weight: bold; text-align: center;'>\n\t\t\t\t".$languageStrings['TotalNumberOfPosts'].$numberofposts . "\n\t\t\t</p>\n\t\t</div>\n\t\t<p>&nbsp;</p>\n";
		}

		// if splitting the posts onto several pages, display navigation links
		if ($entriesPerPage > 0)	{
			displayPostNavigation($numberofposts, $offset);
		}

		// creating array out of guestbook entry
		//
		// prepare the check whether whole guestbook or current entry is empty (either if it is the last or if there accidentally got an empty line into the database file)
		$gbIsEmpty = "1";

		// order of display is checked: usually you want newest first
		if ($displayNewestFirst == "1")	{
			$content = array_reverse($content);
		}

		echo "\n\t\t<!-- beginning of the display of the guestbook entries -->\n";
		echo "\n\t\t<table class='gbdisplay' cellpadding='0' cellspacing='0'>\n";

		// looping over the posts and displaying the table rows for each one
		for ($postnumber = 0; $postnumber < $numberofposts; $postnumber++)	{
			$gbentryline = $content[$postnumber];

			// the current post might be empty, and then ...
			if (($gbentryline == "") && ($gbIsEmpty == "1"))	{
				// Obviously, the guestbook is currently empty -> display a message.
				echo "The guestbook is currently empty.";
			}
			else	{
				if (($entriesPerPage == 0) || (($entriesPerPage != 0) && ($postnumber >= $offset) && ($postnumber < ($offset + $entriesPerPage))))	{
					// if we are here, we can display the current post

					// creating an array of each line in the guestbook file
					$gbentry = split($delimiter, $gbentryline);

					// first line of post: dark background;left cell: "nickname", right cell: "date, time"
					echo "\n\t\t\t<!-- post number " . ($numberofposts - $postnumber) . " -->\n";
					echo "\t\t\t<tr class='layouttr'>\n\t\t\t\t<td class='posttopleft' valign='top'>";
					echo "\n\t\t\t\t\t<span class='emphasis'>" . ($numberofposts - $postnumber) . ". " . $gbentry[0] . "</span>\n\t\t\t\t</td>\n";
					echo "\t\t\t\t<td class='posttopright'  valign='top'>\n\t\t\t\t\t<span class='emphasis'>" . $gbentry[3] . ", " . $gbentry[4] . "</span>\n\t\t\t\t\t</td>\n\t\t\t\t</tr>\n";

					// second line of post: light background; left cell: "homepage, email", right cell: "message"
					echo "\t\t\t<tr>\n\t\t\t\t<td class='postbottomleft'  valign='top'>";
					if ($gbentry[1] != "")	{
						echo " <a href='mailto:" . $gbentry[1] . "'><img src='" . $emailIcon . "' alt='email' border=''></a>&nbsp;";
						if ($gbentry[2] == "")	{
							echo "\n\t\t\t\t<br>";
						}
					}

					if ($gbentry[2] != "")	{
						$currentHomepage = $gbentry[2];
						if (!(preg_match("/^http:\/\//", $currentHomepage)))
							{	$currentHomepage = "http://" . $currentHomepage;	}
						echo "<a href='" . $currentHomepage . "'><img src='" . $homepageIcon . "' alt='homepage' border='0'></a><br>";
					}

					// displaying button to delete the entry if logged in as admin
					if ($adminmode == 1)	{
						echo "\t\t\t\t\t<form method='POST' action='" . $_SERVER['PHP_SELF'] . "'><input type='hidden' name='whichpost' value='" . $postnumber . "'><input type='hidden' name='posttime' value='" . $gbentry[4] . "'><input type='submit' value='".$languageStrings['AdminDelete']."' name='delete'></form>";
					}

					echo "</td>\n\t\t\t\t<td class='postbottomright' valign='top'>";
					echo "\n\t\t\t\t\t" . recreateUserInput($gbentry[6], $delimiter) . "\t\t\t\t</td>\n\t\t\t</tr>\n";
					$gbIsEmpty = "0";
				}
				else	{
					// this post is not inside the wanted numbers, do nothing
				}
			}
		}
		echo "\t\t</table>\n";
	
		// if splitting the posts onto several pages, display navigation links
		if ($entriesPerPage > 0)	{
			displayPostNavigation($numberofposts, $offset);
		}
	}
	
	if ($adminmode == 1)	{
		echo "\t\t<div class='adminlink'><a href='" . $_SERVER['PHP_SELF'] . "?logout' style='font-size: 9px;'>".$languageStrings['AdminLogout']."</a></div>\n";
	}
	else {
		echo "\t\t<div class='adminlink'><a href='" . $_SERVER['PHP_SELF'] . "?adminlogin=1' style='font-size: 9px;'>".$languageStrings['AdminLogin']."</a></div>\n";
	}
	
	displayHTMLFooter();
?>
