/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Iterator;
import org.jfree.chart.Effect3D;
import org.jfree.chart.axis.HorizontalNumberAxis;
import org.jfree.chart.axis.Tick;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.HorizontalValuePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.CategoryItemRenderer;
import org.jfree.ui.RefineryUtilities;

public class HorizontalNumberAxis3D
extends HorizontalNumberAxis
implements Serializable {
    public HorizontalNumberAxis3D(String string) {
        super(string);
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, int n) {
        Rectangle2D rectangle2D3;
        Object object;
        Serializable serializable;
        if (!this.isVisible()) {
            return;
        }
        String string = this.getLabel();
        if (string != null) {
            serializable = this.getLabelFont();
            graphics2D.setFont((Font)serializable);
            graphics2D.setPaint(this.getLabelPaint());
            object = graphics2D.getFontRenderContext();
            rectangle2D3 = ((Font)serializable).getStringBounds(string, (FontRenderContext)object);
            LineMetrics lineMetrics = ((Font)serializable).getLineMetrics(string, (FontRenderContext)object);
            float f = (float)(rectangle2D2.getX() + rectangle2D.getWidth() / 2.0 - rectangle2D3.getWidth() / 2.0);
            float f2 = (float)(rectangle2D.getMaxY() - (double)this.getLabelInsets().bottom - (double)lineMetrics.getDescent() - (double)lineMetrics.getLeading());
            graphics2D.drawString(string, f, f2);
        }
        serializable = (CategoryPlot)this.getPlot();
        object = (Effect3D)((Object)((CategoryPlot)serializable).getRenderer());
        rectangle2D3 = new Rectangle2D.Double(rectangle2D2.getMinX(), rectangle2D2.getMinY() + object.getYOffset(), rectangle2D2.getWidth() - object.getXOffset(), rectangle2D2.getHeight() - object.getYOffset());
        this.refreshTicks(graphics2D, rectangle2D, rectangle2D3, n);
        float f = (float)rectangle2D2.getMaxY();
        graphics2D.setFont(this.getTickLabelFont());
        Iterator iterator = this.getTicks().iterator();
        while (iterator.hasNext()) {
            Tick tick = (Tick)iterator.next();
            float f3 = (float)this.translateValueToJava2D(tick.getNumericalValue(), rectangle2D3);
            if (this.isTickLabelsVisible()) {
                graphics2D.setPaint(this.getTickLabelPaint());
                if (this.isVerticalTickLabels()) {
                    RefineryUtilities.drawRotatedString((String)tick.getText(), (Graphics2D)graphics2D, (float)tick.getX(), (float)tick.getY(), (double)-1.5707963267948966);
                } else {
                    graphics2D.drawString(tick.getText(), tick.getX(), tick.getY());
                }
            }
            if (!this.isTickMarksVisible()) continue;
            graphics2D.setStroke(this.getTickMarkStroke());
            graphics2D.setPaint(this.getTickMarkPaint());
            Line2D.Float float_ = new Line2D.Float(f3, f - this.getTickMarkInsideLength(), f3, f + this.getTickMarkOutsideLength());
            graphics2D.draw(float_);
        }
    }

    public double reserveHeight(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, int n) {
        Object object;
        if (!this.isVisible()) {
            return 0.0;
        }
        double d = 0.0;
        String string = this.getLabel();
        if (string != null) {
            object = this.getLabelFont().getLineMetrics(string, graphics2D.getFontRenderContext());
            Insets insets = this.getLabelInsets();
            d = (float)insets.top + ((LineMetrics)object).getHeight() + (float)insets.bottom;
        }
        object = this.getTickLabelInsets();
        double d2 = ((Insets)object).top + ((Insets)object).bottom;
        if (this.isTickLabelsVisible()) {
            graphics2D.setFont(this.getTickLabelFont());
            this.refreshTicks(graphics2D, rectangle2D, rectangle2D, n);
            d2 += this.getMaxTickLabelHeight(graphics2D, rectangle2D, this.isVerticalTickLabels());
        }
        return d + d2;
    }

    public double reserveHeight(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, int n, double d, int n2) {
        Object object;
        if (!this.isVisible()) {
            return 0.0;
        }
        double d2 = 0.0;
        String string = this.getLabel();
        if (string != null) {
            object = this.getLabelFont().getLineMetrics(string, graphics2D.getFontRenderContext());
            Insets insets = this.getLabelInsets();
            d2 = (float)insets.top + ((LineMetrics)object).getHeight() + (float)insets.bottom;
        }
        object = this.getTickLabelInsets();
        double d3 = ((Insets)object).top + ((Insets)object).bottom;
        if (this.isTickLabelsVisible()) {
            graphics2D.setFont(this.getTickLabelFont());
            this.refreshTicks(graphics2D, rectangle2D, rectangle2D, n);
            d3 += this.getMaxTickLabelHeight(graphics2D, rectangle2D, this.isVerticalTickLabels());
        }
        return d2 + d3;
    }

    private double getMaxTickLabelHeight(Graphics2D graphics2D, Rectangle2D rectangle2D, boolean bl) {
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        double d = 0.0;
        if (bl) {
            Iterator iterator = this.getTicks().iterator();
            while (iterator.hasNext()) {
                Tick tick = (Tick)iterator.next();
                Rectangle2D rectangle2D2 = font.getStringBounds(tick.getText(), fontRenderContext);
                if (!(rectangle2D2.getWidth() > d)) continue;
                d = rectangle2D2.getWidth();
            }
        } else {
            LineMetrics lineMetrics = font.getLineMetrics("Sample", fontRenderContext);
            d = lineMetrics.getHeight();
        }
        return d;
    }

    protected boolean isCompatiblePlot(Plot plot) {
        return plot instanceof HorizontalValuePlot;
    }

    private double get3DXOffset() {
        CategoryPlot categoryPlot;
        CategoryItemRenderer categoryItemRenderer;
        double d = 0.0;
        Plot plot = this.getPlot();
        if (plot != null && plot instanceof CategoryPlot && (categoryItemRenderer = (categoryPlot = (CategoryPlot)plot).getRenderer()) instanceof Effect3D) {
            Effect3D effect3D = (Effect3D)((Object)categoryItemRenderer);
            d = effect3D.getXOffset();
        }
        return d;
    }

    private double get3DYOffset() {
        CategoryPlot categoryPlot;
        CategoryItemRenderer categoryItemRenderer;
        double d = 0.0;
        Plot plot = this.getPlot();
        if (plot != null && plot instanceof CategoryPlot && (categoryItemRenderer = (categoryPlot = (CategoryPlot)plot).getRenderer()) instanceof Effect3D) {
            Effect3D effect3D = (Effect3D)((Object)categoryItemRenderer);
            d = effect3D.getYOffset();
        }
        return d;
    }
}

