/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jfree.chart.axis.HorizontalAxis;
import org.jfree.chart.axis.HorizontalNumberAxis;
import org.jfree.chart.axis.Tick;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.plot.HorizontalValuePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.data.Range;

public class HorizontalSymbolicAxis
extends HorizontalNumberAxis
implements HorizontalAxis,
Serializable {
    public static final Paint DEFAULT_SYMBOLIC_GRID_LINE_PAINT = new Color(232, 234, 232);
    private List symbolicValue;
    private boolean xSymbolicZoomIsAccepted = false;
    private List symbolicGridLineList = null;
    private transient Paint symbolicGridPaint;
    private boolean symbolicGridLinesVisible;

    public HorizontalSymbolicAxis(String string, String[] stringArray) {
        super(string);
        this.symbolicValue = Arrays.asList(stringArray);
        this.symbolicGridLinesVisible = true;
        this.symbolicGridPaint = DEFAULT_SYMBOLIC_GRID_LINE_PAINT;
        this.setAutoTickUnitSelection(false, false);
        this.setAutoRangeStickyZero(false);
    }

    public String[] getSymbolicValue() {
        String[] stringArray = new String[this.symbolicValue.size()];
        stringArray = this.symbolicValue.toArray(stringArray);
        return stringArray;
    }

    public Paint getSymbolicGridPaint() {
        return this.symbolicGridPaint;
    }

    public boolean isGridLinesVisible() {
        return this.symbolicGridLinesVisible;
    }

    public void setSymbolicGridLinesVisible(boolean bl) {
        if (this.symbolicGridLinesVisible != bl) {
            this.symbolicGridLinesVisible = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public void setAnchoredRange(double d) {
        if (this.xSymbolicZoomIsAccepted) {
            double d2 = Math.rint(this.getAnchorValue());
            double d3 = Math.rint(d2 - d / 2.0) - 0.5;
            double d4 = Math.rint(d2 + d / 2.0) + 0.5;
            if (d3 < -0.5) {
                d3 = -0.5;
            }
            if (d4 > (double)this.symbolicValue.size() - 0.5) {
                d4 = (double)this.symbolicValue.size() - 0.5;
            }
            this.setRange(d3, d4);
        }
    }

    protected void selectAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        throw new UnsupportedOperationException();
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, int n) {
        if (this.isVisible()) {
            super.draw(graphics2D, rectangle2D, rectangle2D2, n);
        }
        if (this.symbolicGridLinesVisible) {
            this.drawSymbolicGridLines(graphics2D, rectangle2D, rectangle2D2);
        }
    }

    public void drawSymbolicGridLines(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        this.drawSymbolicGridLines(graphics2D, rectangle2D, rectangle2D2, true);
    }

    public void drawSymbolicGridLines(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, boolean bl) {
        this.symbolicGridLineList = new Vector(this.getTicks().size());
        boolean bl2 = bl;
        double d = rectangle2D2.getY();
        double d2 = this.getPlot().getOutlineStroke() != null ? (double)((BasicStroke)this.getPlot().getOutlineStroke()).getLineWidth() : 1.0;
        Iterator iterator = this.getTicks().iterator();
        while (iterator.hasNext()) {
            Tick tick = (Tick)iterator.next();
            double d3 = this.translateValueToJava2D(tick.getNumericalValue() - 0.5, rectangle2D2);
            double d4 = this.translateValueToJava2D(tick.getNumericalValue() + 0.5, rectangle2D2);
            if (bl2) {
                graphics2D.setPaint(Color.white);
                graphics2D.setXORMode((Color)this.symbolicGridPaint);
            } else {
                graphics2D.setPaint(Color.white);
                graphics2D.setXORMode(Color.white);
            }
            Rectangle2D.Double double_ = new Rectangle2D.Double(d3, d + d2, d4 - d3, rectangle2D2.getMaxY() - d - d2);
            graphics2D.fill(double_);
            this.symbolicGridLineList.add(double_);
            boolean bl3 = bl2 = !bl2;
        }
        graphics2D.setPaintMode();
    }

    public Rectangle2D.Double getSymbolicGridLine(int n) {
        if (this.symbolicGridLineList != null) {
            return (Rectangle2D.Double)this.symbolicGridLineList.get(n);
        }
        return null;
    }

    protected void autoAdjustRange() {
        Plot plot = this.getPlot();
        if (plot == null) {
            return;
        }
        if (plot instanceof HorizontalValuePlot) {
            double d;
            double d2;
            double d3 = this.symbolicValue.size() - 1;
            double d4 = d3 - (d2 = 0.0);
            if (d4 < (d = this.getAutoRangeMinimumSize())) {
                d3 = (d3 + d2 + d) / 2.0;
                d2 = (d3 + d2 - d) / 2.0;
            }
            double d5 = 0.5;
            double d6 = 0.5;
            if (this.autoRangeIncludesZero()) {
                if (this.autoRangeStickyZero()) {
                    d3 = d3 <= 0.0 ? 0.0 : (d3 += d5);
                    d2 = d2 >= 0.0 ? 0.0 : (d2 -= d6);
                } else {
                    d3 = Math.max(0.0, d3 + d5);
                    d2 = Math.min(0.0, d2 - d6);
                }
            } else if (this.autoRangeStickyZero()) {
                d3 = d3 <= 0.0 ? Math.min(0.0, d3 + d5) : (d3 += d5 * d4);
                d2 = d2 >= 0.0 ? Math.max(0.0, d2 - d6) : (d2 -= d6);
            } else {
                d3 += d5;
                d2 -= d6;
            }
            this.setRangeAttribute(new Range(d2, d3));
        }
    }

    public void refreshTicks(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, int n) {
        this.getTicks().clear();
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        double d = this.getTickUnit().getSize();
        int n2 = this.calculateVisibleTickCount();
        double d2 = this.calculateLowestVisibleTickValue();
        if (n2 <= 500) {
            int n3 = 0;
            while (n3 < n2) {
                double d3 = d2 + (double)n3 * d;
                double d4 = this.translateValueToJava2D(d3, rectangle2D2);
                NumberFormat numberFormat = this.getNumberFormatOverride();
                String string = numberFormat != null ? numberFormat.format(d3) : this.valueToString(d3);
                Rectangle2D rectangle2D3 = font.getStringBounds(string, fontRenderContext);
                LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
                float f = 0.0f;
                float f2 = 0.0f;
                Insets insets = this.getTickLabelInsets();
                if (this.isVerticalTickLabels()) {
                    f = (float)(d4 + rectangle2D3.getHeight() / 2.0);
                    f2 = n == 0 ? (float)(rectangle2D2.getMinY() - (double)insets.bottom - rectangle2D3.getWidth()) : (float)(rectangle2D2.getMaxY() + (double)insets.top + rectangle2D3.getWidth());
                } else {
                    f = (float)(d4 - rectangle2D3.getWidth() / 2.0);
                    f2 = n == 0 ? (float)(rectangle2D2.getMinY() - (double)insets.bottom - (double)lineMetrics.getLeading() - (double)lineMetrics.getDescent()) : (float)(rectangle2D2.getMaxY() + (double)insets.top + rectangle2D3.getHeight());
                }
                Tick tick = new Tick(new Double(d3), string, f, f2);
                this.getTicks().add(tick);
                ++n3;
            }
        }
    }

    public String valueToString(double d) {
        String string;
        try {
            string = (String)this.symbolicValue.get((int)d);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            string = new String("");
        }
        return string;
    }
}

