/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.CrosshairInfo;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractXYItemRenderer;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.chart.tooltips.HighLowToolTipGenerator;
import org.jfree.chart.tooltips.XYToolTipGenerator;
import org.jfree.data.HighLowDataset;
import org.jfree.data.XYDataset;
import org.jfree.io.SerialUtilities;

public class CandlestickRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Serializable {
    private double candleWidth;
    private transient Paint upPaint;
    private transient Paint downPaint;
    private boolean drawVolume;

    public CandlestickRenderer() {
        this(-1.0);
    }

    public CandlestickRenderer(double d) {
        this(d, true, new HighLowToolTipGenerator());
    }

    public CandlestickRenderer(double d, boolean bl, XYToolTipGenerator xYToolTipGenerator) {
        super(xYToolTipGenerator);
        this.candleWidth = d;
        this.drawVolume = bl;
        this.upPaint = Color.green;
        this.downPaint = Color.red;
    }

    public double getCandleWidth() {
        return this.candleWidth;
    }

    public void setCandleWidth(double d) {
        if (d != this.candleWidth) {
            Double d2 = new Double(this.candleWidth);
            this.candleWidth = d;
            this.firePropertyChanged("CandleStickRenderer.candleWidth", d2, new Double(d));
        }
    }

    public Paint getUpPaint() {
        return this.upPaint;
    }

    public void setUpPaint(Paint paint) {
        Paint paint2 = this.upPaint;
        this.upPaint = paint;
        this.firePropertyChanged("CandleStickRenderer.upPaint", paint2, paint);
    }

    public Paint getDownPaint() {
        return this.downPaint;
    }

    public void setDownPaint(Paint paint) {
        Paint paint2 = this.upPaint;
        this.downPaint = paint;
        this.firePropertyChanged("CandleStickRenderer.downPaint", paint2, paint);
    }

    public boolean drawVolume() {
        return this.drawVolume;
    }

    public void setDrawVolume(boolean bl) {
        if (this.drawVolume != bl) {
            this.drawVolume = bl;
            this.firePropertyChanged("CandlestickRenderer.drawVolume", null, new Boolean(bl));
        }
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, int n3, CrosshairInfo crosshairInfo) {
        EntityCollection entityCollection = null;
        if (chartRenderingInfo != null) {
            entityCollection = chartRenderingInfo.getEntityCollection();
        }
        HighLowDataset highLowDataset = (HighLowDataset)xYDataset;
        Number number = highLowDataset.getXValue(n2, n3);
        Number number2 = highLowDataset.getHighValue(n2, n3);
        Number number3 = highLowDataset.getLowValue(n2, n3);
        Number number4 = highLowDataset.getOpenValue(n2, n3);
        Number number5 = highLowDataset.getCloseValue(n2, n3);
        double d = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D);
        double d2 = valueAxis2.translateValueToJava2D(number2.doubleValue(), rectangle2D);
        double d3 = valueAxis2.translateValueToJava2D(number3.doubleValue(), rectangle2D);
        double d4 = valueAxis2.translateValueToJava2D(number4.doubleValue(), rectangle2D);
        double d5 = valueAxis2.translateValueToJava2D(number5.doubleValue(), rectangle2D);
        double d6 = this.candleWidth;
        double d7 = this.candleWidth;
        if (this.candleWidth <= 0.0) {
            int n4 = highLowDataset.getItemCount(n2);
            d6 = (rectangle2D.getMaxX() - rectangle2D.getMinX()) / (double)n4 * 4.5 / 7.0;
            if (d6 < 1.0) {
                d6 = 1.0;
            }
            if ((d7 = d6) < 3.0) {
                d7 = 3.0;
            }
        }
        Paint paint = this.getItemPaint(n, n2, n3);
        Stroke stroke = this.getSeriesStroke(n, n2);
        graphics2D.setStroke(stroke);
        if (this.drawVolume) {
            int n5 = highLowDataset.getVolumeValue(n2, n3).intValue();
            int n6 = 1;
            int n7 = highLowDataset.getItemCount(n2);
            int n8 = 0;
            while (n8 < n7) {
                int n9 = highLowDataset.getVolumeValue(n2, n8).intValue();
                if (n9 > n6) {
                    n6 = n9;
                }
                ++n8;
            }
            double d8 = (double)n5 / (double)n6;
            double d9 = rectangle2D.getMinY();
            double d10 = rectangle2D.getMaxY();
            double d11 = d8 * (d10 - d9);
            graphics2D.setPaint(Color.gray);
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.3f));
            graphics2D.fill(new Rectangle2D.Double(d - d6 / 2.0, d10 - d11, d6, d11));
            graphics2D.setComposite(composite);
        }
        graphics2D.setPaint(paint);
        if (d2 < d4 && d2 < d5) {
            graphics2D.draw(new Line2D.Double(d, d2, d, Math.min(d4, d5)));
        }
        if (d3 > d4 && d3 > d5) {
            graphics2D.draw(new Line2D.Double(d, d3, d, Math.max(d4, d5)));
        }
        Rectangle2D.Double double_ = null;
        if (d4 > d5) {
            double_ = new Rectangle2D.Double(d - d7 / 2.0, d5, d7, d4 - d5);
            if (this.upPaint != null) {
                graphics2D.setPaint(this.upPaint);
                graphics2D.fill(double_);
            }
            graphics2D.setPaint(paint);
            graphics2D.draw(double_);
        } else {
            double_ = new Rectangle2D.Double(d - d7 / 2.0, d4, d7, d5 - d4);
            if (this.downPaint != null) {
                graphics2D.setPaint(this.downPaint);
            }
            graphics2D.fill(double_);
            graphics2D.setPaint(paint);
            graphics2D.draw(double_);
        }
        if (entityCollection != null) {
            String string = "";
            if (this.getToolTipGenerator() != null) {
                string = this.getToolTipGenerator().generateToolTip(xYDataset, n2, n3);
            }
            String string2 = null;
            if (this.getURLGenerator() != null) {
                string2 = this.getURLGenerator().generateURL(xYDataset, n2, n3);
            }
            XYItemEntity xYItemEntity = new XYItemEntity(double_, string, string2, n2, n3);
            entityCollection.addEntity(xYItemEntity);
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof CandlestickRenderer) {
            CandlestickRenderer candlestickRenderer = (CandlestickRenderer)object;
            boolean bl = super.equals(object);
            bl = bl && this.candleWidth == candlestickRenderer.getCandleWidth();
            bl = bl && this.upPaint.equals(candlestickRenderer.getUpPaint());
            bl = bl && this.downPaint.equals(candlestickRenderer.getDownPaint());
            bl = bl && this.drawVolume == candlestickRenderer.drawVolume;
            return bl;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint((Paint)this.upPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.downPaint, (ObjectOutputStream)objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.upPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.downPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
    }
}

