/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.Marker;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.CategoryItemRenderer;
import org.jfree.chart.renderer.HorizontalBarRenderer;
import org.jfree.chart.tooltips.CategoryToolTipGenerator;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.data.CategoryDataset;
import org.jfree.data.IntervalCategoryDataset;
import org.jfree.data.MultiIntervalCategoryDataset;
import org.jfree.data.Range;

public class HorizontalIntervalBarRenderer
extends HorizontalBarRenderer
implements CategoryItemRenderer,
Serializable {
    public HorizontalIntervalBarRenderer() {
        this(null, null);
    }

    public HorizontalIntervalBarRenderer(CategoryToolTipGenerator categoryToolTipGenerator) {
        this(categoryToolTipGenerator, null);
    }

    public HorizontalIntervalBarRenderer(CategoryURLGenerator categoryURLGenerator) {
        this(null, categoryURLGenerator);
    }

    public HorizontalIntervalBarRenderer(CategoryToolTipGenerator categoryToolTipGenerator, CategoryURLGenerator categoryURLGenerator) {
        super(categoryToolTipGenerator, categoryURLGenerator);
    }

    public void drawRangeMarker(Graphics2D graphics2D, CategoryPlot categoryPlot, ValueAxis valueAxis, Marker marker, Rectangle2D rectangle2D, Shape shape) {
        double d = marker.getValue();
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        double d2 = valueAxis.translateValueToJava2D(marker.getValue(), rectangle2D);
        Line2D.Double double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        graphics2D.setPaint(marker.getOutlinePaint());
        graphics2D.draw(double_);
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        if (categoryDataset instanceof MultiIntervalCategoryDataset) {
            MultiIntervalCategoryDataset multiIntervalCategoryDataset = (MultiIntervalCategoryDataset)categoryDataset;
            this.drawSubIntervals(graphics2D, rectangle2D, categoryPlot, categoryAxis, valueAxis, multiIntervalCategoryDataset, n, n2, n3);
        } else if (categoryDataset instanceof IntervalCategoryDataset) {
            IntervalCategoryDataset intervalCategoryDataset = (IntervalCategoryDataset)categoryDataset;
            this.drawInterval(graphics2D, rectangle2D, categoryPlot, categoryAxis, valueAxis, intervalCategoryDataset, n, n2, n3);
        }
    }

    private void drawInterval(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, IntervalCategoryDataset intervalCategoryDataset, int n, int n2, int n3) {
        EntityCollection entityCollection;
        double d;
        double d2;
        Number number = intervalCategoryDataset.getStartValue(n2, n3);
        double d3 = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D);
        Number number2 = intervalCategoryDataset.getEndValue(n2, n3);
        double d4 = valueAxis.translateValueToJava2D(number2.doubleValue(), rectangle2D);
        if (d4 < d3) {
            d2 = d4;
            d4 = d3;
            d3 = d2;
        }
        d2 = categoryAxis.getCategoryStart(n3, this.getColumnCount(), rectangle2D);
        int n4 = this.getRowCount();
        int n5 = this.getColumnCount();
        if (n4 > 1) {
            d = rectangle2D.getHeight() * this.getItemMargin() / (double)(n5 * (n4 - 1));
            d2 += (double)n2 * (this.getBarWidth() + d);
        } else {
            d2 += (double)n2 * this.getBarWidth();
        }
        d = Math.abs(d4 - d3);
        double d5 = this.getBarWidth();
        Rectangle2D.Double double_ = new Rectangle2D.Double(d3, d2, d, d5);
        Paint paint = this.getItemPaint(n, n2, n3);
        graphics2D.setPaint(paint);
        graphics2D.fill(double_);
        if (this.getBarWidth() > 3.0) {
            graphics2D.setStroke(this.getItemStroke(n, n2, n3));
            graphics2D.setPaint(this.getItemOutlinePaint(n, n2, n3));
            graphics2D.draw(double_);
        }
        if (this.getInfo() != null && (entityCollection = this.getInfo().getEntityCollection()) != null) {
            String string = null;
            if (this.getToolTipGenerator() != null) {
                string = this.getToolTipGenerator().generateToolTip(intervalCategoryDataset, n2, n3);
            }
            String string2 = null;
            if (this.getURLGenerator() != null) {
                string2 = this.getURLGenerator().generateURL(intervalCategoryDataset, n2, n3);
            }
            CategoryItemEntity categoryItemEntity = new CategoryItemEntity(double_, string, string2, n2, intervalCategoryDataset.getColumnKey(n3), n3);
            entityCollection.addEntity(categoryItemEntity);
        }
    }

    private void drawSubIntervals(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, MultiIntervalCategoryDataset multiIntervalCategoryDataset, int n, int n2, int n3) {
        int n4 = multiIntervalCategoryDataset.getSubIntervalCount(n2, n3);
        if (n4 == 0) {
            this.drawInterval(graphics2D, rectangle2D, categoryPlot, categoryAxis, valueAxis, multiIntervalCategoryDataset, n, n2, n3);
        }
        int n5 = 0;
        while (n5 < n4) {
            EntityCollection entityCollection;
            double d;
            double d2;
            Number number = multiIntervalCategoryDataset.getStartValue(n2, n3, n5);
            double d3 = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D);
            Number number2 = multiIntervalCategoryDataset.getEndValue(n2, n3, n5);
            double d4 = valueAxis.translateValueToJava2D(number2.doubleValue(), rectangle2D);
            if (d4 < d3) {
                d2 = d4;
                d4 = d3;
                d3 = d2;
            }
            d2 = categoryAxis.getCategoryStart(n3, this.getColumnCount(), rectangle2D);
            int n6 = this.getRowCount();
            int n7 = this.getColumnCount();
            if (n6 > 1) {
                d = rectangle2D.getHeight() * this.getItemMargin() / (double)(n7 * (n6 - 1));
                d2 += (double)n2 * (this.getBarWidth() + d);
            } else {
                d2 += (double)n2 * this.getBarWidth();
            }
            d = Math.abs(d4 - d3);
            double d5 = this.getBarWidth();
            Rectangle2D.Double double_ = new Rectangle2D.Double(d3, d2, d, d5);
            Paint paint = this.getItemPaint(n, n2, n3);
            graphics2D.setPaint(paint);
            graphics2D.fill(double_);
            if (this.getBarWidth() > 3.0) {
                graphics2D.setStroke(this.getItemStroke(n, n2, n3));
                graphics2D.setPaint(this.getItemOutlinePaint(n, n2, n3));
                graphics2D.draw(double_);
            }
            if (this.getInfo() != null && (entityCollection = this.getInfo().getEntityCollection()) != null) {
                String string = null;
                if (this.getToolTipGenerator() != null) {
                    string = this.getToolTipGenerator().generateToolTip(multiIntervalCategoryDataset, n2, n3);
                }
                String string2 = null;
                if (this.getURLGenerator() != null) {
                    string2 = this.getURLGenerator().generateURL(multiIntervalCategoryDataset, n2, n3);
                }
                CategoryItemEntity categoryItemEntity = new CategoryItemEntity(double_, string, string2, n2, multiIntervalCategoryDataset.getColumnKey(n3), n3);
                entityCollection.addEntity(categoryItemEntity);
            }
            ++n5;
        }
    }
}

