/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Paint;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.io.SerialUtilities;

public class PaintTable
implements Serializable {
    private int rows = 0;
    private int columns = 0;
    private transient Paint[][] data = new Paint[0][0];

    public int getRowCount() {
        return this.rows;
    }

    public int getColumnCount() {
        return this.columns;
    }

    public Paint getPaint(int n, int n2) {
        Paint[] paintArray;
        Paint paint = null;
        if (n < this.data.length && n2 < (paintArray = this.data[n]).length) {
            paint = paintArray[n2];
        }
        return paint;
    }

    public void setPaint(int n, int n2, Paint paint) {
        int n3;
        Paint[][] paintArrayArray;
        if (n >= this.data.length) {
            paintArrayArray = new Paint[n + 1][];
            int n4 = 0;
            while (n4 < this.data.length) {
                paintArrayArray[n4] = this.data[n4];
                ++n4;
            }
            n3 = this.data.length;
            while (n3 <= n) {
                paintArrayArray[n3] = new Paint[0];
                ++n3;
            }
            this.data = paintArrayArray;
        }
        if (n2 >= (paintArrayArray = this.data[n]).length) {
            Paint[] paintArray = new Paint[n2 + 1];
            n3 = 0;
            while (n3 < paintArrayArray.length) {
                paintArray[n3] = paintArrayArray[n3];
                ++n3;
            }
            paintArray[n2] = paint;
            this.data[n] = paintArray;
        } else {
            paintArrayArray[n2] = paint;
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object instanceof PaintTable) {
            PaintTable paintTable = (PaintTable)object;
            boolean bl = this.rows == paintTable.getRowCount() && this.columns == paintTable.getColumnCount();
            int n = 0;
            while (n < this.rows) {
                int n2 = this.data[n].length;
                int n3 = 0;
                while (n3 < n2) {
                    bl = bl && this.data[n][n3].equals(paintTable.getPaint(n, n3));
                    ++n3;
                }
                ++n;
            }
            return bl;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = 0;
        while (n < this.rows) {
            int n2 = this.data[n].length;
            objectOutputStream.writeInt(n2);
            int n3 = 0;
            while (n3 < n2) {
                SerialUtilities.writePaint((Paint)this.data[n][n3], (ObjectOutputStream)objectOutputStream);
                ++n3;
            }
            ++n;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.data = new Paint[this.rows][this.columns];
        int n = 0;
        while (n < this.rows) {
            int n2 = objectInputStream.readInt();
            int n3 = 0;
            while (n3 < n2) {
                Paint paint;
                this.data[n][n3] = paint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
                ++n3;
            }
            ++n;
        }
    }
}

