/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.data.Series;
import org.jfree.data.SeriesException;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimePeriodValue;

public class TimePeriodValues
extends Series
implements Serializable {
    protected static final String DEFAULT_DOMAIN_DESCRIPTION = "Time";
    protected static final String DEFAULT_RANGE_DESCRIPTION = "Value";
    private String domain;
    private String range;
    private List data;

    public TimePeriodValues(String string) {
        this(string, DEFAULT_DOMAIN_DESCRIPTION, DEFAULT_RANGE_DESCRIPTION);
    }

    public TimePeriodValues(String string, String string2, String string3) {
        super(string);
        this.domain = string2;
        this.range = string3;
        this.data = new ArrayList();
    }

    public String getDomainDescription() {
        return this.domain;
    }

    public void setDomainDescription(String string) {
        String string2 = this.domain;
        this.domain = string;
        this.firePropertyChange("Domain", string2, string);
    }

    public String getRangeDescription() {
        return this.range;
    }

    public void setRangeDescription(String string) {
        String string2 = this.range;
        this.range = string;
        this.firePropertyChange("Range", string2, string);
    }

    public int getItemCount() {
        return this.data.size();
    }

    public TimePeriodValue getDataItem(int n) {
        return (TimePeriodValue)this.data.get(n);
    }

    public TimePeriod getTimePeriod(int n) {
        return this.getDataItem(n).getPeriod();
    }

    public Number getValue(int n) {
        return this.getDataItem(n).getValue();
    }

    public void add(TimePeriodValue timePeriodValue) throws SeriesException {
        if (timePeriodValue == null) {
            throw new IllegalArgumentException("TimePeriodValues.add(...): null item not allowed.");
        }
        this.data.add(timePeriodValue);
    }

    public void add(TimePeriod timePeriod, double d) throws SeriesException {
        TimePeriodValue timePeriodValue = new TimePeriodValue(timePeriod, d);
        this.add(timePeriodValue);
    }

    public void add(TimePeriod timePeriod, Number number) throws SeriesException {
        TimePeriodValue timePeriodValue = new TimePeriodValue(timePeriod, number);
        this.add(timePeriodValue);
    }

    public void update(int n, Number number) {
        TimePeriodValue timePeriodValue = this.getDataItem(n);
        timePeriodValue.setValue(number);
        this.fireSeriesChanged();
    }

    public void delete(int n, int n2) {
        int n3 = 0;
        while (n3 <= n2 - n) {
            this.data.remove(n);
            ++n3;
        }
        this.fireSeriesChanged();
    }
}

