/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hpsf.MarkUnsupportedException;
import org.apache.poi.hpsf.NoPropertySetStreamException;
import org.apache.poi.hpsf.NoSingleSectionException;
import org.apache.poi.hpsf.Property;
import org.apache.poi.hpsf.Section;
import org.apache.poi.hpsf.Util;
import org.apache.poi.hpsf.littleendian.ClassID;
import org.apache.poi.hpsf.littleendian.DWord;
import org.apache.poi.hpsf.littleendian.Word;
import org.apache.poi.hpsf.wellknown.SectionIDMap;

public class PropertySet {
    static final byte[] BYTE_ORDER_ASSERTION = new byte[]{-1, -2};
    static final byte[] FORMAT_ASSERTION = new byte[]{0, 0};
    private Word byteOrder;
    private Word format;
    private DWord osVersion;
    private ClassID classID;
    private int sectionCount;
    private List sections;

    public Word getByteOrder() {
        return this.byteOrder;
    }

    public Word getFormat() {
        return this.format;
    }

    public DWord getOSVersion() {
        return this.osVersion;
    }

    public ClassID getClassID() {
        return this.classID;
    }

    public int getSectionCount() {
        return this.sectionCount;
    }

    public List getSections() {
        return this.sections;
    }

    protected PropertySet() {
    }

    public PropertySet(InputStream stream) throws NoPropertySetStreamException, MarkUnsupportedException, IOException {
        if (!PropertySet.isPropertySetStream(stream)) {
            throw new NoPropertySetStreamException();
        }
        int avail = stream.available();
        byte[] buffer = new byte[avail];
        stream.read(buffer, 0, buffer.length);
        this.init(buffer, 0, buffer.length);
    }

    public PropertySet(byte[] stream, int offset, int length) throws NoPropertySetStreamException {
        if (!PropertySet.isPropertySetStream(stream, offset, length)) {
            throw new NoPropertySetStreamException();
        }
        this.init(stream, offset, length);
    }

    public PropertySet(byte[] stream) throws NoPropertySetStreamException {
        this(stream, 0, stream.length);
    }

    public static boolean isPropertySetStream(InputStream stream) throws MarkUnsupportedException, IOException {
        int BUFFER_SIZE = 50;
        if (!stream.markSupported()) {
            throw new MarkUnsupportedException(stream.getClass().getName());
        }
        stream.mark(50);
        byte[] buffer = new byte[50];
        int bytes = stream.read(buffer, 0, Math.min(buffer.length, stream.available()));
        boolean isPropertySetStream = PropertySet.isPropertySetStream(buffer, 0, bytes);
        stream.reset();
        return isPropertySetStream;
    }

    public static boolean isPropertySetStream(byte[] src, int offset, int length) {
        Word byteOrder = new Word(src, offset);
        offset += 2;
        if (!Util.equal(byteOrder.getBytes(), BYTE_ORDER_ASSERTION)) {
            return false;
        }
        Word format = new Word(src, offset);
        offset += 2;
        if (!Util.equal(format.getBytes(), FORMAT_ASSERTION)) {
            return false;
        }
        DWord osVersion = new DWord(src, offset);
        ClassID classID = new ClassID(src, offset += 4);
        DWord sectionCount = new DWord(src, offset += 16);
        offset += 4;
        return sectionCount.intValue() >= 1;
    }

    private void init(byte[] src, int offset, int length) {
        this.byteOrder = new Word(src, offset);
        this.format = new Word(src, offset += 2);
        this.osVersion = new DWord(src, offset += 2);
        this.classID = new ClassID(src, offset += 4);
        this.sectionCount = new DWord(src, offset += 16).intValue();
        offset += 4;
        this.sections = new ArrayList(2);
        int i = 0;
        while (i < this.sectionCount) {
            Section s = new Section(src, offset);
            offset += 20;
            this.sections.add(s);
            ++i;
        }
    }

    public boolean isSummaryInformation() {
        return Util.equal(((Section)this.sections.get(0)).getFormatID().getBytes(), SectionIDMap.SUMMARY_INFORMATION_ID);
    }

    public boolean isDocumentSummaryInformation() {
        return Util.equal(((Section)this.sections.get(0)).getFormatID().getBytes(), SectionIDMap.DOCUMENT_SUMMARY_INFORMATION_ID);
    }

    public Property[] getProperties() throws NoSingleSectionException {
        return this.getSingleSection().getProperties();
    }

    protected Object getProperty(int id) throws NoSingleSectionException {
        return this.getSingleSection().getProperty(id);
    }

    protected int getPropertyIntValue(int id) throws NoSingleSectionException {
        return this.getSingleSection().getPropertyIntValue(id);
    }

    public boolean wasNull() throws NoSingleSectionException {
        return this.getSingleSection().wasNull();
    }

    public Section getSingleSection() {
        if (this.sectionCount != 1) {
            throw new NoSingleSectionException("Property set contains " + this.sectionCount + " sections.");
        }
        return (Section)this.sections.get(0);
    }
}

