/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class BOFRecord
extends Record {
    public static final short sid = 2057;
    private short field_1_version;
    private short field_2_type;
    private short field_3_build;
    private short field_4_year;
    private int field_5_history;
    private int field_6_rversion;
    public static final short VERSION = 6;
    public static final short BUILD = 4307;
    public static final short BUILD_YEAR = 1996;
    public static final short HISTORY_MASK = 65;
    public static final short TYPE_WORKBOOK = 5;
    public static final short TYPE_VB_MODULE = 6;
    public static final short TYPE_WORKSHEET = 16;
    public static final short TYPE_CHART = 32;
    public static final short TYPE_EXCEL_4_MACRO = 64;
    public static final short TYPE_WORKSPACE_FILE = 256;

    public BOFRecord() {
    }

    public BOFRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public BOFRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    protected void validateSid(short id) {
        if (id != 2057) {
            throw new RecordFormatException("NOT A BOF RECORD");
        }
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_version = LittleEndian.getShort(data, 0 + offset);
        this.field_2_type = LittleEndian.getShort(data, 2 + offset);
        this.field_3_build = LittleEndian.getShort(data, 4 + offset);
        this.field_4_year = LittleEndian.getShort(data, 6 + offset);
        this.field_5_history = LittleEndian.getInt(data, 8 + offset);
        this.field_6_rversion = LittleEndian.getInt(data, 12 + offset);
    }

    public void setVersion(short version) {
        this.field_1_version = version;
    }

    public void setType(short type) {
        this.field_2_type = type;
    }

    public void setBuild(short build) {
        this.field_3_build = build;
    }

    public void setBuildYear(short year) {
        this.field_4_year = year;
    }

    public void setHistoryBitMask(int bitmask) {
        this.field_5_history = bitmask;
    }

    public void setRequiredVersion(int version) {
        this.field_6_rversion = version;
    }

    public short getVersion() {
        return this.field_1_version;
    }

    public short getType() {
        return this.field_2_type;
    }

    public short getBuild() {
        return this.field_3_build;
    }

    public short getBuildYear() {
        return this.field_4_year;
    }

    public int getHistoryBitMask() {
        return this.field_5_history;
    }

    public int getRequiredVersion() {
        return this.field_6_rversion;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[BOF RECORD]\n");
        buffer.append("    .version         = ").append(Integer.toHexString(this.getVersion())).append("\n");
        buffer.append("    .type            = ").append(Integer.toHexString(this.getType())).append("\n");
        buffer.append("    .build           = ").append(Integer.toHexString(this.getBuild())).append("\n");
        buffer.append("    .buildyear       = ").append(this.getBuildYear()).append("\n");
        buffer.append("    .history         = ").append(Integer.toHexString(this.getHistoryBitMask())).append("\n");
        buffer.append("    .requiredversion = ").append(Integer.toHexString(this.getRequiredVersion())).append("\n");
        buffer.append("[/BOF RECORD]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)2057);
        LittleEndian.putShort(data, 2 + offset, (short)16);
        LittleEndian.putShort(data, 4 + offset, this.getVersion());
        LittleEndian.putShort(data, 6 + offset, this.getType());
        LittleEndian.putShort(data, 8 + offset, this.getBuild());
        LittleEndian.putShort(data, 10 + offset, this.getBuildYear());
        LittleEndian.putInt(data, 12 + offset, this.getHistoryBitMask());
        LittleEndian.putInt(data, 16 + offset, this.getRequiredVersion());
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 20;
    }

    public short getSid() {
        return 2057;
    }
}

