/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.util.LittleEndian;

public class DefaultRowHeightRecord
extends Record {
    public static final short sid = 549;
    private short field_1_option_flags;
    private short field_2_row_height;

    public DefaultRowHeightRecord() {
    }

    public DefaultRowHeightRecord(short id, short size, byte[] data) {
        super(id, size, data);
    }

    public DefaultRowHeightRecord(short id, short size, byte[] data, int offset) {
        super(id, size, data, offset);
    }

    protected void validateSid(short id) {
        if (id != 549) {
            throw new RecordFormatException("NOT A DefaultRowHeight RECORD");
        }
    }

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_option_flags = LittleEndian.getShort(data, 0 + offset);
        this.field_2_row_height = LittleEndian.getShort(data, 2 + offset);
    }

    public void setOptionFlags(short flags) {
        this.field_1_option_flags = flags;
    }

    public void setRowHeight(short height) {
        this.field_2_row_height = height;
    }

    public short getOptionFlags() {
        return this.field_1_option_flags;
    }

    public short getRowHeight() {
        return this.field_2_row_height;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[DEFAULTROWHEIGHT]\n");
        buffer.append("    .optionflags    = ").append(Integer.toHexString(this.getOptionFlags())).append("\n");
        buffer.append("    .rowheight      = ").append(Integer.toHexString(this.getRowHeight())).append("\n");
        buffer.append("[/DEFAULTROWHEIGHT]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)549);
        LittleEndian.putShort(data, 2 + offset, (short)4);
        LittleEndian.putShort(data, 4 + offset, this.getOptionFlags());
        LittleEndian.putShort(data, 6 + offset, this.getRowHeight());
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 8;
    }

    public short getSid() {
        return 549;
    }
}

